/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.render.RenderState;

public class ImageNode
extends Node {
    private static final Class CLASS = ImageNode.class;
    private int blobID;
    private IVMImage image;
    private String altText;

    public ImageNode(int blobID) {
        super(8, 32816);
        this.blobID = blobID;
    }

    public ImageNode(ImageNode other) {
        super(other);
        this.blobID = other.blobID;
        this.image = other.image;
        this.altText = other.altText;
    }

    @Override
    public Node cloneNode() {
        return new ImageNode(this);
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        sb.append("Image " + this.altText);
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("\"");
        } else {
            sb.append(" ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isZoomable(RenderState state) {
        return true;
    }

    @Override
    public void size(RenderState state) throws CMException {
        state.pushCurrentNode(this);
        this.loadImage(state);
        VMPoint size = new VMPoint();
        if (this.image == null) {
            size.copy(state.getPainter().measureString(this.altText));
        } else if (state.isZoomed()) {
            this.zoomImage = this.loadZoomImage(state);
            size.copy(this.zoomImage.onImageGetSize());
        } else {
            size.copy(this.image.onImageGetSize());
        }
        int padding = this.getPadding();
        this.setPreferredSize(size.x + 2 * padding, size.y + 2 * padding, state);
        state.popCurrentNode(0);
    }

    @Override
    public void onSizeEnd(int cx, int cy, RenderState state) {
    }

    @Override
    public int getPadding() {
        return 2;
    }

    @Override
    public void paint(RenderState state) throws CMException {
        state.pushCurrentNode(this);
        this.loadImage(state);
        int padding = this.getPadding();
        if (this.image == null) {
            state.getPainter().setColor(state.getTextColor());
            state.getPainter().drawString(padding, padding, this.altText);
        } else if (state.isZoomed() && (this.paintZoomImage != null || this.zoomImage != null)) {
            if (this.paintZoomImage != null) {
                state.getPainter().drawImage(padding, padding, this.paintZoomImage);
            } else {
                state.getPainter().drawImage(padding, padding, this.zoomImage);
            }
        } else {
            state.getPainter().drawImage(padding, padding, this.image);
        }
        if (state.isSelected()) {
            this.paintSelection(state);
        }
        state.popCurrentNode(0);
    }

    @Override
    public boolean alwaysCheckCache() {
        return true;
    }

    private void loadImage(RenderState state) {
        if (this.image != null || this.altText != null) {
            return;
        }
        if (!this.getScene().checkStyle(2)) {
            try {
                byte[] imageBytes = state.reader.onReaderLoadBlob(this.blobID);
                if (imageBytes == null || imageBytes.length == 0) {
                    VM.log(CLASS, 3, "invalid image: " + this.blobID);
                    this.image = null;
                } else {
                    this.image = state.getPainter().createImage(1, imageBytes);
                }
            }
            catch (Throwable ex) {
                VM.log(CLASS, 3, ex);
            }
            if (this.image == null) {
                VM.log(CLASS, 3, "failed to create image: blob #" + this.blobID);
            }
        }
        if (this.image == null) {
            this.altText = "???";
        }
    }
}

