/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import java.util.Hashtable;
import java.util.Vector;

public class RowColumnFocusBuilder {
    private static final Class CLASS = RowColumnFocusBuilder.class;

    public static TableNode buildRowFocusTable(Node parent, VMScene.Hints hints, CellNode selectedCell) throws CMException {
        if (selectedCell == null) {
            return null;
        }
        int[] focusRows = RowColumnFocusBuilder.findFocusColumnsOrRows(selectedCell, 1);
        if (focusRows.length == 0) {
            return null;
        }
        int maxColumnIndex = focusRows[0];
        for (int i = 1; i < focusRows.length; ++i) {
            maxColumnIndex = Math.max(maxColumnIndex, focusRows[i]);
        }
        TableNode sourceTable = selectedCell.getTable();
        TableNode focusTable = new TableNode(1, selectedCell.getTable(), focusRows, selectedCell.getTable().getID());
        focusTable.onBuildBegin(parent, sourceTable.getStartAddress());
        focusTable.setFreeze(sourceTable.getFreezeRowCount(), sourceTable.getFreezeColumnCount());
        Hashtable cellsAdded = new Hashtable();
        Hashtable cellRowIndexes = new Hashtable();
        Hashtable cellColumnIndexes = new Hashtable();
        VMScene newRootScene = parent.getScene();
        for (int columnIndex = 0; columnIndex < sourceTable.getColumnCount(); ++columnIndex) {
            focusTable.onBuildBeginRow();
            for (int rowIndex = 0; rowIndex < sourceTable.getFreezeRowCount(); ++rowIndex) {
                RowColumnFocusBuilder.addCellToCurrentRow(newRootScene, cellsAdded, cellRowIndexes, cellColumnIndexes, focusTable, 1, rowIndex, columnIndex, hints, selectedCell, maxColumnIndex);
            }
            for (int i = 0; i < focusRows.length; ++i) {
                int rowIndex = focusRows[i];
                RowColumnFocusBuilder.addCellToCurrentRow(newRootScene, cellsAdded, cellRowIndexes, cellColumnIndexes, focusTable, 1, rowIndex, columnIndex, hints, selectedCell, maxColumnIndex);
            }
        }
        focusTable.onBuildEnd(sourceTable.getEndAddress());
        return focusTable;
    }

    public static TableNode buildColumnFocusTable(Node parent, VMScene.Hints hints, CellNode selectedCell) throws CMException {
        if (selectedCell == null) {
            return null;
        }
        int[] focusColumns = RowColumnFocusBuilder.findFocusColumnsOrRows(selectedCell, 2);
        if (focusColumns.length == 0) {
            return null;
        }
        TableNode sourceTable = selectedCell.getTable();
        TableNode focusTable = new TableNode(2, selectedCell.getTable(), focusColumns, selectedCell.getTable().getID());
        focusTable.onBuildBegin(parent, sourceTable.getStartAddress());
        focusTable.setFreeze(sourceTable.getFreezeColumnCount(), sourceTable.getFreezeRowCount());
        Hashtable cellsAdded = new Hashtable();
        Hashtable cellRowIndexes = new Hashtable();
        Hashtable cellColumnIndexes = new Hashtable();
        VMScene newRootScene = parent.getScene();
        for (int rowIndex = 0; rowIndex < sourceTable.getRowCount(); ++rowIndex) {
            focusTable.onBuildBeginRow();
            for (int columnIndex = 0; columnIndex < sourceTable.getFreezeColumnCount(); ++columnIndex) {
                RowColumnFocusBuilder.addCellToCurrentRow(newRootScene, cellsAdded, cellRowIndexes, cellColumnIndexes, focusTable, 2, rowIndex, columnIndex, hints, selectedCell, -1);
            }
            for (int i = 0; i < focusColumns.length; ++i) {
                int columnIndex = focusColumns[i];
                RowColumnFocusBuilder.addCellToCurrentRow(newRootScene, cellsAdded, cellRowIndexes, cellColumnIndexes, focusTable, 2, rowIndex, columnIndex, hints, selectedCell, -1);
            }
        }
        focusTable.onBuildEnd(sourceTable.getEndAddress());
        return focusTable;
    }

    private static int[] findFocusColumnsOrRows(CellNode selectedCell, int focus) {
        int min = 0;
        int max = 0;
        switch (focus) {
            case 2: {
                min = selectedCell.getTable().getFreezeColumnCount();
                max = selectedCell.getTable().getColumnCount();
                break;
            }
            case 1: {
                min = selectedCell.getTable().getFreezeRowCount();
                max = selectedCell.getTable().getRowCount();
            }
        }
        boolean[] marked = new boolean[max];
        RowColumnFocusBuilder.addCellToMarked(selectedCell, focus, marked);
        Vector markedCells = selectedCell.getTable().findDescendentsFromStyle(131072, false);
        for (int i = 0; i < markedCells.size(); ++i) {
            CellNode cell = (CellNode)markedCells.elementAt(i);
            RowColumnFocusBuilder.addCellToMarked(cell, focus, marked);
        }
        int count = 0;
        for (int i = min; i < max; ++i) {
            if (!marked[i]) continue;
            ++count;
        }
        int[] indexes = new int[count];
        count = 0;
        for (int i = min; i < max; ++i) {
            if (!marked[i]) continue;
            indexes[count] = i;
            ++count;
        }
        return indexes;
    }

    private static boolean[] addCellToMarked(CellNode cell, int focus, boolean[] marked) {
        int limit;
        switch (focus) {
            case 2: {
                int start = cell.getColumn();
                limit = start + cell.getColspan();
                break;
            }
            case 1: {
                int start = cell.getRow();
                limit = start + cell.getRowspan();
                break;
            }
            default: {
                return marked;
            }
        }
        for (int i = start; i < limit; ++i) {
            marked[i] = true;
        }
        return marked;
    }

    private static void addCellToCurrentRow(VMScene rootScene, Hashtable cellsAdded, Hashtable cellRowIndexes, Hashtable cellColumnIndexes, TableNode focusTable, int focus, int rowIndex, int columnIndex, VMScene.Hints hints, CellNode selectedCell, int maxColumnIndex) throws CMException {
        TableNode sourceTable = selectedCell.getTable();
        CellNode sourceCell = sourceTable.findTableCell(rowIndex, columnIndex);
        if (sourceCell == null) {
            VM.log(CLASS, 2, "failed to find part for cell row=" + rowIndex + ", col=" + columnIndex);
            return;
        }
        int thisRowIndex = focus == 1 ? columnIndex : rowIndex;
        int thisColumnIndex = focus == 1 ? rowIndex : columnIndex;
        CellNode focusCell = (CellNode)cellsAdded.get(sourceCell);
        if (focusCell != null) {
            int sourceColumnIndex;
            int sourceRowIndex = (Integer)cellRowIndexes.get(sourceCell);
            if (sourceRowIndex == thisRowIndex) {
                focusCell.setSpans(focusCell.getColspan() + 1, focusCell.getRowspan());
            }
            if ((sourceColumnIndex = ((Integer)cellColumnIndexes.get(sourceCell)).intValue()) == thisColumnIndex) {
                focusCell.setSpans(focusCell.getColspan(), focusCell.getRowspan() + 1);
            }
            return;
        }
        focusCell = (CellNode)sourceCell.cloneTree();
        focusCell.setSpans(1, 1);
        focusCell.setScene(rootScene);
        cellsAdded.put(sourceCell, focusCell);
        cellRowIndexes.put(sourceCell, new Integer(thisRowIndex));
        cellColumnIndexes.put(sourceCell, new Integer(thisColumnIndex));
        focusCell.setColumnAndRow(thisColumnIndex, thisRowIndex);
        if (maxColumnIndex != -1 && focusCell.getColumn() > maxColumnIndex) {
            VM.log(CLASS, 0, "cell in column " + focusCell.getColumn() + " needs to be dropped");
            return;
        }
        if (sourceCell == selectedCell) {
            hints.selected = focusCell;
        }
        focusTable.onBuildBeginCell(focusCell);
    }

    public static boolean isAbleToSwitchFocus(Node selectedCell) {
        if (selectedCell == null) {
            return false;
        }
        if (!(selectedCell instanceof CellNode)) {
            return false;
        }
        int[] focusColumns = RowColumnFocusBuilder.findFocusColumnsOrRows((CellNode)selectedCell, 1);
        return focusColumns.length != 0;
    }
}

