/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.DefaultKeyHandler;
import com.cognos.mobile.vm.node.SpotNode;

public class SpotKeyHandler
extends DefaultKeyHandler {
    private static final Class CLASS = SpotKeyHandler.class;
    private Node leftNode;
    private Node upNode;
    private Node rightNode;
    private Node downNode;

    public SpotKeyHandler(VMScene scene) {
        super(scene);
    }

    @Override
    public boolean sendKey(int key, int flags) {
        Node oldSelectedNode = this.scene.getSelection().getSelectedNode();
        int optionalFlags = 0;
        switch (key) {
            case 1: {
                flags |= 0x20;
                optionalFlags = 8;
                break;
            }
            case 4: 
            case 7: {
                flags |= 8;
                optionalFlags = 32;
                break;
            }
            case 2: {
                flags |= 0x40;
                optionalFlags = 16;
                break;
            }
            case 3: 
            case 8: {
                flags |= 0x10;
                optionalFlags = 64;
            }
        }
        int oldViewportX = this.scene.viewport.x;
        int oldViewportY = this.scene.viewport.y;
        Node newSelectedNode = null;
        switch (key) {
            case 5: {
                newSelectedNode = this.scene.getSelection().selectFirst(1, flags);
                break;
            }
            case 6: {
                newSelectedNode = this.scene.getSelection().selectFirst(-1, flags);
                break;
            }
            case 4: {
                newSelectedNode = this.scene.getSelection().selectNext(-1, flags, false);
                break;
            }
            case 1: {
                if (this.leftNode == null) {
                    this.leftNode = this.scene.getSelection().getSpot(((SpotNode)oldSelectedNode).getLeftSpot());
                }
                if (this.leftNode == null) break;
                newSelectedNode = this.leftNode;
                this.scene.getSelection().select(newSelectedNode, 1, flags);
                break;
            }
            case 7: {
                if (this.upNode == null) {
                    this.upNode = this.scene.getSelection().getSpot(((SpotNode)oldSelectedNode).getUpSpot());
                }
                if (this.upNode == null) break;
                newSelectedNode = this.upNode;
                this.scene.getSelection().select(newSelectedNode, 1, flags);
                break;
            }
            case 3: {
                newSelectedNode = this.scene.getSelection().selectNext(1, flags, false);
                break;
            }
            case 2: {
                if (this.rightNode == null) {
                    this.rightNode = this.scene.getSelection().getSpot(((SpotNode)oldSelectedNode).getRightSpot());
                }
                if (this.rightNode == null) break;
                newSelectedNode = this.rightNode;
                this.scene.getSelection().select(newSelectedNode, 1, flags);
                break;
            }
            case 8: {
                if (this.downNode == null) {
                    this.downNode = this.scene.getSelection().getSpot(((SpotNode)oldSelectedNode).getDownSpot());
                }
                if (this.downNode == null) break;
                newSelectedNode = this.downNode;
                this.scene.getSelection().select(newSelectedNode, 1, flags);
            }
        }
        if (newSelectedNode != null) {
            VM.log(CLASS, 1, "new selection: " + newSelectedNode.toString());
        } else {
            VM.log(CLASS, 1, "new selection: NULL");
        }
        if (oldSelectedNode == newSelectedNode && oldViewportX == this.scene.viewport.x && oldViewportY == this.scene.viewport.y) {
            this.scrollPage(flags, optionalFlags);
        } else if (newSelectedNode != null) {
            this.scene.setTooltip(newSelectedNode.getLabel());
            int estimatedToolMaxTipHeight = 20;
            int screenBottom = this.scene.viewport.getViewportHeight() - this.scene.viewport.getScrollY();
            if (newSelectedNode.getLabel() != null && newSelectedNode.getLabel().length() > 0 && newSelectedNode.getRect().y + newSelectedNode.getRect().cy + estimatedToolMaxTipHeight > screenBottom) {
                this.scrollPage(16, 0);
            }
            this.leftNode = this.scene.getSelection().getSpot(((SpotNode)newSelectedNode).getLeftSpot());
            this.upNode = this.scene.getSelection().getSpot(((SpotNode)newSelectedNode).getUpSpot());
            this.rightNode = this.scene.getSelection().getSpot(((SpotNode)newSelectedNode).getRightSpot());
            this.downNode = this.scene.getSelection().getSpot(((SpotNode)newSelectedNode).getDownSpot());
        } else {
            this.scrollPage(flags, 0);
        }
        return true;
    }
}

