/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.CMPoint;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.DefaultMouseHandler;
import java.util.Vector;

public class SpotMouseHandler
extends DefaultMouseHandler {
    private static final Class CLASS = SpotMouseHandler.class;

    public SpotMouseHandler(VMScene scene) {
        super(scene);
    }

    @Override
    public void sendMouse(int mouse, int x, int y) {
        if (mouse == 3 && this.scene.getType() != 1) {
            boolean isClick;
            this.isMouseDown = false;
            int dx = Math.abs(this.mouseDownX - x);
            int dy = Math.abs(this.mouseDownY - y);
            boolean bl = isClick = dx <= 3 && dy <= 3;
            if (isClick) {
                x = this.scene.getViewport().physicalToLogicalX(x);
                y = this.scene.getViewport().physicalToLogicalY(y);
                Node newSelectedNode = SpotMouseHandler.findClosestNode(this.scene.getSelection().getSelectable(), x, y);
                if (newSelectedNode != null) {
                    this.scene.getSelection().select(newSelectedNode);
                    this.scene.setTooltip(newSelectedNode.getLabel());
                    if (this.scene.getHost() != null) {
                        this.scene.getHost().onSceneInvalidateRect(this.scene, null);
                    }
                }
            }
        } else {
            super.sendMouse(mouse, x, y);
        }
    }

    private static Node findClosestNode(Vector selectable, int x, int y) {
        CMPoint regionA = new CMPoint(x, y);
        CMPoint testPoint = new CMPoint();
        double shortestDistance = -1.0;
        Node closestNode = null;
        for (int i = 0; i < selectable.size(); ++i) {
            Node node = (Node)selectable.elementAt(i);
            if (node == null || node.getType() == 8) continue;
            testPoint.x = node.getAbsoluteRect().x;
            testPoint.y = node.getAbsoluteRect().y;
            double distance = CMMathHelper.distance(regionA, testPoint);
            if (!(shortestDistance < 0.0) && (!(shortestDistance >= 0.0) || !(distance < shortestDistance))) continue;
            shortestDistance = distance;
            closestNode = node;
        }
        return closestNode;
    }
}

