/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.DefaultMouseHandler;
import com.cognos.mobile.vm.node.GroupNode;
import com.cognos.mobile.vm.node.SpotMouseHandler;
import com.cognos.mobile.vm.render.RenderState;

public class SpotNode
extends Node {
    private static final boolean DEBUG_SHOW_SPOTS = false;
    private static final int SPOT_CX = 8;
    private static final int SPOT_CY = 8;
    private double normalizedX;
    private double normalizedY;
    private int index = -1;
    private int leftSpot = -1;
    private int upSpot = -1;
    private int rightSpot = -1;
    private int downSpot = -1;
    private DefaultMouseHandler mouseHandler;

    public SpotNode(double normalizedX, double normalizedY) {
        super(5, 0x100010);
        this.normalizedX = normalizedX;
        this.normalizedY = normalizedY;
    }

    public SpotNode(SpotNode other) {
        super(other);
    }

    @Override
    public Node cloneNode() {
        return new SpotNode(this);
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        sb.append("spot");
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("\"");
        } else {
            sb.append(" ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    public void size(VMScene scene) throws CMException {
    }

    @Override
    public void layout(RenderState state, int x, int y) {
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
        int parentCX = parent.getLayoutRect().cx - 1;
        int parentCY = parent.getLayoutRect().cy - 1;
        if (parentCX <= 0) {
            return;
        }
        if (parentCY <= 0) {
            return;
        }
        int spotX = CMMathHelper.multiplyIntByDouble(parentCX, this.normalizedX);
        int spotY = CMMathHelper.multiplyIntByDouble(parentCY, this.normalizedY);
        this.setLayout(spotX - 4, spotY - 4, 8, 8, state);
    }

    @Override
    public void paint(RenderState renderState) throws CMException {
        renderState.pushCurrentNode(this);
        if (renderState.isSelected()) {
            this.paintSelection(renderState);
        }
        renderState.popCurrentNode(0);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void paintSelection(RenderState state) {
        VMRect rect = new VMRect();
        rect.cx = this.getRenderRect((RenderState)state).cx;
        rect.cy = this.getRenderRect((RenderState)state).cy;
        state.getPainter().setColor(VMColor.DEFAULT_BACK_COLOR);
        state.getPainter().drawRect(rect.x, rect.y, rect.cx, rect.cy);
        rect.inflateRect(-1, -1);
        state.getPainter().setColor(VMColor.SELECTION_BORDER_COLOR);
        state.getPainter().drawRect(rect.x, rect.y, rect.cx, rect.cy);
        state.getPainter().setColor(VMColor.SELECTION_FILL_COLOR);
        rect.inflateRect(-1, -1);
        state.getPainter().fillRect(rect.x, rect.y, rect.cx, rect.cy);
    }

    @Override
    public IKeyHandler getKeyHandler() {
        if (this.getParent() != null && this.getParent().getType() == 4 && ((GroupNode)this.getParent()).getGroupType() == 5) {
            return ((GroupNode)this.getParent()).getSpotKeyHandler();
        }
        return super.getKeyHandler();
    }

    @Override
    public IMouseHandler getMouseHandler() {
        if (this.mouseHandler == null) {
            this.mouseHandler = new SpotMouseHandler(this.getScene());
        }
        return this.mouseHandler;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setLeftSpot(int leftSpot) {
        this.leftSpot = leftSpot;
    }

    public int getLeftSpot() {
        return this.leftSpot;
    }

    public void setUpSpot(int upSpot) {
        this.upSpot = upSpot;
    }

    public int getUpSpot() {
        return this.upSpot;
    }

    public void setRightSpot(int rightSpot) {
        this.rightSpot = rightSpot;
    }

    public int getRightSpot() {
        return this.rightSpot;
    }

    public void setDownSpot(int downSpot) {
        this.downSpot = downSpot;
    }

    public int getDownSpot() {
        return this.downSpot;
    }
}

