/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import java.util.Vector;

public class TableBuilder {
    private static final Class CLASS = TableBuilder.class;
    private TableNode table;
    private TablePartNode topLeftPart;
    private TablePartNode topPart;
    private TablePartNode leftPart;
    private TablePartNode mainPart;
    private Vector rows;
    private VMPoint span;

    public TableBuilder(TableNode table) {
        this.table = table;
        this.rows = new Vector();
    }

    public TablePartNode getTopLeftPart() {
        return this.topLeftPart;
    }

    public TablePartNode getTopPart() {
        return this.topPart;
    }

    public TablePartNode getLeftPart() {
        return this.leftPart;
    }

    public TablePartNode getMainPart() {
        return this.mainPart;
    }

    public int getRowCount() {
        return this.span.y;
    }

    public int getColumnCount() {
        return this.span.x;
    }

    public void onBuildBeginRow() {
        Row row = new Row();
        row.cells = new Vector();
        this.rows.addElement(row);
    }

    public CellNode onBuildBeginCell(CellNode cellNode) {
        if (this.rows.isEmpty()) {
            VM.log(CLASS, 2, "missing TableRow");
            this.onBuildBeginRow();
        }
        Row row = (Row)this.rows.elementAt(this.rows.size() - 1);
        row.cells.addElement(cellNode);
        return cellNode;
    }

    public void buildTable() throws CMException {
        if (this.rows.isEmpty() || ((Row)this.rows.elementAt((int)0)).cells.isEmpty()) {
            VM.log(CLASS, 2, "empty table found");
            this.onBuildBeginCell(new CellNode(1, 1));
        }
        this.span = this.ensureSpansValid();
        this.positionCells(false);
        this.span = this.countRowsAndColumns();
        this.buildTableParts();
    }

    private VMPoint countRowsAndColumns() {
        VMPoint rc = new VMPoint();
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.elementAt(i);
            for (int j = 0; j < row.cells.size(); ++j) {
                CellNode cell = (CellNode)row.cells.elementAt(j);
                int rowCount = cell.getRow() + cell.getRowspan();
                int colCount = cell.getColumn() + cell.getColspan();
                rc.x = Math.max(rc.x, colCount);
                rc.y = Math.max(rc.y, rowCount);
            }
        }
        return rc;
    }

    private VMPoint ensureSpansValid() {
        boolean foundSpan = false;
        int spanRowCount = 0;
        int spanColCount = 0;
        int rowCount = this.rows.size();
        for (int i = 0; i < rowCount; ++i) {
            Row row = (Row)this.rows.elementAt(i);
            int maxRowSpan = 0;
            int rowColCount = 0;
            int cellCount = row.cells.size();
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                CellNode cell = (CellNode)row.cells.elementAt(cellIndex);
                int rowspan = cell.getRowspan();
                int colspan = cell.getColspan();
                if (rowspan > 1 || colspan > 1) {
                    foundSpan = true;
                }
                maxRowSpan = Math.max(maxRowSpan, rowspan);
                rowColCount += colspan;
            }
            spanRowCount += maxRowSpan;
            spanColCount = Math.max(spanColCount, rowColCount);
        }
        VM.log(CLASS, 0, "table appears to span at most " + spanColCount + " column(s) and " + spanRowCount + " row(s)");
        if (spanRowCount == 0 || spanColCount == 0) {
            return new VMPoint();
        }
        if (!foundSpan) {
            VM.log(CLASS, 0, "table contains no spans, so no reduction required");
            return new VMPoint(spanColCount, spanRowCount);
        }
        CellNode[][] spots = new CellNode[spanColCount][spanRowCount];
        int rowIndex = 0;
        int colIndex = 0;
        for (int i = 0; i < rowCount; ++i) {
            Row row = (Row)this.rows.elementAt(i);
            int cellCount = row.cells.size();
            int maxRowSpan = 1;
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                CellNode cell = (CellNode)row.cells.elementAt(cellIndex);
                for (int x = 0; x < cell.getColspan(); ++x) {
                    for (int y = 0; y < cell.getRowspan(); ++y) {
                        if (colIndex + x >= spanColCount) {
                            VM.log(CLASS, 3, "impossible column index found: " + colIndex + x);
                            continue;
                        }
                        if (rowIndex + y >= spanRowCount) {
                            VM.log(CLASS, 3, "impossible row index found: " + rowIndex + y);
                            continue;
                        }
                        spots[colIndex + x][rowIndex + y] = cell;
                    }
                }
                maxRowSpan = Math.max(maxRowSpan, cell.getRowspan());
                colIndex += cell.getColspan();
            }
            if (i >= rowCount - 1) continue;
            colIndex = this.findFirstEmptyColumn(spots, ++rowIndex);
            while (colIndex == -1 && rowIndex < spanRowCount - 1) {
                colIndex = this.findFirstEmptyColumn(spots, ++rowIndex);
            }
            if (colIndex != -1) continue;
            VM.log(CLASS, 3, "impossible: not enough rows");
            break;
        }
        String lastSignature = this.computeRowSignature(spots, 0);
        for (int y = 1; y < spanRowCount; ++y) {
            String signature = this.computeRowSignature(spots, y);
            if (signature.equals(lastSignature)) {
                VM.log(CLASS, 0, "reducing row " + y);
                for (int x = 0; x < spots.length; ++x) {
                    if (spots[x][y] == null) continue;
                    spots[x][y].reduceRowSpan();
                }
            }
            lastSignature = signature;
        }
        lastSignature = this.computeColumnSignature(spots, 0);
        for (int x = 1; x < spanColCount; ++x) {
            String signature = this.computeColumnSignature(spots, x);
            if (signature.equals(lastSignature)) {
                VM.log(CLASS, 0, "reducing column " + x);
                for (int y = 0; y < spots[x].length; ++y) {
                    if (spots[x][y] == null) continue;
                    spots[x][y].reduceColumnSpan();
                }
            }
            lastSignature = signature;
        }
        return new VMPoint(spanColCount, spanRowCount);
    }

    private int findFirstEmptyColumn(CellNode[][] spots, int row) {
        for (int col = 0; col < spots.length; ++col) {
            if (row >= spots[col].length || spots[col][row] != null) continue;
            return col;
        }
        return -1;
    }

    private String computeRowSignature(CellNode[][] spots, int row) {
        StringBuffer sig = new StringBuffer();
        for (int col = 0; col < spots.length; ++col) {
            if (col != 0) {
                sig.append(':');
            }
            if (spots[col][row] == null) continue;
            sig.append(spots[col][row].hashCode());
        }
        char[] c = new char[sig.length()];
        sig.getChars(0, sig.length(), c, 0);
        return new String(c);
    }

    private String computeColumnSignature(CellNode[][] spots, int col) {
        StringBuffer sig = new StringBuffer();
        int rowCount = spots[0].length;
        for (int row = 0; row < rowCount; ++row) {
            if (row != 0) {
                sig.append(':');
            }
            if (spots[col][row] == null) continue;
            sig.append(spots[col][row].hashCode());
        }
        char[] c = new char[sig.length()];
        sig.getChars(0, sig.length(), c, 0);
        return new String(c);
    }

    private void positionCells(boolean isFocusTable) {
        int[] rowspanLeft = new int[this.getColumnCount()];
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            Row row = (Row)this.rows.elementAt(rowIndex);
            int cellCount = row.cells.size();
            int colIndex = 0;
            for (int cellIndex = 0; cellIndex < cellCount && colIndex < this.getColumnCount(); ++cellIndex) {
                CellNode cellNode = (CellNode)row.cells.elementAt(cellIndex);
                while (colIndex < this.getColumnCount() && rowspanLeft[colIndex] > 0) {
                    int n = colIndex++;
                    rowspanLeft[n] = rowspanLeft[n] - 1;
                }
                if (colIndex == this.getColumnCount()) {
                    VM.log(CLASS, 3, "extra cells in row " + rowIndex);
                    break;
                }
                cellNode.setColumnAndRow(colIndex, rowIndex);
                for (int i = 0; i < cellNode.getColspan(); ++i) {
                    rowspanLeft[colIndex] = cellNode.getRowspan() - 1;
                    ++colIndex;
                }
            }
            while (colIndex < this.getColumnCount()) {
                if (rowspanLeft[colIndex] > 0) {
                    int n = colIndex;
                    rowspanLeft[n] = rowspanLeft[n] - 1;
                }
                ++colIndex;
            }
        }
    }

    private void buildTableParts() {
        int j;
        int i;
        this.topLeftPart = null;
        this.topPart = null;
        this.leftPart = null;
        this.mainPart = null;
        int freezeRows = this.table.getFreezeRowCount();
        int freezeCols = this.table.getFreezeColumnCount();
        if (freezeRows > 0 && freezeCols > 0) {
            this.topLeftPart = new TablePartNode(this.table, 0, 0);
        }
        if (freezeRows > 0) {
            this.topPart = new TablePartNode(this.table, 0, freezeCols);
        }
        if (freezeCols > 0) {
            this.leftPart = new TablePartNode(this.table, freezeRows, 0);
        }
        this.mainPart = new TablePartNode(this.table, freezeRows, freezeCols);
        for (i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.elementAt(i);
            for (j = 0; j < row.cells.size(); ++j) {
                CellNode cell = (CellNode)row.cells.elementAt(j);
                if (cell.getRow() == -1 || cell.getColumn() == -1) {
                    VM.log(CLASS, 2, "ignoring extra cell near row=" + i + ", cell=" + j);
                    continue;
                }
                if (cell.getColumn() < freezeCols && cell.getRow() < freezeRows) {
                    this.topLeftPart.addCell(cell);
                    continue;
                }
                if (cell.getRow() < freezeRows) {
                    this.topPart.addCell(cell);
                    continue;
                }
                if (cell.getColumn() < freezeCols) {
                    this.leftPart.addCell(cell);
                    continue;
                }
                this.mainPart.addCell(cell);
            }
        }
        if (!this.table.checkStyle(4096)) {
            VMPoint sourceCoords;
            CellNode cell;
            int i2;
            TablePartNode part;
            TablePartNode[] parts;
            if (this.table.getFocus() == 0) {
                if (this.topPart != null) {
                    for (i = 0; i < this.topPart.getChildCount(); ++i) {
                        this.topPart.getChild(i).setStyle(128, false);
                    }
                }
                if (this.leftPart != null) {
                    for (i = 0; i < this.leftPart.getChildCount(); ++i) {
                        this.leftPart.getChild(i).setStyle(64, false);
                    }
                }
                if (this.mainPart != null) {
                    for (i = 0; i < this.mainPart.getChildCount(); ++i) {
                        this.mainPart.getChild(i).setStyle(192, false);
                    }
                }
            }
            if (this.table.getFocus() == 2) {
                TableNode sourceTable = this.table.getSourceTable();
                parts = new TablePartNode[]{this.topPart, this.mainPart};
                for (j = 0; j < parts.length; ++j) {
                    part = parts[j];
                    if (part == null) continue;
                    for (i2 = 0; i2 < part.getChildCount(); ++i2) {
                        cell = (CellNode)part.getChild(i2);
                        sourceCoords = this.table.focusToAbsolute(cell.getRow(), cell.getColumn());
                        if (sourceCoords.x > sourceTable.getFreezeColumnCount()) {
                            cell.setStyle(1024, false);
                        }
                        if (sourceCoords.x >= sourceTable.getColumnCount() - 1) continue;
                        cell.setStyle(2048, false);
                    }
                }
            }
            if (this.table.getFocus() == 1) {
                TableNode sourceTable = this.table.getSourceTable();
                parts = new TablePartNode[]{this.leftPart, this.mainPart};
                for (j = 0; j < parts.length; ++j) {
                    part = parts[j];
                    if (part == null) continue;
                    for (i2 = 0; i2 < part.getChildCount(); ++i2) {
                        cell = (CellNode)part.getChild(i2);
                        sourceCoords = this.table.focusToAbsolute(cell.getRow(), cell.getColumn());
                        if (sourceCoords.y > sourceTable.getFreezeRowCount()) {
                            cell.setStyle(256, false);
                        }
                        if (sourceCoords.y >= sourceTable.getRowCount() - 1) continue;
                        cell.setStyle(512, false);
                    }
                }
            }
            TablePartNode[] parts2 = new TablePartNode[]{this.topPart, this.leftPart, this.mainPart};
            for (int j2 = 0; j2 < parts2.length; ++j2) {
                TablePartNode part2 = parts2[j2];
                if (part2 == null) continue;
                for (int i3 = 0; i3 < part2.getChildCount(); ++i3) {
                    CellNode cell2 = (CellNode)part2.getChild(i3);
                    cell2.setStyle(65536, false);
                }
            }
        }
    }

    private static class Row {
        Vector cells;

        private Row() {
        }
    }
}

