/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.Selection;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;

public class TableKeyHandler
implements IKeyHandler {
    private final Class CLASS = TableKeyHandler.class;
    private TableNode table;
    private int lastRow;
    private int lastColumn;

    public TableKeyHandler(TableNode table) {
        this.table = table;
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    @Override
    public boolean sendKey(int key, int flags) {
        Selection selection = this.table.getScene().getSelection();
        if (selection.getSelectedNode() == null || selection.getSelectedNode().getType() != 3) {
            VM.log(this.CLASS, 3, "not selected table cell");
            return false;
        }
        CellNode cell = (CellNode)selection.getSelectedNode();
        if (this.lastRow == -1 || this.lastRow < cell.getRow() || this.lastRow >= cell.getRow() + cell.getRowspan()) {
            this.lastRow = cell.getRow();
        }
        if (this.lastColumn == -1 || this.lastColumn < cell.getColumn() || this.lastColumn >= cell.getColumn() + cell.getColspan()) {
            this.lastColumn = cell.getColumn();
        }
        if (!this.table.checkStyle(4096)) {
            switch (key) {
                case 3: {
                    key = 8;
                    break;
                }
                case 4: {
                    key = 7;
                }
            }
        }
        boolean handled = false;
        int visibleSides = cell.getVisibility().getVisibleSides(cell);
        boolean shouldScrollPage = false;
        if (cell.hasNestedTable()) {
            switch (key) {
                case 1: {
                    if ((visibleSides & 1) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 7: {
                    if ((visibleSides & 2) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 2: {
                    if ((visibleSides & 4) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 8: {
                    if ((visibleSides & 8) != 0) break;
                    shouldScrollPage = true;
                }
            }
        }
        if (!shouldScrollPage) {
            switch (key) {
                case 8: {
                    handled = this.moveSelection(selection, true, cell.getRow() + cell.getRowspan(), this.lastColumn, 1);
                    break;
                }
                case 7: {
                    handled = this.moveSelection(selection, true, cell.getRow() - 1, this.lastColumn, -1);
                    break;
                }
                case 1: {
                    handled = this.moveSelection(selection, true, this.lastRow, cell.getColumn() - 1, 1);
                    break;
                }
                case 2: {
                    handled = this.moveSelection(selection, true, this.lastRow, cell.getColumn() + cell.getColspan(), -1);
                    break;
                }
                case 4: {
                    if (this.lastColumn == 0) {
                        handled = this.moveSelection(selection, false, this.lastRow - 1, 0, -1);
                        break;
                    }
                    handled = this.moveSelection(selection, false, this.lastRow, this.lastColumn - 1, -1);
                    break;
                }
                case 3: {
                    if (this.lastColumn + cell.getColspan() >= this.table.getColumnCount()) {
                        handled = this.moveSelection(selection, false, this.lastRow + 1, 0, 1);
                        break;
                    }
                    handled = this.moveSelection(selection, false, this.lastRow, this.lastColumn + cell.getColspan(), 1);
                    break;
                }
                case 5: {
                    CellNode first = (CellNode)this.table.getMainPart().getChild(0);
                    handled = this.moveSelection(selection, false, first.getRow(), first.getColumn(), -1);
                    break;
                }
                case 6: {
                    CellNode last = (CellNode)this.table.getMainPart().getChild(this.table.getMainPart().getChildCount() - 1);
                    handled = this.moveSelection(selection, false, last.getRow(), last.getColumn(), 1);
                    break;
                }
                default: {
                    handled = false;
                }
            }
        }
        return handled;
    }

    private boolean moveSelection(Selection selection, boolean eatKeypress, int newRow, int newColumn, int dir) {
        if (newRow < 0 || newRow >= this.table.getRowCount()) {
            return eatKeypress;
        }
        if (newColumn < 0 || newColumn >= this.table.getColumnCount()) {
            return eatKeypress;
        }
        VM.log(this.CLASS, 0, "target selected cell: row=" + newRow + ", col=" + newColumn);
        CellNode cell = this.table.findTableCell(newRow, newColumn);
        if (cell == null) {
            return eatKeypress;
        }
        if (cell == selection.getSelectedNode()) {
            return eatKeypress;
        }
        selection.select(cell, dir, 1);
        return true;
    }
}

