/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.DefaultMouseHandler;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TableScroller;

public class TableMouseHandler
implements IMouseHandler {
    private static final Class CLASS = DefaultMouseHandler.class;
    private static final int CLICK_HYSTERESIS = 3;
    private boolean isMouseDown;
    private VMPoint mouseDown;
    private VMPoint sceneDownViewport;
    private VMPoint tableDownViewport;
    private boolean isTableScrollX;
    private boolean isTableScrollY;
    private boolean isSceneScrollX;
    private boolean isSceneScrollY;
    private TableNode table;
    private VMScene scene;
    private TableScroller tableScroller;

    public TableMouseHandler(TableNode table, TableScroller tableScroller) {
        this.table = table;
        this.scene = table.getScene();
        this.tableScroller = tableScroller;
        this.isMouseDown = false;
        this.isTableScrollX = tableScroller.getViewport().isScrollableX();
        this.isTableScrollY = tableScroller.getViewport().isScrollableY();
        this.isSceneScrollX = this.scene.getViewport().isScrollableX();
        this.isSceneScrollY = this.scene.getViewport().isScrollableY();
    }

    @Override
    public void sendMouse(int mouse, int x, int y) {
        switch (mouse) {
            case 1: {
                this.sendMouseDown(x, y);
                break;
            }
            case 2: {
                this.sendMouseMove(x, y);
                break;
            }
            case 3: {
                this.sendMouseUp(x, y);
                break;
            }
            default: {
                VM.log(CLASS, 3, "invalid mouse constant: " + mouse);
            }
        }
    }

    private void sendMouseDown(int x, int y) {
        this.isMouseDown = true;
        this.mouseDown = new VMPoint(x, y);
        this.sceneDownViewport = new VMPoint(this.scene.getViewport().x, this.scene.getViewport().y);
        this.tableDownViewport = new VMPoint(this.tableScroller.getViewport().x, this.tableScroller.getViewport().y);
    }

    private void sendMouseMove(int x, int y) {
        int dy;
        int newY;
        int newX;
        int dx;
        if (!this.isMouseDown) {
            return;
        }
        boolean scrolled = false;
        VMRect invalidateRect = null;
        if (this.isTableScrollX || this.isTableScrollY) {
            dx = this.isTableScrollX ? x - this.mouseDown.x : 0;
            newX = this.tableDownViewport.x + dx;
            if (this.tableScroller.scrollTo(newX, newY = this.tableDownViewport.y + (dy = this.isTableScrollY ? y - this.mouseDown.y : 0))) {
                scrolled = true;
                invalidateRect = this.table.getAbsoluteRect();
            }
        } else if (!this.isSceneScrollX && !this.isSceneScrollY) {
            this.isSceneScrollX = this.scene.getViewport().isScrollableX();
            this.isSceneScrollY = this.scene.getViewport().isScrollableY();
        }
        if (!scrolled && (this.isSceneScrollX || this.isSceneScrollY)) {
            dx = this.isSceneScrollX ? x - this.mouseDown.x : 0;
            dy = this.isSceneScrollY ? y - this.mouseDown.x : 0;
            newX = this.sceneDownViewport.x + dx;
            newY = this.sceneDownViewport.y + dy;
            if (this.scene.getViewport().scrollTo(newX, newY)) {
                scrolled = true;
                invalidateRect = null;
            }
        }
        if (scrolled && this.scene.getHost() != null) {
            this.scene.getHost().onSceneInvalidateRect(this.scene, invalidateRect);
        }
    }

    private void sendMouseUp(int x, int y) {
        boolean isClick;
        this.isMouseDown = false;
        int dx = Math.abs(this.mouseDown.x - x);
        int dy = Math.abs(this.mouseDown.y - y);
        boolean bl = isClick = dx <= 3 && dy <= 3;
        if (isClick) {
            x = this.scene.getViewport().physicalToLogicalX(x);
            y = this.scene.getViewport().physicalToLogicalY(y);
            this.scene.getSelection().selectByPoint(x, y, 1);
        }
    }
}

