/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMVectorHelper;
import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.INodeVisibility;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.layout.ILayout;
import com.cognos.mobile.vm.layout.TableLayout;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableBuilder;
import com.cognos.mobile.vm.node.TableKeyHandler;
import com.cognos.mobile.vm.node.TableMouseHandler;
import com.cognos.mobile.vm.node.TableNodeVisibility;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.node.TableScroller;
import com.cognos.mobile.vm.node.TextNode;
import com.cognos.mobile.vm.render.RenderState;
import java.util.Vector;

public class TableNode
extends Node {
    private static final Class CLASS = TableNode.class;
    private int focus;
    private TableNode sourceTable;
    private int[] focusRowCols;
    private VMPoint freeze;
    private TablePartNode topLeftPart;
    private TablePartNode topPart;
    private TablePartNode leftPart;
    private TablePartNode mainPart;
    private TableBuilder builder;
    private TableKeyHandler keyHandler;
    private TableMouseHandler mouseHandler;
    private TableScroller scroller;
    private TableNodeVisibility visibility;
    private Vector rows;
    private Vector columns;

    @Override
    public boolean hasNestedTable() {
        TablePartNode tbn = (TablePartNode)this.getChild(0);
        for (int i = 0; i < tbn.getChildCount(); ++i) {
            if (!((CellNode)tbn.getChild(i)).hasNestedTable()) continue;
            return true;
        }
        return false;
    }

    public TableNode(int focus, TableNode sourceTable, int[] focusRowCols, String tableID) {
        super(2, 524328);
        this.focus = focus;
        this.sourceTable = sourceTable;
        this.focusRowCols = focusRowCols;
        this.freeze = new VMPoint(-1, -1);
        this.keyHandler = new TableKeyHandler(this);
        this.mouseHandler = null;
        this.visibility = null;
        this.setID(tableID);
    }

    public TableNode(TableNode other) {
        super(other);
        this.focus = other.focus;
        this.sourceTable = other.sourceTable;
        this.focusRowCols = CMVectorHelper.cloneIntVector(other.focusRowCols);
        this.freeze = new VMPoint(other.freeze);
        this.keyHandler = new TableKeyHandler(this);
        this.mouseHandler = null;
        this.visibility = null;
        this.topLeftPart = null;
        this.topPart = null;
        this.leftPart = null;
        this.mainPart = null;
    }

    public int getFocus() {
        return this.focus;
    }

    public TableNode getSourceTable() {
        return this.sourceTable;
    }

    public INodeVisibility getTableVisibility() {
        if (this.visibility == null) {
            return super.getVisibility();
        }
        return this.visibility;
    }

    public IKeyHandler getTableKeyHandler() {
        return this.keyHandler;
    }

    public TablePartNode getTopLeftPart() {
        return this.topLeftPart;
    }

    public TablePartNode getTopPart() {
        return this.topPart;
    }

    public TablePartNode getLeftPart() {
        return this.leftPart;
    }

    public TablePartNode getMainPart() {
        return this.mainPart;
    }

    public VMRect getPartVisibleRect(TablePartNode part) {
        return this.getPartVisibleRect(part, null);
    }

    public VMRect getPartVisibleRect(TablePartNode part, RenderState state) {
        if (this.scroller == null) {
            return part.getAbsoluteRect(state);
        }
        return this.scroller.getPartVisibleRect(part, state);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowHeight(int index) {
        Row row = (Row)this.rows.elementAt(index);
        return row.height;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnWidth(int index) {
        Column column = (Column)this.columns.elementAt(index);
        return column.width;
    }

    public int getFreezeRowCount() {
        if (this.freeze.y < 1) {
            return 0;
        }
        return this.freeze.y;
    }

    public int getFreezeColumnCount() {
        if (this.freeze.x < 1) {
            return 0;
        }
        return this.freeze.x;
    }

    public CellNode findTableCell(int targetRow, int targetColumn) {
        TablePartNode partNode = null;
        partNode = targetRow < this.freeze.y && targetColumn < this.freeze.x ? this.topLeftPart : (targetRow < this.freeze.y ? this.topPart : (targetColumn < this.freeze.x ? this.leftPart : this.mainPart));
        if (partNode != null) {
            return partNode.findTableCell(targetRow, targetColumn);
        }
        return null;
    }

    public VMPoint focusToAbsolute(int row, int column) {
        VMPoint abs;
        switch (this.focus) {
            default: {
                abs = new VMPoint(column, row);
                break;
            }
            case 1: 
            case 2: {
                if (this.freeze.x <= 0) {
                    if (column >= this.focusRowCols.length) {
                        VM.log(CLASS, 3, "invalid column index: " + column);
                        column = this.focusRowCols.length - 1;
                    }
                    column = this.focusRowCols[column];
                } else if (column >= this.freeze.x) {
                    if (column >= this.focusRowCols.length + this.freeze.x) {
                        VM.log(CLASS, 3, "invalid column index: " + column);
                        column = this.focusRowCols.length + this.freeze.x - 1;
                    }
                    column = this.focusRowCols[column - this.freeze.x];
                }
                abs = this.focus == 1 ? new VMPoint(row, column) : new VMPoint(column, row);
            }
        }
        return abs;
    }

    public boolean isScrolling() {
        return this.scroller != null && this.scroller.isScrolling();
    }

    @Override
    public Node cloneNode() {
        return new TableNode(this);
    }

    @Override
    public Node cloneTree() throws CMException {
        int i;
        TableNode clone = (TableNode)this.cloneNode();
        clone.rows = new Vector();
        for (i = 0; i < this.getRowCount(); ++i) {
            clone.rows.addElement(new Row());
        }
        clone.columns = new Vector();
        for (i = 0; i < this.getColumnCount(); ++i) {
            clone.columns.addElement(new Column());
        }
        if (this.topLeftPart != null) {
            clone.topLeftPart = (TablePartNode)this.topLeftPart.cloneTree();
            clone.addChild(clone.topLeftPart);
        }
        if (this.topPart != null) {
            clone.topPart = (TablePartNode)this.topPart.cloneTree();
            clone.addChild(clone.topPart);
        }
        if (this.leftPart != null) {
            clone.leftPart = (TablePartNode)this.leftPart.cloneTree();
            clone.addChild(clone.leftPart);
        }
        if (this.mainPart != null) {
            clone.mainPart = (TablePartNode)this.mainPart.cloneTree();
            clone.addChild(clone.mainPart);
        }
        return clone;
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        String table = this.checkStyle(4096) ? "layout table" : "table";
        StringBuffer sb = new StringBuffer();
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append(table + "\"");
        } else {
            sb.append(table + " ");
            sb.append(this.getColumnCount());
            sb.append("x");
            sb.append(this.getRowCount());
            sb.append(" ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    @Override
    public VMPoint getMaxSize(RenderState state) {
        return VMPoint.ZERO;
    }

    @Override
    public boolean isSelectable() {
        return !this.checkStyle(4096);
    }

    @Override
    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public void setFreeze(int cols, int rows) {
        this.freeze.x = cols > 0 ? cols : -1;
        this.freeze.y = rows > 0 ? rows : -1;
    }

    public void onBuildBeginRow() throws CMException {
        if (this.builder == null) {
            this.builder = new TableBuilder(this);
        }
        this.builder.onBuildBeginRow();
    }

    public CellNode onBuildBeginCell(CellNode cellNode) {
        if (this.builder == null) {
            this.builder = new TableBuilder(this);
        }
        return this.builder.onBuildBeginCell(cellNode);
    }

    @Override
    public void onBuildEnd(int endAddress) throws CMException {
        super.onBuildEnd(endAddress);
        if (this.builder == null) {
            this.builder = new TableBuilder(this);
        }
        this.builder.buildTable();
        this.topLeftPart = this.builder.getTopLeftPart();
        this.topPart = this.builder.getTopPart();
        this.leftPart = this.builder.getLeftPart();
        this.mainPart = this.builder.getMainPart();
        int rowCount = this.builder.getRowCount();
        this.rows = new Vector(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.rows.addElement(new Row());
        }
        int columnCount = this.builder.getColumnCount();
        this.columns = new Vector(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.columns.addElement(new Column());
        }
        this.resetChildren();
        if (this.topLeftPart != null) {
            this.addChild(this.topLeftPart);
        }
        if (this.topPart != null) {
            this.addChild(this.topPart);
        }
        if (this.leftPart != null) {
            this.addChild(this.leftPart);
        }
        if (this.mainPart != null) {
            this.addChild(this.mainPart);
        }
        this.builder = null;
    }

    @Override
    public void onSizeEnd(int cx, int cy, RenderState state) {
        int i;
        for (i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.elementAt(i);
            row.height = 0;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.elementAt(i);
            col.width = 0;
        }
        super.onSizeEnd(cx, cy, state);
    }

    @Override
    public int getMargin() {
        if (this.checkStyle(4096)) {
            return 0;
        }
        return 2;
    }

    public void updateRowHeight(int index, int height) {
        Row row = (Row)this.rows.elementAt(index);
        row.height = Math.max(row.height, height);
    }

    public void updateColumnWidth(int index, int width) {
        Column col = (Column)this.columns.elementAt(index);
        col.width = Math.max(col.width, width);
    }

    @Override
    public ILayout getLayout() {
        return TableLayout.instance();
    }

    @Override
    public void onLayoutEnd(RenderState renderState) throws CMException {
        super.onLayoutEnd(renderState);
        this.initializeScrolling();
    }

    public void initializeScrolling() {
        TableScroller scroller = new TableScroller(this);
        if (scroller.initializeScrolling()) {
            VM.log(CLASS, 1, "scrolling enabled for " + this.toString());
            this.scroller = scroller;
            this.visibility = new TableNodeVisibility(this, scroller);
            this.mouseHandler = new TableMouseHandler(this, scroller);
        } else {
            this.scroller = null;
        }
    }

    public boolean allNodesHasEmptyText() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            TablePartNode tmp = (TablePartNode)this.getChild(i);
            for (int j = 0; j < tmp.getChildCount(); ++j) {
                CellNode tmpCell = (CellNode)tmp.getChild(j);
                if (tmpCell.getChildCount() > 1) {
                    return false;
                }
                if (tmpCell.getChild(0) instanceof TextNode) {
                    if (((TextNode)tmpCell.getChild(0)).getText().trim().length() <= 0) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void paint(RenderState state) throws CMException {
        if (this.allNodesHasEmptyText()) {
            return;
        }
        if (this.checkStyle(8192)) {
            super.paint(state);
            return;
        }
        VM.log(CLASS, 0, this.toString() + " paint begin");
        try {
            VMRect clipRect = new VMRect(0, 0, this.getRenderRect((RenderState)state).cx, this.getRenderRect((RenderState)state).cy);
            state.pushCurrentNode(this, clipRect);
            if (!this.checkStyle(4096)) {
                state.setTextColor(VMColor.DEFAULT_TEXT_COLOR);
                state.setBackColor(VMColor.DEFAULT_BACK_COLOR);
            }
            if (this.mainPart != null) {
                this.mainPart.paint(state);
            }
            if (this.topPart != null) {
                this.topPart.paint(state);
            }
            if (this.leftPart != null) {
                this.leftPart.paint(state);
            }
            if (this.topLeftPart != null) {
                this.topLeftPart.paint(state);
            }
            if (this.shouldPaintSelection(state)) {
                this.paintSelection(state);
            }
        }
        finally {
            state.popCurrentNode(0);
        }
        VM.log(CLASS, 0, this.toString() + " paint end");
    }

    @Override
    public void onPaintEnd(RenderState state) {
        int[] borderColor = state.getBorderColors();
        int cx = this.getRenderRect((RenderState)state).cx;
        int cy = this.getRenderRect((RenderState)state).cy;
        state.painter.drawRect(state.getBorderDisplay(), borderColor, 0, 0, cx, cy);
    }

    private boolean shouldPaintSelection(RenderState state) {
        boolean subfocusedChild = false;
        if (state.isAncestorSelected() && !this.getParent().checkStyle(32) && this.getParent().checkStyle(0x400000)) {
            subfocusedChild = true;
        }
        return state.isSelected() || subfocusedChild && this.getParent() == this.getScene().getSelection().getSelectedNode();
    }

    @Override
    public boolean alwaysCheckCache() {
        return this.isSelectable();
    }

    public static class Column {
        int width;
    }

    private static class Row {
        int height;

        private Row() {
        }
    }
}

