/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.INodeVisibility;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.node.TableScroller;
import com.cognos.mobile.vm.render.RenderState;

public class TableNodeVisibility
implements INodeVisibility {
    private static final Class CLASS = TableNodeVisibility.class;
    private TableNode table;
    private TableScroller scroller;

    public TableNodeVisibility(TableNode table, TableScroller scroller) {
        this.table = table;
        this.scroller = scroller;
    }

    @Override
    public int getVisibleSides(Node node) {
        switch (node.getType()) {
            case 3: {
                return this.scroller.getCellVisibleSides((CellNode)node);
            }
            case 7: {
                return this.scroller.getPartVisibleSides((TablePartNode)node);
            }
        }
        VM.log(CLASS, 3, "unexpected node type: " + node.toString());
        return 0;
    }

    @Override
    public boolean ensureNodeVisible(Node node, boolean fullyVisible, int dir, boolean allowSnap) {
        boolean changed = false;
        if (this.table.getVisibility().ensureNodeVisible(this.table, false, dir, allowSnap)) {
            changed = true;
        }
        switch (node.getType()) {
            case 3: {
                if (!this.scroller.ensureCellVisible((CellNode)node, fullyVisible, dir, allowSnap)) break;
                changed = true;
                break;
            }
            case 7: {
                if (!this.scroller.ensurePartVisible((TablePartNode)node, fullyVisible, dir, allowSnap)) break;
                changed = true;
                break;
            }
            default: {
                VM.log(CLASS, 3, "unexpected node type: " + node.toString());
            }
        }
        VMRect rect = node.getAbsoluteRect();
        if (node.getScene().getViewport().ensureRectVisible(rect, dir, allowSnap)) {
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isVisible(Node node, RenderState state) {
        int visibleSides = this.getVisibleSides(node);
        return (visibleSides & 1) != 0 || (visibleSides & 2) != 0 || (visibleSides & 4) != 0 || (visibleSides & 8) != 0;
    }
}

