/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.render.RenderState;
import java.util.Vector;

public class TablePartNode
extends Node {
    private static final Class CLASS = TablePartNode.class;
    private int startRow;
    private int startColumn;
    private final Vector rows;

    public TablePartNode(TableNode parentTable, int startRow, int startColumn) {
        super(7, 0);
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.rows = new Vector();
        this.setScene(parentTable.getScene());
    }

    public TablePartNode(TablePartNode other) {
        super(other);
        this.startRow = other.startRow;
        this.startColumn = other.startColumn;
        this.rows = other.rows;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public TableNode getTable() {
        if (this.getParent() == null || this.getParent().getType() != 2) {
            return null;
        }
        TableNode tableNode = (TableNode)this.getParent();
        return tableNode;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Row getRow(int index) {
        return (Row)this.rows.elementAt(index);
    }

    public CellNode findTableCell(int targetRow, int targetColumn) {
        if (targetRow < 0) {
            return null;
        }
        if (targetColumn < 0) {
            return null;
        }
        for (int i = targetRow; i >= 0; --i) {
            if (i >= this.rows.size()) continue;
            Row row = (Row)this.rows.elementAt(i);
            for (int j = targetColumn; j >= 0; --j) {
                CellNode cell;
                if (j >= row.cells.size() || targetRow < (cell = (CellNode)row.cells.elementAt(j)).getRow() || targetRow >= cell.getRow() + cell.getRowspan() || targetColumn < cell.getColumn() || targetColumn >= cell.getColumn() + cell.getColspan()) continue;
                return cell;
            }
        }
        return null;
    }

    public void addCell(CellNode cell) {
        int i;
        this.addChild(cell);
        if (this.startAddress == -1 || this.startAddress > cell.getStartAddress()) {
            this.startAddress = cell.getStartAddress();
        }
        if (this.endAddress == -1 || this.endAddress < cell.getEndAddress()) {
            this.endAddress = cell.getEndAddress();
        }
        if (cell.checkStyle(16384)) {
            this.setStyle(16384, false);
        }
        if (cell.checkStyle(32768)) {
            this.setStyle(32768, false);
        }
        if ((i = cell.getRow() - this.startRow) < 0) {
            VM.log(CLASS, 3, "attempted to add invalid cell");
            return;
        }
        while (i >= this.rows.size()) {
            this.rows.addElement(new Row());
        }
        Row row = (Row)this.rows.elementAt(i);
        row.cells.addElement(cell);
    }

    public int getApproxColumnCount() {
        if (this.rows.isEmpty()) {
            return 0;
        }
        Row row = (Row)this.rows.elementAt(this.rows.size() - 1);
        CellNode cell = (CellNode)row.cells.elementAt(row.cells.size() - 1);
        int columnCount = cell.getColumn() + cell.getColspan();
        return columnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(RenderState state) throws CMException {
        VM.log(CLASS, 0, this.toString() + " paint begin");
        TableNode table = this.getTable();
        VMRect clipRect = this.absoluteToRelative(table.getPartVisibleRect(this, state), state);
        try {
            state.pushCurrentNode(this, clipRect);
            boolean finished = false;
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                Row row = (Row)this.rows.elementAt(rowIndex);
                int cellCount = row.cells.size();
                if (cellCount > 0) {
                    for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                        CellNode cellNode = (CellNode)row.cells.elementAt(cellIndex);
                        if (cellNode.getRenderRect().y > clipRect.y + clipRect.cy) {
                            finished = true;
                            break;
                        }
                        if (cellNode.getRenderRect().x > clipRect.x + clipRect.cx) break;
                        if (!cellNode.getRenderRect(state).intersects(clipRect)) continue;
                        cellNode.paint(state);
                    }
                }
                if (!finished) continue;
                break;
            }
        }
        finally {
            state.popCurrentNode(0);
        }
    }

    @Override
    public Node cloneNode() {
        return new TablePartNode((TableNode)this.getParent(), this.getStartRow(), this.getStartColumn());
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("part \"");
        } else {
            sb.append("part (");
            sb.append(this.getRowCount());
            sb.append(" rows) ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    public static class Column {
        public int width;
    }

    public static class Row {
        public Vector cells = new Vector();
    }
}

