/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMViewport;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.render.RenderState;

public class TableScroller {
    private static final Class CLASS = TableScroller.class;
    private TableNode table;
    private VMPoint topLeftSize;
    private VMViewport mainViewport;

    public TableScroller(TableNode table) {
        this.table = table;
    }

    public boolean isScrolling() {
        return this.mainViewport != null;
    }

    public boolean initializeScrolling() {
        this.topLeftSize = null;
        this.mainViewport = null;
        if (this.table.getTopPart() == null && this.table.getLeftPart() == null) {
            return false;
        }
        boolean cellsAreSelectable = false;
        if (this.table.getMainPart().getChildCount() > 0 && this.table.getScene().getSelection().isSelectable(this.table.getMainPart().getChild(0))) {
            cellsAreSelectable = true;
        }
        if (!cellsAreSelectable) {
            return false;
        }
        this.topLeftSize = new VMPoint();
        int cxViewport = this.table.getScene().getViewport().getViewportWidth() - 1;
        int cyViewport = this.table.getScene().getViewport().getViewportHeight() - 1;
        if (this.table.getLeftPart() != null) {
            this.topLeftSize.x = this.table.getLeftPart().getLayoutRect().cx;
            cxViewport -= this.topLeftSize.x;
        }
        if (this.table.getTopPart() != null) {
            this.topLeftSize.y = this.table.getTopPart().getLayoutRect().cy;
            cyViewport -= this.topLeftSize.y;
        }
        int cyMin = this.table.getScene().getViewport().getViewportHeight() / 2;
        int cxMin = this.table.getScene().getViewport().getViewportWidth() / 2;
        boolean isVertScroll = false;
        int cyCanvas = this.table.getMainPart().getLayoutRect().cy;
        if (this.table.getTopPart() != null) {
            if (cyViewport < cyMin) {
                VM.log(CLASS, 2, "insufficient room to freeze top part");
                cyViewport = cyCanvas;
            } else if (cyCanvas < cyViewport) {
                VM.log(CLASS, 1, "no vertical scrolling required");
                cyViewport = cyCanvas;
                isVertScroll = true;
            } else {
                VM.log(CLASS, 1, "top part frozen");
                isVertScroll = true;
            }
        }
        boolean isHorzScroll = false;
        int cxCanvas = this.table.getMainPart().getLayoutRect().cx;
        if (this.table.getLeftPart() != null) {
            if (cxViewport < cxMin) {
                VM.log(CLASS, 2, "insufficient room to freeze left part");
                cxViewport = cxCanvas;
            } else if (cxCanvas < cxViewport) {
                VM.log(CLASS, 1, "no horizontal scrolling required");
                cxViewport = cxCanvas;
                isHorzScroll = true;
            } else {
                VM.log(CLASS, 1, "left part frozen");
                isHorzScroll = true;
            }
        }
        if (!isHorzScroll && !isVertScroll) {
            return false;
        }
        this.mainViewport = new VMViewport(cxViewport, cyViewport, cxCanvas, cyCanvas);
        int cxTable = isHorzScroll ? this.topLeftSize.x + cxViewport : this.table.getLayoutRect().cx;
        int cyTable = isVertScroll ? this.topLeftSize.y + cyViewport : this.table.getLayoutRect().cy;
        int x = this.table.getLayoutRect().x;
        int y = this.table.getLayoutRect().y;
        this.table.setLayout(x, y, cxTable, cyTable, null);
        VM.log(CLASS, 1, "table resized to " + cxTable + "x" + cyTable);
        return true;
    }

    public boolean scrollTo(int newX, int newY) {
        if (!this.isScrolling()) {
            return false;
        }
        if (!this.mainViewport.scrollTo(newX, newY)) {
            return false;
        }
        this.syncWithViewport();
        return true;
    }

    public VMRect getPartVisibleRect(TablePartNode tablePart) {
        return this.getPartVisibleRect(tablePart, null);
    }

    public VMRect getPartVisibleRect(TablePartNode tablePart, RenderState state) {
        VMRect rect = new VMRect();
        VMRect tableAbsRect = this.table.getAbsoluteRect(state);
        if (tablePart == this.table.getTopLeftPart()) {
            rect.x = tableAbsRect.x;
            rect.y = tableAbsRect.y;
            rect.cx = this.topLeftSize.x;
            rect.cy = this.topLeftSize.y;
        } else if (tablePart == this.table.getTopPart()) {
            rect.x = tableAbsRect.x + this.topLeftSize.x;
            rect.y = tableAbsRect.y;
            rect.cx = tableAbsRect.cx - this.topLeftSize.x;
            rect.cy = this.topLeftSize.y;
        } else if (tablePart == this.table.getLeftPart()) {
            rect.x = tableAbsRect.x;
            rect.y = tableAbsRect.y + this.topLeftSize.y;
            rect.cx = this.topLeftSize.x;
            rect.cy = tableAbsRect.cy - this.topLeftSize.y;
        } else if (tablePart == this.table.getMainPart()) {
            rect.x = this.topLeftSize.x;
            rect.y = this.topLeftSize.y;
            rect.cx = tableAbsRect.cx - this.topLeftSize.x;
            rect.cy = tableAbsRect.cy - this.topLeftSize.y;
        } else {
            VM.log(CLASS, 3, "invalid table part: " + tablePart.toString());
        }
        return rect;
    }

    public int getCellVisibleSides(CellNode cell) {
        TablePartNode part = cell.getTablePart();
        if (part == null) {
            VM.log(CLASS, 3, "cell doesn't have a table part");
            return 0;
        }
        int flags = 15;
        VMRect viewRect = this.mainViewport.getViewportRect();
        VMRect cellRect = cell.getRect();
        if (part == this.table.getLeftPart() || part == this.table.getMainPart()) {
            if (!viewRect.pointInRect(viewRect.x, cellRect.y)) {
                flags &= 2;
            }
            if (!viewRect.pointInRect(viewRect.x, cellRect.getBottom())) {
                flags &= 8;
            }
        }
        if (part == this.table.getTopPart() || part == this.table.getMainPart()) {
            if (!viewRect.pointInRect(cellRect.x, viewRect.y)) {
                flags &= 1;
            }
            if (!viewRect.pointInRect(cellRect.getRight(), viewRect.y)) {
                flags &= 4;
            }
        }
        return flags;
    }

    public int getPartVisibleSides(TablePartNode part) {
        return 0;
    }

    public boolean ensurePartVisible(TablePartNode part, boolean fullyVisible, int dir, boolean allowSnap) {
        return false;
    }

    public boolean ensureCellVisible(CellNode cell, boolean fullyVisible, int dir, boolean allowSnap) {
        TablePartNode part = cell.getTablePart();
        if (part == null) {
            VM.log(CLASS, 3, "cell doesn't have a table part");
            return false;
        }
        VMRect cellRect = new VMRect(cell.getRect());
        if (part != this.table.getMainPart()) {
            if (part == this.table.getLeftPart()) {
                cellRect.x = 0;
            } else if (part == this.table.getTopPart()) {
                cellRect.y = 0;
            }
        }
        boolean changed = false;
        if (this.mainViewport.ensureRectVisible(cellRect, dir, allowSnap)) {
            changed = true;
            this.syncWithViewport();
        }
        return changed;
    }

    public VMViewport getViewport() {
        return this.mainViewport;
    }

    private void syncWithViewport() {
        if (this.table.getLeftPart() != null) {
            int x = this.table.getLeftPart().getRect().x;
            this.table.getLeftPart().move(x, this.topLeftSize.y + this.mainViewport.y);
        }
        if (this.table.getTopPart() != null) {
            int y = this.table.getTopPart().getRect().y;
            this.table.getTopPart().move(this.topLeftSize.x + this.mainViewport.x, y);
        }
        this.table.getMainPart().move(this.topLeftSize.x + this.mainViewport.x, this.topLeftSize.y + this.mainViewport.y);
    }
}

