/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ITextSizer;
import com.cognos.mobile.common.WordWrapper;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.node.ScaleMap;
import com.cognos.mobile.vm.render.FindState;
import com.cognos.mobile.vm.render.RenderState;

public class TextNode
extends Node
implements ITextSizer {
    private static final Class CLASS = TextNode.class;
    private static final int MIN_WIDTH_IN_CHARACTERS = 12;
    private static final int MIN_WIDTH_IN_CHARACTERS_DATA = 1;
    private static final int MIN_WRAPPABLE_WIDTH_IN_CHARACTERS = 15;
    private static final int MAX_WIDTH_IN_CHARACTERS = 100;
    private static final int MIN_HEIGHT_IN_CHARACTERS = 1;
    private static final int MAX_HEIGHT_IN_CHARACTERS = 50;
    private static final boolean DEBUG_FORCE_TEXT_UNZOOMABLE = false;
    private final String text;
    private boolean hide = false;
    private ScaleMap linePos;

    public String getText() {
        return this.text;
    }

    public TextNode(String text) {
        super(6, 16432);
        this.text = text;
        this.linePos = new ScaleMap();
    }

    public TextNode(TextNode other) {
        super(other);
        this.text = other.text;
        this.linePos = other.getLinePos();
        this.hide = other.hide;
    }

    @Override
    public Node cloneNode() {
        return new TextNode(this);
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("text '" + this.text + "'\"");
        } else {
            sb.append("text '" + this.text + "' ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isZoomable(RenderState state) {
        double scale = state.getZoomScale();
        boolean isSupported = state.getPainter().isSupportedTextScale(scale);
        return isSupported;
    }

    @Override
    public synchronized void size(RenderState state) throws CMException {
        int cy;
        int cx;
        if (state.isZoomed() && !this.isZoomable(state)) {
            super.size(state);
            return;
        }
        if (state.isZoomed() && this.zoomImage == null) {
            this.clearStyle(8192, false);
        }
        state.pushCurrentNode(this);
        this.setupFont(state);
        int textColor = state.getTextColor();
        int backColor = state.getBackColor();
        if (!this.hide && textColor == backColor) {
            this.hide = true;
        }
        boolean dataCellText = this.getParent().getType() == 3 && !this.getParent().checkStyle(4096);
        int stateWidth = state.getWidth(this);
        int padding = this.getPadding(state);
        if (this.getParent() != null) {
            if (stateWidth > 0) {
                cx = stateWidth;
                if (cx > 2 * padding + 1) {
                    cx -= 2 * padding;
                }
            } else {
                cx = dataCellText ? this.generateMinWrapWidth(state) : this.getParent().getMaxSize((RenderState)state).x;
            }
            cy = this.getParent().getMaxSize((RenderState)state).y;
        } else {
            cx = dataCellText ? this.generateMinWrapWidth(state) : this.getMaxSize((RenderState)state).x;
            cy = this.getMaxSize((RenderState)state).y;
        }
        VMPoint charSize = state.getPainter().measureString("X");
        if (cx == 0) {
            cx = this.getWidth(state.getPainter(), this.text.length() > 99 ? this.text.substring(0, 99) : this.text);
        }
        if (cy == 0) {
            cy = 50 * charSize.y;
        }
        VMPoint minSize = new VMPoint(charSize);
        minSize.x = minSize.x * (dataCellText ? 1 : 12);
        minSize.y *= 1;
        if (stateWidth == 0) {
            cx = Math.max(minSize.x, cx);
        }
        cy = Math.max(minSize.y, cy);
        if (stateWidth > 0 || this.text.length() > 15) {
            WordWrapper wordWrapper = new WordWrapper(this);
            String[] testLines = wordWrapper.wrapText(state.getPainter(), this.text, cx, cy, stateWidth <= 0);
            cx = 0;
            cy = 0;
            for (int i = 0; i < testLines.length; ++i) {
                VMPoint size = state.getPainter().measureString(testLines[i]);
                cx = Math.max(cx, size.x);
                cy += size.y;
            }
        } else {
            VMPoint textSize = state.getPainter().measureString(this.text);
            cx = textSize.x;
            cy = textSize.y;
        }
        this.setPreferredSize(cx + 2 * padding, cy + 2 * padding, state);
        state.popCurrentNode(0);
    }

    private int generateMinWrapWidth(RenderState state) {
        String finalText;
        int numChars = this.text.length();
        if (numChars <= 15) {
            return this.getWidth(state.getPainter(), this.text);
        }
        int finalNumChars = numChars;
        if (numChars > 99) {
            finalText = this.text.substring(0, 99);
            finalNumChars = 99;
        } else {
            finalText = this.text;
        }
        return this.getWidth(state.getPainter(), finalText.substring(0, finalNumChars / 2));
    }

    @Override
    public void onSizeEnd(int cx, int cy, RenderState state) {
    }

    public int getPadding(RenderState state) {
        return Math.min((int)(state.getZoomScale() * 10.0 * 2.0) / 10, 2);
    }

    @Override
    public void layout2(RenderState state, int x, int y) throws CMException {
        state.pushCurrentNode(this);
        this.setupFont(state);
        int padding = this.getPadding(state);
        if (this.getParent() != null && this.getParent().getChildCount() == 1) {
            this.getLayoutRect().cx = this.getParent().getLayoutRect().cx;
            this.getLayoutRect().x = 0;
        }
        int cx = this.getLayoutRect().cx - 2 * padding;
        int cy = this.getParent() != null ? this.getParent().getMaxSize((RenderState)state).y : this.getMaxSize((RenderState)state).y;
        VMPoint charSize = state.getPainter().measureString("X");
        if (cy == 0) {
            cy = 50 * charSize.y;
        }
        int minSizeY = charSize.y * 1;
        cy = Math.max(minSizeY, cy);
        if (state.getWidth(this) > 0 || this.text.length() > 15) {
            WordWrapper wordWrapper = new WordWrapper(this);
            int[] wrapPos = wordWrapper.generateWrapPos(state.getPainter(), this.text, cx, cy, false);
            this.linePos.update(state.getZoomScale(), wrapPos);
            if (wrapPos != null) {
                String[] lines = WordWrapper.generateWrappedStrings(state.getPainter(), wrapPos, this.text);
                cy = 0;
                for (int i = 0; i < lines.length; ++i) {
                    VMPoint size = state.getPainter().measureString(lines[i]);
                    cx = Math.max(cx, size.x);
                    cy += size.y;
                }
            }
        } else {
            VMPoint textSize = state.getPainter().measureString(this.text);
            cx = textSize.x;
            cy = textSize.y;
        }
        this.setPreferredSize(cx + 2 * padding, cy + 2 * padding, state);
        Node parent = this.getParent();
        if (parent != null && parent.getType() == 3) {
            parent.setPreferredSize(Math.max(cx + 2 * padding, parent.getLayoutRect().cx), Math.max(cy + 2 * padding, parent.getLayoutRect().cy), state);
        }
        this.transferToRenderRect(state.isZoomed());
        if (!this.checkStyle(8192)) {
            this.paintZoomImage = null;
        } else if (this.zoomImage != null) {
            this.paintZoomImage = this.zoomImage;
            this.zoomImage = null;
        }
        this.setMaxSize(null);
        state.popCurrentNode(0);
    }

    @Override
    public synchronized void paint(RenderState state) throws CMException {
        int highlightIndex;
        int backColor;
        int textColor;
        String[] lines;
        if (this.checkStyle(8192)) {
            super.paint(state);
            return;
        }
        VM.log(CLASS, 0, this.toString() + " paint begin");
        state.pushCurrentNode(this);
        this.setupFont(state);
        int padding = this.getPadding(state);
        WordWrapper wordWrapper = new WordWrapper(this);
        int[] wrapPosObj = this.linePos.get(state.getZoomScale());
        if (wrapPosObj != null) {
            lines = WordWrapper.generateWrappedStrings(state.getPainter(), wrapPosObj, this.text);
        } else {
            int cx = this.getRenderRect((RenderState)state).cx - 2 * padding;
            int cy = this.getRenderRect((RenderState)state).cy - 2 * padding;
            lines = wordWrapper.wrapText(state.getPainter(), this.text, cx, cy);
        }
        if (state.isSelected()) {
            textColor = VMColor.SELECTION_TEXT_COLOR;
            backColor = VMColor.SELECTION_FILL_COLOR;
        } else {
            textColor = state.getTextColor();
            backColor = state.getBackColor();
        }
        if (textColor == backColor) {
            textColor = backColor != VMColor.DEFAULT_MATCHING_TEXT_COLOR ? VMColor.DEFAULT_MATCHING_TEXT_COLOR : VMColor.ALTERNATE_MATCHING_TEXT_COLOR;
        }
        boolean isHighlight = false;
        String lowerText = null;
        if (state.isAncestorTagged()) {
            lowerText = this.text.toLowerCase();
            highlightIndex = lowerText.indexOf(state.getTagString(), 0);
        } else {
            highlightIndex = -1;
        }
        if (backColor != state.getBackColor()) {
            state.getPainter().setColor(backColor);
            state.getPainter().fillRect(0, 0, this.getRenderRect((RenderState)state).cx, this.getRenderRect((RenderState)state).cy);
        }
        state.getPainter().setBackgroundColor(backColor);
        state.getPainter().setColor(textColor);
        int y = padding;
        int charsSoFar = 0;
        for (int i = 0; i < lines.length; ++i) {
            int x;
            int size_x = state.getPainter().getWidth(lines[i]);
            int size_y = state.getPainter().getHeight(lines[i]);
            switch (this.getHorizontalAlign()) {
                default: {
                    x = padding;
                    break;
                }
                case 1: {
                    x = this.getRenderRect((RenderState)state).cx - size_x - padding;
                    break;
                }
                case 2: {
                    x = (this.getRenderRect((RenderState)state).cx - size_x) / 2;
                }
            }
            if (highlightIndex != -1 && highlightIndex < lines[i].length()) {
                String lineLeft = lines[i];
                do {
                    String linePart = lineLeft.substring(0, highlightIndex);
                    int cx = state.getPainter().measureString((String)linePart).x;
                    charsSoFar += this.drawLinePart(state.getPainter(), x, y, cx, size_y, isHighlight, linePart);
                    x += cx;
                    lineLeft = lineLeft.substring(highlightIndex);
                    highlightIndex -= linePart.length();
                    boolean bl = isHighlight = !isHighlight;
                    if (isHighlight) {
                        highlightIndex += state.getTagString().length();
                        continue;
                    }
                    state.getPainter().setBackgroundColor(backColor);
                    state.getPainter().setColor(textColor);
                    highlightIndex += state.getTagString().length();
                    highlightIndex = lowerText.indexOf(state.getTagString(), charsSoFar);
                } while (highlightIndex != -1 && highlightIndex < lineLeft.length());
                if (lineLeft.length() > 0) {
                    int cx = state.getPainter().measureString((String)lineLeft).x;
                    charsSoFar += this.drawLinePart(state.getPainter(), x, y, cx, size_y, isHighlight, lineLeft);
                }
            } else {
                charsSoFar += this.drawLinePart(state.getPainter(), x, y, size_x, size_y, isHighlight, lines[i]);
                if (highlightIndex != -1) {
                    highlightIndex -= lines[i].length();
                }
            }
            y += size_y;
        }
        state.popCurrentNode(0);
        VM.log(CLASS, 0, this.toString() + " paint end");
    }

    @Override
    public void find(FindState state) throws CMException {
        if (this.text != null) {
            String findStr = state.getStringToFind();
            if (this.text.toLowerCase().indexOf(findStr) != -1) {
                state.addFoundNode(this);
            }
        }
    }

    @Override
    public VMPoint measureText(Object context, String line) {
        IVMPainter painter = (IVMPainter)context;
        return painter.measureString(line);
    }

    @Override
    public int getWidth(Object context, String line) {
        IVMPainter painter = (IVMPainter)context;
        return painter.getWidth(line);
    }

    @Override
    public int getHeight(Object context, String line) {
        IVMPainter painter = (IVMPainter)context;
        return painter.getHeight(line);
    }

    private void setupFont(RenderState state) {
        double scale = state.getZoomScale();
        if (state.isZoomed() && state.getPainter().isSupportedTextScale(scale)) {
            state.getPainter().setFont(state.getFont(), scale);
        } else {
            state.getPainter().setFont(state.getFont(), 1.0);
        }
    }

    private int drawLinePart(IVMPainter painter, int x, int y, int cx, int cy, boolean isHighlight, String linePart) {
        if (isHighlight) {
            painter.setColor(VMColor.HIGHLIGHT_BACK_COLOR);
            painter.fillRect(x, y, cx, cy);
            painter.setBackgroundColor(VMColor.HIGHLIGHT_BACK_COLOR);
            painter.setColor(VMColor.HIGHLIGHT_TEXT_COLOR);
        }
        if (!this.hide) {
            painter.drawString(x, y, linePart);
        }
        return linePart.length();
    }

    private ScaleMap getLinePos() {
        return this.linePos;
    }

    private String generateTestString(int numChars) {
        char[] str = new char[numChars];
        for (int i = 0; i < numChars; ++i) {
            str[i] = 88;
        }
        return new String(str).intern();
    }
}

