/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.render.State;

public class BuildState
extends State {
    private int rootStartAddress;
    private boolean nextLineNextNode;

    public BuildState(IVMReader reader, int rootStartAddress) {
        super(0, reader);
        this.rootStartAddress = rootStartAddress;
        this.nextLineNextNode = false;
    }

    public void onBuildNextLine() {
        this.nextLineNextNode = true;
    }

    public void pushBuildNode(Node node, boolean isBeginNode) {
        int startAddress;
        Node parent = this.getCurrentNode();
        super.pushCurrentNode(node);
        if (parent == null) {
            startAddress = this.rootStartAddress;
        } else if (isBeginNode) {
            startAddress = this.getCurrentCodeRecord().address;
        } else {
            IVMReader.CodeRecord rec = new IVMReader.CodeRecord();
            try {
                for (startAddress = (siblingCount = parent.getChildCount()) == 0 ? this.getCurrentCodeRecord().address : parent.getChild(siblingCount - 1).getEndAddress(); startAddress < this.getCurrentCodeRecord().address && this.reader.onReaderLoadCode(startAddress, rec) && rec.opcode == 2; ++startAddress) {
                }
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        if (this.nextLineNextNode) {
            node.setStyle(0x200000, false);
            this.nextLineNextNode = false;
        }
        node.onBuildBegin(parent, startAddress);
    }

    @Override
    public void popCurrentNode(int endAddressOffset) throws CMException {
        Node currentNode = this.getCurrentNode();
        int endAddress = this.getCurrentCodeRecord().address;
        currentNode.onBuildEnd(endAddress + endAddressOffset + 1);
        this.nextLineNextNode = false;
        super.popCurrentNode(endAddressOffset);
    }
}

