/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMIntStack;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.instruction.INBackColor;
import com.cognos.mobile.vm.instruction.INBase;
import com.cognos.mobile.vm.instruction.INBlockBegin;
import com.cognos.mobile.vm.instruction.INBlockEnd;
import com.cognos.mobile.vm.instruction.INBodyBegin;
import com.cognos.mobile.vm.instruction.INBodyEnd;
import com.cognos.mobile.vm.instruction.INBorderColor;
import com.cognos.mobile.vm.instruction.INBorderDisplay;
import com.cognos.mobile.vm.instruction.INBorderHorizontalColor;
import com.cognos.mobile.vm.instruction.INBorderVerticalColor;
import com.cognos.mobile.vm.instruction.INChartBegin;
import com.cognos.mobile.vm.instruction.INChartEnd;
import com.cognos.mobile.vm.instruction.INClearStyle;
import com.cognos.mobile.vm.instruction.INDrillBegin;
import com.cognos.mobile.vm.instruction.INDrillCMPath;
import com.cognos.mobile.vm.instruction.INDrillContextBegin;
import com.cognos.mobile.vm.instruction.INDrillContextEnd;
import com.cognos.mobile.vm.instruction.INDrillEnd;
import com.cognos.mobile.vm.instruction.INDrillIndex;
import com.cognos.mobile.vm.instruction.INDrillLabel;
import com.cognos.mobile.vm.instruction.INDrillNameType;
import com.cognos.mobile.vm.instruction.INDrillParamMun;
import com.cognos.mobile.vm.instruction.INDrillParameters;
import com.cognos.mobile.vm.instruction.INDrillSearchPath;
import com.cognos.mobile.vm.instruction.INDrillUpDownContext;
import com.cognos.mobile.vm.instruction.INDrillUpDownWidget;
import com.cognos.mobile.vm.instruction.INFlow;
import com.cognos.mobile.vm.instruction.INFont;
import com.cognos.mobile.vm.instruction.INFooterBegin;
import com.cognos.mobile.vm.instruction.INFooterEnd;
import com.cognos.mobile.vm.instruction.INGroupBegin;
import com.cognos.mobile.vm.instruction.INGroupEnd;
import com.cognos.mobile.vm.instruction.INHeaderBegin;
import com.cognos.mobile.vm.instruction.INHeaderEnd;
import com.cognos.mobile.vm.instruction.INImage;
import com.cognos.mobile.vm.instruction.INLabel;
import com.cognos.mobile.vm.instruction.INMailtoBCC;
import com.cognos.mobile.vm.instruction.INMailtoBegin;
import com.cognos.mobile.vm.instruction.INMailtoCC;
import com.cognos.mobile.vm.instruction.INMailtoEnd;
import com.cognos.mobile.vm.instruction.INMailtoSubBody;
import com.cognos.mobile.vm.instruction.INMailtoTo;
import com.cognos.mobile.vm.instruction.INNextLine;
import com.cognos.mobile.vm.instruction.INNop;
import com.cognos.mobile.vm.instruction.INSetStyle;
import com.cognos.mobile.vm.instruction.INSize;
import com.cognos.mobile.vm.instruction.INSpotBegin;
import com.cognos.mobile.vm.instruction.INSpotDown;
import com.cognos.mobile.vm.instruction.INSpotEnd;
import com.cognos.mobile.vm.instruction.INSpotIndex;
import com.cognos.mobile.vm.instruction.INSpotLeft;
import com.cognos.mobile.vm.instruction.INSpotRight;
import com.cognos.mobile.vm.instruction.INSpotUp;
import com.cognos.mobile.vm.instruction.INTableBegin;
import com.cognos.mobile.vm.instruction.INTableCell;
import com.cognos.mobile.vm.instruction.INTableEnd;
import com.cognos.mobile.vm.instruction.INTableFreeze;
import com.cognos.mobile.vm.instruction.INTableRow;
import com.cognos.mobile.vm.instruction.INText;
import com.cognos.mobile.vm.instruction.INTextAlign;
import com.cognos.mobile.vm.instruction.INTextColor;
import com.cognos.mobile.vm.render.State;

public class Executive {
    private static final boolean isDebugLog = VM.wouldLog(Executive.class, 0);
    private static final INBase[] s_instructions = new INBase[131];
    private static Class CLASS;
    private static final int MAX_CALL_STACK_DEPTH = 3;

    public static synchronized int executeProgram(State state, int startAddress, int endAddress, int haltInstruction) {
        int currentAddress = -1;
        CMIntStack callStack = null;
        try {
            currentAddress = startAddress;
            block7: while (currentAddress != endAddress) {
                INBase instruction = null;
                IVMReader.CodeRecord buf = state.getCurrentCodeRecord();
                if (state.reader.onReaderLoadCode(currentAddress, buf)) {
                    if (buf.address != currentAddress) {
                        VM.log(CLASS, 2, "reader returned incorrect address");
                        buf.address = currentAddress;
                    }
                    int record_instruction = buf.opcode & 0xFF;
                    buf.opcode >>= 2;
                    int record_p2 = buf.p2;
                    buf.opcode >>= 2;
                    int record_p1 = buf.p1;
                    switch (record_instruction) {
                        case 2: {
                            if (isDebugLog) {
                                VM.log(CLASS, 0, "@ " + CMStringHelper.formatAddress(currentAddress) + " " + "Call" + " " + CMStringHelper.formatAddress(record_p1));
                            }
                            if (callStack == null) {
                                callStack = new CMIntStack(3);
                            }
                            callStack.push(currentAddress);
                            currentAddress = record_p1;
                            continue block7;
                        }
                        case 0: {
                            if (!isDebugLog) break;
                            VM.log(CLASS, 0, "@ " + CMStringHelper.formatAddress(currentAddress) + " " + "End");
                            break;
                        }
                        case 3: {
                            if (isDebugLog) {
                                VM.log(CLASS, 0, "@ " + CMStringHelper.formatAddress(currentAddress) + " " + "Return");
                            }
                            if (callStack.isEmpty()) {
                                VM.log(CLASS, 3, "premature Return @" + CMStringHelper.formatAddress(currentAddress));
                                return currentAddress;
                            }
                            currentAddress = callStack.pop();
                            break;
                        }
                        default: {
                            if (record_instruction >= 0 && record_instruction < s_instructions.length) {
                                instruction = s_instructions[record_instruction];
                            }
                            if (instruction == null) {
                                VM.log(CLASS, 2, CMStringHelper.formatAddress(currentAddress) + " invalid instruction - 0x" + Integer.toHexString(record_instruction));
                                break;
                            }
                            if (isDebugLog) {
                                VM.log(CLASS, 0, "@ " + CMStringHelper.formatAddress(currentAddress) + " " + instruction.getMnemonic() + " " + record_p1 + "," + record_p2);
                            }
                            instruction.execute(state, record_p1, record_p2);
                        }
                    }
                    if (record_instruction != haltInstruction) {
                        ++currentAddress;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, CMStringHelper.formatAddress(currentAddress) + ": " + ex.getMessage(), ex);
        }
        return currentAddress;
    }

    public static void executeNode(Node node, State state) {
        int startAddress = node.getStartAddress();
        int endAddress = node.getEndAddress();
        if (startAddress != -1 && endAddress != -1) {
            Executive.executeProgram(state, startAddress, endAddress, -1);
        }
    }

    public static void executeNodeEnter(Node node, State state) {
        int startAddress = node.getStartAddress();
        int endAddress = node.getEndAddress();
        if (startAddress != -1 && endAddress != -1) {
            if (node.getChildCount() > 0) {
                Node child = node.getChild(0);
                int childStartAddress = startAddress;
                int childEndAddress = child.getStartAddress();
                Executive.executeProgram(state, childStartAddress, childEndAddress, -1);
            } else {
                Executive.executeProgram(state, startAddress, endAddress, -1);
            }
        }
    }

    public static void executeNodeExit(Node node, State state) {
        int startAddress = node.getStartAddress();
        int endAddress = node.getEndAddress();
        if (startAddress != -1 && endAddress != -1 && node.getChildCount() > 0) {
            Node child = node.getChild(node.getChildCount() - 1);
            int childStartAddress = child.getEndAddress();
            int childEndAddress = endAddress;
            Executive.executeProgram(state, childStartAddress, childEndAddress, -1);
        }
    }

    static {
        Executive.s_instructions[87] = new INBackColor();
        Executive.s_instructions[112] = new INBlockBegin();
        Executive.s_instructions[113] = new INBlockEnd();
        Executive.s_instructions[64] = new INBodyBegin();
        Executive.s_instructions[65] = new INBodyEnd();
        Executive.s_instructions[94] = new INBorderColor();
        Executive.s_instructions[96] = new INChartBegin();
        Executive.s_instructions[97] = new INChartEnd();
        Executive.s_instructions[93] = new INClearStyle();
        Executive.s_instructions[85] = new INFont();
        Executive.s_instructions[95] = new INFlow();
        Executive.s_instructions[66] = new INFooterBegin();
        Executive.s_instructions[67] = new INFooterEnd();
        Executive.s_instructions[90] = new INGroupBegin();
        Executive.s_instructions[91] = new INGroupEnd();
        Executive.s_instructions[69] = new INHeaderBegin();
        Executive.s_instructions[70] = new INHeaderEnd();
        Executive.s_instructions[89] = new INImage();
        Executive.s_instructions[100] = new INLabel();
        Executive.s_instructions[68] = new INNextLine();
        Executive.s_instructions[1] = new INNop();
        Executive.s_instructions[71] = new INNop();
        Executive.s_instructions[72] = new INNop();
        Executive.s_instructions[73] = new INTableBegin();
        Executive.s_instructions[80] = new INTableCell();
        Executive.s_instructions[81] = new INTableEnd();
        Executive.s_instructions[82] = new INTableFreeze();
        Executive.s_instructions[83] = new INTableRow();
        Executive.s_instructions[84] = new INText();
        Executive.s_instructions[88] = new INTextAlign();
        Executive.s_instructions[86] = new INTextColor();
        Executive.s_instructions[92] = new INSetStyle();
        Executive.s_instructions[98] = new INSpotBegin();
        Executive.s_instructions[123] = new INSpotIndex();
        Executive.s_instructions[124] = new INSpotLeft();
        Executive.s_instructions[125] = new INSpotUp();
        Executive.s_instructions[126] = new INSpotRight();
        Executive.s_instructions[127] = new INSpotDown();
        Executive.s_instructions[99] = new INSpotEnd();
        Executive.s_instructions[101] = new INDrillIndex();
        Executive.s_instructions[102] = new INDrillParameters();
        Executive.s_instructions[103] = new INDrillBegin();
        Executive.s_instructions[104] = new INDrillEnd();
        Executive.s_instructions[105] = new INDrillCMPath();
        Executive.s_instructions[110] = new INDrillLabel();
        Executive.s_instructions[106] = new INDrillNameType();
        Executive.s_instructions[107] = new INDrillSearchPath();
        Executive.s_instructions[108] = new INDrillContextBegin();
        Executive.s_instructions[109] = new INDrillContextEnd();
        Executive.s_instructions[111] = new INDrillParamMun();
        Executive.s_instructions[114] = new INBorderDisplay();
        Executive.s_instructions[115] = new INMailtoBegin();
        Executive.s_instructions[116] = new INMailtoEnd();
        Executive.s_instructions[117] = new INMailtoTo();
        Executive.s_instructions[118] = new INMailtoCC();
        Executive.s_instructions[119] = new INMailtoBCC();
        Executive.s_instructions[120] = new INMailtoSubBody();
        Executive.s_instructions[121] = new INDrillUpDownContext();
        Executive.s_instructions[122] = new INDrillUpDownWidget();
        Executive.s_instructions[128] = new INBorderHorizontalColor();
        Executive.s_instructions[129] = new INBorderVerticalColor();
        Executive.s_instructions[130] = new INSize();
        CLASS = Executive.class;
    }
}

