/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.render.Executive;
import com.cognos.mobile.vm.render.State;
import java.util.Stack;

public class RenderState
extends State {
    private static final Class CLASS = RenderState.class;
    private static final int FLAG_SELECTED = 1;
    private static final int FLAG_TAGGED = 2;
    private static final int FLAG_ANCESTOR_SELECTED = 4;
    private static final int FLAG_ANCESTOR_TAGGED = 8;
    private static final int FLAG_CLIPPED = 16;
    public static final int RENDERTYPE_LAYOUT = 1;
    public static final int RENDERTYPE_SIZE = 2;
    public static final int RENDERTYPE_PAINT = 3;
    public static final int RENDERTYPE_ZOOM_PAINT = 4;
    public static final String TEXT_SAMPLE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$. ";
    public static final double WIDTH_CONVERSION_CORRECTION = 0.0028;
    public IVMPainter painter;
    private MobileServiceProxy mobileServiceProxy;
    private int pageWidth;
    private int zoomLevel;
    private double zoomScale;
    private boolean isPaintSelection;
    private VMPoint currentPoint;
    private Stack renderContextStack;
    private RenderContextPool renderContextPool = new RenderContextPool();
    private Stack clipStack;
    private int tileSize;
    private boolean layoutToViewport;
    private int width;
    private int sampleTextSize;
    private double widthConversion;

    public RenderState(int exec, IVMReader reader, IVMPainter painter, VMRect clipRect, int viewportWidth) {
        super(exec, reader);
        this.constructCommon(reader, painter, clipRect, viewportWidth, viewportWidth, 100, 1.0, null, 240, false, -1);
    }

    public RenderState(int exec, IVMReader reader, IVMPainter painter, VMRect clipRect, int pageWidth, int viewportWidth, int zoomLevel, double zoomScale, MobileServiceProxy mobileServiceProxy, int tileSize, boolean layoutToViewport, int unzoomedTextSize) {
        super(exec, reader);
        this.constructCommon(reader, painter, clipRect, pageWidth, viewportWidth, zoomLevel, zoomScale, mobileServiceProxy, tileSize, layoutToViewport, unzoomedTextSize);
    }

    public IVMPainter getPainter() {
        return this.painter;
    }

    public MobileServiceProxy getMobileService() {
        return this.mobileServiceProxy;
    }

    public void stopUsingMobileService() {
        this.mobileServiceProxy = null;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public double getZoomScale() {
        return this.zoomScale;
    }

    public VMPoint getCurrentPoint() {
        return this.currentPoint;
    }

    public VMRect getClipRect() {
        if (this.clipStack.empty()) {
            return null;
        }
        VMRect clipRect = (VMRect)this.clipStack.peek();
        return clipRect;
    }

    public void setPaintSelection(boolean isPaintSelection) {
        this.isPaintSelection = isPaintSelection;
    }

    public void setCurrentPoint(int x, int y) {
        this.currentPoint.x = x;
        this.currentPoint.y = y;
        this.ensurePointInExtent(x, y);
    }

    public void ensurePointInExtent(int x, int y) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        if (x < nc.extentTopLeft.x) {
            nc.extentTopLeft.x = x;
        }
        if (y < nc.extentTopLeft.y) {
            nc.extentTopLeft.y = y;
        }
        if (x > nc.extentBottomRight.x) {
            nc.extentBottomRight.x = x;
        }
        if (y > nc.extentBottomRight.y) {
            nc.extentBottomRight.y = y;
        }
    }

    public VMRect getCurrentExtent() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        VMRect extent = new VMRect(nc.extentTopLeft, nc.extentBottomRight);
        return extent;
    }

    public int getFont() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.font;
    }

    public int getBackColor() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.backColor;
    }

    public int getTextColor() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.textColor;
    }

    public int[] getBorderColors() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.borderColor;
    }

    public int getFlow() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.flow;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public boolean isLayoutToViewport() {
        return this.layoutToViewport;
    }

    public boolean isBorderSuppressed(int border) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.borderDisplay[border] == 1;
    }

    public boolean[] getBorderDisplay() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        boolean[] sb = new boolean[]{nc.borderDisplay[0] == 1, nc.borderDisplay[1] == 1, nc.borderDisplay[2] == 1, nc.borderDisplay[3] == 1};
        return sb;
    }

    public boolean isZoomed() {
        return this.zoomLevel != 100;
    }

    public boolean isSelected() {
        if (this.isPaintSelection) {
            RenderContext nc = (RenderContext)this.renderContextStack.peek();
            return 0 != (nc.flags & 1);
        }
        return false;
    }

    public boolean isAncestorSelected() {
        if (this.isPaintSelection) {
            RenderContext nc = (RenderContext)this.renderContextStack.peek();
            return 0 != (nc.flags & 4);
        }
        return false;
    }

    public boolean isTagged() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return 0 != (nc.flags & 2);
    }

    public boolean isAncestorTagged() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return 0 != (nc.flags & 8);
    }

    public String getTagString() {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        return nc.tagString;
    }

    public void setFont(int font) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.font = font;
    }

    public void setBackColor(int color) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.backColor = color;
    }

    public void setTextColor(int color) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.textColor = color;
    }

    public void setBorderColor(int color) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.borderColor[0] = color;
        nc.borderColor[1] = color;
        nc.borderColor[2] = color;
        nc.borderColor[3] = color;
    }

    public void setBorderColor(int border, int color) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.borderColor[border] = color;
    }

    public void setFlow(int flow) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        nc.flow = flow;
    }

    public void setBorderDisplay(byte[] borderDisplay) {
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        if (borderDisplay[0] != 0) {
            nc.borderDisplay[0] = borderDisplay[0];
        }
        if (borderDisplay[1] != 0) {
            nc.borderDisplay[1] = borderDisplay[1];
        }
        if (borderDisplay[2] != 0) {
            nc.borderDisplay[2] = borderDisplay[2];
        }
        if (borderDisplay[3] != 0) {
            nc.borderDisplay[3] = borderDisplay[3];
        }
    }

    @Override
    public void pushCurrentNode(Node node) {
        this.pushCurrentNode(node, null);
    }

    public void pushCurrentNode(Node node, VMRect clipRect) {
        RenderContext nc = this.renderContextPool.get();
        this.resetContext(nc);
        if (this.renderContextStack.empty()) {
            nc.textColor = VMColor.DEFAULT_TEXT_COLOR;
            nc.font = 0;
            nc.borderColor = new int[]{0xF000000, 0xF000000, 0xF000000, 0xF000000};
            nc.flow = 0;
        } else {
            RenderContext parent = (RenderContext)this.renderContextStack.peek();
            nc.copy(parent);
            if (0 != (parent.flags & 4)) {
                nc.flags |= 4;
            }
            if (0 != (parent.flags & 8)) {
                nc.flags |= 8;
            }
            nc.tagString = parent.tagString;
        }
        nc.dx = node.getRenderRect((RenderState)this).x;
        nc.dy = node.getRenderRect((RenderState)this).y;
        if (node == node.getScene().getSelection().getSelectedNode()) {
            nc.flags |= 1;
            nc.flags |= 4;
        }
        if (node.getScene().getSelection().isTagged(node)) {
            nc.flags |= 2;
            nc.flags |= 8;
            nc.tagString = node.getScene().getSelection().getTagString().toLowerCase();
        }
        this.renderContextStack.push(nc);
        this.painter.addOffset(nc.dx, nc.dy);
        this.currentPoint.x = 0;
        this.currentPoint.y = 0;
        if (clipRect != null) {
            nc.flags |= 0x10;
            this.pushClip(node, clipRect);
        }
        super.pushCurrentNode(node);
        if (node.getType() == 2) {
            this.setWidth(0);
        }
        if (!this.renderContextStack.empty()) {
            Executive.executeNodeEnter(node, this);
        }
    }

    @Override
    public void popCurrentNode(int endAddressOffset) throws CMException {
        Node poppedNode = this.getCurrentNode();
        if (poppedNode == null) {
            VM.log(CLASS, 3, "bad push/pop nesting");
            return;
        }
        if (!this.renderContextStack.empty()) {
            Executive.executeNodeExit(poppedNode, this);
        }
        if (this.renderContextStack.empty()) {
            throw new CMException(1202, "badly nested objects");
        }
        RenderContext nc = (RenderContext)this.renderContextStack.peek();
        switch (this.exec) {
            case 1: {
                int cx = nc.extentBottomRight.x - nc.extentTopLeft.x + 1;
                int cy = nc.extentBottomRight.y - nc.extentTopLeft.y + 1;
                poppedNode.onSizeEnd(cx, cy, this);
                break;
            }
            case 3: 
            case 11: {
                poppedNode.onPaintEnd(this);
            }
        }
        if (0 != (nc.flags & 0x10)) {
            this.popClip(poppedNode);
        }
        this.painter.addOffset(-nc.dx, -nc.dy);
        VMRect poppedRect = poppedNode.getLayoutRect();
        this.currentPoint.x = poppedRect.getRight();
        this.currentPoint.y = poppedRect.getBottom();
        this.renderContextStack.pop();
        switch (this.exec) {
            case 1: {
                Node parentNode = poppedNode.getParent();
                if (parentNode == null) break;
                int x = this.getCurrentNode().getLayoutRect().x + poppedRect.x + poppedRect.cx;
                int y = this.getCurrentNode().getLayoutRect().y + poppedRect.y + poppedRect.cy;
                this.ensurePointInExtent(x, y);
            }
        }
        if (poppedNode.getType() == 3) {
            this.setWidth(0);
        }
        super.popCurrentNode(endAddressOffset);
    }

    @Override
    public void dispose() {
        this.currentPoint = null;
        this.renderContextStack = null;
        this.clipStack = null;
    }

    public int getExec() {
        return this.exec;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth(Node node) {
        if (node.getType() == 3 || node.getParent() != null && node.getParent().getType() == 3) {
            return CMMathHelper.multiplyIntByDouble(this.width, this.widthConversion);
        }
        return 0;
    }

    public int getSampleTextSize() {
        return this.sampleTextSize;
    }

    public double getWidthConversion() {
        return this.widthConversion;
    }

    private void constructCommon(IVMReader reader, IVMPainter painter, VMRect clipRect, int pageWidth, int viewportWidth, int zoomLevel, double zoomScale, MobileServiceProxy mobileServiceProxy, int tileSize, boolean layoutToViewport, int unzoomedTextSize) {
        this.reader = reader;
        this.painter = painter;
        this.pageWidth = pageWidth;
        this.zoomLevel = zoomLevel;
        this.zoomScale = zoomScale;
        this.mobileServiceProxy = mobileServiceProxy;
        this.tileSize = tileSize;
        this.layoutToViewport = layoutToViewport;
        this.currentPoint = new VMPoint();
        this.renderContextStack = new Stack(){
            private static final long serialVersionUID = -5040539172872820836L;

            public synchronized Object pop() {
                RenderContext rc = (RenderContext)super.pop();
                RenderState.this.renderContextPool.done(rc);
                return rc;
            }
        };
        this.clipStack = new Stack();
        this.isPaintSelection = true;
        this.getPainter().setFont(0, 1.0);
        if (this.isZoomed() && this.getPainter().isSupportedTextScale(this.getZoomScale())) {
            this.getPainter().setFont(0, this.getZoomScale());
        }
        this.sampleTextSize = this.sizeSampleText(TEXT_SAMPLE, unzoomedTextSize);
        this.widthConversion = (double)this.sampleTextSize * 0.0028;
    }

    private int sizeSampleText(String text, int unzoomedTextSize) {
        VMPoint size = new VMPoint();
        if (this.getPainter().isSupportedTextScale(this.getZoomScale())) {
            size = this.getPainter().measureString(text);
        } else {
            size.x = unzoomedTextSize != -1 ? CMMathHelper.multiplyIntByDouble(unzoomedTextSize, this.getZoomScale()) : -1;
            if (size.x <= 0) {
                size.x = 1;
            }
        }
        return size.x;
    }

    private void pushClip(Node node, VMRect clipRect) {
        VMRect absClipRect = node.relativeToAbsolute(clipRect, this);
        this.clipStack.push(absClipRect);
    }

    private void popClip(Node node) {
        if (this.clipStack.empty()) {
            return;
        }
        this.clipStack.pop();
    }

    private void resetContext(RenderContext nc) {
        nc.extentTopLeft.x = 0;
        nc.extentTopLeft.y = 0;
        nc.extentBottomRight.x = 0;
        nc.extentBottomRight.y = 0;
        nc.textColor = VMColor.DEFAULT_TEXT_COLOR;
        nc.font = 0;
        nc.flow = 0;
    }

    private static class RenderContextPool {
        private final Stack pool = new Stack();

        private RenderContextPool() {
        }

        public synchronized RenderContext get() {
            if (this.pool.size() == 0) {
                return new RenderContext();
            }
            RenderContext rc = (RenderContext)this.pool.pop();
            rc.clear();
            return rc;
        }

        public synchronized void done(RenderContext rc) {
            rc.clear();
            this.pool.push(rc);
        }

        public synchronized void clear() {
            this.pool.empty();
        }
    }

    private static final class RenderContext {
        int dx;
        int dy;
        VMPoint extentTopLeft = new VMPoint();
        VMPoint extentBottomRight = new VMPoint();
        int font;
        int backColor;
        int textColor = VMColor.DEFAULT_TEXT_COLOR;
        int[] borderColor;
        int flow;
        int flags;
        String tagString;
        int[] borderDisplay;

        RenderContext() {
            this.backColor = VMColor.DEFAULT_BACK_COLOR;
            this.borderDisplay = new int[]{0, 0, 0, 0};
            this.borderColor = new int[]{0xF000000, 0xF000000, 0xF000000, 0xF000000};
        }

        void clear() {
            this.textColor = VMColor.DEFAULT_TEXT_COLOR;
            this.backColor = VMColor.DEFAULT_BACK_COLOR;
            this.extentTopLeft.x = 0;
            this.extentBottomRight.y = 0;
            this.flow = 0;
            this.tagString = null;
            this.dx = 0;
            this.dy = 0;
            this.font = 0;
            this.flags = 0;
            this.borderDisplay[0] = 0;
            this.borderDisplay[1] = 0;
            this.borderDisplay[2] = 0;
            this.borderDisplay[3] = 0;
            this.borderColor[0] = 0xF000000;
            this.borderColor[1] = 0xF000000;
            this.borderColor[2] = 0xF000000;
            this.borderColor[3] = 0xF000000;
        }

        void copy(RenderContext other) {
            this.dx = other.dx;
            this.dy = other.dy;
            this.font = other.font;
            this.textColor = other.textColor;
            this.backColor = other.backColor;
            this.flow = other.flow;
        }
    }
}

