/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMSceneHost;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMNullPainter;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.render.BuildState;
import com.cognos.mobile.vm.render.Executive;
import com.cognos.mobile.vm.render.RenderState;
import com.cognos.mobile.vm.render.State;

public class SceneBuilder {
    private static final Class CLASS = SceneBuilder.class;
    private VMScene scene;

    public SceneBuilder(VMScene scene) {
        this.scene = scene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildScene(int startAddress, int endAddress, int endInstruction, IVMPainter painter, ITaskMonitor taskMonitor) throws CMException {
        State state = null;
        Object object = this.scene.getLock();
        synchronized (object) {
            try {
                VM.log(CLASS, 1, "build begin");
                long startTime = System.currentTimeMillis();
                state = new BuildState(this.scene.getRender().reader, startAddress);
                ((BuildState)state).pushBuildNode(this.scene.getRootNode(), true);
                Executive.executeProgram(state, startAddress, endAddress, endInstruction);
                if (state.getCurrentNode() != this.scene.getRootNode()) {
                    throw new CMException(1202, "badly nested scene objects");
                }
                ((BuildState)state).popCurrentNode(0);
                this.scene.getSelection().buildSelectableNodes();
                long stopTime = System.currentTimeMillis();
                VM.log(CLASS, 1, "build end in " + Long.toString(stopTime - startTime) + "ms");
            }
            finally {
                if (state != null) {
                    state.dispose();
                }
            }
        }
        this.layoutScene(painter, this.scene.getViewport().getViewportWidth(), 100, 1.0, null, 0, taskMonitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutScene(IVMPainter painter, int pageWidth, int zoomLevel, double zoomScale, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor, boolean layoutToViewport) throws CMException {
        VMNullPainter nullPainter = null;
        RenderState state = null;
        boolean isZoomed = zoomLevel != 100;
        try {
            VM.log(CLASS, 1, "layout begin");
            long startTime = System.currentTimeMillis();
            this.scene.getRootNode().resetLayout();
            taskMonitor.throwIfCancelled();
            nullPainter = new VMNullPainter(painter);
            state = new RenderState(1, this.scene.getRender().reader, nullPainter, null, pageWidth, this.scene.getViewport().getViewportWidth(), zoomLevel, zoomScale, mobileServiceProxy, tileSize, layoutToViewport, this.scene.getUnzoomedSampleTextSize());
            if (!layoutToViewport && this.scene.getUnzoomedSampleTextSize() == -1) {
                this.scene.setUnzoomedSampleTextSize(state.getSampleTextSize());
            }
            this.scene.getRootNode().size(state);
            taskMonitor.throwIfCancelled();
            state = new RenderState(2, this.scene.getRender().reader, nullPainter, null, pageWidth, this.scene.getViewport().getViewportWidth(), zoomLevel, zoomScale, mobileServiceProxy, tileSize, layoutToViewport, this.scene.getUnzoomedSampleTextSize());
            this.scene.getRootNode().layout(state, 0, 0);
            taskMonitor.throwIfCancelled();
            if (isZoomed) {
                this.scene.setStyle(1);
            } else {
                this.scene.clearStyle(1);
            }
            this.scene.getRootNode().layout2(state, 0, 0);
            taskMonitor.throwIfCancelled();
            Object object = this.scene.getLock();
            synchronized (object) {
                this.scene.getRootNode().onLayoutEnd(state);
                taskMonitor.throwIfCancelled();
                int cx = this.scene.getRootNode().getRect().cx;
                int cy = this.scene.getRootNode().getRect().cy;
                this.scene.getViewport().setCanvasSize(cx, cy);
                this.scene.getSelection().sortSelectableNodes();
                this.scene.getSelection().reselect();
                if (this.scene.getSceneZoomer() != null) {
                    this.scene.getSceneZoomer().setPaintLevel(zoomLevel);
                    this.scene.getSceneZoomer().setPaintScale(zoomScale);
                    this.scene.getSceneZoomer().setPaintPageWidth(pageWidth);
                }
            }
            long stopTime = System.currentTimeMillis();
            VM.log(CLASS, 1, "layout end in " + Long.toString(stopTime - startTime) + "ms");
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, "tree after layout:");
                this.scene.getRootNode().logTree("", state);
            }
        }
        finally {
            if (state != null) {
                state.dispose();
            }
            if (nullPainter != null) {
                nullPainter.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMScene buildFocusScene(String scenePath, int focus, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, ITaskMonitor taskMonitor) throws CMException {
        Object object = this.scene.getLock();
        synchronized (object) {
            Node selectedNode = this.scene.getSelection().getSelectedNode();
            if (selectedNode == null) {
                return null;
            }
            VM.log(CLASS, 1, "focus begin");
            long startTime = System.currentTimeMillis();
            VMScene focusScene = new VMScene(this.scene.getRender(), this.scene.getPageIndex(), scenePath, 3, cxViewport, cyViewport, host, this.scene.getClientApplication(), this.scene.getClientCache());
            switch (focus) {
                case 2: {
                    focusScene.setStyle(8);
                    break;
                }
                case 1: {
                    focusScene.setStyle(4);
                }
            }
            VMScene.Hints hints = new VMScene.Hints();
            if (selectedNode.createFocusTree(focusScene.getRootNode(), focus, hints) == null) {
                VM.log(CLASS, 2, "failed to create focus tree");
                return null;
            }
            focusScene.getSelection().buildSelectableNodes();
            SceneBuilder builder = new SceneBuilder(focusScene);
            builder.layoutScene(painter, cxViewport, 100, 1.0, null, 0, taskMonitor, false);
            if (hints.selected != null) {
                focusScene.getSelection().select(hints.selected);
            } else {
                focusScene.getSelection().selectFirst(1, 0);
            }
            long stopTime = System.currentTimeMillis();
            VM.log(CLASS, 1, "focus end in " + Long.toString(stopTime - startTime) + "ms");
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, "focus tree:");
                focusScene.getRootNode().logTree("", null);
            }
            return focusScene;
        }
    }
}

