/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.client.tasks.FocusSelectedObjectTask;
import com.cognos.mobile.client.tasks.GotoPageTask;
import com.cognos.mobile.client.tasks.ZoomSceneInTask;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.task.IMonitorableTaskRunner;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMSceneHost;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.NodeFinder;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.GroupNode;
import java.util.Stack;

public class SceneManager {
    private static final Class CLASS = SceneManager.class;
    private final VMOptions options;
    private final VMRender render;
    private final IResourceManager resourceManager;
    private final IClientApplication clientApplication;
    private final IVMCache cache;
    private final MobileServiceProxy mobileServiceProxy;
    private int currentPageIndex;
    private Stack sceneStack;

    public SceneManager(VMOptions options, VMRender render, IResourceManager resourceManager, IClientApplication clientApplication, IVMCache cache, MobileServiceProxy mobileServiceProxy) {
        this.options = options;
        this.render = render;
        this.resourceManager = resourceManager;
        this.clientApplication = clientApplication;
        this.cache = cache;
        this.sceneStack = new Stack();
        boolean useService = true;
        switch (options.getAuthenticationState()) {
            case 0: 
            case 3: {
                useService = false;
            }
        }
        if (options.getServerUrl() == null || options.getServerUrl().length() == 0) {
            useService = false;
        }
        this.mobileServiceProxy = useService ? mobileServiceProxy : null;
    }

    public VMRender getRender() {
        return this.render;
    }

    public int getCurrentPage() {
        return this.currentPageIndex;
    }

    public synchronized VMScene getCurrentScene() {
        if (this.sceneStack.isEmpty()) {
            return null;
        }
        StackItem context = (StackItem)this.sceneStack.peek();
        return context.scene;
    }

    public VMScene gotoPage(int newPageIndex, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        this.popAllScenes();
        VMScene pageScene = this.render.buildPageScene(newPageIndex, cxViewport, cyViewport, painter, host, this.clientApplication, this.cache, taskMonitor);
        pageScene.getSelection().selectFirst(1, 0);
        int zoomLevel = this.options.getPageInitialZoom();
        pageScene.zoomSceneByZoomLevel(painter, zoomLevel, this.mobileServiceProxy, tileSize, taskMonitor);
        this.currentPageIndex = newPageIndex;
        this.pushScene(0, pageScene);
        String tooltip = this.resourceManager.formatString(CMIDs.PAGE_TOOLTIP_AT_PAGE_N_OF_N, new String[]{this.render.getMeta().label, Integer.toString(pageScene.getPageIndex() + 1), Integer.toString(this.render.getPageCount())});
        pageScene.setTooltip(tooltip);
        return pageScene;
    }

    public VMScene focusSelectedObject(int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        VMScene newScene;
        VMScene parentScene = this.getCurrentScene();
        if (parentScene == null) {
            VM.log(CLASS, 2, "can't focus because no visible scene");
            return null;
        }
        if (parentScene.getSelection().getSelectedNode() == null) {
            VM.log(CLASS, 2, "can't focus because no selected object");
            return null;
        }
        Node nodeToFocusOn = parentScene.getSelection().getSelectedNode();
        if (!nodeToFocusOn.checkStyle(32) && nodeToFocusOn.checkStyle(0x400000)) {
            for (int i = 0; i < nodeToFocusOn.getChildCount(); ++i) {
                Node child = nodeToFocusOn.getChild(i);
                if (!child.checkStyle(32) || !child.isSelectable()) continue;
                nodeToFocusOn = child;
                break;
            }
        }
        if ((newScene = this.render.buildObjectScene(parentScene, nodeToFocusOn, cxViewport, cyViewport, painter, host, this.clientApplication, this.cache, taskMonitor)) == null) {
            VM.log(CLASS, 3, "failed to build focus scene");
            return null;
        }
        int zoomLevel = this.getInitialZoom(newScene);
        if (zoomLevel != 100) {
            newScene.zoomSceneByZoomLevel(painter, zoomLevel, this.mobileServiceProxy, tileSize, taskMonitor);
        }
        newScene.getSelection().selectFirst(1, 3);
        this.pushScene(0, newScene);
        String tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_OBJECT_FOCUS);
        switch (parentScene.getSelection().getSelectedNode().getType()) {
            case 2: {
                tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_TABLE_FOCUS);
                break;
            }
            case 4: {
                GroupNode group = (GroupNode)parentScene.getSelection().getSelectedNode();
                switch (group.getGroupType()) {
                    case 5: {
                        tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_CHART_FOCUS);
                        break;
                    }
                    case 3: {
                        tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_FOOTER_FOCUS);
                        break;
                    }
                    case 2: {
                        tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_HEADER_FOCUS);
                        break;
                    }
                    case 4: {
                        tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_IMAGE_FOCUS);
                    }
                }
                break;
            }
            case 8: {
                tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_IMAGE_FOCUS);
                break;
            }
            case 6: {
                tooltip = this.resourceManager.loadString(CMIDs.OBJECT_TOOLTIP_TEXT_FOCUS);
            }
        }
        newScene.setTooltip(tooltip);
        return newScene;
    }

    public VMScene focusSelectedRowOrColumn(int focus, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize) throws CMException {
        VMScene parentScene = this.getCurrentScene();
        if (parentScene == null) {
            VM.log(CLASS, 3, "can't focus because no visible scene");
            return null;
        }
        if (parentScene.getSelection().getSelectedNode() == null) {
            VM.log(CLASS, 3, "can't focus because no selected object");
            return null;
        }
        VMScene newScene = this.render.buildFocusScene(parentScene, focus, cxViewport, cyViewport, painter, host, ITaskMonitor.NULL);
        if (newScene == null) {
            VM.log(CLASS, 3, "failed to build focus scene");
            return null;
        }
        int zoomLevel = this.getInitialZoom(newScene);
        if (zoomLevel != 100) {
            newScene.zoomSceneByZoomLevel(painter, zoomLevel, this.mobileServiceProxy, tileSize, ITaskMonitor.NULL);
        }
        this.pushScene(focus, newScene);
        String tooltip = null;
        if (parentScene.getSelection().getSelectedNode().getType() == 3) {
            int current = 0;
            int total = 0;
            String stringID = null;
            CellNode cell = (CellNode)parentScene.getSelection().getSelectedNode();
            switch (focus) {
                case 2: {
                    stringID = CMIDs.FOCUS_TOOLTIP_COLUMN_FOCUS;
                    current = cell.getColumn();
                    total = cell.getTable().getColumnCount();
                    break;
                }
                case 1: {
                    stringID = CMIDs.FOCUS_TOOLTIP_ROW_FOCUS;
                    current = cell.getRow();
                    total = cell.getTable().getRowCount();
                }
            }
            tooltip = this.resourceManager.formatString(stringID, new String[]{Integer.toString(current + 1), Integer.toString(total)});
        }
        newScene.setTooltip(tooltip);
        return newScene;
    }

    public VMScene moveRowColumn(int drow, int dcol, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize) throws CMException {
        return this.tableFocusHelper(0, drow, dcol, cxViewport, cyViewport, painter, host, tileSize);
    }

    public VMScene changeFocusMode(int newMode, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize) throws CMException {
        return this.tableFocusHelper(newMode, 0, 0, cxViewport, cyViewport, painter, host, tileSize);
    }

    public VMScene zoomSceneIn(boolean isZoomIn, IVMPainter painter, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        VMScene scene = this.getCurrentScene();
        if (scene == null) {
            return null;
        }
        int newZoomLevel = scene.zoomSceneIn(isZoomIn, painter, this.mobileServiceProxy, tileSize, taskMonitor);
        String tooltip = this.resourceManager.formatString(CMIDs.PAGE_TOOLTIP_ZOOM_N_PERCENT, Integer.toString(newZoomLevel));
        scene.setTooltip(tooltip);
        return scene;
    }

    public VMScene zoomSceneByZoomLevel(IVMPainter painter, int zoomLevel, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        VMScene scene = this.getCurrentScene();
        if (scene == null) {
            return null;
        }
        scene.zoomSceneByZoomLevel(painter, zoomLevel, this.mobileServiceProxy, tileSize, taskMonitor);
        int newZoomLevel = scene.getZoomLevel();
        String tooltip = this.resourceManager.formatString(CMIDs.PAGE_TOOLTIP_ZOOM_N_PERCENT, Integer.toString(newZoomLevel));
        scene.setTooltip(tooltip);
        return scene;
    }

    public VMScene markSelectedNode(boolean mark) {
        VMScene scene = this.getCurrentScene();
        if (scene == null) {
            return null;
        }
        Node selectNode = scene.getSelection().getSelectedNode();
        this.parentSceneMarkCell(mark, selectNode);
        scene.markSelectedNode(mark);
        String tooltip = this.resourceManager.loadString(mark ? CMIDs.OBJECT_TOOLTIP_MARKED_CELL : CMIDs.OBJECT_TOOLTIP_UNMARKED_CELL);
        scene.setTooltip(tooltip);
        return scene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parentSceneMarkCell(boolean mark, Node selectNode) {
        SceneManager sceneManager = this;
        synchronized (sceneManager) {
            if (this.sceneStack.isEmpty()) {
                VM.log(CLASS, 3, "no current scene");
                return;
            }
            StackItem focusItem = (StackItem)this.sceneStack.pop();
            if (!(focusItem.focusMode != 2 && focusItem.focusMode != 1 || this.sceneStack.isEmpty())) {
                StackItem context = (StackItem)this.sceneStack.peek();
                context.scene.markNode(selectNode, mark);
            }
            this.sceneStack.push(focusItem);
        }
    }

    public VMScene sendKey(int key, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize, IMonitorableTaskRunner taskRunner) throws CMException {
        VMScene scene = this.getCurrentScene();
        if (scene == null) {
            return null;
        }
        switch (key) {
            case 100: {
                return this.closeScene();
            }
            case 101: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 0x400L)) {
                    int pageIndex = this.getCurrentPage() - 1;
                    return (VMScene)taskRunner.run(new GotoPageTask(this, pageIndex, cxViewport, cyViewport, painter, host, tileSize));
                }
                return scene;
            }
            case 102: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 0x200L)) {
                    int pageIndex = this.getCurrentPage() + 1;
                    return (VMScene)taskRunner.run(new GotoPageTask(this, pageIndex, cxViewport, cyViewport, painter, host, tileSize));
                }
                return scene;
            }
            case 103: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 1L)) {
                    return (VMScene)taskRunner.run(new FocusSelectedObjectTask(this, cxViewport, cyViewport, painter, host, tileSize));
                }
                if (0L != (enabled & 2L)) {
                    return this.focusSelectedRowOrColumn(1, cxViewport, cyViewport, painter, host, tileSize);
                }
                if (0L != (enabled & 4L)) {
                    return this.focusSelectedRowOrColumn(1, cxViewport, cyViewport, painter, host, tileSize);
                }
                if (0L != (enabled & 0x10000L)) {
                    return this.markSelectedNode(true);
                }
                if (0L != (enabled & 0x20000L)) {
                    return this.markSelectedNode(false);
                }
                return scene;
            }
            case 9: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 0x10000L)) {
                    return this.markSelectedNode(true);
                }
                if (0L != (enabled & 0x20000L)) {
                    return this.markSelectedNode(false);
                }
                return scene;
            }
            case 104: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 0x800L)) {
                    return (VMScene)taskRunner.run(new ZoomSceneInTask(this, true, painter, tileSize));
                }
                return scene;
            }
            case 105: {
                long enabled = scene.getEnabledCommands();
                if (0L != (enabled & 0x1000L)) {
                    return (VMScene)taskRunner.run(new ZoomSceneInTask(this, false, painter, tileSize));
                }
                return scene;
            }
        }
        scene.sendKey(key, 1, 5);
        return scene;
    }

    public VMScene relayoutScene(IVMPainter painter, int cxViewport, int cyViewport, int tileSize) throws CMException {
        VMScene scene = this.getCurrentScene();
        if (scene != null) {
            scene.relayoutScene(painter, this.mobileServiceProxy, cxViewport, cyViewport, tileSize);
        }
        return scene;
    }

    public VMScene resizeScene(IVMPainter painter, int cxViewport, int cyViewport, int tileSize) throws CMException {
        VMScene scene = this.getCurrentScene();
        if (scene != null && (cxViewport != scene.getViewport().getViewportWidth() || cyViewport != scene.getViewport().getViewportHeight())) {
            scene.relayoutScene(painter, this.mobileServiceProxy, cxViewport, cyViewport, tileSize);
        }
        return scene;
    }

    public synchronized VMScene closeScene() {
        if (this.sceneStack.empty()) {
            return null;
        }
        StackItem stackItem = (StackItem)this.sceneStack.peek();
        stackItem.scene.dispose();
        stackItem = (StackItem)this.sceneStack.pop();
        return stackItem.scene;
    }

    private synchronized void popAllScenes() {
        while (!this.sceneStack.isEmpty()) {
            StackItem stackItem = (StackItem)this.sceneStack.pop();
            stackItem.scene.dispose();
        }
    }

    private synchronized void pushScene(int focusMode, VMScene scene) {
        StackItem newContext = new StackItem();
        newContext.focusMode = focusMode;
        newContext.scene = scene;
        this.sceneStack.push(newContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMScene tableFocusHelper(int newFocusMode, int drow, int dcol, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, int tileSize) throws CMException {
        VMScene scene;
        StackItem focusItem;
        SceneManager sceneManager = this;
        synchronized (sceneManager) {
            if (this.sceneStack.isEmpty()) {
                VM.log(CLASS, 3, "no current scene");
                return null;
            }
            focusItem = (StackItem)this.sceneStack.pop();
            if (focusItem.focusMode != 2 && focusItem.focusMode != 1) {
                VM.log(CLASS, 3, "current scene is not a column or row focus scene");
                this.sceneStack.push(focusItem);
                return null;
            }
        }
        VMScene focusScene = focusItem.scene;
        VMScene parentScene = this.getCurrentScene();
        if (parentScene == null) {
            VM.log(CLASS, 3, "row/column focus scene has no parent?!");
            this.sceneStack.push(focusItem);
            return null;
        }
        CellNode selectedTableCell = NodeFinder.findOtherTableCell(focusScene, parentScene, drow, dcol);
        if (selectedTableCell == null) {
            VM.log(CLASS, 2, "failed to move next/previous row/column");
            this.sceneStack.push(focusItem);
            return null;
        }
        parentScene.getSelection().select(selectedTableCell);
        if (newFocusMode == 0) {
            newFocusMode = focusItem.focusMode;
        }
        if ((scene = this.focusSelectedRowOrColumn(newFocusMode, cxViewport, cyViewport, painter, host, tileSize)) == null) {
            this.sceneStack.push(focusItem);
            return null;
        }
        return scene;
    }

    int getInitialZoom(VMScene newScene) {
        Node rootNode = newScene.getRootNode();
        if (rootNode == null) {
            return 100;
        }
        if (rootNode.checkStyle(32768)) {
            return this.options.getImageInitialZoom();
        }
        return this.options.getTextInitialZoom();
    }

    private class StackItem {
        public int focusMode;
        public VMScene scene;

        private StackItem() {
        }
    }
}

