/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.render.SceneManager;
import java.util.Stack;

public class SceneManagerStack {
    private Stack stack = new Stack();

    public synchronized SceneManager pushRender(VMOptions options, VMRender render, IResourceManager resourceManager, IClientApplication clientApplication, IVMCache cache, MobileServiceProxy mobileServiceProxy) {
        SceneManager newSceneManager = new SceneManager(options, render, resourceManager, clientApplication, cache, mobileServiceProxy);
        this.stack.push(newSceneManager);
        clientApplication.untriggerNewRendersAlert();
        return newSceneManager;
    }

    public synchronized SceneManager popRender() {
        if (this.stack.empty()) {
            return null;
        }
        return (SceneManager)this.stack.pop();
    }

    public synchronized SceneManager peek() {
        if (!this.stack.empty()) {
            return (SceneManager)this.stack.peek();
        }
        return null;
    }

    public synchronized void push(SceneManager manager) {
        this.stack.push(manager);
    }

    public void dispose() {
        VMRender render;
        SceneManager manager = this.popRender();
        if (manager != null && (render = manager.getRender()) != null) {
            render.dispose();
            Object var2_2 = null;
        }
    }
}

