/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.render.SceneBuilder;

public class SceneZoomer {
    private static final Class CLASS = SceneZoomer.class;
    private static final double ZOOM_SCALE_FUDGE = 0.98;
    private VMScene scene;
    private VMPoint unzoomedSize;
    private int level;
    private double scale;
    private int pageWidth;
    private int paintLevel;
    private double paintScale;
    private int paintPageWidth;

    public SceneZoomer(VMScene scene, int unzoomedWidth, int unzoomedHeight) {
        this.scene = scene;
        this.unzoomedSize = new VMPoint(unzoomedWidth, unzoomedHeight);
        this.level = 100;
        this.scale = 1.0;
        this.pageWidth = 0;
        this.paintLevel = 100;
        this.paintScale = 1.0;
        this.paintPageWidth = 0;
    }

    public int getZoomLevel() {
        int zoomLevel = CMMathHelper.multiplyIntByDouble(100, this.scale);
        return zoomLevel;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public double getScale() {
        return this.scale;
    }

    public void setPaintLevel(int paintLevel) {
        this.paintLevel = paintLevel;
    }

    public int getPaintLevel() {
        return this.paintLevel;
    }

    public void setPaintScale(double paintScale) {
        this.paintScale = paintScale;
    }

    public double getPaintScale() {
        return this.paintScale;
    }

    public void setPaintPageWidth(int paintPageWidth) {
        this.paintPageWidth = paintPageWidth;
    }

    public int getPaintPageWidth() {
        return this.paintPageWidth;
    }

    public void zoomSceneByPageWidth(IVMPainter painter, int pageWidth, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        if (pageWidth < 1) {
            String details = "invalid page width: " + pageWidth;
            throw new CMException(1200, details);
        }
        this.pageWidth = pageWidth;
        this.scale = (double)pageWidth / (double)this.unzoomedSize.x;
        this.level = CMMathHelper.multiplyIntByDouble(100, this.scale);
        this.zoomSceneCommon(painter, mobileServiceProxy, tileSize, taskMonitor);
    }

    public void zoomSceneByPageHeight(IVMPainter painter, int pageHeight, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        if (pageHeight < 1) {
            String details = "invalid page width: " + this.pageWidth;
            throw new CMException(1200, details);
        }
        this.scale = (double)pageHeight / (double)this.unzoomedSize.y;
        this.pageWidth = (int)(this.scale * (double)this.unzoomedSize.x);
        this.level = CMMathHelper.multiplyIntByDouble(100, this.scale);
        this.zoomSceneCommon(painter, mobileServiceProxy, tileSize, taskMonitor);
    }

    public int zoomSceneIn(boolean isZoomIn, IVMPainter painter, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        int zoomLevel = this.getZoomLevel();
        if (isZoomIn) {
            zoomLevel += 25;
            zoomLevel = zoomLevel / 25 * 25;
            zoomLevel = Math.min(zoomLevel, 300);
        } else {
            zoomLevel -= 25;
            zoomLevel = (zoomLevel + 24) / 25 * 25;
            zoomLevel = Math.max(zoomLevel, 10);
        }
        if (zoomLevel != this.getZoomLevel()) {
            this.zoomSceneByZoomLevel(painter, zoomLevel, mobileServiceProxy, tileSize, taskMonitor);
        } else {
            VM.log(CLASS, 1, "zoom level already at " + zoomLevel);
        }
        return zoomLevel;
    }

    public void zoomSceneByZoomLevel(IVMPainter painter, int zoomLevel, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        int cxPage;
        switch (zoomLevel) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                zoomLevel = Math.min(zoomLevel, 300);
                zoomLevel = Math.max(zoomLevel, 10);
            }
        }
        double scaleFudge = 1.0;
        switch (zoomLevel) {
            case -1: {
                cxPage = this.scene.getViewport().getViewportWidth();
                scaleFudge = 0.98;
                break;
            }
            case -2: {
                double viewRatio = (double)this.scene.getViewport().getViewportWidth() / (double)this.scene.getViewport().getViewportHeight();
                double pageRatio = (double)this.unzoomedSize.x / (double)this.unzoomedSize.y;
                if (pageRatio < viewRatio) {
                    int cyPage = this.scene.getViewport().getViewportHeight();
                    cxPage = CMMathHelper.multiplyIntByDouble(cyPage, pageRatio);
                } else {
                    cxPage = this.scene.getViewport().getViewportWidth();
                }
                scaleFudge = 0.98;
                break;
            }
            default: {
                cxPage = CMMathHelper.multiplyIntByDouble(this.unzoomedSize.x, (double)zoomLevel / 100.0);
            }
        }
        this.level = zoomLevel;
        this.pageWidth = cxPage;
        int cxFull = this.unzoomedSize.x;
        this.scale = (double)cxPage / (double)cxFull;
        this.scale *= scaleFudge;
        if (this.scale < 0.01) {
            VM.log(CLASS, 3, "invalid scale: " + this.scale);
            return;
        }
        this.zoomSceneCommon(painter, mobileServiceProxy, tileSize, taskMonitor);
        int testCX = 0;
        int testCY = 0;
        if (zoomLevel == -2) {
            testCX = this.scene.getRootNode().getRect().cx;
            testCY = this.scene.getRootNode().getRect().cy;
        } else if (zoomLevel == -1) {
            testCX = this.scene.getRootNode().getRect().cx;
        }
        double correction = 0.0;
        if (testCX != 0 && testCX != this.scene.getViewport().getViewportWidth()) {
            correction = (double)testCX / (double)this.scene.getViewport().getViewportWidth();
        }
        if (testCY != 0 && testCY != this.scene.getViewport().getViewportHeight()) {
            correction = Math.max(correction, (double)testCY / (double)this.scene.getViewport().getViewportHeight());
        }
        if (correction < 0.01) {
            return;
        }
        if (Math.abs(correction - 1.0) < 0.01) {
            // empty if block
        }
        VM.log(CLASS, 1, "correcting too large scene (" + testCX + "," + testCY + ") by a factor of " + correction);
        this.scale /= correction;
        this.scale *= 0.98;
        this.zoomSceneCommon(painter, mobileServiceProxy, tileSize, taskMonitor);
    }

    public void rezoom(IVMPainter painter, MobileServiceProxy mobileServiceProxy, int unzoomedWidth, int unzoomedHeight, int tileSize) throws CMException {
        this.unzoomedSize = new VMPoint(unzoomedWidth, unzoomedHeight);
        this.zoomSceneByZoomLevel(painter, this.level, mobileServiceProxy, tileSize, ITaskMonitor.NULL);
    }

    public void unzoomScene() throws CMException {
        if (!this.scene.checkStyle(1)) {
            return;
        }
        this.scene.getViewport().setCanvasSize(this.unzoomedSize.x + 1, this.unzoomedSize.y + 1);
        this.scene.getSelection().reselect();
    }

    private void zoomSceneCommon(IVMPainter painter, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        boolean wouldDebugLog = VM.wouldLog(CLASS, 0);
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "zoom scale = " + this.scale);
            VM.log(CLASS, 0, "zoom target size = " + this.pageWidth + "x" + CMMathHelper.multiplyIntByDouble(this.unzoomedSize.y, this.scale));
        }
        if (this.scene.getRender().getMeta().renderID < 0 && mobileServiceProxy != null) {
            VM.log(CLASS, 1, "forcing renders to be generated (not on server)");
            mobileServiceProxy = null;
        }
        SceneBuilder builder = new SceneBuilder(this.scene);
        builder.layoutScene(painter, this.pageWidth, this.level, this.scale, mobileServiceProxy, tileSize, taskMonitor, true);
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "tree after zooming:");
            this.scene.getRootNode().logTree("");
        }
        this.scene.getViewport().x = 0;
        this.scene.getViewport().y = 0;
        int cxPage = this.scene.getRootNode().getRect().cx;
        int cyPage = this.scene.getRootNode().getRect().cy;
        this.scene.getViewport().setCanvasSize(cxPage, cyPage);
        this.scene.getSelection().reselect();
    }
}

