/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.render;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import java.util.Stack;

public class State {
    private static final Class CLASS = State.class;
    private static boolean DEBUG_TRACK_PUSH_AND_POP = false;
    public int exec;
    public IVMReader reader;
    private IVMReader.CodeRecord codeRecord;
    private Stack nodeStack;

    public State(int exec, IVMReader reader) {
        this.exec = exec;
        this.reader = reader;
        this.codeRecord = new IVMReader.CodeRecord();
        this.nodeStack = new Stack();
    }

    public void dispose() {
    }

    public void pushCurrentNode(Node node) {
        if (DEBUG_TRACK_PUSH_AND_POP) {
            VM.log(CLASS, 0, "push: " + node.toString());
        }
        this.nodeStack.push(node);
    }

    public void popCurrentNode(int endAddressOffset) throws CMException {
        if (this.nodeStack.empty()) {
            throw new CMException(1202, "badly nested objects");
        }
        if (DEBUG_TRACK_PUSH_AND_POP) {
            Node currentNode = this.getCurrentNode();
            VM.log(CLASS, 0, "pop: " + currentNode.toString());
        }
        this.nodeStack.pop();
    }

    public Node getCurrentNode() {
        if (this.nodeStack.empty()) {
            return null;
        }
        return (Node)this.nodeStack.peek();
    }

    public IVMReader.CodeRecord getCurrentCodeRecord() {
        return this.codeRecord;
    }
}

