/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.model.data.AtomFeedNode;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLAtomFeedNodeHandler
extends DefaultHandler {
    public static final int TOKEN_ATOM_ENTRY_O = 1;
    public static final int TOKEN_ATOM_ENTRY_C = 2;
    public static final int TOKEN_ATOM_ID_O = 3;
    public static final int TOKEN_ATOM_ID_C = 4;
    public static final int TOKEN_ATOM_TITLE_O = 5;
    public static final int TOKEN_ATOM_TITLE_C = 6;
    public static final int TOKEN_ATOM_UPDATED_O = 7;
    public static final int TOKEN_ATOM_UPDATED_C = 8;
    public static final int TOKEN_ATOM_CONTENT_TYPE_O = 9;
    public static final int TOKEN_ATOM_CONTENT_TYPE_C = 10;
    public static final int TOKEN_ATOM_LINK_O = 11;
    public static final int TOKEN_ATOM_LINK_C = 12;
    public static final int TOKEN_CM_SEARCHPATH_O = 13;
    public static final int TOKEN_CM_SEARCHPATH_C = 14;
    public static final int TOKEN_CM_STOREID_O = 15;
    public static final int TOKEN_CM_STOREID_C = 16;
    public static final int TOKEN_CM_OBJCLASS_O = 17;
    public static final int TOKEN_CM_OBJCLASS_C = 18;
    public static final int TOKEN_ATOM_FEED_O = 19;
    public static final int TOKEN_ATOM_FEED_C = 20;
    private AtomFeedNode atomFeedNode;
    private StringBuffer text;
    private boolean collectText;
    private boolean entryStart = false;
    private String atomID;
    private String atomTitle;
    private Date atomUpdated;
    private String atomContent;
    private String atomLink;
    private String cmPath;
    private String cmStoreID;
    private String cmObjectClass;

    public XMLAtomFeedNodeHandler(AtomFeedNode atomFeedNode) {
        this.atomFeedNode = atomFeedNode;
    }

    public int lookupToken(String node, boolean open) {
        int iToken = 0;
        if (!open) {
            ++iToken;
        }
        if (node == null) {
            return -1;
        }
        if (node.equals("atom:feed")) {
            return iToken + 19;
        }
        if (node.equals("atom:entry")) {
            return iToken + 1;
        }
        if (node.equals("atom:id")) {
            return iToken + 3;
        }
        if (node.equals("atom:title")) {
            return iToken + 5;
        }
        if (node.equals("atom:updated")) {
            return iToken + 7;
        }
        if (node.equals("atom:content")) {
            return iToken + 9;
        }
        if (node.equals("atom:link")) {
            return iToken + 11;
        }
        if (node.equals("cm:searchPath")) {
            return iToken + 13;
        }
        if (node.equals("cm:storeID")) {
            return iToken + 15;
        }
        if (node.equals("cm:objectClass")) {
            return iToken + 17;
        }
        return -1;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        System.out.println("Localname: " + localName);
        System.out.println("Name: " + name);
        int token = this.lookupToken(name, true);
        switch (token) {
            case 1: {
                this.entryStart = true;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 17: {
                if (this.entryStart) {
                    this.captureText(true);
                    break;
                }
                this.captureText(false);
                break;
            }
            case 11: {
                if (this.entryStart) {
                    this.captureText(true);
                } else {
                    this.captureText(false);
                }
                String type = attributes.getValue("type");
                if (type == null || !type.equals("text/html")) break;
                this.atomLink = attributes.getValue("href");
                break;
            }
            default: {
                this.captureText(false);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        System.out.println("Localname: " + localName);
        System.out.println("Name: " + name);
        int token = this.lookupToken(name, false);
        switch (token) {
            case 2: {
                this.entryStart = false;
                this.atomFeedNode.add(this.atomID, this.atomTitle, this.atomUpdated, this.atomContent, this.atomLink, this.cmPath, this.cmStoreID, this.cmObjectClass);
                this.clear();
                break;
            }
            case 4: {
                this.atomID = this.getText();
                break;
            }
            case 6: {
                this.atomTitle = CMUrlHelper.encodeSourcePathElement(this.getText());
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                this.atomContent = this.getText();
                break;
            }
            case 14: {
                this.cmPath = this.getText();
                break;
            }
            case 16: {
                this.cmStoreID = this.getText();
            }
            case 18: {
                this.cmObjectClass = this.getText();
                break;
            }
            case 20: {
                if (this.atomFeedNode.hasChildren()) break;
                this.atomFeedNode.setLeaf();
            }
        }
    }

    private void clear() {
        this.atomID = null;
        this.atomTitle = null;
        this.atomUpdated = null;
        this.atomContent = null;
        this.atomLink = null;
        this.cmPath = null;
        this.cmStoreID = null;
        this.cmObjectClass = null;
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectText) {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.collectText) {
            this.text.append(ch, start, length);
        }
    }

    public final void captureText(boolean t) {
        this.collectText = t;
        this.text = new StringBuffer();
    }

    public final String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }
}

