/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.model.data.PortalItem;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import com.cognos.mobile.xml.XMLResponseHandler;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class XMLBrowsePortalHandler
extends XMLResponseHandler {
    private static Class CLASS = XMLBrowsePortalHandler.class;
    private static final int STATE_ITEM = 8;
    private static final int STATE_LABEL = 9;
    private static final int STATE_ITEMTYPE = 10;
    private static final int STATE_CMPATH = 11;
    private static final int STATE_SOURCEPATH = 12;
    private static final int STATE_ACCESSPERMISSION_READ = 13;
    private static final int STATE_ACCESSPERMISSION_EXECUTE = 14;
    private static final int STATE_ACCESSPERMISSION_TRAVERSE = 15;
    private Vector m_items;
    private PortalItem m_currentItem;

    public XMLBrowsePortalHandler() {
        this.addStateTransition("item", 1, 8);
        this.addStateTransition("label", 8, 9);
        this.addStateTransition("itemType", 8, 10);
        this.addStateTransition("cmPath", 8, 11);
        this.addStateTransition("sourcePath", 8, 12);
        this.addStateTransition("canRead", 8, 13);
        this.addStateTransition("canExecute", 8, 14);
        this.addStateTransition("canTraverse", 8, 15);
        this.m_items = new Vector();
        this.m_currentItem = null;
    }

    public PortalItem[] getPortalItems() {
        int count = this.m_items == null ? 0 : this.m_items.size();
        PortalItem[] list = new PortalItem[count];
        for (int i = 0; i < count; ++i) {
            list[i] = (PortalItem)this.m_items.elementAt(i);
        }
        return list;
    }

    @Override
    public void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
        super.onStateHandlerStartState(state, attrs);
        switch (state) {
            case 8: {
                this.m_currentItem = new PortalItem();
            }
        }
    }

    @Override
    public void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        super.onStateHandlerEndState(state, characters);
        switch (state) {
            case 9: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.label = characters;
                break;
            }
            case 10: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.itemType = XMLHelper.crackItemType(characters);
                break;
            }
            case 11: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.cmPath = characters;
                break;
            }
            case 12: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.sourcePath = characters;
                break;
            }
            case 13: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.canRead = CMStringHelper.parseBoolean(characters);
                break;
            }
            case 14: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.canExecute = CMStringHelper.parseBoolean(characters);
                break;
            }
            case 15: {
                if (this.m_currentItem == null) break;
                this.m_currentItem.canTraverse = CMStringHelper.parseBoolean(characters);
                break;
            }
            case 8: {
                if (this.m_currentItem == null) break;
                if (this.m_currentItem.label == null || this.m_currentItem.label.equals("")) {
                    VM.log(CLASS, 2, "skipped item without a label");
                    this.m_currentItem = null;
                } else if (this.m_currentItem.itemType == 50) {
                    VM.log(CLASS, 2, "skipped unknown item type");
                    this.m_currentItem = null;
                }
                if (this.m_currentItem == null) break;
                this.m_items.addElement(this.m_currentItem);
                this.m_currentItem = null;
            }
        }
    }
}

