/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.prompts.TreePromptNode;
import com.cognos.mobile.prompts.TreePromptNodeHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class XMLBrowseTreeNodePromptHandler
implements IRecoverableResponseHandler {
    private static Class CLASS = XMLBrowseTreeNodePromptHandler.class;
    private static final String SIGNATURE = "<rds:treePromptNode";
    private final ICMXMLParserFactory xmlPFact;
    private final TreePromptNodeHandler promptsContentHandler;

    public XMLBrowseTreeNodePromptHandler(TreePromptNode node, ICMXMLParserFactory xmlPFact) {
        this.xmlPFact = xmlPFact;
        this.promptsContentHandler = new TreePromptNodeHandler(node);
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equalsIgnoreCase("text/xml") && response.responseBodyContains("<response status=\"success\">") && response.responseBodyContains(SIGNATURE);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        IXMLParser p = this.xmlPFact.create();
        try {
            InputStream in = response.getInputStream();
            p.parse(in, this.promptsContentHandler);
        }
        catch (IOException ioe) {
            VM.log(CLASS, 3, ioe);
        }
        catch (SAXException saxe) {
            VM.log(CLASS, 3, saxe);
        }
        return null;
    }
}

