/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMBase64;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLResponseHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import org.xml.sax.SAXParseException;

public class XMLDownloadRenderHandler
extends XMLResponseHandler {
    private static Class CLASS = XMLDownloadRenderHandler.class;
    private static final int STATE_COUNT = 8;
    private static final int STATE_CHUNK = 9;
    private static final int STATE_INDEX = 10;
    private static final int STATE_TYPE = 11;
    private static final int STATE_BYTES = 12;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_CODE = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BLOB = 3;
    private IVMWriter m_writer;
    private int m_chunkIndex;
    private int m_chunkType;
    private byte[] m_chunkBytes;
    private int m_currentBlobID;
    private ByteArrayOutputStream m_currentBlob;

    public XMLDownloadRenderHandler(IVMWriter writer) {
        this.m_writer = writer;
        this.m_chunkIndex = -1;
        this.m_currentBlobID = -1;
        this.m_currentBlob = null;
        this.addStateTransition("count", 1, 8);
        this.addStateTransition("chunk", 1, 9);
        this.addStateTransition("index", 9, 10);
        this.addStateTransition("type", 9, 11);
        this.addStateTransition("bytes", 9, 12);
    }

    @Override
    public void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        super.onStateHandlerEndState(state, characters);
        switch (state) {
            case 1: {
                try {
                    this.flushCurrentBlob();
                    break;
                }
                catch (Exception ex) {
                    String message = "failed to flush last blob: " + ex.toString();
                    VM.log(CLASS, 3, message);
                    throw new SAXParseException(ex.toString(), null);
                }
            }
            case 10: {
                int newIndex = Integer.parseInt(characters);
                if (newIndex != this.m_chunkIndex + 1) {
                    throw new SAXParseException("index out of order", null);
                }
                this.m_chunkIndex = newIndex;
                break;
            }
            case 11: {
                if (characters.equals("code")) {
                    this.m_chunkType = 1;
                    break;
                }
                if (characters.equals("string")) {
                    this.m_chunkType = 2;
                    break;
                }
                if (characters.equals("blob")) {
                    this.m_chunkType = 3;
                    break;
                }
                VM.log(CLASS, 2, "unrecognized chunk type: " + characters);
                this.m_chunkType = 0;
                break;
            }
            case 12: {
                this.m_chunkBytes = CMBase64.decode(characters);
                break;
            }
            case 9: {
                this.saveChunk();
            }
        }
    }

    private void saveChunk() throws SAXParseException {
        if (this.m_chunkType != 0) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.m_chunkBytes));
            switch (this.m_chunkType) {
                case 1: {
                    this.saveCodeChunk(in);
                    break;
                }
                case 2: {
                    this.saveStringChunk(in);
                    break;
                }
                case 3: {
                    this.saveBlobChunk(in);
                }
            }
        }
        this.m_chunkType = 0;
        this.m_chunkBytes = null;
    }

    private void saveCodeChunk(DataInputStream in) throws SAXParseException {
        try {
            while (in.available() > 0) {
                byte opcode = in.readByte();
                int p1 = in.readInt();
                int p2 = in.readInt();
                this.m_writer.onWriterWriteCode(opcode, p1, p2);
            }
        }
        catch (Exception ex) {
            String msg = "failed to process code chunk: " + ex.toString();
            VM.log(CLASS, 3, msg);
            throw new SAXParseException(msg, null);
        }
    }

    private void saveStringChunk(DataInputStream in) throws SAXParseException {
        try {
            while (in.available() > 0) {
                String string = in.readUTF();
                this.m_writer.onWriterWriteString(string);
            }
        }
        catch (Exception ex) {
            String msg = "failed to process string chunk: " + ex.toString();
            VM.log(CLASS, 3, msg);
            throw new SAXParseException(msg, null);
        }
    }

    private void saveBlobChunk(DataInputStream in) throws SAXParseException {
        try {
            int blobID = in.readInt();
            in.readInt();
            int length = in.readInt();
            if (length < 0) {
                String msg = "invalid blob length: " + length;
                VM.log(CLASS, 3, msg);
                throw new SAXParseException(msg, null);
            }
            if (blobID != this.m_currentBlobID) {
                this.flushCurrentBlob();
                this.m_currentBlobID = blobID;
                this.m_currentBlob = new ByteArrayOutputStream(length);
            }
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            this.m_currentBlob.write(bytes);
        }
        catch (Exception ex) {
            String msg = "failed to process blob chunk: " + ex.toString();
            VM.log(CLASS, 3, msg);
            throw new SAXParseException(msg, null);
        }
    }

    private void flushCurrentBlob() throws CMException {
        if (this.m_currentBlobID != -1 && this.m_currentBlob != null) {
            this.m_writer.onWriterWriteBlob(this.m_currentBlob.toByteArray(), 5);
            this.m_currentBlobID = -1;
            this.m_currentBlob = null;
        }
    }
}

