/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.xml.XMLResponseHandler;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class XMLFailureResponseHandler
extends XMLResponseHandler {
    private static final int STATE_ERROR_ELT = 8;
    private static final int STATE_ERROR_CODE = 9;
    private static final int STATE_ERROR_MESSAGE = 10;
    private static final int STATE_ERROR_DETAILS = 11;
    private static final int STATE_ERROR_PARAM = 12;
    private int m_errorCode;
    private Vector m_errorParams;
    private String m_errorMessage;
    private String m_errorDetails;

    public XMLFailureResponseHandler() {
        this.addStateTransition("error", 1, 8);
        this.addStateTransition("code", 8, 9);
        this.addStateTransition("param", 8, 12);
        this.addStateTransition("message", 8, 10);
        this.addStateTransition("details", 8, 11);
        this.m_errorCode = -1;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public String[] getErrorParams() {
        if (this.m_errorParams == null) {
            return new String[0];
        }
        String[] ret = new String[this.m_errorParams.size()];
        for (int i = 0; i < this.m_errorParams.size(); ++i) {
            ret[i] = (String)this.m_errorParams.elementAt(i);
        }
        return ret;
    }

    public String getErrorDetails() {
        return this.m_errorDetails;
    }

    @Override
    protected void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
    }

    @Override
    protected void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        switch (state) {
            case 9: {
                try {
                    this.m_errorCode = Integer.parseInt(characters);
                }
                catch (NumberFormatException ex) {
                    this.m_errorCode = -1;
                }
                break;
            }
            case 10: {
                this.m_errorMessage = characters;
                break;
            }
            case 11: {
                this.m_errorDetails = characters;
                break;
            }
            case 12: {
                if (this.m_errorParams == null) {
                    this.m_errorParams = new Vector();
                }
                this.m_errorParams.addElement(characters);
            }
        }
    }

    @Override
    protected void onStateHandlerInvalidElement(int state, String element) throws SAXParseException {
    }
}

