/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import java.util.Hashtable;

public class XMLHelper {
    private static Hashtable xmlCharacters = null;

    public static int crackItemType(String itemTypeString) {
        if (itemTypeString == null) {
            return 50;
        }
        if (itemTypeString.equals("report")) {
            return 51;
        }
        if (itemTypeString.equals("interactiveReport")) {
            return 57;
        }
        if (itemTypeString.equals("dashboard")) {
            return 56;
        }
        if (itemTypeString.equals("query")) {
            return 52;
        }
        if (itemTypeString.equals("analysis")) {
            return 53;
        }
        if (itemTypeString.equals("shortcut")) {
            return 55;
        }
        if (itemTypeString.equals("reportView")) {
            return 54;
        }
        if (itemTypeString.equals("activeReportView")) {
            return 65;
        }
        if (itemTypeString.equals("folder")) {
            return 58;
        }
        if (itemTypeString.equals("content")) {
            return 64;
        }
        return 50;
    }

    public static String encodeXml(String in) {
        int length = in == null ? 0 : in.length();
        StringBuffer out = new StringBuffer(length);
        block9: for (int i = 0; i < length; ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '<': {
                    out.append("&lt;");
                    continue block9;
                }
                case '>': {
                    out.append("&gt;");
                    continue block9;
                }
                case '&': {
                    out.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    out.append("&#39;");
                    continue block9;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block9;
                }
                case ']': {
                    out.append("&#93;");
                    continue block9;
                }
                case '?': {
                    out.append("&#63;");
                    continue block9;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    public static final String openTag(String element) {
        return "<" + element + ">";
    }

    public static final String openTag(String element, String attName, String attValue) {
        return "<" + element + " " + attName + "=\"" + attValue + "\">";
    }

    public static final String closeTag(String element) {
        return "</" + element + ">";
    }

    public static String xmlDecode(String sXMLEncoded) {
        if (sXMLEncoded == null || sXMLEncoded.length() < 1) {
            return sXMLEncoded;
        }
        String startControl = "&";
        String endControl = ";";
        StringBuffer sXMLDecoded = new StringBuffer();
        int index = 0;
        while (index < sXMLEncoded.length()) {
            int startIndex = sXMLEncoded.indexOf(startControl, index);
            if (startIndex == -1) {
                sXMLDecoded.append(sXMLEncoded.substring(index));
                index = sXMLEncoded.length();
                continue;
            }
            int endIndex = sXMLEncoded.indexOf(endControl, startIndex);
            if (endIndex == -1) {
                sXMLDecoded.append(sXMLEncoded.substring(index));
                index = sXMLEncoded.length();
                continue;
            }
            sXMLDecoded.append(sXMLEncoded.substring(index, startIndex));
            String foundControl = sXMLEncoded.substring(startIndex, endIndex + 1);
            String replace = (String)xmlCharacters.get(foundControl);
            if (replace == null) {
                sXMLDecoded.append(sXMLEncoded.substring(startIndex, startIndex + 1));
                index = startIndex + 1;
                continue;
            }
            sXMLDecoded.append(replace);
            index = endIndex + 1;
        }
        return sXMLDecoded.toString();
    }

    static {
        xmlCharacters = new Hashtable();
        xmlCharacters.put("&amp;", "&");
        xmlCharacters.put("&lt;", "<");
        xmlCharacters.put("&gt;", ">");
        xmlCharacters.put("&quot;", "\"");
        xmlCharacters.put("&apos;", "'");
        xmlCharacters.put("&#63;", "?");
        xmlCharacters.put("&#93;", "]");
    }
}

