/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMIntSet;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLStateHandler;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class XMLResponseHandler
extends XMLStateHandler {
    private static Class CLASS = XMLResponseHandler.class;
    protected static final int STATE_RESPONSE = 1;
    private static final int STATE_SETTINGS = 2;
    private static final int STATE_SETTING = 3;
    private static final int STATE_NEXTCALL = 4;
    private static final int STATE_S2 = 5;
    private static final int STATE_INBOX = 6;
    private static final int STATE_SCHEDULE = 7;
    public static final int STATE_LAST = 7;
    private Hashtable settings = null;
    private CMIntSet s2Inbox = null;
    private int nextCall = -1;
    private String camID = null;
    private String currentSettingName;
    private boolean success = false;

    public XMLResponseHandler() {
        this.addStateTransition("response", 0, 1);
        this.addStateTransition("settings", 1, 2);
        this.addStateTransition("setting", 2, 3);
        this.addStateTransition("nextCall", 1, 4);
        this.addStateTransition("s2", 1, 5);
        this.addStateTransition("inbox", 5, 6);
    }

    public Hashtable getSettings() {
        return this.settings;
    }

    public CMIntSet getS2Inbox() {
        return this.s2Inbox;
    }

    public int nextCallInSeconds() {
        return this.nextCall;
    }

    public boolean success() {
        return this.success;
    }

    public String getS2User() {
        return this.camID;
    }

    @Override
    protected void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
        switch (state) {
            case 1: {
                String status = attrs.getValue("status");
                if (status == null) break;
                if (status.equals("success")) {
                    this.success = true;
                    break;
                }
                this.success = false;
                break;
            }
            case 2: {
                this.settings = new Hashtable();
                break;
            }
            case 3: {
                this.currentSettingName = attrs.getValue("name");
                break;
            }
            case 4: {
                try {
                    String nxt = attrs.getValue("seconds");
                    this.nextCall = Integer.parseInt(nxt);
                }
                catch (Exception e) {
                    VM.log(CLASS, 3, e);
                }
                break;
            }
            case 5: {
                this.camID = attrs.getValue("user");
            }
        }
    }

    @Override
    protected void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        switch (state) {
            case 3: {
                if (this.currentSettingName == null) break;
                VM.log(CLASS, 1, this.currentSettingName + " = " + characters);
                this.settings.put(this.currentSettingName, characters);
                break;
            }
            case 6: {
                this.s2Inbox = CMIntSet.fromString(characters);
            }
        }
    }

    @Override
    protected void onStateHandlerInvalidElement(int state, String element) throws SAXParseException {
    }
}

