/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class XMLRunReportHandler
extends XMLResponseHandler {
    private static Class CLASS = XMLRunReportHandler.class;
    private static final int STATE_RENDER = 8;
    private static final int STATE_RENDERID = 9;
    private static final int STATE_LABEL = 10;
    private static final int STATE_RENDERTIME = 11;
    private static final int STATE_SIZE = 12;
    private static final int STATE_CMPATH = 13;
    private static final int STATE_SOURCEPATH = 14;
    private static final int STATE_SOURCECODE = 15;
    private static final int STATE_DESCRIPTION = 16;
    private static final int STATE_INPROGRESS = 17;
    private static final int STATE_INPROGRESS_STATUS = 18;
    private static final int STATE_INPROGRESS_P64GUID = 19;
    private static final int STATE_INPROGRESS_PPS_TRACKING = 20;
    private Render m_render;

    public XMLRunReportHandler() {
        this.addStateTransition("render", 1, 8);
        this.addStateTransition("renderID", 8, 9);
        this.addStateTransition("label", 8, 10);
        this.addStateTransition("renderTime", 8, 11);
        this.addStateTransition("size", 8, 12);
        this.addStateTransition("cmPath", 8, 13);
        this.addStateTransition("sourcePath", 8, 14);
        this.addStateTransition("sourceCode", 8, 15);
        this.addStateTransition("description", 8, 16);
        this.addStateTransition("renderInProgress", 1, 17);
        this.addStateTransition("status", 17, 18);
        this.addStateTransition("pp64guid", 17, 19);
        this.addStateTransition("pps_tracking", 17, 20);
    }

    public Render getRender() {
        return this.m_render;
    }

    @Override
    public void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
        super.onStateHandlerStartState(state, attrs);
        switch (state) {
            case 8: {
                this.m_render = new Render();
            }
        }
    }

    @Override
    public void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        super.onStateHandlerEndState(state, characters);
        switch (state) {
            case 9: {
                this.m_render.renderID = CMStringHelper.parseInteger(characters, -1);
                break;
            }
            case 10: {
                this.m_render.label = characters;
                break;
            }
            case 13: {
                this.m_render.cmPath = characters;
                break;
            }
            case 14: {
                this.m_render.sourcePath = characters;
                break;
            }
            case 11: {
                this.m_render.renderTime = CMStringHelper.parseDateTime(characters);
                break;
            }
            case 12: {
                this.m_render.size = CMStringHelper.parseInteger(characters, -1);
                this.m_render.pageCount = CMStringHelper.parseInteger(characters, -1);
                break;
            }
            case 15: {
                if (this.m_render == null) break;
                this.m_render.sourceCode = CMStringHelper.parseInteger(characters, -1);
                break;
            }
            case 16: {
                this.m_render.description = characters;
                break;
            }
            case 8: {
                if (this.m_render.renderID > 0) break;
                VM.log(CLASS, 2, "invalid render ID: " + this.m_render.renderID);
                this.m_render = null;
                break;
            }
            case 18: {
                if (this.m_render == null) {
                    VM.log(CLASS, 3, "got render status, but no renderID: " + characters);
                    break;
                }
                this.m_render.inProgress.setStatus(characters);
                if (this.m_render.inProgress.getStatus().equals("inProgress") || this.m_render.inProgress.getStatus().equals("notInProgress")) break;
                VM.log(CLASS, 3, "Inalid render status from renderInProgress. Got status: " + characters);
                break;
            }
            case 19: {
                if (this.m_render == null) {
                    VM.log(CLASS, 3, "got p64guid for render in progress, but no renderID: " + characters);
                    break;
                }
                this.m_render.inProgress.setNodeID(characters);
                break;
            }
            case 20: {
                if (this.m_render == null) {
                    VM.log(CLASS, 3, "got render tracking value, but no renderID: " + characters);
                    break;
                }
                this.m_render.inProgress.setTrackingVal(characters);
            }
        }
    }
}

