/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.model.data.Report;
import com.cognos.mobile.xml.XMLResponseHandler;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class XMLSearchHandler
extends XMLResponseHandler {
    private static final int STATE_COUNT = 8;
    private static final int STATE_REPORT = 9;
    private static final int STATE_LABEL = 10;
    private static final int STATE_CMPATH = 11;
    private static final int STATE_SOURCEPATH = 12;
    private Vector m_reports;
    private Report m_currentReport;

    public XMLSearchHandler() {
        this.addStateTransition("count", 1, 8);
        this.addStateTransition("report", 1, 9);
        this.addStateTransition("label", 9, 10);
        this.addStateTransition("cmPath", 9, 11);
        this.addStateTransition("sourcePath", 9, 12);
        this.m_reports = new Vector();
        this.m_currentReport = null;
    }

    public Report[] getReportList() {
        int count = this.m_reports == null ? 0 : this.m_reports.size();
        Report[] list = new Report[count];
        for (int i = 0; i < count; ++i) {
            list[i] = (Report)this.m_reports.elementAt(i);
        }
        return list;
    }

    @Override
    public void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
        super.onStateHandlerStartState(state, attrs);
        switch (state) {
            case 9: {
                this.m_currentReport = new Report();
            }
        }
    }

    @Override
    public void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        super.onStateHandlerEndState(state, characters);
        switch (state) {
            case 8: {
                int count = CMStringHelper.parseInteger(characters, -1);
                if (count < 0) {
                    throw new SAXParseException("invalid count: " + characters, null);
                }
                if (this.m_reports == null) {
                    this.m_reports = new Vector(count);
                    break;
                }
                this.m_reports.ensureCapacity(count);
                break;
            }
            case 10: {
                if (this.m_currentReport == null) break;
                this.m_currentReport.label = characters;
                break;
            }
            case 11: {
                if (this.m_currentReport == null) break;
                this.m_currentReport.cmPath = characters;
                break;
            }
            case 12: {
                if (this.m_currentReport == null) break;
                this.m_currentReport.sourcePath = characters;
                break;
            }
            case 9: {
                if (this.m_currentReport == null) break;
                this.m_reports.addElement(this.m_currentReport);
                this.m_currentReport = null;
            }
        }
    }
}

