/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLStateHandler {
    private static final Class CLASS = XMLStateHandler.class;
    public static final int STATE_START = 0;
    public static final int STATE_ERROR = -1;
    public static final int OPTIONS_DEFAULT = 0;
    public static final int OPTIONS_IGNORE_UNRECOGNIZED_TAGS = 1;
    private static final boolean PRINT_DEBUGGING_OUTPUT = false;
    private final Vector m_transitions = new Vector();
    private final int m_options;
    private boolean whiteSpaceAllowed = false;

    public XMLStateHandler() {
        this(0);
    }

    public XMLStateHandler(int options) {
        this.m_options = options;
    }

    public XMLStateHandler(boolean whiteSpaceAllowed) {
        this(0);
        this.whiteSpaceAllowed = whiteSpaceAllowed;
    }

    protected final int addStateTransition(String element, int startState, int endState) {
        Transition transition = new Transition();
        transition.element = element;
        transition.startState = startState;
        transition.endState = endState;
        this.m_transitions.addElement(transition);
        return this.m_transitions.size();
    }

    public void doParse(IXMLParser xmlParser, InputStream inputStream) throws SAXException, IOException {
        try {
            xmlParser.parse(inputStream, new SaxHandler());
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "parser failure", ex);
            throw new SAXException(ex.toString());
        }
    }

    protected abstract void onStateHandlerStartState(int var1, Attributes var2) throws SAXParseException;

    protected abstract void onStateHandlerEndState(int var1, String var2) throws SAXParseException;

    protected abstract void onStateHandlerInvalidElement(int var1, String var2) throws SAXParseException;

    private static final class Transition {
        public String element;
        public int startState;
        public int endState;

        private Transition() {
        }
    }

    private static final class State {
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_UNRECOGNIZED_TAG = 1;
        public int type;
        public int state;
        public StringBuffer characters;

        public State(int type, int aState) {
            this.type = type;
            this.state = aState;
            this.characters = new StringBuffer();
        }
    }

    private class SaxHandler
    extends DefaultHandler {
        public final Stack m_stateStack = new Stack();

        public SaxHandler() {
            this.m_stateStack.push(new State(0, 0));
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXParseException {
            State topOfStack = (State)this.m_stateStack.peek();
            int currentState = topOfStack == null ? 0 : topOfStack.state;
            if ((XMLStateHandler.this.m_options & 1) == 0 && topOfStack != null && topOfStack.type == 1) {
                currentState = -1;
            }
            int count = XMLStateHandler.this.m_transitions.size();
            for (int i = 0; i < count; ++i) {
                Transition transition = (Transition)XMLStateHandler.this.m_transitions.elementAt(i);
                if (transition.startState != currentState || !transition.element.equals(qName)) continue;
                int newState = transition.endState;
                this.m_stateStack.push(new State(0, newState));
                XMLStateHandler.this.onStateHandlerStartState(newState, attrs);
                return;
            }
            if ((XMLStateHandler.this.m_options & 1) == 0) {
                XMLStateHandler.this.onStateHandlerInvalidElement(currentState, qName);
            }
            this.m_stateStack.push(new State(1, currentState));
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            State state = (State)this.m_stateStack.peek();
            if (state != null) {
                state.characters.append(buf, offset, len);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            State currentState = (State)this.m_stateStack.peek();
            if (currentState != null) {
                this.m_stateStack.pop();
                if (currentState.type == 1) {
                    if ((XMLStateHandler.this.m_options & 1) == 0) {
                        if (XMLStateHandler.this.whiteSpaceAllowed) {
                            XMLStateHandler.this.onStateHandlerEndState(-1, currentState.characters.toString());
                        } else {
                            XMLStateHandler.this.onStateHandlerEndState(-1, currentState.characters.toString().trim());
                        }
                    }
                } else if (XMLStateHandler.this.whiteSpaceAllowed) {
                    XMLStateHandler.this.onStateHandlerEndState(currentState.state, currentState.characters.toString());
                } else {
                    XMLStateHandler.this.onStateHandlerEndState(currentState.state, currentState.characters.toString().trim());
                }
            }
        }
    }
}

