/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.xml;

import com.cognos.mobile.xml.IXMLStreamHost;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLStream
extends DefaultHandler {
    public static final int STATE_START = 0;
    public static final int STATE_ERROR = -1;
    private Stack m_streams = new Stack();

    public final void addStream(IXMLStreamHost host) {
        Stream stream = new Stream();
        stream.host = host;
        stream.states = new Stack();
        stream.transitions = new Vector();
        stream.states.push(new State(0));
        this.m_streams.push(stream);
    }

    public final int addStateTransition(String element, int startState, int endState) {
        Stream stream = this.getCurrentStream();
        Transition transition = new Transition();
        transition.element = element;
        transition.startState = startState;
        transition.endState = endState;
        stream.transitions.addElement(transition);
        return stream.transitions.size();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXParseException {
        Stream stream = this.getCurrentStream();
        int currentState = this.getCurrentState((Stream)stream).state;
        int count = stream.transitions.size();
        for (int i = 0; i < count; ++i) {
            Transition transition = (Transition)stream.transitions.elementAt(i);
            if (transition.startState != currentState || !transition.element.equals(qName)) continue;
            int newState = transition.endState;
            stream.states.push(new State(newState));
            stream.host.onStreamStartState(this, newState, attrs);
            return;
        }
        stream.host.onStreamInvalidElement(this, currentState, qName);
        stream.states.push(new State(-1));
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        Stream stream = this.getCurrentStream();
        State state = this.getCurrentState(stream);
        state.characters.append(buf, offset, len);
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        Stream stream = this.getCurrentStream();
        while (true) {
            State state = this.getCurrentState(stream);
            stream.host.onStreamEndState(this, state.state, state.characters.toString().trim());
            stream.states.pop();
            if (!stream.states.empty() || this.m_streams.empty()) break;
            this.m_streams.pop();
            stream = this.getCurrentStream();
        }
    }

    private Stream getCurrentStream() {
        if (this.m_streams.empty()) {
            return null;
        }
        return (Stream)this.m_streams.peek();
    }

    private State getCurrentState(Stream stream) {
        return (State)stream.states.peek();
    }

    private static final class Transition {
        public String element;
        public int startState;
        public int endState;

        private Transition() {
        }
    }

    private static final class State {
        public int state;
        public StringBuffer characters;

        public State(int aState) {
            this.state = aState;
            this.characters = new StringBuffer();
        }
    }

    private static final class Stream {
        public IXMLStreamHost host;
        public Stack states;
        public Vector transitions;

        private Stream() {
        }
    }
}

