/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.server.configTest;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.mobile.log4j.L4Logger;
import com.cognos.mobile.server.bus.SHIPFLogger;
import com.cognos.mobile.server.configTest.DbConnTask;
import com.cognos.mobile.standardedition.SERes;
import com.cognos.mobile.vm.VM;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class ConfigTest
implements ICnfgTest {
    private static final Class<ConfigTest> CLASS = ConfigTest.class;
    private final String MOB_TAG = "MOB";
    protected static boolean m_useCfgapiEncryption = true;
    private static final String DB_PROVIDERS = "DatabaseProviders";
    private static final String DB_CONN_PREFIX = "Database";
    private static final String DB_DRIVER_PREFIX = "DbDriver";
    private static final String DB_MICROSOFT = "Microsoft";
    private static final String DB_MICROSOFTWINAUTH = "MicrosoftWinAuth";
    private static final String DB_DB2 = "DB2";
    private static final String DB_DB2_TYPE2 = "DB2T2";
    private static final String DB_DB2_TYPE4 = "DB2T4";
    private static final String DB_ORACLE = "Oracle";
    private static final String DB_ORACLEADVANCED = "OracleAdvanced";
    private static final String DB_SYBASE = "Sybase";
    private static final String DB_DERBY = "Derby";
    private static final String DB_INFORMIX = "Informix";
    public static final int OracleDB = 1;
    public static final int MSSQLDB = 2;
    public static final int Db2DB_Type2 = 3;
    public static final int Db2DB_Type4 = 3;
    public static final int OracleAdvancedDB = 4;
    public static final int SybaseDB = 5;
    public static final int DerbyDB = 6;
    public static final int MSSQLWinAuthDB = 7;
    public static final int InformixDB = 8;
    private final String INSTANCE_TAG = "instance";
    private final String INSTANCES_TAG = "instances";
    private final String PARAMETER_TAG = "parameter";
    private final String VALUE_TAG = "value";
    private final String NAME_ATTR = "name";
    private final String CLASS_ATTR = "class";
    private final String CRN_DBMS_APPENDER_CLASS = "mob_database";
    protected static String[] m_testErrMsgString;
    private static Properties m_DBConnProp;
    private List<DbConnTask> m_taskList = null;
    protected static String m_taskLabel;
    protected static String m_taskDesc;

    public boolean initialize(ICCLConfiguration cfgapi, ICnfgFeedback feedback) {
        VM.logger = new SHIPFLogger();
        VM.logger2 = L4Logger.createLogger();
        ArrayList<Element> instanceElementList = new ArrayList<Element>();
        try {
            this.initializeResources(feedback);
            this.initializeMOBParams(cfgapi, instanceElementList, feedback);
        }
        catch (Exception e) {
            return false;
        }
        return this.parseMOBInstances(instanceElementList, feedback);
    }

    public ICnfgTask[] getTasks(String parameter, ICnfgFeedback feedback) {
        ICnfgTask[] ret = null;
        if (this.m_taskList != null) {
            if (this.m_taskList.isEmpty()) {
                feedback.showInformational(m_testErrMsgString[1]);
            } else if (this.isLocalConfigOrEnvironmentNode(parameter)) {
                ret = this.m_taskList.toArray(new ICnfgTask[this.m_taskList.size()]);
            } else {
                StringTokenizer st = new StringTokenizer(parameter, "/");
                if (st.countTokens() >= 3) {
                    for (int ii = 0; ii < 3; ++ii) {
                        st.nextToken();
                    }
                }
                String dbForTesting = st.nextToken();
                ArrayList<DbConnTask> tmpList = new ArrayList<DbConnTask>();
                for (DbConnTask aTask : this.m_taskList) {
                    if (dbForTesting.compareTo(aTask.getDBInstanceName()) != 0) continue;
                    tmpList.add(aTask);
                }
                ret = tmpList.toArray(new ICnfgTask[tmpList.size()]);
            }
        }
        return ret;
    }

    public void terminate(ICnfgFeedback feedback) {
        if (this.m_taskList != null) {
            for (DbConnTask task : this.m_taskList) {
                task.cancel(feedback);
            }
        }
    }

    private void initializeMOBParams(ICCLConfiguration cclConfig, List<Element> instanceElementList, ICnfgFeedback arg1) throws CCLConfigurationException {
        Element configElement;
        try {
            configElement = cclConfig.getValueElement("MOB", m_useCfgapiEncryption);
        }
        catch (CCLConfigurationException e) {
            VM.log(CLASS, (int)3, (String)("Failed to read MOB startup parameters from ICCLConfiguration; error " + e.getMessage()));
            arg1.showError(m_testErrMsgString[0]);
            throw e;
        }
        if (null == configElement) {
            VM.log(CLASS, (int)3, (String)"ICCLConfiguration returned no MOB startup parameters");
            arg1.showError(m_testErrMsgString[0]);
            throw new CCLConfigurationException(9);
        }
        if (null != instanceElementList) {
            for (Object obj : configElement.elements("instances")) {
                Element instancesElement;
                String nameAttr;
                if (!(obj instanceof Element) || null == (nameAttr = (instancesElement = (Element)obj).attributeValue("name")) || !nameAttr.equals("mob_database")) continue;
                for (Object el : instancesElement.elements("instance")) {
                    instanceElementList.add((Element)el);
                }
            }
        }
    }

    private boolean parseMOBInstances(List<Element> instanceElementList, ICnfgFeedback arg1) {
        if (null == instanceElementList) {
            VM.log(CLASS, (int)2, (String)"Logging DB Connection Test: No appenders defined");
            arg1.showWarning(m_testErrMsgString[1]);
            return false;
        }
        this.m_taskList = new ArrayList<DbConnTask>();
        for (Element instanceElement : instanceElementList) {
            String classAttr = instanceElement.attribute("class").getValue();
            String nameAttr = instanceElement.attribute("name").getValue();
            if (null == classAttr || null == nameAttr) continue;
            this.parseJDBCConnProps(instanceElement, this.m_taskList, arg1, nameAttr);
        }
        return true;
    }

    private boolean parseJDBCConnProps(Element dbInstanceElement, List<DbConnTask> taskList, ICnfgFeedback arg1, String dbInstanceName) {
        String dbConnectionString;
        String databaseType = dbInstanceElement.attributeValue("class");
        String serverHost = "";
        String databaseSpecifier = "";
        String dbUser = "";
        String dbPassword = "";
        String dbName = "";
        String dbDriver = "";
        String dbTrustServerCertificate = "";
        int dbType = 0;
        boolean sslEnabled = false;
        DbConnTask connTask = new DbConnTask();
        connTask.setDBInstanceName(dbInstanceName);
        for (Object obj : dbInstanceElement.elements("parameter")) {
            Element dbInstanceParameterElement;
            String nameAttr;
            if (!(obj instanceof Element) || null == (nameAttr = (dbInstanceParameterElement = (Element)obj).attributeValue("name"))) continue;
            Element valueElement = dbInstanceParameterElement.element("value");
            if (nameAttr.equalsIgnoreCase("user")) {
                Element credentialElement = valueElement.element("credential");
                dbUser = credentialElement.elementText("username");
                connTask.setDBUser(dbUser);
                dbPassword = credentialElement.elementText("password");
                connTask.setDBPassword(dbPassword);
                continue;
            }
            if (nameAttr.equalsIgnoreCase("server")) {
                serverHost = valueElement.getText();
                continue;
            }
            if (nameAttr.equalsIgnoreCase("name")) {
                dbName = valueElement.getText();
                continue;
            }
            if (nameAttr.equalsIgnoreCase("specifier")) {
                databaseSpecifier = valueElement.getText();
                continue;
            }
            if (nameAttr.equalsIgnoreCase("servicename")) {
                dbName = valueElement.getText();
                continue;
            }
            if (nameAttr.equalsIgnoreCase("SSLencryptionEnabled")) {
                String enabled = valueElement.getTextTrim();
                if (enabled == null) continue;
                sslEnabled = Boolean.parseBoolean(enabled);
                continue;
            }
            if (!nameAttr.equalsIgnoreCase("advancedProperties")) continue;
            List propertieesElementList = valueElement.elements();
            for (Element instanceElement : propertieesElementList) {
                String propNameAttr = instanceElement.attribute("name").getValue();
                if (null == propNameAttr || !propNameAttr.equalsIgnoreCase("trustServerCertificate")) continue;
                Element propValueElement = instanceElement.element("value");
                dbTrustServerCertificate = propValueElement.getTextTrim();
                boolean trustServerCertificate = false;
                if (dbTrustServerCertificate == null) continue;
                trustServerCertificate = Boolean.parseBoolean(dbTrustServerCertificate);
            }
        }
        connTask.setDBName(dbName);
        dbDriver = m_DBConnProp.getProperty(DB_DRIVER_PREFIX + databaseType);
        connTask.setDBDriver(dbDriver);
        if (null == dbDriver) {
            VM.log(CLASS, (int)2, (String)(databaseType + " driver listing is missing "));
            arg1.showWarning(m_testErrMsgString[2] + databaseType);
            return false;
        }
        VM.log(CLASS, (int)0, (String)("Setting DB Driver to: " + dbDriver));
        if (databaseType.equalsIgnoreCase("db2")) {
            if (serverHost.length() == 0) {
                dbConnectionString = m_DBConnProp.getProperty("DatabaseDB2T2");
                dbType = 3;
            } else {
                dbConnectionString = m_DBConnProp.getProperty("DatabaseDB2T4");
                dbType = 3;
            }
        } else {
            dbConnectionString = m_DBConnProp.getProperty(DB_CONN_PREFIX + databaseType);
        }
        if (null == dbConnectionString) {
            VM.log(CLASS, (int)2, (String)(databaseType + " connection string listing is missing "));
            arg1.showWarning(m_testErrMsgString[3] + databaseType);
            return false;
        }
        StringTokenizer st = new StringTokenizer(dbConnectionString, "{}", false);
        int noOfTokens = st.countTokens();
        String dbConnectionStringUpd = st.nextToken();
        st.nextToken();
        VM.log(CLASS, (int)2, (String)("ConfigTest received databaseType: " + databaseType + " dbConnectionString: " + dbConnectionString));
        if (databaseType.equalsIgnoreCase("microsoft") && noOfTokens == 4) {
            dbType = 2;
            if (serverHost.length() == 0) {
                VM.log(CLASS, (int)2, (String)"ConfigTest failed to read the database server and port from CFGAPI");
                arg1.showWarning(m_testErrMsgString[4]);
                return false;
            }
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
            connTask.setTrustServerCertificate(dbTrustServerCertificate);
        } else if (databaseType.equalsIgnoreCase("microsoftwinauth") && noOfTokens == 5) {
            dbType = 7;
            if (serverHost.length() == 0) {
                VM.log(CLASS, (int)2, (String)"ConfigTest failed to read the database server and port from CFGAPI");
                arg1.showWarning(m_testErrMsgString[4]);
                return false;
            }
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
            st.nextToken();
            dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
            connTask.setTrustServerCertificate(dbTrustServerCertificate);
        } else if (databaseType.equalsIgnoreCase("oracle") && noOfTokens == 4) {
            dbType = 1;
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
        } else if (databaseType.equalsIgnoreCase("oracleadvanced") && noOfTokens == 2) {
            dbType = 4;
            dbConnectionStringUpd = dbConnectionStringUpd + databaseSpecifier;
        } else if (databaseType.equalsIgnoreCase("sybase") && noOfTokens == 4) {
            dbType = 5;
            if (serverHost.length() == 0) {
                VM.log(CLASS, (int)2, (String)"ConfigTest failed to read the database server and port from CFGAPI");
                arg1.showWarning(m_testErrMsgString[4]);
                return false;
            }
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
        } else if (databaseType.equalsIgnoreCase("derby") && noOfTokens == 4) {
            dbType = 6;
            if (serverHost.length() == 0) {
                VM.log(CLASS, (int)2, (String)"ConfigTest failed to read the database server and port from CFGAPI");
                arg1.showWarning(m_testErrMsgString[4]);
                return false;
            }
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
        } else if (databaseType.equalsIgnoreCase("informix") && noOfTokens == 5) {
            dbType = 8;
            if (serverHost.length() == 0) {
                VM.log(CLASS, (int)2, (String)"ConfigTest failed to read the database server and port from CFGAPI");
                arg1.showWarning(m_testErrMsgString[4]);
                return false;
            }
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
        } else if (dbType == 3 && noOfTokens == 3) {
            dbConnectionStringUpd = dbConnectionStringUpd + dbName + st.nextToken();
        } else if (dbType == 3 && noOfTokens == 5) {
            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + dbName;
            st.nextToken();
            dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
        } else {
            VM.log(CLASS, (int)2, (String)("ConfigTest has corrupted entry for " + databaseType + "type:" + dbType + dbConnectionString + noOfTokens + " connection string"));
            return false;
        }
        if (sslEnabled) {
            if (databaseType.equalsIgnoreCase(DB_DB2)) {
                dbConnectionStringUpd = dbConnectionStringUpd + "sslConnection=true;";
            } else if (databaseType.equalsIgnoreCase(DB_MICROSOFT)) {
                dbConnectionStringUpd = dbConnectionStringUpd + ";encrypt=true;trustServerCertificate=false";
            } else if (databaseType.equalsIgnoreCase(DB_MICROSOFTWINAUTH)) {
                dbConnectionStringUpd = dbConnectionStringUpd + ";encrypt=true;trustServerCertificate=false";
            } else if (databaseType.equalsIgnoreCase(DB_INFORMIX)) {
                dbConnectionStringUpd = dbConnectionStringUpd + "sslConnection=true;";
            }
        }
        connTask.setDBType(dbType);
        connTask.setDBURL(dbConnectionStringUpd);
        taskList.add(connTask);
        return true;
    }

    private void initializeResources(ICnfgFeedback feedback) throws Exception {
        SERes.initialize((String[])new String[]{"../webapps/p2pd/WEB-INF/classes/mobile", "../shared/res/shared"});
        m_testErrMsgString = new String[7];
        try {
            ConfigTest.m_testErrMsgString[0] = SERes.singleton.getString("2100", Locale.getDefault());
            ConfigTest.m_testErrMsgString[1] = SERes.singleton.getString("2101", Locale.getDefault());
            ConfigTest.m_testErrMsgString[2] = SERes.singleton.getString("2102", Locale.getDefault());
            ConfigTest.m_testErrMsgString[3] = SERes.singleton.getString("2103", Locale.getDefault());
            ConfigTest.m_testErrMsgString[4] = SERes.singleton.getString("2104", Locale.getDefault());
            ConfigTest.m_testErrMsgString[5] = SERes.singleton.getString("2105", Locale.getDefault());
            ConfigTest.m_testErrMsgString[6] = SERes.singleton.getString("2106", Locale.getDefault());
            m_taskLabel = SERes.singleton.getString("CONFIGTEST_LABEL", Locale.getDefault());
            m_taskDesc = SERes.singleton.getString("CONFIGTEST_DESC", Locale.getDefault());
        }
        catch (Exception e) {
            feedback.showError(e.getMessage());
            throw e;
        }
    }

    private boolean isLocalConfigOrEnvironmentNode(String parameter) {
        return null == parameter || parameter.length() == 0 || parameter.endsWith("MOB") || -1 == parameter.indexOf("MOB");
    }

    static {
        m_DBConnProp = null;
        if (null == m_DBConnProp) {
            m_DBConnProp = new Properties();
        }
        m_DBConnProp.setProperty(DB_PROVIDERS, "Microsoft,MicrosoftWinAuth,Oracle,DB2,OracleAdvanced,Sybase,Derby");
        m_DBConnProp.setProperty("DatabaseMicrosoft", "jdbc:sqlserver://{1};databaseName={2}");
        m_DBConnProp.setProperty("DatabaseMicrosoftWinAuth", "jdbc:sqlserver://{1};databaseName={2};integratedSecurity=true");
        m_DBConnProp.setProperty("DatabaseDB2T2", "jdbc:db2:{1}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;");
        m_DBConnProp.setProperty("DatabaseDB2T4", "jdbc:db2://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;");
        m_DBConnProp.setProperty("DatabaseOracle", "jdbc:oracle:thin:@{1}:{2}");
        m_DBConnProp.setProperty("DatabaseOracleAdvanced", "jdbc:oracle:thin:@{specifier}");
        m_DBConnProp.setProperty("DatabaseSybase", "jdbc:sybase:Tds:{server}/{databaseName}");
        m_DBConnProp.setProperty("DatabaseDerby", "jdbc:derby://{1}/{2}");
        m_DBConnProp.setProperty("DatabaseInformix", "jdbc:ids://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;");
        m_DBConnProp.setProperty("DbDriverMicrosoft", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        m_DBConnProp.setProperty("DbDriverMicrosoftWinAuth", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        m_DBConnProp.setProperty("DbDriverOracle", "oracle.jdbc.driver.OracleDriver");
        m_DBConnProp.setProperty("DbDriverDB2", "com.ibm.db2.jcc.DB2Driver");
        m_DBConnProp.setProperty("DbDriverOracleAdvanced", "oracle.jdbc.driver.OracleDriver");
        m_DBConnProp.setProperty("DbDriverSybase", "com.sybase.jdbc2.jdbc.SybDriver");
        m_DBConnProp.setProperty("DbDriverDerby", "org.apache.derby.jdbc.EmbeddedDriver");
        m_DBConnProp.setProperty("DbDriverInformix", "com.ibm.db2.jcc.DB2Driver");
    }
}

