/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.server.configTest;

import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.cognos.mobile.server.configTest.ConfigTest;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DbConnTask
implements ICnfgTask {
    private static final Class<DbConnTask> CLASS = DbConnTask.class;
    private String m_dbUser = "";
    private char[] m_dbPassword = null;
    private String m_dbName = "";
    private String m_dbDriver = "";
    private boolean m_driverLoaded = false;
    private int m_dbType = 0;
    private String m_dbURL = "";
    private String m_dbInstanceName = "";
    private String m_dbTrustServerCertificate = "";
    private int m_status;
    protected Connection m_dbConn = null;

    private String getDBPassword() {
        return this.m_dbPassword == null ? "" : new String(this.m_dbPassword);
    }

    public String getDBInstanceName() {
        return this.m_dbInstanceName;
    }

    public String getDBURL() {
        return this.m_dbURL;
    }

    public void setDBUser(String param) {
        this.m_dbUser = param;
    }

    public void setDBPassword(String param) {
        if (param != null) {
            this.m_dbPassword = param.toCharArray();
        }
    }

    public void setDBName(String param) {
        this.m_dbName = param;
    }

    public void setDBInstanceName(String param) {
        this.m_dbInstanceName = param;
    }

    public void setDBDriver(String param) {
        this.m_dbDriver = param;
    }

    public void setDBType(int param) {
        this.m_dbType = param;
    }

    public void setDBURL(String param) {
        this.m_dbURL = param;
    }

    public String getLabel() {
        return ConfigTest.m_taskLabel;
    }

    public String getDescription() {
        return ConfigTest.m_taskDesc;
    }

    public void setTrustServerCertificate(String param) {
        this.m_dbTrustServerCertificate = param;
    }

    public boolean isMandatory() {
        return true;
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public boolean run(Object[] arg0, ICnfgFeedback arg1) throws Exception {
        if (this.m_dbURL.length() == 0) {
            throw new Exception("URL not set");
        }
        if (this.m_dbUser.length() == 0 && this.m_dbType != 7 && this.m_dbType != 6) {
            throw new Exception(ConfigTest.m_testErrMsgString[6] + this.m_dbURL);
        }
        if (this.m_dbType == 0) {
            throw new Exception("Database type not set");
        }
        try {
            this.getConnection();
        }
        catch (Exception e) {
            arg1.showError(ConfigTest.m_testErrMsgString[6] + this.m_dbURL);
            if (e.getMessage().compareToIgnoreCase("no suitable driver") == 0) {
                throw new Exception(ConfigTest.m_testErrMsgString[2] + this.m_dbURL);
            }
            return false;
        }
        if (null == this.m_dbConn) {
            arg1.showError(ConfigTest.m_testErrMsgString[6] + this.m_dbURL);
            return false;
        }
        this.closeConnection();
        return true;
    }

    public void cancel(ICnfgFeedback arg0) {
        this.clearPassword();
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    private Connection getConnection() throws SQLException {
        if (!this.m_driverLoaded) {
            this.setDriver(this.m_dbDriver);
        }
        if (null == this.m_dbConn) {
            if (this.m_dbUser != null && this.m_dbUser.length() > 0) {
                if (this.m_dbTrustServerCertificate != null && this.m_dbTrustServerCertificate != "") {
                    Properties props = new Properties();
                    props.setProperty("trustServerCertificate", this.m_dbTrustServerCertificate);
                    props.put("user", this.m_dbUser);
                    props.put("password", this.getDBPassword());
                    this.m_dbConn = DriverManager.getConnection(this.m_dbURL, props);
                } else {
                    this.m_dbConn = DriverManager.getConnection(this.m_dbURL, this.m_dbUser, this.getDBPassword());
                }
                this.clearPassword();
            } else {
                this.m_dbConn = DriverManager.getConnection(this.m_dbURL);
            }
        }
        if (null == this.m_dbConn) {
            return this.m_dbConn;
        }
        if (5 == this.m_dbType && this.m_dbConn.getCatalog().compareTo(this.m_dbName) != 0) {
            try {
                this.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_dbConn = null;
        }
        return this.m_dbConn;
    }

    private void setDriver(String driverClass) {
        try {
            Class.forName(driverClass);
            this.m_driverLoaded = true;
        }
        catch (Exception e) {
            VM.log(CLASS, (int)3, (String)("Failed to load driver " + driverClass), (Throwable)e);
        }
    }

    private void closeConnection() throws Exception {
        try {
            if (this.m_dbConn != null && !this.m_dbConn.isClosed()) {
                this.m_dbConn.close();
                this.m_dbConn = null;
            }
        }
        catch (SQLException e) {
            VM.log(CLASS, (int)3, (String)"Error closing connection ", (Throwable)e);
            throw e;
        }
    }

    private void clearPassword() {
        if (this.m_dbPassword != null) {
            for (int i = 0; i < this.m_dbPassword.length; ++i) {
                this.m_dbPassword[i] = '\u0000';
            }
            this.m_dbPassword = null;
        }
    }
}

