/*
 * Decompiled with CFR 0.152.
 */
package com.avs.openviz3.cognos;

import com.avs.openviz3.chart.ChartTypeEnum;
import com.avs.openviz3.chart.CurveSmoothingAlgorithmEnum;
import com.avs.openviz3.chart.ILabelGroupSceneNode;
import com.avs.openviz3.chart.ILabelLayout;
import com.avs.openviz3.chart.ILabelProperties;
import com.avs.openviz3.chart.ILineSegmentShapes;
import com.avs.openviz3.chart.LabelFittingEnum;
import com.avs.openviz3.chart.LineAreaChart;
import com.avs.openviz3.chart.LineAreaChartPropertyEnum;
import com.avs.openviz3.chart.LineAreaSeriesPropertyEnum;
import com.avs.openviz3.chart.RectilinearCellSizeEnum;
import com.avs.openviz3.chart.SeriesAxisMapSource;
import com.avs.openviz3.chart.StaircaseStyleEnum;
import com.avs.openviz3.chart.ValueAxisMapSource;
import com.avs.openviz3.cognos.LineAreaSegmentChartPropertyEnum;
import com.avs.openviz3.cognos.LineAreaSegmentSeriesPropertyEnum;
import com.avs.openviz3.fw.Array;
import com.avs.openviz3.fw.ArrayDouble;
import com.avs.openviz3.fw.ArrayInt;
import com.avs.openviz3.fw.ArrayPointFloat3;
import com.avs.openviz3.fw.AxisOrderEnum;
import com.avs.openviz3.fw.Dimensions;
import com.avs.openviz3.fw.LabelFilteringEnum;
import com.avs.openviz3.fw.NullMask;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.attribute.AttributeList;
import com.avs.openviz3.fw.attribute.IAttribute;
import com.avs.openviz3.fw.base.ArrayResult;
import com.avs.openviz3.fw.base.AxisMapSourceProxy;
import com.avs.openviz3.fw.base.BoundingBox;
import com.avs.openviz3.fw.base.ComponentException;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.ComponentSceneNode;
import com.avs.openviz3.fw.base.ExceptionTypeEnum;
import com.avs.openviz3.fw.base.FieldSource;
import com.avs.openviz3.fw.base.FieldSourceProxy;
import com.avs.openviz3.fw.base.GroupSceneNode;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.IChartAttributes;
import com.avs.openviz3.fw.base.IChartComponent;
import com.avs.openviz3.fw.base.IComponent;
import com.avs.openviz3.fw.base.ICurrencyFormat;
import com.avs.openviz3.fw.base.IDataSinkComponent;
import com.avs.openviz3.fw.base.IDataSource;
import com.avs.openviz3.fw.base.IDataSourceComponent;
import com.avs.openviz3.fw.base.IDataSourceProxy;
import com.avs.openviz3.fw.base.IDispatcher;
import com.avs.openviz3.fw.base.IDropShadowAttributes;
import com.avs.openviz3.fw.base.IFieldSource;
import com.avs.openviz3.fw.base.IGlyphAttributes210;
import com.avs.openviz3.fw.base.IGroupSceneNode;
import com.avs.openviz3.fw.base.ILineAttributes;
import com.avs.openviz3.fw.base.IMaterialAttributes;
import com.avs.openviz3.fw.base.INumberFormat;
import com.avs.openviz3.fw.base.IPointAttributes;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISceneNodeAttributes;
import com.avs.openviz3.fw.base.ISimpleDispatched;
import com.avs.openviz3.fw.base.ISurfaceAttributes;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributes;
import com.avs.openviz3.fw.base.ITextAttributes;
import com.avs.openviz3.fw.base.SceneNodeAttributesPropertyEnum;
import com.avs.openviz3.fw.base.SimpleDispatcher;
import com.avs.openviz3.fw.base.TraverserBase;
import com.avs.openviz3.fw.base.TraverserResultEnum;
import com.avs.openviz3.fw.curvesmoothing.CurveSmoothingAlgorithmFactory;
import com.avs.openviz3.fw.curvesmoothing.Result;
import com.avs.openviz3.fw.field.DataArray;
import com.avs.openviz3.fw.field.DataArrayAdapter;
import com.avs.openviz3.fw.field.FieldAdapter;
import com.avs.openviz3.fw.field.IAxisMap;
import com.avs.openviz3.fw.field.IDataArray;
import com.avs.openviz3.fw.field.IDataArrayCollection;
import com.avs.openviz3.fw.field.IField;
import com.avs.openviz3.fw.field.IMesh;
import com.avs.openviz3.fw.field.MeshTypeEnum;
import com.avs.openviz3.fw.field.RectilinearField;
import com.avs.openviz3.fw.util.Common;
import com.avs.openviz3.layout.CombineAxisMaps;
import com.avs.openviz3.viewer.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class LineAreaSegmentChart
extends ComponentSceneNode
implements ComponentExceptionListener,
ISimpleDispatched,
IChartComponent {
    public static final int E_COLORMAP_ERROR = 1;
    private static final long serialVersionUID = -6718027538774479993L;
    private static final AxisOrderEnum DEFAULT_AXIS_ORDER = AxisOrderEnum.XYZ;
    private static final double DEFAULT_CROSS_OVER_VALUE = 0.0;
    private static final CurveSmoothingAlgorithmEnum DEFAULT_CURVESMOOTHING_ALGORITHM = CurveSmoothingAlgorithmEnum.NONE;
    private static final double DEFAULT_DEPTH_OFFSET = 0.0;
    private static final double DEFAULT_DEPTH_SCALE = 0.5;
    private static final double DEFAULT_GLYPH_SCALE_FACTOR = 1.0;
    private static final boolean DEFAULT_IGNORE_NULL = false;
    private static final int DEFAULT_MAX_SAMPLES = 2000;
    private static final int DEFAULT_RENDER_QUALITY = 3;
    private static final boolean DEFAULT_SHOW_AREA = true;
    private static final boolean DEFAULT_SHOW_BORDER = false;
    private static final boolean DEFAULT_SHOW_GLYPHS = false;
    private static final boolean DEFAULT_SHOW_LINES = true;
    private static final StaircaseStyleEnum DEFAULT_STAIRCASE_STYLE = StaircaseStyleEnum.NONE;
    private static final ChartTypeEnum DEFAULT_CHART_TYPE = ChartTypeEnum.OVERLAP;
    private ArrayList<LineSegmentGroup> lineSegments = new ArrayList();
    private ArrayList<AreaSegmentGroup> areaSegments = new ArrayList();
    private PointsAndLabels pointsAndLabels = new PointsAndLabels(this);
    private AreaSegmentGroup area = new AreaSegmentGroup(this);
    private boolean useSegmentedArea = true;
    private boolean numOfSeriesChanged = true;
    private GroupSceneNode linesGroup;
    private GroupSceneNode areasGroup;
    private GroupSceneNode pointsGroup;
    private ArrayList<LineAreaSegmentSeries> theSeries;
    private AxisOrderEnum axisOrder;
    private Object crossOverValueAsObject;
    private CurveSmoothingAlgorithmEnum curveSmoothingAlgorithm;
    private double depthOffset;
    private double depthScale;
    private double glyphScaleFactor;
    private boolean ignoreNull;
    private String imageMapNullString;
    private String imageMapTemplate;
    private FieldSourceProxy inputFieldProxy;
    private AxisMapSourceProxy inputValueAxisMapProxy;
    private int maxSamples;
    private boolean generateLineSegmentImageMapAreas = true;
    SeriesAxisMapSource outputSeriesAxisMap;
    ValueAxisMapSource outputValueAxisMap;
    private CombineAxisMaps outputCombineAxisMaps;
    private int renderQuality;
    private boolean showArea;
    private boolean showBorder;
    private boolean showGlyphs;
    private boolean showLines;
    private StaircaseStyleEnum staircaseStyle;
    private ChartTypeEnum type;
    private static final String _RELEASE_INFO = "OV31/64164";
    private static final String COPR = "Copyright 1997-2009 AVS";
    private ArrayList<double[]> yControlPoints = new ArrayList();
    private ArrayList<NullMask> yNullMasks = new ArrayList();
    private double[] xSplineCoords;
    private ArrayList<double[]> seriesYSplineCoords;
    private ArrayList<NullMask> seriesYSplineNullMasks;
    private int nPartsPerControlPoint;
    private ArrayList<FieldSource> fieldSources = new ArrayList();
    private LineAreaChart seriesAxisMapChart = null;
    double cellDepth;

    public LineAreaSegmentChart() {
        this("LineAreaSegmentChart");
    }

    public LineAreaSegmentChart(String string) {
        super(string);
        this.linesGroup = new GroupSceneNode();
        this.areasGroup = new GroupSceneNode();
        this.pointsGroup = new GroupSceneNode();
        this.addChild((ISceneNode)this.areasGroup);
        this.addChild((ISceneNode)this.linesGroup);
        this.addChild((ISceneNode)this.pointsGroup);
        this.theSeries = new ArrayList();
        this.outputSeriesAxisMap = new SeriesAxisMapSource((IDataSourceComponent)this);
        this._addOutputDataSource((IDataSource)this.outputSeriesAxisMap);
        this.outputValueAxisMap = new ValueAxisMapSource((IDataSourceComponent)this);
        this._addOutputDataSource((IDataSource)this.outputValueAxisMap);
        this.outputCombineAxisMaps = new CombineAxisMaps();
        this.setAxisOrder(DEFAULT_AXIS_ORDER);
        this.setCrossOverValueAsObject(new Double(0.0));
        this.setCurveSmoothingAlgorithm(DEFAULT_CURVESMOOTHING_ALGORITHM);
        this.setDepthOffset(0.0);
        this.setDepthScale(0.5);
        this.setGlyphScaleFactor(1.0);
        this.setIgnoreNull(false);
        this.setMaxSamples(2000);
        this.setRenderQuality(3);
        this.setShowArea(true);
        this.setShowBorder(false);
        this.setShowGlyphs(false);
        this.setShowLines(true);
        this.setStaircaseStyle(DEFAULT_STAIRCASE_STYLE);
        this.setType(DEFAULT_CHART_TYPE);
        this.inputFieldProxy = new FieldSourceProxy((IDataSinkComponent)this, "inputField");
        this._addInputDataSource((IDataSourceProxy)this.inputFieldProxy);
        this.inputValueAxisMapProxy = new AxisMapSourceProxy((IDataSinkComponent)this, "inputValueAxisMap");
        this._addInputDataSource((IDataSourceProxy)this.inputValueAxisMapProxy);
        this._setDispatcher((IDispatcher)new SimpleDispatcher((ISimpleDispatched)this));
        this.area.setName("SingleAreaChart");
        this.area.addComponentExceptionListener(this);
        this.pointsAndLabels.addComponentExceptionListener(this);
        this.cellDepth = 1.0;
    }

    public String getReleaseInfo() {
        return _RELEASE_INFO;
    }

    private void allocSeriesToChart(LineAreaChart lineAreaChart, ArrayList<LineAreaSegmentSeries> arrayList) {
        int n;
        int n2;
        int n3 = arrayList.size();
        int n4 = n3 - (n2 = lineAreaChart.getNumSeries());
        if (n4 > 0) {
            for (n = 0; n < n4; ++n) {
                lineAreaChart.newSeries(0);
            }
        } else {
            for (n = n3; n < n2; ++n) {
                lineAreaChart.removeSeries(n3);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            LineAreaChart.LineAreaSeries lineAreaSeries = lineAreaChart.getSeries(n);
            lineAreaSeries.setValueIndex(arrayList.get(n).getValueIndex());
        }
    }

    private void allocFieldSource(int n) {
        block3: {
            int n2;
            int n3;
            block2: {
                n3 = this.fieldSources.size();
                n2 = n - n3;
                if (n2 <= 0) break block2;
                for (int i = 0; i < n2; ++i) {
                    String string = "outputField#" + i;
                    FieldSource fieldSource = new FieldSource((IDataSourceComponent)this, string);
                    this._addOutputDataSource((IDataSource)fieldSource);
                    this.fieldSources.add(fieldSource);
                }
                break block3;
            }
            if (n2 >= 0) break block3;
            for (int i = n; i < n3; ++i) {
                this.fieldSources.get(i).setField(null);
            }
        }
    }

    private <T extends SegmentGroup> void allocLineAreaCharts(int n, ArrayList<T> arrayList, ChartFactory<T> chartFactory) {
        int n2;
        int n3 = arrayList.size();
        int n4 = n - n3;
        if (n4 > 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                SegmentGroup segmentGroup = (SegmentGroup)((Object)chartFactory.newChart(this));
                segmentGroup.addComponentExceptionListener(this);
                arrayList.add((T)((Object)segmentGroup));
                this.allocSeriesToChart(segmentGroup, this.theSeries);
            }
        } else if (n4 < 0) {
            for (n2 = n; n2 < n3; ++n2) {
                ((SegmentGroup)((Object)arrayList.get(n2))).resetProperty(LineAreaChartPropertyEnum.INPUT_FIELD);
                arrayList.remove(n2);
            }
        }
        if (this.numOfSeriesChanged) {
            n3 = arrayList.size() < n3 ? arrayList.size() : n3;
            for (n2 = 0; n2 < n3; ++n2) {
                this.allocSeriesToChart((LineAreaChart)arrayList.get(n2), this.theSeries);
            }
        }
        if (n4 != 0) {
            for (n2 = 0; n2 < n; ++n2) {
                ((SegmentGroup)((Object)arrayList.get(n2))).setSegmentIndex(n2, n);
            }
        }
    }

    public void connectInputField(IFieldSource iFieldSource) {
        this.inputFieldProxy.connect(iFieldSource);
        this.inputFieldProxy.setDirty(true);
    }

    public ILineSegmentGroup getLineSegmentGroup(int n) {
        this.performUpdateIfNeeded();
        if (n < 0 || n >= this.lineSegments.size()) {
            throw new IllegalArgumentException("segmentIndex out of range.");
        }
        return this.lineSegments.get(n);
    }

    public IAreaSegmentGroup getAreaSegmentGroup(int n) {
        this.performUpdateIfNeeded();
        if (this.isUseSegmentedArea()) {
            if (n < 0 || n >= this.areaSegments.size()) {
                throw new IllegalArgumentException("segmentIndex out of range.");
            }
            return this.areaSegments.get(n);
        }
        return this.area;
    }

    public int getNumLineSegments() {
        return this._getNumOfSegments();
    }

    public int getNumAreaSegments() {
        return this.isUseSegmentedArea() ? this._getNumOfSegments() : 1;
    }

    public IPoints getPoints() {
        this.performUpdateIfNeeded();
        return this.pointsAndLabels;
    }

    public IAttributeSceneNode getLabels() {
        return this.pointsAndLabels;
    }

    public ILabelProperties getLabelProperties() {
        return this.pointsAndLabels.getLabelProperties();
    }

    public ICurrencyFormat getCurrencyFormat() {
        return this.pointsAndLabels.getCurrencyFormat();
    }

    public INumberFormat getNumberFormat() {
        return this.pointsAndLabels.getNumberFormat();
    }

    private PointsAndLabels getPointsAndLabels() {
        this.performUpdateIfNeeded();
        return this.pointsAndLabels;
    }

    public LineAreaSegmentSeries newSeries(int n) {
        LineAreaSegmentSeries lineAreaSegmentSeries = new LineAreaSegmentSeries(new Integer(n));
        this.theSeries.add(lineAreaSegmentSeries);
        this.numOfSeriesChanged = true;
        this.sendUpdateNeeded();
        return lineAreaSegmentSeries;
    }

    public LineAreaSegmentSeries getSeries(int n) {
        if (n < 0 || n >= this.theSeries.size()) {
            throw new IllegalArgumentException("index must be >= 0 and less than the number of series.");
        }
        return this.theSeries.get(n);
    }

    public void removeSeries(int n) {
        this.theSeries.remove(n);
        this.numOfSeriesChanged = true;
        this.sendUpdateNeeded();
    }

    public void freeAllSeries() {
        this.theSeries.clear();
        this.numOfSeriesChanged = true;
        this.sendUpdateNeeded();
    }

    public int getNumSeries() {
        return this.theSeries.size();
    }

    public void setAxisOrder(AxisOrderEnum axisOrderEnum) {
        this.axisOrder = axisOrderEnum;
        this.sendUpdateNeeded();
    }

    public AxisOrderEnum getAxisOrder() {
        return this.axisOrder;
    }

    public double getDepthOffset() {
        return this.depthOffset;
    }

    public void setDepthOffset(double d) {
        this.depthOffset = d;
        this.sendUpdateNeeded();
    }

    public Object getCrossOverValueAsObject() {
        return this.crossOverValueAsObject;
    }

    public void setCrossOverValueAsObject(Object object) {
        this.crossOverValueAsObject = object;
        this.sendUpdateNeeded();
    }

    public double getDepthScale() {
        return this.depthScale;
    }

    public void setDepthScale(double d) {
        this.depthScale = d;
        this.sendUpdateNeeded();
    }

    public double getGlyphScaleFactor() {
        return this.glyphScaleFactor;
    }

    public void setGlyphScaleFactor(double d) {
        this.glyphScaleFactor = d;
        this.sendUpdateNeeded();
    }

    public boolean getIgnoreNull() {
        return this.ignoreNull;
    }

    public void setIgnoreNull(boolean bl) {
        this.ignoreNull = bl;
        this.sendUpdateNeeded();
    }

    public String getImageMapNullString() {
        return this.imageMapNullString;
    }

    public void setImageMapNullString(String string) {
        this.imageMapNullString = string;
        this.sendUpdateNeeded();
    }

    public String getImageMapTemplate() {
        return this.imageMapTemplate;
    }

    public void setImageMapTemplate(String string) {
        this.imageMapTemplate = string;
        this.sendUpdateNeeded();
    }

    public void setInputValueAxisMap(IAxisMapSource iAxisMapSource) {
        this.inputValueAxisMapProxy.setSource(iAxisMapSource);
        this.inputValueAxisMapProxy.setDirty(true);
        this.sendUpdateNeeded();
    }

    public void connectInputValueAxisMap(IAxisMapSource iAxisMapSource) {
        this.inputValueAxisMapProxy.connect(iAxisMapSource);
        this.inputValueAxisMapProxy.setDirty(true);
        this.sendUpdateNeeded();
    }

    public int getMaxSamples() {
        return this.maxSamples;
    }

    public void setMaxSamples(int n) {
        this.maxSamples = n;
        this.sendUpdateNeeded();
    }

    public boolean getGenerateLineSegmentImageMapAreas() {
        return this.generateLineSegmentImageMapAreas;
    }

    public void setGenerateLineSegmentImageMapAreas(boolean bl) {
        this.generateLineSegmentImageMapAreas = bl;
        this.sendUpdateNeeded();
    }

    public IAxisMapSource getOutputSeriesAxisMap() {
        return this.outputSeriesAxisMap;
    }

    public IAxisMapSource getOutputValueAxisMap() {
        return this.outputValueAxisMap;
    }

    public void setRenderQuality(int n) {
        this.renderQuality = n;
        this.sendUpdateNeeded();
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public boolean getShowArea() {
        return this.showArea;
    }

    public void setShowArea(boolean bl) {
        this.showArea = bl;
        this.sendUpdateNeeded();
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.sendUpdateNeeded();
    }

    public boolean getShowGlyphs() {
        return this.showGlyphs;
    }

    public void setShowGlyphs(boolean bl) {
        this.showGlyphs = bl;
        this.sendUpdateNeeded();
    }

    public boolean getShowLines() {
        return this.showLines;
    }

    public void setShowLines(boolean bl) {
        this.showLines = bl;
        this.sendUpdateNeeded();
    }

    public StaircaseStyleEnum getStaircaseStyle() {
        return this.staircaseStyle;
    }

    public void setStaircaseStyle(StaircaseStyleEnum staircaseStyleEnum) {
        this.staircaseStyle = staircaseStyleEnum;
        this.sendUpdateNeeded();
    }

    public CurveSmoothingAlgorithmEnum getCurveSmoothingAlgorithm() {
        return this.curveSmoothingAlgorithm;
    }

    public void setCurveSmoothingAlgorithm(CurveSmoothingAlgorithmEnum curveSmoothingAlgorithmEnum) {
        this.curveSmoothingAlgorithm = curveSmoothingAlgorithmEnum;
        this.sendUpdateNeeded();
    }

    public ChartTypeEnum getType() {
        return this.type;
    }

    public void setType(ChartTypeEnum chartTypeEnum) {
        this.type = chartTypeEnum;
        this.sendUpdateNeeded();
    }

    public void setUseSegmentedArea(boolean bl) {
        this.useSegmentedArea = bl;
        this.sendUpdateNeeded();
    }

    public boolean isUseSegmentedArea() {
        return this.useSegmentedArea;
    }

    private int _getNumOfSegments() {
        IDataArray iDataArray;
        IMesh iMesh;
        IField iField;
        int n = 0;
        if (this.inputFieldProxy.isConnected() && (iField = this.inputFieldProxy.getSource().getField()) != null && (iMesh = iField.getMesh()) != null && (iDataArray = iMesh.getCoordinates()) != null) {
            n = iDataArray.getNumValues() - 1;
        }
        return n;
    }

    private void allocLineAreaCharts() {
        if (this.inputFieldProxy.isDirty() || this.numOfSeriesChanged) {
            int n = this._getNumOfSegments();
            this.allocLineAreaCharts(n, this.lineSegments, new ChartFactory<LineSegmentGroup>(){

                @Override
                public LineSegmentGroup newChart(LineAreaSegmentChart lineAreaSegmentChart) {
                    return new LineSegmentGroup(lineAreaSegmentChart);
                }
            });
            this.allocLineAreaCharts(n, this.areaSegments, new ChartFactory<AreaSegmentGroup>(){

                @Override
                public AreaSegmentGroup newChart(LineAreaSegmentChart lineAreaSegmentChart) {
                    return new AreaSegmentGroup(lineAreaSegmentChart);
                }
            });
            this.allocFieldSource(n);
        }
        if (this.numOfSeriesChanged) {
            this.allocSeriesToChart(this.area, this.theSeries);
            this.allocSeriesToChart(this.pointsAndLabels, this.theSeries);
        }
        this.numOfSeriesChanged = false;
    }

    private void performUpdateIfNeeded() {
        this.allocLineAreaCharts();
    }

    private void cleanSceneTree() {
        this.linesGroup.removeAllChildren();
        this.areasGroup.removeAllChildren();
        this.pointsGroup.removeAllChildren();
        this.outputCombineAxisMaps.removeAxisMaps();
        this.outputValueAxisMap.setAxisMap(null);
        this.outputSeriesAxisMap.setAxisMap(null);
        this.seriesAxisMapChart = null;
    }

    private int getRange(double d, ArrayList<Range> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < arrayList.size(); ++i) {
            Range range = arrayList.get(i);
            if (!(d < range.max)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void updateRangesMap(double[] dArray, NullMask nullMask, Hashtable<Integer, ArrayList<Range>> hashtable) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            Range range;
            int n;
            double d;
            double d2;
            boolean bl;
            int n2 = i + 1;
            boolean bl2 = bl = nullMask == null || !nullMask.getNull(i) && !nullMask.getNull(n2);
            if (!bl) continue;
            if (dArray[i] < dArray[n2]) {
                d2 = dArray[i];
                d = dArray[n2];
            } else {
                d2 = dArray[n2];
                d = dArray[i];
            }
            ArrayList<Range> arrayList = hashtable.get(i);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashtable.put(i, arrayList);
            }
            if (arrayList.size() == 0) {
                arrayList.add(new Range(d2, d));
                continue;
            }
            int n3 = this.getRange(d2, arrayList);
            if (n3 == (n = this.getRange(d, arrayList))) {
                if (n3 == arrayList.size()) {
                    arrayList.add(new Range(d2, d));
                    continue;
                }
                range = arrayList.get(n3);
                if (d < range.min) {
                    arrayList.add(n3, new Range(d2, d));
                    continue;
                }
                if (!(d2 < range.min)) continue;
                range.min = d2;
                continue;
            }
            range = arrayList.get(n3);
            if (d2 < range.min) {
                range.min = d2;
            }
            int n4 = n - n3;
            if (n < arrayList.size()) {
                Range range2 = arrayList.get(n);
                if (d < range2.min) {
                    --n4;
                } else {
                    d = range2.max;
                }
            } else {
                --n4;
            }
            range.max = d;
            for (int j = 0; j < n4; ++j) {
                arrayList.remove(n3 + 1);
            }
        }
    }

    private void createSplineCoordinates(double[] dArray, ArrayList<double[]> arrayList, ArrayList<NullMask> arrayList2) {
        boolean bl = true;
        if (bl) {
            int n;
            int n2;
            int n3;
            Object object;
            this.nPartsPerControlPoint = this.getRenderQuality() * 4 - 1;
            int n4 = arrayList.size();
            this.seriesYSplineCoords = new ArrayList(n4);
            this.seriesYSplineNullMasks = new ArrayList(n4);
            boolean bl2 = this.ignoreNull;
            if (this.type == ChartTypeEnum.PERCENT || this.type == ChartTypeEnum.STACK) {
                SegmentGroup._scaleCoordinatesForStackOrPercentageChart(this.type, dArray.length, arrayList, arrayList2);
            }
            ArrayList arrayList3 = new ArrayList();
            int n5 = 0;
            if (this.staircaseStyle != StaircaseStyleEnum.NONE) {
                Hashtable<Integer, ArrayList<Range>> hashtable = null;
                if (this.type != ChartTypeEnum.GRID) {
                    hashtable = new Hashtable<Integer, ArrayList<Range>>();
                }
                for (int i = 0; i < n4; ++i) {
                    object = arrayList.get(i);
                    NullMask nullMask = arrayList2.get(i);
                    ArrayList<InclusionRanges> arrayList4 = new ArrayList<InclusionRanges>();
                    arrayList3.add(arrayList4);
                    for (int j = 0; j < ((double[])object).length - 1; ++j) {
                        if (nullMask != null && (nullMask.getNull(j) || nullMask.getNull(j + 1))) continue;
                        double d = object[j];
                        double d2 = object[j + 1];
                        n3 = d > d2 ? 1 : 0;
                        ArrayList<Range> arrayList5 = hashtable == null ? null : hashtable.get(j);
                        InclusionRanges inclusionRanges = this.getInclusionRanges(arrayList5, d, d2);
                        if (inclusionRanges.size() > 0) {
                            boolean bl3;
                            n2 = this.staircaseStyle == StaircaseStyleEnum.CENTER ? 1 : 0;
                            n2 += inclusionRanges.size() * 2;
                            n2 += inclusionRanges.size() - 1;
                            Range range = (Range)inclusionRanges.get(0);
                            Range range2 = (Range)inclusionRanges.get(inclusionRanges.size() - 1);
                            boolean bl4 = n3 != 0 ? d > range.min : (bl3 = d < range.min);
                            int n6 = n3 != 0 ? (d2 < range2.max ? 1 : 0) : (n = d2 > range2.max ? 1 : 0);
                            if (bl3) {
                                n2 += 2;
                            }
                            if (n != 0) {
                                n2 += 2;
                            }
                            inclusionRanges.setNumOfEndPointCoords(n2);
                            if (n2 > n5) {
                                n5 = n2;
                            }
                        }
                        arrayList4.add(inclusionRanges);
                    }
                    if (hashtable == null) continue;
                    this.updateRangesMap((double[])object, nullMask, hashtable);
                }
            }
            if (this.nPartsPerControlPoint < n5) {
                this.nPartsPerControlPoint = n5 % 2 == 0 ? n5 + 1 : n5;
            }
            this.xSplineCoords = this.staircaseStyle == StaircaseStyleEnum.NONE ? this.createSpline(dArray) : this.createStaircasePoints(dArray);
            for (int i = 0; i < n4; ++i) {
                boolean bl5;
                Object object2;
                double[] dArray2 = arrayList.get(i);
                object = arrayList2.get(i);
                if (bl2 || object == null || !object.hasNullValues()) {
                    if (this.staircaseStyle == StaircaseStyleEnum.NONE) {
                        double[] dArray3 = this.createSpline(dArray2);
                        this.seriesYSplineCoords.add(dArray3);
                        this.seriesYSplineNullMasks.add(null);
                        continue;
                    }
                    ArrayList arrayList6 = (ArrayList)arrayList3.get(i);
                    object2 = this.createLinearStaircasePoints(arrayList6, dArray2);
                    this.seriesYSplineCoords.add(((LinearStairCaseResult)object2).staircaseCoords);
                    this.seriesYSplineNullMasks.add(((LinearStairCaseResult)object2).staircaseNullMask);
                    continue;
                }
                int n7 = dArray2.length;
                int n8 = this.nPartsPerControlPoint * n7 - this.nPartsPerControlPoint + 1;
                object2 = new double[n8];
                NullMask nullMask = new NullMask(new Dimensions(n8));
                ArrayDouble arrayDouble = new ArrayDouble(new Dimensions(0));
                boolean bl6 = bl5 = !object.getNull(0);
                if (bl5) {
                    arrayDouble.pushBack(dArray2[0]);
                }
                int n9 = 0;
                n3 = 0;
                int n10 = 1;
                while (n10 < n7) {
                    int n11;
                    int n12;
                    if (bl5) {
                        while (n10 < n7 && !object.getNull(n10)) {
                            arrayDouble.pushBack(dArray2[n10]);
                            n3 = n10++;
                        }
                        n12 = n3 - n9 + 1;
                        n2 = n9 * this.nPartsPerControlPoint;
                        n11 = n3 * this.nPartsPerControlPoint;
                        if (n12 > 1) {
                            NullMask nullMask2;
                            double[] dArray4;
                            if (this.staircaseStyle == StaircaseStyleEnum.NONE) {
                                dArray4 = this.createSpline(arrayDouble.getNativeArrayDouble());
                                nullMask2 = null;
                            } else {
                                ArrayList arrayList7 = (ArrayList)arrayList3.get(i);
                                LinearStairCaseResult linearStairCaseResult = this.createLinearStaircasePoints(arrayList7.subList(n9, n3 + 1), arrayDouble.getNativeArrayDouble());
                                dArray4 = linearStairCaseResult.staircaseCoords;
                                nullMask2 = linearStairCaseResult.staircaseNullMask;
                            }
                            for (n = n2; n <= n11; ++n) {
                                object2[n] = dArray4[n - n2];
                                boolean bl7 = nullMask2 == null ? false : nullMask2.getNull(n - n2);
                                nullMask.setNull(n, bl7);
                            }
                        } else {
                            int n13 = n2;
                            if (n2 > this.nPartsPerControlPoint - 1) {
                                n2 -= this.nPartsPerControlPoint - 1;
                            }
                            if (n11 < n8 - this.nPartsPerControlPoint) {
                                n11 += this.nPartsPerControlPoint - 1;
                            }
                            for (int j = n2; j <= n11; ++j) {
                                if (j == n13) {
                                    object2[j] = arrayDouble.getValue(0);
                                    nullMask.setNull(j, false);
                                    continue;
                                }
                                nullMask.setNull(j, true);
                            }
                        }
                        arrayDouble = new ArrayDouble(new Dimensions(0));
                        n9 = n3 + 1;
                        bl5 = false;
                        continue;
                    }
                    while (n10 < n7 && object.getNull(n10)) {
                        n3 = n10++;
                    }
                    n12 = n9 * this.nPartsPerControlPoint;
                    if (n12 > this.nPartsPerControlPoint - 1) {
                        n12 -= this.nPartsPerControlPoint - 1;
                    }
                    if ((n2 = n3 * this.nPartsPerControlPoint) < n8 - this.nPartsPerControlPoint) {
                        n2 += this.nPartsPerControlPoint - 1;
                    }
                    for (n11 = n12; n11 <= n2; ++n11) {
                        nullMask.setNull(n11, true);
                    }
                    n9 = n3 + 1;
                    bl5 = true;
                }
                this.seriesYSplineCoords.add((double[])object2);
                this.seriesYSplineNullMasks.add(nullMask);
            }
        } else {
            this.nPartsPerControlPoint = 1;
            this.xSplineCoords = dArray;
            this.seriesYSplineCoords = arrayList;
            this.seriesYSplineNullMasks = arrayList2;
        }
    }

    private void generateValueDataArrays(IField iField) {
        IAxisMap iAxisMap = null;
        if (this.inputValueAxisMapProxy.isConnected()) {
            iAxisMap = this.inputValueAxisMapProxy.getSource().getAxisMap();
        }
        int n = this.theSeries.size();
        this.yControlPoints = new ArrayList();
        this.yNullMasks = new ArrayList();
        for (int i = 0; i < n; ++i) {
            NullMask nullMask;
            ArrayDouble arrayDouble;
            Object object;
            int n2 = this.theSeries.get(i).getValueIndex();
            FieldAdapter fieldAdapter = new FieldAdapter(iField);
            DataArrayAdapter dataArrayAdapter = new DataArrayAdapter();
            fieldAdapter.getNodeData(n2, dataArrayAdapter);
            int n3 = dataArrayAdapter.getNumValues();
            if (iAxisMap != null) {
                object = dataArrayAdapter.getValues();
                NullMask nullMask2 = dataArrayAdapter.getNullMask();
                ArrayResult arrayResult = iAxisMap.mapValuesToCoordinates(object, nullMask2);
                arrayDouble = new ArrayDouble(arrayResult.getArray());
                nullMask = arrayResult.getNullMask();
                this.yNullMasks.add(nullMask);
            } else {
                object = dataArrayAdapter.getValues();
                if (!Common.isDataTypeNumeric((Class)object.getDataType())) {
                    throw new ComponentException((IComponent)this, ExceptionTypeEnum.COMPONENT, 12, "Unsupported data type for value data");
                }
                arrayDouble = new ArrayDouble(object);
                nullMask = dataArrayAdapter.getNullMask();
                this.yNullMasks.add(nullMask);
            }
            object = new double[n3];
            this.yControlPoints.add((double[])object);
            for (int j = 0; j < n3; ++j) {
                if (nullMask != null && nullMask.getNull(j)) continue;
                double d = arrayDouble.getValue(j);
                object[j] = (Array)d;
            }
        }
    }

    private double[] createCategoryCoordinates(IDataArray iDataArray) {
        Dimensions dimensions;
        Dimensions dimensions2;
        Dimensions dimensions3 = iDataArray.getDimensions();
        if (dimensions3.getNumDimensions() == 1) {
            dimensions2 = new Dimensions(0);
            dimensions = new Dimensions(dimensions3.getDimension(0) - 1);
        } else {
            dimensions2 = new Dimensions(0, 0);
            dimensions = new Dimensions(dimensions3.getDimension(0) - 1, 0);
        }
        ArrayPointFloat3 arrayPointFloat3 = new ArrayPointFloat3(iDataArray.getSection(dimensions2, dimensions));
        int n = dimensions3.getDimension(0);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = arrayPointFloat3.getValue(i).getX();
        }
        return dArray;
    }

    private double[] createSeriesCoordinates(IDataArray iDataArray) {
        double[] dArray;
        Dimensions dimensions = iDataArray.getDimensions();
        if (dimensions.getNumDimensions() == 2) {
            Dimensions dimensions2 = new Dimensions(0, 0);
            Dimensions dimensions3 = new Dimensions(0, dimensions.getDimension(1) - 1);
            ArrayPointFloat3 arrayPointFloat3 = new ArrayPointFloat3(iDataArray.getSection(dimensions2, dimensions3));
            int n = dimensions.getDimension(1);
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = arrayPointFloat3.getValue(i).getY();
            }
        } else {
            dArray = null;
        }
        return dArray;
    }

    private ColorCache getColorCache(IDataArrayCollection iDataArrayCollection, int n) {
        ArrayDouble arrayDouble = null;
        NullMask nullMask = null;
        if (n < 0 || n >= iDataArrayCollection.getNumDataArrays()) {
            throw new ComponentException((IComponent)this, ExceptionTypeEnum.COMPONENT, 2, "Color index out of range");
        }
        IDataArray iDataArray = iDataArrayCollection.getDataArray(n);
        try {
            arrayDouble = new ArrayDouble(iDataArray.getValues());
            nullMask = iDataArray.getNullMask();
        }
        catch (Throwable throwable) {
            ComponentException componentException = new ComponentException((IComponent)this, ExceptionTypeEnum.COMPONENT, 1, "Error, colour values must be numeric : {" + throwable.getMessage() + "} ");
            this.exceptionOccurred(new ComponentExceptionEvent((Object)this, componentException));
        }
        ColorCache colorCache = arrayDouble != null ? new ColorCache(arrayDouble, nullMask) : null;
        return colorCache;
    }

    private HashMap<Integer, ColorCache> buildColorCaches(IDataArrayCollection iDataArrayCollection) {
        HashMap<Integer, ColorCache> hashMap = new HashMap<Integer, ColorCache>();
        for (int i = 0; i < this.theSeries.size(); ++i) {
            ColorCache colorCache;
            Integer n;
            LineAreaSegmentSeries lineAreaSegmentSeries = this.theSeries.get(i);
            if (lineAreaSegmentSeries.isLineSegmentStartColorIndexSetByUser() && !hashMap.containsKey(n = lineAreaSegmentSeries.getLineSegmentStartColorIndex()) && (colorCache = this.getColorCache(iDataArrayCollection, n)) != null) {
                hashMap.put(n, colorCache);
            }
            if (!lineAreaSegmentSeries.isLineSegmentEndColorIndexSetByUser() || hashMap.containsKey(n = Integer.valueOf(lineAreaSegmentSeries.getLineSegmentEndColorIndex())) || (colorCache = this.getColorCache(iDataArrayCollection, n)) == null) continue;
            hashMap.put(n, colorCache);
        }
        return hashMap;
    }

    private IDataArray addGradientColors(Double d, Double d2, double[] dArray, int n, int n2) {
        ArrayDouble arrayDouble = new ArrayDouble(new Dimensions(n2));
        NullMask nullMask = null;
        if (d == null) {
            nullMask = new NullMask(new Dimensions(n2));
            nullMask.setNull(0, true);
        } else {
            arrayDouble.setValue(0, d.doubleValue());
        }
        if (d2 == null) {
            if (nullMask == null) {
                nullMask = new NullMask(new Dimensions(n2));
            }
            nullMask.setNull(n2 - 1, true);
        } else {
            arrayDouble.setValue(n2 - 1, d2.doubleValue());
        }
        if (d == null || d2 == null) {
            for (int i = 1; i < n2 - 1; ++i) {
                nullMask.setNull(i, true);
            }
        } else {
            double d3 = dArray[n];
            double d4 = dArray[n + n2 - 1];
            double d5 = d2 - d;
            double d6 = d4 - d3;
            for (int i = 1; i < n2 - 1; ++i) {
                double d7 = dArray[n + i];
                double d8 = d6 != 0.0 ? (d7 - d3) / d6 : (double)i / (double)(n2 - 1);
                if (d8 < 0.0) {
                    d8 = 0.0;
                } else if (d8 > 1.0) {
                    d8 = 1.0;
                }
                double d9 = d + d8 * d5;
                arrayDouble.setValue(i, d9);
            }
        }
        DataArray dataArray = new DataArray((Array)arrayDouble);
        if (nullMask != null) {
            dataArray.setNullMask(nullMask);
        }
        return dataArray;
    }

    private RectilinearField createSegmentField(IDataArrayCollection iDataArrayCollection, HashMap<Integer, ColorCache> hashMap, int n, int n2, double[] dArray) {
        DataArray dataArray;
        NullMask nullMask;
        Array array;
        Object object;
        int n3;
        int n4;
        int n5 = n2 + 1;
        int n6 = n * n2;
        ArrayInt arrayInt = new ArrayInt(new Dimensions(n5));
        ArrayPointFloat3 arrayPointFloat3 = new ArrayPointFloat3(new Dimensions(n5));
        for (int i = n6; i < n5 + n6; ++i) {
            n4 = i - n6;
            arrayPointFloat3.setValue(n4, new PointFloat3((float)dArray[i], 0.0f, 0.0f));
            n3 = i / n2;
            arrayInt.setValue(n4, n3);
        }
        RectilinearField rectilinearField = new RectilinearField(arrayPointFloat3);
        n4 = iDataArrayCollection == null ? 0 : iDataArrayCollection.getNumDataArrays();
        for (n3 = 0; n3 < n4; ++n3) {
            object = iDataArrayCollection.getDataArray(n3);
            array = object.getValuesAtIndices(arrayInt);
            nullMask = object.getNullMaskAtIndices(arrayInt);
            dataArray = new DataArray(array);
            if (nullMask != null) {
                dataArray.setNullMask(nullMask);
            }
            rectilinearField.addNodeData((IDataArray)dataArray);
        }
        for (n3 = 0; n3 < this.theSeries.size(); ++n3) {
            object = this.seriesYSplineCoords.get(n3);
            array = this.seriesYSplineNullMasks.get(n3);
            nullMask = new ArrayDouble(new Dimensions(n5));
            dataArray = null;
            for (int i = n6; i < n5 + n6; ++i) {
                int n7 = i - n6;
                arrayPointFloat3.setValue(n7, new PointFloat3((float)dArray[i], 0.0f, 0.0f));
                if (array != null && array.getNull(i)) {
                    if (dataArray == null) {
                        dataArray = new NullMask(new Dimensions(n5));
                    }
                    dataArray.setNull(n7, true);
                    continue;
                }
                nullMask.setValue(n7, (double)object[i]);
            }
            DataArray dataArray2 = new DataArray((Array)nullMask);
            if (dataArray != null) {
                dataArray2.setNullMask((NullMask)dataArray);
            }
            rectilinearField.addNodeData((IDataArray)dataArray2);
        }
        for (n3 = 0; n3 < this.theSeries.size(); ++n3) {
            boolean bl;
            object = this.theSeries.get(n3);
            boolean bl2 = ((LineAreaSegmentSeries)object).isLineSegmentStartColorIndexSetByUser();
            boolean bl3 = bl = ((LineAreaSegmentSeries)object).isLineSegmentStartColorIndexSetByUser() && ((LineAreaSegmentSeries)object).isLineSegmentEndColorIndexSetByUser();
            if (!bl && !bl2) continue;
            int n8 = ((LineAreaSegmentSeries)object).getLineSegmentStartColorIndex();
            int n9 = bl ? ((LineAreaSegmentSeries)object).getLineSegmentEndColorIndex() : n8;
            ColorCache colorCache = hashMap.get(n8);
            ColorCache colorCache2 = hashMap.get(n9);
            if (colorCache == null || colorCache2 == null) continue;
            int n10 = arrayInt.getValue(0);
            int n11 = bl ? arrayInt.getValue(arrayInt.getNumValues() - 1) : n10;
            Double d = colorCache.getColorsNullMask() != null && colorCache.getColorsNullMask().getNull(n10) ? null : Double.valueOf(colorCache.getColors().getValue(n10));
            Double d2 = colorCache2.getColorsNullMask() != null && colorCache2.getColorsNullMask().getNull(n11) ? null : Double.valueOf(colorCache2.getColors().getValue(n11));
            double[] dArray2 = this.seriesYSplineCoords.get(n3);
            IDataArray iDataArray = this.addGradientColors(d, d2, dArray2, n6, n5);
            rectilinearField.addNodeData(iDataArray);
        }
        return rectilinearField;
    }

    private double[] createStaircasePoints(double[] dArray) {
        int n = (dArray.length - 1) * this.nPartsPerControlPoint + 1;
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d = dArray[i];
            double d2 = dArray[i + 1];
            double d3 = this.staircaseStyle == StaircaseStyleEnum.LEFT ? d : (this.staircaseStyle == StaircaseStyleEnum.RIGHT ? d2 : (d + d2) / 2.0);
            int n2 = i * this.nPartsPerControlPoint;
            dArray2[n2] = d;
            for (int j = 1; j < this.nPartsPerControlPoint; ++j) {
                dArray2[n2 + j] = d3;
            }
        }
        dArray2[n - 1] = dArray[dArray.length - 1];
        return dArray2;
    }

    private InclusionRanges getInclusionRanges(ArrayList<Range> arrayList, double d, double d2) {
        int n;
        InclusionRanges inclusionRanges;
        block12: {
            int n2;
            double d3;
            double d4;
            block15: {
                Range range;
                block16: {
                    block14: {
                        block13: {
                            block11: {
                                inclusionRanges = new InclusionRanges();
                                if (d < d2) {
                                    d4 = d;
                                    d3 = d2;
                                } else {
                                    d4 = d2;
                                    d3 = d;
                                }
                                if (arrayList != null) break block11;
                                inclusionRanges.add(new InclusionRange(d4, d3));
                                break block12;
                            }
                            n2 = this.getRange(d4, arrayList);
                            n = this.getRange(d3, arrayList);
                            if (n2 != arrayList.size()) break block13;
                            inclusionRanges.add(new InclusionRange(d4, d3));
                            break block12;
                        }
                        boolean bl = false;
                        if (n == 0) {
                            range = arrayList.get(0);
                            if (d3 < range.min) {
                                bl = true;
                            }
                        }
                        if (!bl) break block14;
                        inclusionRanges.add(new InclusionRange(d4, d3));
                        break block12;
                    }
                    if (n2 != n) break block15;
                    range = arrayList.get(n2);
                    if (!(d4 < range.min) || !(d3 < range.min)) break block16;
                    inclusionRanges.add(new InclusionRange(d4, d3));
                    break block12;
                }
                if (!(d4 < range.min)) break block12;
                inclusionRanges.add(new InclusionRange(d4, range.min));
                break block12;
            }
            for (int i = n2; i < n; ++i) {
                Range range;
                int n3;
                Range range2 = arrayList.get(i);
                if (i == n2 && d4 < range2.min) {
                    inclusionRanges.add(new InclusionRange(d4, range2.min));
                }
                if ((n3 = i + 1) < n) {
                    range = arrayList.get(n3);
                    inclusionRanges.add(new InclusionRange(range2.max, range.min));
                    continue;
                }
                if (n3 < arrayList.size()) {
                    range = arrayList.get(n3);
                    if (d3 < range.min) {
                        inclusionRanges.add(new InclusionRange(range2.max, d3));
                        continue;
                    }
                    inclusionRanges.add(new InclusionRange(range2.max, range.min));
                    continue;
                }
                inclusionRanges.add(new InclusionRange(range2.max, d3));
            }
        }
        if (d > d2) {
            InclusionRanges inclusionRanges2 = new InclusionRanges();
            for (n = inclusionRanges.size() - 1; n >= 0; --n) {
                InclusionRange inclusionRange = (InclusionRange)inclusionRanges.get(n);
                double d5 = inclusionRange.min;
                inclusionRange.min = inclusionRange.max;
                inclusionRange.max = d5;
                inclusionRanges2.add(inclusionRange);
            }
            inclusionRanges = inclusionRanges2;
        }
        return inclusionRanges;
    }

    private LinearStairCaseResult createLinearStaircasePoints(List<InclusionRanges> list, double[] dArray) {
        int n = (dArray.length - 1) * this.nPartsPerControlPoint + 1;
        double[] dArray2 = new double[n];
        NullMask nullMask = null;
        for (int i = 0; i < dArray.length - 1; ++i) {
            int n2;
            double d = dArray[i];
            double d2 = dArray[i + 1];
            boolean bl = d > d2;
            InclusionRanges inclusionRanges = list.get(i);
            int n3 = i * this.nPartsPerControlPoint;
            dArray2[n3++] = d;
            if (this.staircaseStyle == StaircaseStyleEnum.RIGHT || this.staircaseStyle == StaircaseStyleEnum.CENTER) {
                dArray2[n3++] = d;
            }
            int n4 = n2 = this.staircaseStyle == StaircaseStyleEnum.CENTER ? 3 : 2;
            if (inclusionRanges.size() > 0) {
                int n5;
                int n6;
                int n7;
                InclusionRange inclusionRange;
                int n8;
                boolean bl2;
                Range range = (Range)inclusionRanges.get(0);
                Range range2 = (Range)inclusionRanges.get(inclusionRanges.size() - 1);
                boolean bl3 = bl ? d > range.min : (bl2 = d < range.min);
                boolean bl4 = bl ? d2 < range2.max : d2 > range2.max;
                int n9 = this.nPartsPerControlPoint - inclusionRanges.getNumOfEndPointCoords();
                int n10 = inclusionRanges.size();
                double d3 = 0.0;
                for (n8 = 0; n8 < n10; ++n8) {
                    inclusionRange = (InclusionRange)inclusionRanges.get(n8);
                    d3 += Math.abs(inclusionRange.max - inclusionRange.min);
                }
                for (n8 = 0; n8 < n10; ++n8) {
                    inclusionRange = (InclusionRange)inclusionRanges.get(n8);
                    double d4 = Math.abs(inclusionRange.max - inclusionRange.min) / d3;
                    n7 = (int)((double)n9 * d4);
                    n6 = 2;
                    if (n8 == 0 && !bl2) {
                        --n6;
                    }
                    if (n8 == n10 - 1 && !bl4) {
                        --n6;
                    }
                    inclusionRange.numOfParts = n7 + n6;
                    n9 -= n7;
                }
                n8 = n9 / n10 + 1;
                for (n5 = 0; n5 < n10 && n9 != 0; n9 -= n8, ++n5) {
                    InclusionRange inclusionRange2 = (InclusionRange)inclusionRanges.get(n5);
                    if (n8 > n9) {
                        n8 = n9;
                    }
                    inclusionRange2.numOfParts += n8;
                }
                if (bl2) {
                    if (nullMask == null) {
                        nullMask = new NullMask(new Dimensions(n));
                    }
                    nullMask.setNull(n3++, true);
                }
                for (n5 = 0; n5 < n10; ++n5) {
                    InclusionRange inclusionRange3 = (InclusionRange)inclusionRanges.get(n5);
                    int n11 = n5 == 0 && !bl2 ? 1 : 0;
                    n7 = inclusionRange3.numOfParts + n11;
                    n6 = n7 == 1 ? 1 : n7 - 1;
                    double d5 = (inclusionRange3.max - inclusionRange3.min) / (double)n6;
                    for (int j = n11; j < n7; ++j) {
                        dArray2[n3++] = inclusionRange3.min + d5 * (double)j;
                    }
                    if (n5 >= n10 - 1 && !bl4) continue;
                    if (nullMask == null) {
                        nullMask = new NullMask(new Dimensions(n));
                    }
                    nullMask.setNull(n3++, true);
                }
            } else {
                if (nullMask == null) {
                    nullMask = new NullMask(new Dimensions(n));
                }
                int n12 = this.nPartsPerControlPoint - n2;
                for (int j = 0; j < n12; ++j) {
                    nullMask.setNull(n3++, true);
                }
            }
            if (this.staircaseStyle != StaircaseStyleEnum.LEFT && this.staircaseStyle != StaircaseStyleEnum.CENTER) continue;
            dArray2[n3++] = d2;
        }
        dArray2[n - 1] = dArray[dArray.length - 1];
        return new LinearStairCaseResult(dArray2, nullMask);
    }

    private double[] createSpline(double[] dArray) {
        CurveSmoothingAlgorithmEnum curveSmoothingAlgorithmEnum = this.getCurveSmoothingAlgorithm();
        if (dArray.length < 2) {
            curveSmoothingAlgorithmEnum = CurveSmoothingAlgorithmEnum.NONE;
        }
        Result result = curveSmoothingAlgorithmEnum == CurveSmoothingAlgorithmEnum.CAT_MULLROM ? CurveSmoothingAlgorithmFactory.createCatmullRom((double[])dArray, null, null, (int)this.nPartsPerControlPoint) : CurveSmoothingAlgorithmFactory.createLinearMultiplePoints((double[])dArray, null, null, (int)this.nPartsPerControlPoint);
        return result.getXCoordinates();
    }

    private LineAreaChart updateLineAreaSegment(LineAreaChart lineAreaChart, IFieldSource iFieldSource, boolean bl, boolean bl2, boolean bl3, int n, HashMap<Integer, ColorCache> hashMap) {
        boolean bl4;
        LineAreaSegmentSeries lineAreaSegmentSeries;
        lineAreaChart.connectInputField(iFieldSource);
        int n2 = n + this.theSeries.size();
        for (int i = 0; i < this.theSeries.size(); ++i) {
            Integer n3;
            lineAreaSegmentSeries = this.theSeries.get(i);
            LineAreaChart.LineAreaSeries lineAreaSeries = lineAreaChart.getSeries(i);
            if (n == -1) {
                n3 = lineAreaSegmentSeries.getValueIndex();
            } else {
                n3 = n + i;
                if (bl2) {
                    boolean bl5;
                    boolean bl6 = lineAreaSegmentSeries.isLineSegmentStartColorIndexSetByUser();
                    boolean bl7 = bl5 = lineAreaSegmentSeries.isLineSegmentStartColorIndexSetByUser() && lineAreaSegmentSeries.isLineSegmentEndColorIndexSetByUser();
                    if (bl5 || bl6) {
                        int n4 = lineAreaSegmentSeries.getLineSegmentStartColorIndex();
                        int n5 = bl5 ? lineAreaSegmentSeries.getLineSegmentEndColorIndex() : n4;
                        ColorCache colorCache = hashMap.get(n4);
                        ColorCache colorCache2 = hashMap.get(n5);
                        if (colorCache != null && colorCache2 != null) {
                            lineAreaSeries.setColorIndex(Integer.valueOf(n2++));
                        } else {
                            lineAreaSeries.resetProperty(LineAreaSeriesPropertyEnum.COLOR_INDEX);
                        }
                    }
                }
            }
            lineAreaSeries.setValueIndex(n3);
            lineAreaSeries.setLinePatternArrayIndex(lineAreaSegmentSeries.getLinePatternArrayIndex());
            lineAreaSeries.setLineWidthIndex(lineAreaSegmentSeries.getLineWidthIndex());
            if (bl3) {
                lineAreaSeries.setColorIndex(lineAreaSegmentSeries.getColorIndex());
                lineAreaSeries.setGlyphIndex(lineAreaSegmentSeries.getGlyphIndex());
                lineAreaSeries.setLabelTemplate(lineAreaSegmentSeries.getLabelTemplate());
                lineAreaSeries.setLabelFiltering(lineAreaSegmentSeries.getLabelFiltering());
                lineAreaSeries.setLabelFitting(lineAreaSegmentSeries.getLabelFitting());
                continue;
            }
            String string = lineAreaSegmentSeries.getImageMapArea();
            if (string == null) {
                lineAreaSeries.getSceneNodeAttributes().resetProperty(SceneNodeAttributesPropertyEnum.IMAGE_MAP_AREA);
                continue;
            }
            lineAreaSeries.getSceneNodeAttributes().setImageMapArea(string);
        }
        lineAreaChart.setAxisOrder(this.axisOrder);
        lineAreaChart.setCrossOverValueAsObject(this.crossOverValueAsObject);
        if (n != -1) {
            lineAreaChart.setCurveSmoothingAlgorithm(CurveSmoothingAlgorithmEnum.NONE);
            if (lineAreaChart instanceof LineSegmentGroup) {
                LineSegmentGroup lineSegmentGroup = (LineSegmentGroup)lineAreaChart;
                lineSegmentGroup.setNumPartsPerShape(this.nPartsPerControlPoint);
            }
            lineAreaChart.resetProperty(LineAreaChartPropertyEnum.INPUT_VALUE_AXIS_MAP);
        } else {
            lineAreaChart.setCurveSmoothingAlgorithm(this.curveSmoothingAlgorithm);
            lineAreaChart.setInputValueAxisMap(this.inputValueAxisMapProxy.getSource());
        }
        lineAreaChart.setDepthOffset(this.depthOffset);
        lineAreaChart.setDepthScale(this.depthScale);
        lineAreaChart.setIgnoreNull(this.ignoreNull);
        lineAreaChart.setImageMapNullString(this.imageMapNullString);
        lineAreaChart.setImageMapTemplate(this.imageMapTemplate);
        lineAreaChart.setMaxSamples(this.maxSamples);
        lineAreaChart.setRenderQuality(this.renderQuality);
        lineAreaChart.setShowArea(bl);
        lineAreaChart.setShowBorder(this.showBorder);
        lineAreaChart.setShowGlyphs(bl3);
        lineAreaChart.setShowLines(bl2);
        IAttribute iAttribute = lineAreaChart.getAttributeList().lookupAttribute("generateLineSegmentImageMapAreas");
        if (iAttribute != null) {
            iAttribute.setObject((Object)new Boolean(this.generateLineSegmentImageMapAreas));
        }
        lineAreaSegmentSeries = this.type;
        boolean bl8 = bl4 = bl3 || this.showArea && !this.isUseSegmentedArea();
        if (!(bl4 || this.type != ChartTypeEnum.PERCENT && this.type != ChartTypeEnum.STACK)) {
            lineAreaSegmentSeries = ChartTypeEnum.OVERLAP;
        }
        lineAreaChart.setType((ChartTypeEnum)lineAreaSegmentSeries);
        this.outputCombineAxisMaps.addAxisMap(lineAreaChart.getOutputValueAxisMap());
        return lineAreaChart;
    }

    public void simpleUpdate() {
        this.allocLineAreaCharts();
        this.cleanSceneTree();
        if (!this.inputFieldProxy.isConnected()) {
            return;
        }
        IField iField = this.inputFieldProxy.getSource().getField();
        if (iField == null) {
            return;
        }
        IMesh iMesh = iField.getMesh();
        if (iMesh == null) {
            return;
        }
        IDataArray iDataArray = iMesh.getCoordinates();
        if (iDataArray == null) {
            return;
        }
        double[] dArray = this.createCategoryCoordinates(iDataArray);
        double[] dArray2 = this.createSeriesCoordinates(iDataArray);
        this.calcCellDepth(iMesh.getType(), dArray, dArray2);
        this.generateValueDataArrays(iField);
        this.createSplineCoordinates(dArray, this.yControlPoints, this.yNullMasks);
        IDataArrayCollection iDataArrayCollection = iField.getNodeDataCollection();
        HashMap<Integer, ColorCache> hashMap = this.buildColorCaches(iDataArrayCollection);
        int n = iDataArray.getNumValues() - 1;
        for (int i = 0; i < n; ++i) {
            RectilinearField rectilinearField = this.createSegmentField(iDataArrayCollection, hashMap, i, this.nPartsPerControlPoint, this.xSplineCoords);
            int n2 = iDataArrayCollection.getNumDataArrays();
            FieldSource fieldSource = this.fieldSources.get(i);
            fieldSource.setField((IField)rectilinearField);
            if (this.showLines) {
                this.seriesAxisMapChart = this.lineSegments.get(i);
                this.linesGroup.addChild((ISceneNode)this.updateLineAreaSegment(this.seriesAxisMapChart, (IFieldSource)fieldSource, false, true, false, n2, hashMap));
            }
            if (!this.showArea || !this.isUseSegmentedArea()) continue;
            this.seriesAxisMapChart = this.areaSegments.get(i);
            this.areasGroup.addChild((ISceneNode)this.updateLineAreaSegment(this.seriesAxisMapChart, (IFieldSource)fieldSource, true, false, false, n2, hashMap));
        }
        if (this.showArea && !this.isUseSegmentedArea()) {
            this.seriesAxisMapChart = this.area;
            this.areasGroup.addChild((ISceneNode)this.updateLineAreaSegment(this.area, this.inputFieldProxy.getSource(), true, false, false, -1, null));
        }
        if (this.showGlyphs) {
            this.seriesAxisMapChart = this.pointsAndLabels;
            this.pointsGroup.addChild((ISceneNode)this.updateLineAreaSegment(this.pointsAndLabels, this.inputFieldProxy.getSource(), false, false, true, -1, null));
        }
    }

    private void calcCellDepth(MeshTypeEnum meshTypeEnum, double[] dArray, double[] dArray2) {
        int n;
        int n2 = n = dArray2 == null ? 1 : 2;
        if (meshTypeEnum == MeshTypeEnum.UNIFORM) {
            double d = dArray.length <= 1 ? 1.0 : Math.abs(dArray[dArray.length - 1] - dArray[0]) / (double)(dArray.length - 1);
            this.cellDepth = n == 1 ? d : (dArray2.length <= 1 ? 1.0 : Math.abs(dArray2[dArray2.length - 1] - dArray2[0]) / (double)(dArray2.length - 1));
        } else {
            RectilinearCellSizeEnum rectilinearCellSizeEnum = RectilinearCellSizeEnum.MINIMUM;
            if (rectilinearCellSizeEnum == RectilinearCellSizeEnum.MINIMUM) {
                this.computeCellInfoRectilinearMinimum(dArray, dArray2);
            } else if (rectilinearCellSizeEnum == RectilinearCellSizeEnum.FIVE_PERCENT) {
                this.computeCellInfoRectilinearPercent(dArray, dArray2);
            }
        }
    }

    private void computeCellInfoRectilinearMinimum(double[] dArray, double[] dArray2) {
        double d;
        int n;
        int n2 = dArray2 == null ? 1 : 2;
        double d2 = dArray.length <= 1 ? 0.0 : Math.abs(dArray[1] - dArray[0]);
        for (n = 2; n < dArray.length; ++n) {
            d = Math.abs(dArray[n] - dArray[n - 1]);
            if (!(d > 0.0) || !(d < d2)) continue;
            d2 = d;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if (n2 == 2) {
            this.cellDepth = dArray2.length <= 1 ? 0.0 : Math.abs(dArray2[1] - dArray2[0]);
            for (n = 2; n < dArray2.length; ++n) {
                d = dArray2[n] - dArray2[n - 1];
                if (!(d > 0.0) || !(d < this.cellDepth)) continue;
                this.cellDepth = d;
            }
            if (this.cellDepth == 0.0) {
                this.cellDepth = 1.0;
            }
        } else {
            this.cellDepth = d2;
        }
    }

    private void computeCellInfoRectilinearPercent(double[] dArray, double[] dArray2) {
        int n = dArray2 == null ? 1 : 2;
        double d = dArray.length < 1 ? 0.0 : Math.abs(dArray[dArray.length - 1] - dArray[0]) * 0.05;
        if (d == 0.0) {
            d = 1.0;
        }
        if (n == 1) {
            this.cellDepth = d;
        } else if (n == 2) {
            this.cellDepth = dArray2.length < 1 ? 0.0 : Math.abs(dArray2[dArray2.length - 1] - dArray2[0]) * 0.05;
            if (this.cellDepth == 0.0) {
                this.cellDepth = 1.0;
            }
        }
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        IComponent iComponent = componentExceptionEvent.getComponent();
        ExceptionTypeEnum exceptionTypeEnum = componentExceptionEvent.getType();
        int n = componentExceptionEvent.getCode();
        String string = componentExceptionEvent.getMessage();
        String string2 = iComponent.getName();
        if (exceptionTypeEnum == ExceptionTypeEnum.WARNING) {
            String string3 = "Warning: " + string + " (" + string2 + ":" + n + ")";
            System.err.println(string3);
        } else if (exceptionTypeEnum == ExceptionTypeEnum.INTERNAL) {
            String string4 = "Internal: " + string + " (" + string2 + ":" + n + ")";
            System.err.println(string4);
        } else if (exceptionTypeEnum == ExceptionTypeEnum.COMPONENT) {
            String string5 = "Component: " + string + " (" + string2 + ":" + n + ")";
            System.err.println(string5);
        }
    }

    public void updateCategoryAxisMap() {
    }

    public void updateSeriesAxisMap() {
        this.update(null);
        if (this.seriesAxisMapChart != null) {
            this.outputSeriesAxisMap.setAxisMap(this.seriesAxisMapChart.getOutputSeriesAxisMap().getAxisMap());
        }
    }

    public void updateValueAxisMap() {
        this.update(null);
        this.outputValueAxisMap.setAxisMap(this.outputCombineAxisMaps.getOutputAxisMap().getAxisMap());
    }

    public synchronized void resetProperty(LineAreaSegmentChartPropertyEnum lineAreaSegmentChartPropertyEnum) {
        if (!(lineAreaSegmentChartPropertyEnum instanceof LineAreaSegmentChartPropertyEnum)) {
            throw new IllegalArgumentException("Invalid reset property enumerator specified as argument");
        }
        int n = lineAreaSegmentChartPropertyEnum == LineAreaSegmentChartPropertyEnum.ALL ? LineAreaSegmentChartPropertyEnum.INPUT_FIELD.ordinal() : lineAreaSegmentChartPropertyEnum.ordinal();
        int n2 = lineAreaSegmentChartPropertyEnum == LineAreaSegmentChartPropertyEnum.ALL ? LineAreaSegmentChartPropertyEnum.RENDER_QUALITY.ordinal() : lineAreaSegmentChartPropertyEnum.ordinal();
        for (int i = n; i <= n2; ++i) {
            if (i == LineAreaSegmentChartPropertyEnum.INPUT_FIELD.ordinal()) {
                this.inputFieldProxy.setSource(null);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.INPUT_VALUE_AXIS_MAP.ordinal()) {
                this.inputValueAxisMapProxy.setSource(null);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.AXIS_ORDER.ordinal()) {
                this.setAxisOrder(DEFAULT_AXIS_ORDER);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.CROSS_OVER_VALUE.ordinal()) {
                this.setCrossOverValueAsObject(new Double(0.0));
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.CURVE_SMOOTHING_ALGORITHM.ordinal()) {
                this.setCurveSmoothingAlgorithm(DEFAULT_CURVESMOOTHING_ALGORITHM);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.DEPTH_OFFSET.ordinal()) {
                this.setDepthOffset(0.0);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.DEPTH_SCALE.ordinal()) {
                this.setDepthScale(0.5);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.GLYPH_SCALE_FACTOR.ordinal()) {
                this.setGlyphScaleFactor(1.0);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.IGNORE_NULL.ordinal()) {
                this.setIgnoreNull(false);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.MAX_SAMPLES.ordinal()) {
                this.setMaxSamples(2000);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.RENDER_QUALITY.ordinal()) {
                this.setRenderQuality(3);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.SHOW_AREA.ordinal()) {
                this.setShowArea(true);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.SHOW_BORDER.ordinal()) {
                this.setShowBorder(false);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.SHOW_GLYPHS.ordinal()) {
                this.setShowGlyphs(false);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.SHOW_LINES.ordinal()) {
                this.setShowLines(true);
                continue;
            }
            if (i == LineAreaSegmentChartPropertyEnum.STAIRCASE_STYLE.ordinal()) {
                this.setStaircaseStyle(DEFAULT_STAIRCASE_STYLE);
                continue;
            }
            if (i != LineAreaSegmentChartPropertyEnum.TYPE.ordinal()) continue;
            this.setType(DEFAULT_CHART_TYPE);
        }
        this.sendUpdateNeeded();
    }

    private static interface ChartFactory<T> {
        public T newChart(LineAreaSegmentChart var1);
    }

    private static class ColorCache {
        ArrayDouble colors;
        NullMask colorsNullMask;

        public ColorCache(ArrayDouble arrayDouble, NullMask nullMask) {
            this.colors = arrayDouble;
            this.colorsNullMask = nullMask;
        }

        public ArrayDouble getColors() {
            return this.colors;
        }

        public NullMask getColorsNullMask() {
            return this.colorsNullMask;
        }
    }

    public class LineAreaSegmentSeries {
        private Integer colorIndex;
        private Integer glyphIndex;
        private Integer linePatternArrayIndex;
        private Integer lineWidthIndex;
        private Integer lineSegmentEndColorIndex;
        private Integer lineSegmentStartColorIndex;
        private Integer valueIndex;
        private LabelFilteringEnum labelFiltering;
        private LabelFittingEnum labelFitting;
        private String labelTemplate;
        private String imageMapArea;

        public LineAreaSegmentSeries(Integer n) {
            this.valueIndex = n;
            this.labelTemplate = null;
            this.imageMapArea = null;
            this.labelFiltering = LabelFilteringEnum.NONE;
            this.labelFitting = LabelFittingEnum.NONE;
        }

        public IAttributeSceneNode getLineSegment(int n) {
            int n2 = LineAreaSegmentChart.this.theSeries.indexOf(this);
            return ((LineSegmentGroup)LineAreaSegmentChart.this.lineSegments.get(n)).getSeries(n2);
        }

        public ISurfaceFaceAttributeSceneNode getAreaSegment(int n) {
            int n2 = LineAreaSegmentChart.this.theSeries.indexOf(this);
            return ((AreaSegmentGroup)LineAreaSegmentChart.this.areaSegments.get(n)).getSeries(n2);
        }

        public Integer getValueIndex() {
            return this.valueIndex;
        }

        public Integer getColorIndex() {
            return this.colorIndex;
        }

        public void setColorIndex(Integer n) {
            this.colorIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public Integer getLineSegmentStartColorIndex() {
            return this.lineSegmentStartColorIndex;
        }

        public void setLineSegmentStartColorIndex(Integer n) {
            this.lineSegmentStartColorIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        private boolean isLineSegmentStartColorIndexSetByUser() {
            return this.lineSegmentStartColorIndex != null;
        }

        public final synchronized int getLineSegmentEndColorIndex() {
            return this.lineSegmentEndColorIndex;
        }

        public synchronized void setLineSegmentEndColorIndex(Integer n) {
            this.lineSegmentEndColorIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        private synchronized boolean isLineSegmentEndColorIndexSetByUser() {
            return this.lineSegmentEndColorIndex != null;
        }

        public Integer getGlyphIndex() {
            return this.glyphIndex;
        }

        public void setGlyphIndex(Integer n) {
            this.glyphIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public Integer getLinePatternArrayIndex() {
            return this.linePatternArrayIndex;
        }

        public void setLinePatternArrayIndex(Integer n) {
            this.linePatternArrayIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public Integer getLineWidthIndex() {
            return this.lineWidthIndex;
        }

        public void setLineWidthIndex(Integer n) {
            this.lineWidthIndex = n;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public String getLabelTemplate() {
            return this.labelTemplate;
        }

        public void setLabelTemplate(String string) {
            this.labelTemplate = string;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public String getImageMapArea() {
            return this.imageMapArea;
        }

        public void setImageMapArea(String string) {
            this.imageMapArea = string;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public final synchronized LabelFilteringEnum getLabelFiltering() {
            return this.labelFiltering;
        }

        public synchronized void setLabelFiltering(LabelFilteringEnum labelFilteringEnum) {
            this.labelFiltering = labelFilteringEnum;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public final synchronized LabelFittingEnum getLabelFitting() {
            return this.labelFitting;
        }

        public final synchronized void setLabelFitting(LabelFittingEnum labelFittingEnum) {
            this.labelFitting = labelFittingEnum;
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }

        public final synchronized ILabelLayout getLabelLayout() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            ILabelLayout iLabelLayout = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n).getLabelLayout();
            return iLabelLayout;
        }

        public final synchronized ILabelProperties getLabelProperties() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            ILabelProperties iLabelProperties = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n).getLabelProperties();
            return iLabelProperties;
        }

        public final synchronized ICurrencyFormat getCurrencyFormat() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            ICurrencyFormat iCurrencyFormat = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n).getCurrencyFormat();
            return iCurrencyFormat;
        }

        public final synchronized INumberFormat getNumberFormat() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            INumberFormat iNumberFormat = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n).getNumberFormat();
            return iNumberFormat;
        }

        public final synchronized ILabelGroupSceneNode getLabelSceneNode() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            ILabelGroupSceneNode iLabelGroupSceneNode = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n).getLabelSceneNode();
            return iLabelGroupSceneNode;
        }

        public final synchronized IGroupSceneNode getPointSceneNode() {
            int n = LineAreaSegmentChart.this.theSeries.indexOf(this);
            LineAreaChart.LineAreaSeries lineAreaSeries = LineAreaSegmentChart.this.getPointsAndLabels().getSeries(n);
            return lineAreaSeries;
        }

        public synchronized void resetProperty(LineAreaSegmentSeriesPropertyEnum lineAreaSegmentSeriesPropertyEnum) {
            if (!(lineAreaSegmentSeriesPropertyEnum instanceof LineAreaSegmentSeriesPropertyEnum)) {
                throw new IllegalArgumentException("Invalid reset property enumerator specified as argument");
            }
            int n = lineAreaSegmentSeriesPropertyEnum == LineAreaSegmentSeriesPropertyEnum.ALL ? LineAreaSegmentSeriesPropertyEnum.COLOR_INDEX.ordinal() : lineAreaSegmentSeriesPropertyEnum.ordinal();
            int n2 = lineAreaSegmentSeriesPropertyEnum == LineAreaSegmentSeriesPropertyEnum.ALL ? LineAreaSegmentSeriesPropertyEnum.LINE_SEGMENT_END_COLOR_INDEX.ordinal() : lineAreaSegmentSeriesPropertyEnum.ordinal();
            for (int i = n; i <= n2; ++i) {
                if (i == LineAreaSegmentSeriesPropertyEnum.COLOR_INDEX.ordinal()) {
                    this.colorIndex = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LABEL_TEMPLATE.ordinal()) {
                    this.labelTemplate = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LABEL_FILTERING.ordinal()) {
                    this.labelFiltering = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LABEL_FITTING.ordinal()) {
                    this.labelFitting = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.GLYPH_INDEX.ordinal()) {
                    this.glyphIndex = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LINE_WIDTH_INDEX.ordinal()) {
                    this.lineWidthIndex = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LINE_PATTERN_ARRAY_INDEX.ordinal()) {
                    this.linePatternArrayIndex = null;
                    continue;
                }
                if (i == LineAreaSegmentSeriesPropertyEnum.LINE_SEGMENT_START_COLOR_INDEX.ordinal()) {
                    this.lineSegmentStartColorIndex = null;
                    continue;
                }
                if (i != LineAreaSegmentSeriesPropertyEnum.LINE_SEGMENT_END_COLOR_INDEX.ordinal()) continue;
                this.lineSegmentEndColorIndex = null;
            }
            LineAreaSegmentChart.this.sendUpdateNeeded();
        }
    }

    private static class AreaSegmentGroup
    extends SegmentGroup
    implements IAreaSegmentGroup {
        private static final long serialVersionUID = -8917501261955405980L;

        public AreaSegmentGroup(LineAreaSegmentChart lineAreaSegmentChart) {
            super(lineAreaSegmentChart);
        }

        @Override
        public ISurfaceFaceAttributeSceneNode getAreaSegment(int n) {
            return this.getSeries(n);
        }
    }

    private static class LineSegmentGroup
    extends SegmentGroup
    implements ILineSegmentGroup {
        private static final long serialVersionUID = 4085695133848984144L;

        public LineSegmentGroup(LineAreaSegmentChart lineAreaSegmentChart) {
            super(lineAreaSegmentChart);
        }

        @Override
        public ILineSegment getLineSegment(int n) {
            return new LineSegment(this.getSeries(n));
        }

        public void setNumPartsPerShape(int n) {
            this._nPartsPerShape = n;
        }
    }

    private static class LineSegment
    implements ILineSegment {
        private static final long serialVersionUID = -3442836819035276910L;
        private LineAreaChart.LineAreaSeries lineAreaSeries;

        public LineSegment(LineAreaChart.LineAreaSeries lineAreaSeries) {
            this.lineAreaSeries = lineAreaSeries;
        }

        @Override
        public ILineSegmentShapes getLineSegmentEndShapes() {
            return this.lineAreaSeries.getLineSegmentEndShapes();
        }

        @Override
        public ILineSegmentShapes getLineSegmentStartShapes() {
            return this.lineAreaSeries.getLineSegmentStartShapes();
        }

        public IChartAttributes getChartAttributes() {
            return this.lineAreaSeries.getChartAttributes();
        }

        public IDropShadowAttributes getDropShadowAttributes() {
            return this.lineAreaSeries.getDropShadowAttributes();
        }

        public IGlyphAttributes210 getGlyphAttributes() {
            return this.lineAreaSeries.getGlyphAttributes();
        }

        public ILineAttributes getLineAttributes() {
            return this.lineAreaSeries.getLineAttributes();
        }

        public IMaterialAttributes getMaterialAttributes() {
            return this.lineAreaSeries.getMaterialAttributes();
        }

        public IPointAttributes getPointAttributes() {
            return this.lineAreaSeries.getPointAttributes();
        }

        public ISceneNodeAttributes getSceneNodeAttributes() {
            return this.lineAreaSeries.getSceneNodeAttributes();
        }

        public ISurfaceAttributes getSurfaceAttributes() {
            return this.lineAreaSeries.getSurfaceAttributes();
        }

        public ITextAttributes getTextAttributes() {
            return this.lineAreaSeries.getTextAttributes();
        }

        public TraverserResultEnum accept(TraverserBase traverserBase) {
            return this.lineAreaSeries.accept(traverserBase);
        }

        public void draw(Context context) {
            this.lineAreaSeries.draw(context);
        }

        public BoundingBox getBoundingBox() {
            return this.lineAreaSeries.getBoundingBox();
        }

        public IGroupSceneNode getParentSceneNode() {
            return this.lineAreaSeries.getParentSceneNode();
        }

        public boolean getVisible() {
            return this.lineAreaSeries.getVisible();
        }

        public void pick(Context context) {
            this.lineAreaSeries.pick(context);
        }

        public void setParentSceneNode(IGroupSceneNode iGroupSceneNode) {
            this.lineAreaSeries.setParentSceneNode(iGroupSceneNode);
        }

        public void setVisible(boolean bl) {
            this.lineAreaSeries.setVisible(bl);
        }

        public AttributeList getAttributeList() {
            return this.lineAreaSeries.getAttributeList();
        }

        public ISurfaceFaceAttributes getSurfaceFaceAttributes() {
            return this.lineAreaSeries.getSurfaceFaceAttributes();
        }
    }

    private static class PointsAndLabels
    extends SegmentGroup
    implements IPoints {
        private static final long serialVersionUID = 9143074281775942236L;

        public PointsAndLabels(LineAreaSegmentChart lineAreaSegmentChart) {
            super(lineAreaSegmentChart);
        }

        @Override
        public IAttributeSceneNode getPoint(int n) {
            return this.getSeries(n);
        }

        @Override
        public int getNumPoints() {
            return this.getNumSeries();
        }
    }

    private static class SegmentGroup
    extends LineAreaChart {
        private static final long serialVersionUID = 8402562236750196407L;
        private int segmentIndex = 0;
        private int numOfSegments;
        private LineAreaSegmentChart parent;

        public SegmentGroup(LineAreaSegmentChart lineAreaSegmentChart) {
            super(lineAreaSegmentChart.getName());
            this.parent = lineAreaSegmentChart;
        }

        private void setSegmentIndex(int n, int n2) {
            this.segmentIndex = n;
            this.numOfSegments = n2;
        }

        protected void _computeCellInfo() {
            super._computeCellInfo();
            this._cellDepth = this.parent.cellDepth;
        }

        protected boolean isOrigCoordinate(int n) {
            boolean bl;
            boolean bl2 = bl = this.segmentIndex == this.numOfSegments - 1;
            return n == 0 || bl && n == this.parent.nPartsPerControlPoint;
        }

        protected static void _scaleCoordinatesForStackOrPercentageChart(ChartTypeEnum chartTypeEnum, int n, ArrayList<double[]> arrayList, ArrayList<NullMask> arrayList2) {
            LineAreaChart._scaleCoordinatesForStackOrPercentageChart((ChartTypeEnum)chartTypeEnum, (int)n, arrayList, arrayList2);
        }
    }

    public static interface IPoints
    extends IAttributeSceneNode {
        public int getNumPoints();

        public IAttributeSceneNode getPoint(int var1);
    }

    public static interface IAreaSegmentGroup
    extends ISegmentGroup {
        public ISurfaceFaceAttributeSceneNode getAreaSegment(int var1);
    }

    public static interface ILineSegmentGroup
    extends ISegmentGroup {
        public ILineSegment getLineSegment(int var1);
    }

    public static interface ISegmentGroup
    extends IAttributeSceneNode {
        public int getNumSeries();
    }

    public static interface ILineSegment
    extends ISurfaceFaceAttributeSceneNode {
        public ILineSegmentShapes getLineSegmentStartShapes();

        public ILineSegmentShapes getLineSegmentEndShapes();
    }

    private static class LinearStairCaseResult {
        public double[] staircaseCoords;
        public NullMask staircaseNullMask;

        public LinearStairCaseResult(double[] dArray, NullMask nullMask) {
            this.staircaseCoords = dArray;
            this.staircaseNullMask = nullMask;
        }
    }

    private static class InclusionRanges
    extends ArrayList<InclusionRange> {
        private int numOfEndPointCoords = 0;

        InclusionRanges() {
        }

        void setNumOfEndPointCoords(int n) {
            this.numOfEndPointCoords = n;
        }

        int getNumOfEndPointCoords() {
            return this.numOfEndPointCoords;
        }
    }

    private static class InclusionRange
    extends Range {
        public int numOfParts = 0;

        public InclusionRange(double d, double d2) {
            super(d, d2);
        }
    }

    private static class Range {
        public double min;
        public double max;

        public Range(double d, double d2) {
            this.min = d;
            this.max = d2;
        }
    }
}

