/*
 * Decompiled with CFR 0.152.
 */
package com.avs.openviz3.cognos;

import com.avs.openviz3.cognos.AWTRenderer;
import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.Viewport;
import com.avs.openviz3.fw.util.LicenseManager;
import com.avs.openviz3.fw.util.Version;
import com.avs.openviz3.viewer.SceneTreeRenderer;
import com.avs.openviz3.viewer.ToolkitUtil;
import com.avs.openviz3.viewer.renderer.IRenderer;
import com.avs.openviz3.viewer.renderer.OutputTypeEnum;
import com.avs.openviz3.viewer.renderer.paint.PaintRenderer;
import java.awt.Dimension;
import java.awt.Graphics2D;

class OpenVizRendererBridgeImpl
extends SceneTreeRenderer {
    private static final String COPR = "Copyright 1997-2012 AVS";
    private static final String _RELEASE_INFO = "OV31/64164";
    private Dimension _size = new Dimension(256, 256);
    private Dimension _scaledSize = null;
    private boolean _licensed;
    private boolean _evalLicense;
    private String _evalProductName;
    private String _evalProductCode;
    private String _evalVersion;
    private String _watermarkString;
    private String _urlString;
    private boolean _setEvalLicenseCalled = false;
    private float _screenDPI;
    private static final float _cognosDPI = 72.0f;

    OpenVizRendererBridgeImpl(String string, String string2) {
        super(string);
        this._licensed = LicenseManager.validateLicenseKey((String)string2, null);
        int n = Version.getOpenVizEngineMajorVersion();
        int n2 = Version.getOpenVizEngineMinorVersion();
        int n3 = Version.getOpenVizEngineRevision();
        this._evalVersion = n + "." + n2 + "." + n3;
        this._evalProductName = "OpenViz";
        this._evalProductCode = null;
        this._watermarkString = "OpenViz";
        this._urlString = "www.openviz.com";
        if (this._licensed) {
            this.setShowWatermark(false);
            this._evalLicense = false;
        }
        int n4 = ToolkitUtil.getScreenResolution();
        this._screenDPI = n4;
        AWTRenderer aWTRenderer = new AWTRenderer();
        super.setRenderer((IRenderer)aWTRenderer);
        aWTRenderer.setPrinterDPI(72.0f);
    }

    public String getReleaseInfo() {
        return _RELEASE_INFO;
    }

    public void setLicense(String string) {
        this._licensed = LicenseManager.validateLicenseKey((String)string, null);
        if (this._licensed) {
            this.setShowWatermark(false);
        }
        this._evalLicense = false;
    }

    private void checkEvalLicense(boolean bl) {
        if (this._licensed || this._evalLicense) {
            return;
        }
        int[] nArray = new int[1];
        String[] stringArray = new String[1];
        int n = LicenseManager.validateEvaluationLicense((String)this._evalProductName, (String)this._evalProductCode, (String)this._evalVersion, (int[])nArray, (String[])stringArray);
        if (n == 1) {
            this._evalLicense = true;
            this.setShowWatermark(true, nArray[0], this._watermarkString, this._urlString, null);
        } else if (n == 2) {
            this._evalLicense = true;
            this.setShowWatermark(false);
        } else {
            this._evalLicense = false;
            this.setShowWatermark(true, nArray[0], this._watermarkString, this._urlString, stringArray[0]);
        }
    }

    public void setEvalLicense(String string, String string2, String string3, String string4, String string5) {
        if (this._setEvalLicenseCalled || string.equals("OpenViz")) {
            this._evalLicense = false;
            this._setEvalLicenseCalled = true;
            return;
        }
        this._setEvalLicenseCalled = true;
        this._evalProductName = new String(string);
        this._evalProductCode = new String(string2);
        this._evalVersion = new String(string3);
        this._watermarkString = new String(string4);
        this._urlString = new String(string5);
        this.checkEvalLicense(false);
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("Size is null");
        }
        double d = this._screenDPI / 72.0f;
        double d2 = dimension.getWidth() * d;
        double d3 = dimension.getHeight() * d;
        this._scaledSize = new Dimension((int)d2, (int)d3);
        this._size = dimension;
    }

    public int getWidth() {
        return this._scaledSize.width;
    }

    public int getHeight() {
        return this._scaledSize.height;
    }

    public void getScene(Graphics2D graphics2D) {
        this.checkEvalLicense(true);
        this._context.setRenderer(this._renderer);
        this.setOutput(graphics2D, OutputTypeEnum.PRINTER, null);
        if (this._renderer instanceof PaintRenderer) {
            ((PaintRenderer)this._renderer).setOutput((Object)graphics2D, OutputTypeEnum.PRINTER);
        }
        this._context.setBackgroundColor(this.getBackground());
        float f = 28.346457f;
        Viewport viewport = new Viewport(0, 0, (int)this._size.getWidth(), (int)this._size.getHeight());
        this.setViewport(viewport, f);
        this.update();
        this.layout();
        this.draw();
        if (graphics2D != null) {
            graphics2D.dispose();
        }
    }

    public synchronized void addComponentExceptionListener(ComponentExceptionListener componentExceptionListener) {
    }

    public synchronized void removeComponentExceptionListener(ComponentExceptionListener componentExceptionListener) {
    }

    void measureSceneTree() {
        IRenderer iRenderer = this._renderer;
        SceneTreeRenderer.MeasureRenderer measureRenderer = new SceneTreeRenderer.MeasureRenderer();
        measureRenderer.setPrinterDPI(72.0f);
        super.setRenderer((IRenderer)measureRenderer);
        this.getScene(null);
        super.setRenderer(iRenderer);
    }

    PointFloat2[] getScreenCoordinateBoundingBox(ISceneNode iSceneNode) {
        return SceneTreeRenderer.MeasureUtil.getScreenCoordinateBoundingBox((ISceneNode)iSceneNode, (int)((int)this._size.getWidth()), (int)((int)this._size.getHeight()));
    }

    PointFloat2 getScreenCoordinatesExtents(ISceneNode iSceneNode) {
        return SceneTreeRenderer.MeasureUtil.getScreenCoordinatesExtents((ISceneNode)iSceneNode, (int)((int)this._size.getWidth()), (int)((int)this._size.getHeight()));
    }

    void setUsesFractionalFontMetrics(boolean bl) {
        if (this._renderer instanceof PaintRenderer) {
            ((PaintRenderer)this._renderer).setUsesFractionalFontMetrics(bl);
        }
    }
}

