/*
 * Decompiled with CFR 0.152.
 */
package com.qfw.V4toV5;

import com.qfw.V4toV5.IntraBeringUpgrade;
import com.qfw.V4toV5.V4toV5QuerySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IntraBeringMunConversion {
    public static String _upgradeResponse = "upgradeResponse";
    public static String _mun = "mun";
    public static String _replacement = "replacement";
    public static String _member = "member";
    public static String _members = "members";
    public static String _atMEMBER = "@MEMBER";
    public static String _PC = "PC";
    public static String _UTF8 = "UTF8";
    public static String _arrowGT = "-&gt;";
    public static String _arrow = "->";
    public static String _munSym = "->:";
    public static String _leftBracket = "(";
    public static String _rightBracket = ")";
    public static String _Root = "Root";
    public static String _aster = "*";
    public String _sUpgradeMunsReq = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><upgradeMembers><members><member>[national].[Date].[Date].[Quarter]-&gt;:[PC].[Date (Root)].[19930101-19931231].[19930101-19930331]</member><member>[national].[Date].[Date].[Quarter] ->:[PC].[Date (Root)].[19930101-19931231].[19930401-19930630]</member><member>[national].[Line].[Line].[Line]-&gt;:[PC].[Line (Root)]</member><member>[national].[Line].[Line].[Line]-&gt;:[PC].[]</member><member>[national].[Line].[Line].[Line]-&gt;:[PC].[*]</member><member>[national].[Date].[Date].[Quarter]-&gt;:[PC].[Date (Root)].[19930101-19931231].[19930101-19930331]</member><member>[national].[Date].[Date].[Quarter] -&gt;: [PC].[Date (Root)].[19930101-19931231].[19930401-19930630]</member><member>[national].[Date].[Date].[Quarter]-&gt; :[PC].[Date (Root)].[19930101-19931231].[19930701-19930930]</member></members></upgradeMembers>";
    private Document m_retDoc = null;
    private Document m_doc = null;
    private Element m_retRootElem = null;
    private static final int minimun_num_of_parts3 = 2;

    public String doMUNListConversion(String munList) {
        String errMsg = null;
        try {
            ByteArrayInputStream theInputStream = new ByteArrayInputStream(munList.getBytes(_UTF8));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theInputStream);
            errMsg = this.doMUNConversionFromList();
        }
        catch (Exception e) {
            this.createErrorMessage(e.getMessage());
        }
        if (errMsg != null) {
            this.createErrorMessage(errMsg);
        }
        return this.convertToString();
    }

    public String doMUNConversion(String inputMun) throws Exception {
        String newMunStr = null;
        try {
            V4toV5QuerySet v4V5object = new V4toV5QuerySet();
            newMunStr = this.convertSingleMun(inputMun, v4V5object);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (newMunStr != null) {
            return newMunStr;
        }
        return inputMun;
    }

    protected String convertToString() {
        try {
            OutputFormat format = new OutputFormat(this.m_retDoc);
            ByteArrayOutputStream theOut = new ByteArrayOutputStream();
            XMLSerializer output = new XMLSerializer((OutputStream)theOut, format);
            output.serialize(this.m_retDoc);
            return theOut.toString(_UTF8);
        }
        catch (IOException e) {
            return "<Exception>empty</Exception>";
        }
    }

    private String doMUNConversionFromList() {
        Element inputRootElem;
        String rootTagName;
        if (this.m_retDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_retDoc = builder.newDocument();
                this.m_retRootElem = this.m_retDoc.createElement(_upgradeResponse);
                this.m_retDoc.appendChild(this.m_retRootElem);
            }
            catch (Exception e) {
                return "Error in creating return instance: " + e.getMessage();
            }
        }
        if ((rootTagName = (inputRootElem = this.m_doc.getDocumentElement()).getTagName()).compareTo("upgradeMembers") != 0) {
            String errors = "Input error for converting a list of MUNs";
            errors = errors + ": The input root tag name must be 'upgradeMembers'";
            return errors;
        }
        NodeList memberList = inputRootElem.getElementsByTagName(_member);
        Element theMembers = this.m_retDoc.createElement(_members);
        this.m_retRootElem.appendChild(theMembers);
        V4toV5QuerySet v4V5object = new V4toV5QuerySet();
        for (int i = 0; i < memberList.getLength(); ++i) {
            Element aMemberElem = (Element)memberList.item(i);
            StringBuffer munStrBuff = new StringBuffer();
            v4V5object.getTheText(aMemberElem, munStrBuff);
            String munStr = munStrBuff.toString();
            if (munStr.trim().length() == 0) continue;
            Element aMember = this.m_retDoc.createElement(_member);
            aMember.setAttribute(_mun, munStr);
            aMember.setAttribute(_replacement, munStr);
            theMembers.appendChild(aMember);
            String newMunStr = this.convertSingleMun(munStr, v4V5object);
            if (newMunStr == null) continue;
            aMember.setAttribute(_replacement, newMunStr);
        }
        return null;
    }

    private String convertSingleMun(String munStr, V4toV5QuerySet v4V5object) {
        Vector token = new Vector();
        Vector objPos = new Vector();
        if (!v4V5object.parseExpression(munStr, token, objPos)) {
            return null;
        }
        String newMunStr = null;
        if (token.size() != 3) {
            return null;
        }
        newMunStr = this.ConstructNewMun(token, v4V5object);
        return newMunStr;
    }

    private String ConstructNewMun(Vector token, V4toV5QuerySet v4V5object) {
        StringBuffer temp = (StringBuffer)token.get(1);
        String munSymStr = temp.toString();
        if (this.IsTwoNamePartsMun(munSymStr)) {
            Vector nameParts3;
            Vector nameParts1 = new Vector();
            StringBuffer modelPart = (StringBuffer)token.get(0);
            if (!v4V5object.getNameParts(modelPart, nameParts1)) {
                return null;
            }
            if (nameParts1.size() != 3 && nameParts1.size() != 4) {
                return null;
            }
            String newMunStr = null;
            newMunStr = modelPart.toString();
            newMunStr = newMunStr + _munSym;
            StringBuffer physicalPart = (StringBuffer)token.get(2);
            if (!v4V5object.getNameParts(physicalPart, nameParts3 = new Vector())) {
                return null;
            }
            newMunStr = newMunStr + "[";
            String pcStr = (String)nameParts3.get(0);
            if (pcStr.compareTo(_PC) != 0 || nameParts3.size() < 2) {
                return null;
            }
            int size = nameParts3.size();
            for (int iii = 0; iii < size; ++iii) {
                String nameStr = (String)nameParts3.get(iii);
                boolean last = false;
                if (iii == 1) {
                    nameStr = _atMEMBER;
                    last = true;
                }
                if (iii > 0) {
                    newMunStr = newMunStr + ".[";
                }
                newMunStr = newMunStr + nameStr;
                newMunStr = newMunStr + "]";
                if (!last) continue;
                newMunStr = newMunStr + ".[";
                String lastMemberStr = (String)nameParts3.get(size - 1);
                String secndPartStr = (String)nameParts3.get(1);
                newMunStr = (size == 2 || size == 3 && secndPartStr.compareTo(_atMEMBER) == 0) && this.IsRootMember(lastMemberStr) ? newMunStr + _aster : newMunStr + lastMemberStr;
                newMunStr = newMunStr + "]";
                break;
            }
            return newMunStr;
        }
        return null;
    }

    private boolean IsRootMember(String lastMemberStr) {
        String inputStr = lastMemberStr.trim();
        if (inputStr.length() == 0) {
            return true;
        }
        if (inputStr.compareTo(_aster) == 0) {
            return true;
        }
        if (!inputStr.endsWith(_rightBracket)) {
            return false;
        }
        int indexLeft = inputStr.indexOf(_leftBracket);
        if (indexLeft == -1) {
            return false;
        }
        int indexRight = inputStr.indexOf(_rightBracket);
        String rootStr = inputStr.substring(indexLeft + 1, indexRight);
        return rootStr.trim().compareTo(_Root) == 0;
    }

    private boolean IsTwoNamePartsMun(String munStr) {
        String munSymStr = munStr.trim();
        if (!munSymStr.startsWith(_arrow) && !munSymStr.startsWith(_arrowGT)) {
            return false;
        }
        int index = munSymStr.indexOf(":");
        if (index == -1) {
            return false;
        }
        String arrowStr = munSymStr.substring(0, index);
        return arrowStr.trim().compareTo(_arrow) == 0 || arrowStr.trim().compareTo(_arrowGT) == 0;
    }

    public static void main(String[] args) {
        IntraBeringMunConversion theConverter = new IntraBeringMunConversion();
        try {
            if (args.length >= 2) {
                String thefileName = args[0];
                FileInputStream theFilestr = new FileInputStream(thefileName);
                theConverter.setInputDoc(theFilestr);
                String outSrc = null;
                outSrc = theConverter.doMUNConversionFromList();
                String theOutfileName = args[1];
                FileOutputStream outs = new FileOutputStream(theOutfileName);
                if (outSrc != null) {
                    theConverter.createErrorMessage(outSrc);
                }
                String retMUNS = IntraBeringUpgrade.domDocToString(theConverter.getRetDoc(), true);
                outs.write(retMUNS.getBytes(_UTF8));
                outs.close();
            } else if (args.length == 1) {
                String inputMun = args[0];
                if (inputMun.compareToIgnoreCase("test") == 0) {
                    System.out.println("Input : \n" + theConverter._sUpgradeMunsReq);
                    String test = theConverter.doMUNListConversion(theConverter._sUpgradeMunsReq);
                    System.out.println("Output: \n" + test);
                    System.exit(0);
                } else {
                    String testSingleMun = theConverter.doMUNConversion(inputMun);
                    System.out.println("Input : " + inputMun);
                    System.out.println("Output: " + testSingleMun);
                }
            } else {
                System.out.println("Input is incorrect");
            }
        }
        catch (Exception e) {
            System.out.println("I got <Exception>" + e.getMessage() + "</Exception>");
            System.exit(0);
        }
    }

    private Document getRetDoc() {
        return this.m_retDoc;
    }

    private void setInputDoc(FileInputStream theFilestr) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theFilestr);
        }
        catch (Exception e) {
            System.out.println("I got <Exception>" + e.getMessage() + "</Exception>");
            System.exit(1);
        }
    }

    private void createErrorMessage(String errorMsg) {
        Element errorElem = this.m_retDoc.createElement("Exception");
        Text theExpString = this.m_retDoc.createTextNode(errorMsg);
        errorElem.appendChild(theExpString);
        this.m_retRootElem.appendChild(errorElem);
    }
}

