/*
 * Decompiled with CFR 0.152.
 */
package com.qfw.V4toV5;

import com.qfw.V4toV5.V4toV5QuerySet;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IntraBeringUpgrade {
    public static String _queryResultDefinition = "queryResultDefinition";
    public static String _edgeGroups = "edgeGroups";
    public static String _edgeGroup = "edgeGroup";
    public static String _valueSet = "valueSet";
    public static String _refQuery = "refQuery";
    public static String _refDataItem = "refDataItem";
    public static String _expression = "expression";
    public static String _dataItem = "dataItem";
    public static String _name = "name";
    public static String _currentMeasure = "currentMeasure";
    public static String _within = "within";
    public static String _querySet = "querySet";
    public static String _query = "query";
    public static String _queries = "queries";
    public static String _valueSets = "valueSets";
    public static String _ret = "ret";
    public static String _set = "set";
    public static String _detail = "detail";
    public static String _SET = "SET";
    public static String _DETAIL = "DETAIL";
    public static String _UTF8 = "UTF8";
    public static String _solveOrder = "solveOrder";
    private Document m_v5RetDoc = null;
    private Document m_doc = null;
    private Element m_v5RetRootElem = null;

    public Document doConversionV5(Document V5Queries) {
        try {
            this.m_doc = V5Queries;
            this.doConversionFromInputDoc();
        }
        catch (Exception e) {
            String errStr = e.getMessage();
            Element errorElem = this.m_v5RetDoc.createElement("Exception");
            Text theExpString = this.m_v5RetDoc.createTextNode(errStr);
            errorElem.appendChild(theExpString);
            this.m_v5RetRootElem.appendChild(errorElem);
        }
        return this.m_v5RetDoc;
    }

    private boolean mayNeedConversion(Element inputElement, Map result) {
        NodeList qRDList = inputElement.getElementsByTagName(_queryResultDefinition);
        for (int index = 0; index < qRDList.getLength(); ++index) {
            Element aQRD = (Element)qRDList.item(index);
            NodeList edgeGroupSList = aQRD.getElementsByTagName(_edgeGroups);
            for (int i = 0; i < edgeGroupSList.getLength(); ++i) {
                Element aEdgeGroupS = (Element)edgeGroupSList.item(i);
                this.checkEdgeGroups(aEdgeGroupS, aQRD, result);
            }
        }
        return result.size() > 0;
    }

    private void checkEdgeGroups(Element aEDGS, Element aQRD, Map result) {
        String refQueryName;
        int numOfEdgeGroup = 0;
        int numOfValueSet = 0;
        Vector<Pair> diNameVaSetPairs = new Vector<Pair>();
        for (Node edgeGroupChild = aEDGS.getFirstChild(); edgeGroupChild != null; edgeGroupChild = edgeGroupChild.getNextSibling()) {
            if (edgeGroupChild.getNodeType() != 1) continue;
            ++numOfEdgeGroup;
            for (Node firstChildUnderEdgeGroup = edgeGroupChild.getFirstChild(); firstChildUnderEdgeGroup != null; firstChildUnderEdgeGroup = firstChildUnderEdgeGroup.getNextSibling()) {
                Element valuSetsElem;
                NodeList valueSetList;
                if (firstChildUnderEdgeGroup.getNodeType() != 1) continue;
                if (firstChildUnderEdgeGroup.getNodeName().compareTo(_edgeGroups) == 0) {
                    this.checkEdgeGroups((Element)firstChildUnderEdgeGroup, aQRD, result);
                }
                if (firstChildUnderEdgeGroup.getNodeName().compareTo(_valueSets) != 0 || (valueSetList = (valuSetsElem = (Element)firstChildUnderEdgeGroup).getElementsByTagName(_valueSet)).getLength() != 1) continue;
                Element theValueSet = (Element)valueSetList.item(0);
                String dataItemName = theValueSet.getAttribute(_refDataItem);
                Pair aPair = new Pair(dataItemName, theValueSet);
                diNameVaSetPairs.add(aPair);
                ++numOfValueSet;
            }
        }
        if (numOfEdgeGroup == 2 && numOfValueSet == 2 && diNameVaSetPairs.size() != 0 && this.isSummarizingSiblingDataItem(refQueryName = aQRD.getAttribute(_refQuery), diNameVaSetPairs)) {
            boolean alreadyExists = false;
            if (result.containsKey(refQueryName)) {
                Vector temp = (Vector)result.get(refQueryName);
                temp.addAll(diNameVaSetPairs);
                alreadyExists = true;
            }
            if (!alreadyExists) {
                result.put(refQueryName, diNameVaSetPairs);
            }
        }
    }

    private boolean isSummarizingSiblingDataItem(String queryName, Vector itemPairs) {
        if (this.m_v5RetRootElem == null || itemPairs.size() != 2) {
            return false;
        }
        NodeList queryList = this.m_v5RetRootElem.getElementsByTagName(_query);
        String nonSummaryItem = null;
        String summaryItemName = null;
        boolean queryFound = false;
        for (int i = 0; i < queryList.getLength() && !queryFound; ++i) {
            Element aQElem = (Element)queryList.item(i);
            NodeList DIList = aQElem.getElementsByTagName(_dataItem);
            if (queryName.compareTo(aQElem.getAttribute(_name)) != 0) continue;
            queryFound = true;
            for (int ii = 0; ii < DIList.getLength(); ++ii) {
                Element DIElem = (Element)DIList.item(ii);
                String dataItemName = DIElem.getAttribute(_name);
                if (this.getSecondViaFirst(itemPairs, dataItemName) == null) continue;
                NodeList theExprList = DIElem.getElementsByTagName(_expression);
                Element theExprElem = (Element)theExprList.item(0);
                StringBuffer exprStr = new StringBuffer();
                this.getTheText(theExprElem, exprStr);
                Vector words = new Vector();
                StringBuffer startPos = new StringBuffer();
                StringBuffer tokenCount = new StringBuffer();
                boolean detected = IntraBeringUpgrade.expressionPatternDetected(exprStr.toString(), words, startPos, tokenCount);
                if (!detected) {
                    nonSummaryItem = dataItemName;
                    continue;
                }
                int sp = new Integer(startPos.toString());
                String fromCurrentMeasureStr = exprStr.substring(sp, exprStr.length());
                summaryItemName = this.getItemFromExpression(fromCurrentMeasureStr);
            }
        }
        if (nonSummaryItem != null && summaryItemName != null) {
            return nonSummaryItem.compareTo(summaryItemName) == 0;
        }
        return false;
    }

    private String getItemFromExpression(String restStr) {
        String summarizedDIName = null;
        StringBuffer theExpr = new StringBuffer(restStr);
        Vector token = new Vector();
        Vector objPos = new Vector();
        V4toV5QuerySet v4V5object = new V4toV5QuerySet();
        if (!v4V5object.parseExpression(theExpr.toString(), token, objPos) || objPos.isEmpty()) {
            return null;
        }
        StringBuffer theObj = new StringBuffer();
        for (int i = 0; i < objPos.size(); ++i) {
            Integer theInt = (Integer)objPos.get(i);
            int objIdx = theInt;
            theObj = (StringBuffer)token.get(objIdx);
        }
        Vector nameParts = new Vector();
        v4V5object.getNameParts(theObj, nameParts);
        if (nameParts.size() != 1) {
            return null;
        }
        summarizedDIName = (String)nameParts.get(0);
        return summarizedDIName;
    }

    private void convertStringToDoc(InputStream theStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theStream);
        }
        catch (Exception e) {
            System.out.println("<Exception>" + e.getMessage() + "</Exception>");
        }
    }

    private boolean doConversionFromInputDoc() {
        Element querySetElem;
        Element inputRootElem;
        String rootTagName;
        if (this.m_v5RetDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_v5RetDoc = builder.newDocument();
                this.m_v5RetRootElem = this.m_v5RetDoc.createElement(_ret);
                this.m_v5RetDoc.appendChild(this.m_v5RetRootElem);
            }
            catch (Exception e) {
                System.out.println("Error in creating ret instance");
                return false;
            }
        }
        if (!(rootTagName = (inputRootElem = this.m_doc.getDocumentElement()).getTagName()).equals(_querySet)) {
            NodeList allQuerySetItems = inputRootElem.getElementsByTagName(_querySet);
            querySetElem = (Element)allQuerySetItems.item(0);
        } else {
            querySetElem = inputRootElem;
        }
        Node tempNode = this.m_v5RetDoc.importNode(querySetElem, true);
        this.m_v5RetRootElem.appendChild((Element)tempNode);
        HashMap retMap = new HashMap();
        if (!this.mayNeedConversion(this.m_v5RetRootElem, retMap)) {
            return false;
        }
        NodeList queryList = this.m_v5RetRootElem.getElementsByTagName(_query);
        this.doPatternReplacement(queryList, retMap);
        return true;
    }

    private void doPatternReplacement(NodeList queryList, HashMap retMap) {
        for (int i = 0; i < queryList.getLength(); ++i) {
            Element aQElem = (Element)queryList.item(i);
            String queryName = aQElem.getAttribute(_name);
            if (!retMap.containsKey(queryName)) continue;
            Vector dataItemVector = (Vector)retMap.get(queryName);
            NodeList DIList = aQElem.getElementsByTagName(_dataItem);
            for (int ii = 0; ii < DIList.getLength(); ++ii) {
                Element DIElem = (Element)DIList.item(ii);
                String dataItemName = DIElem.getAttribute(_name);
                Element aValueSet = (Element)this.getSecondViaFirst(dataItemVector, dataItemName);
                if (aValueSet == null) continue;
                NodeList theExprList = DIElem.getElementsByTagName(_expression);
                Element oldExprElem = (Element)theExprList.item(0);
                StringBuffer exprStr = new StringBuffer();
                this.getTheText(oldExprElem, exprStr);
                StringBuffer newExprStr = new StringBuffer();
                if (!this.patternReplacementIsNeeded(exprStr, newExprStr)) continue;
                this.replaceTheExpression(DIElem, oldExprElem, newExprStr.toString());
                aValueSet.setAttribute(_solveOrder, "1");
            }
        }
    }

    public void replaceTheExpression(Element theV5DIElem, Element oldExprElem, String newExprStr) {
        Element theV5Expr = (Element)oldExprElem.cloneNode(false);
        Text theExpString = this.m_v5RetDoc.createTextNode(newExprStr);
        theV5Expr.appendChild(theExpString);
        theV5DIElem.replaceChild(theV5Expr, oldExprElem);
    }

    private boolean patternReplacementIsNeeded(StringBuffer exprStr, StringBuffer newExprStr) {
        Vector<String> words = new Vector<String>();
        StringBuffer startPos = new StringBuffer();
        StringBuffer tokenCount = new StringBuffer();
        if (IntraBeringUpgrade.expressionPatternDetected(exprStr.toString(), words, startPos, tokenCount)) {
            String tempString = (String)words.get(2);
            if (tempString.startsWith(_set)) {
                tempString = IntraBeringUpgrade.replacePattern(tempString, _set, _detail);
            } else if (tempString.startsWith(_SET)) {
                tempString = IntraBeringUpgrade.replacePattern(tempString, _SET, _DETAIL);
            }
            words.set(2, tempString);
            int sp = new Integer(startPos.toString());
            int token = new Integer(tokenCount.toString());
            String functionStr = exprStr.substring(0, sp);
            functionStr = functionStr.trim();
            newExprStr.append(functionStr.toString());
            for (int idx = 0; idx < token; ++idx) {
                newExprStr.append((String)words.get(idx));
                newExprStr.append(" ");
            }
            return true;
        }
        return false;
    }

    private static boolean expressionPatternDetected(String exprStr, Vector words, StringBuffer startPos, StringBuffer tokenCount) {
        int startPosition = exprStr.indexOf(_currentMeasure);
        Integer newInt = new Integer(startPosition);
        startPos.delete(0, startPos.length());
        startPos.append(newInt);
        if (startPosition == -1) {
            return false;
        }
        if (startPosition != 0 && '[' == exprStr.charAt(startPosition - 1)) {
            return false;
        }
        String functionStr = exprStr.substring(0, startPosition);
        if (!(functionStr = functionStr.trim()).endsWith("(")) {
            return false;
        }
        String currentMeasureStr = exprStr.substring(startPosition);
        StringTokenizer st = new StringTokenizer(currentMeasureStr);
        Integer tokenCount1 = new Integer(st.countTokens());
        tokenCount.delete(0, tokenCount.length());
        tokenCount.append(tokenCount1);
        int idx = 0;
        while (st.hasMoreTokens()) {
            words.add(idx, st.nextToken());
            ++idx;
        }
        if (!((String)words.get(1)).equalsIgnoreCase(_within)) {
            return false;
        }
        return (false != ((String)words.get(2)).startsWith(_set) || false != ((String)words.get(2)).startsWith(_SET)) && true != ((String)words.get(2)).endsWith("SET]") && true != ((String)words.get(2)).endsWith("set]");
    }

    public static String replacePattern(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuffer sb = new StringBuffer();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }

    public boolean getTheText(Element theElem, StringBuffer theText) {
        Vector<Node> r = new Vector<Node>();
        for (Node n = theElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            r.addElement(n);
        }
        if (r.isEmpty()) {
            return false;
        }
        for (int i = 0; i < r.size(); ++i) {
            Text txt = (Text)r.get(i);
            theText.append(txt.getNodeValue());
        }
        return true;
    }

    public static String domDocToString(Document doc, boolean bPrettyPrint) {
        try {
            OutputFormat format = new OutputFormat(doc);
            if (bPrettyPrint) {
                format.setLineSeparator("\r\n");
                format.setIndenting(true);
                format.setLineWidth(0);
                format.setPreserveSpace(true);
            }
            ByteArrayOutputStream theOut = new ByteArrayOutputStream();
            XMLSerializer output = new XMLSerializer((OutputStream)theOut, format);
            output.serialize(doc);
            return theOut.toString(_UTF8);
        }
        catch (IOException e) {
            return "<Exception>empty</Exception>";
        }
    }

    public static void main(String[] args) {
        boolean qcSanityUpgrade = false;
        if (args.length == 3 && args[2].equalsIgnoreCase("QC")) {
            qcSanityUpgrade = true;
        }
        if (args.length >= 2) {
            try {
                String thefileName = args[0];
                FileInputStream theFilestr = new FileInputStream(thefileName);
                IntraBeringUpgrade theConverter = new IntraBeringUpgrade();
                theConverter.convertStringToDoc(theFilestr);
                theConverter.doConversionFromInputDoc();
                String theOutfileName = args[1];
                FileOutputStream outs = new FileOutputStream(theOutfileName);
                String outSrc = IntraBeringUpgrade.domDocToString(theConverter.getRetDoc(qcSanityUpgrade), true);
                outs.write(outSrc.getBytes(_UTF8));
                outs.close();
            }
            catch (Exception e) {
                System.out.println("I got <Exception>" + e.getMessage() + "</Exception>");
                System.exit(1);
            }
            System.exit(0);
        } else {
            System.out.println("Input is incorrect");
        }
    }

    private Document getRetDoc(boolean upgradeQCtest) {
        if (!upgradeQCtest) {
            return this.m_v5RetDoc;
        }
        return this.getQuerySetDoc();
    }

    private Document getQuerySetDoc() {
        Document m_qcDoc = this.m_doc;
        Element retQueryElem = this.m_v5RetDoc.getDocumentElement();
        NodeList retQuerySetElem = retQueryElem.getElementsByTagName(_querySet);
        Element querySetElem = (Element)retQuerySetElem.item(0);
        Element inputRootElem = m_qcDoc.getDocumentElement();
        NodeList inputQuerySetNode = inputRootElem.getElementsByTagName(_querySet);
        Element inputQuerySetElem = (Element)inputQuerySetNode.item(0);
        Element newQuerySetElem = (Element)m_qcDoc.importNode(querySetElem, true);
        NodeList newQueriesNode = newQuerySetElem.getElementsByTagName(_queries);
        Element newQueriesElem = (Element)newQueriesNode.item(0);
        NodeList oldQueriesNode = inputQuerySetElem.getElementsByTagName(_queries);
        Element oldQueriesElem = (Element)oldQueriesNode.item(0);
        inputQuerySetElem.replaceChild(newQueriesElem, oldQueriesElem);
        return m_qcDoc;
    }

    private Object getSecondViaFirst(Vector pairVector, String first) {
        for (int i = 0; i < pairVector.size(); ++i) {
            Pair aPair = (Pair)pairVector.get(i);
            String aFirst = (String)aPair.getFirst();
            if (aFirst.compareTo(first) != 0) continue;
            return aPair.getSecond();
        }
        return null;
    }

    private class Pair {
        private Object first;
        private Object second;

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public Object getFirst() {
            return this.first;
        }

        public Object getSecond() {
            return this.second;
        }
    }
}

