/*
 * Decompiled with CFR 0.152.
 */
package com.qfw.V4toV5;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class QueryUpgradeProperties {
    private Properties cfgProperties = null;

    QueryUpgradeProperties() {
        this.loadConfigurationProperties();
    }

    public String getString(String key, String defaultValue) {
        String result = defaultValue;
        if (this.cfgProperties.containsKey(key)) {
            result = this.cfgProperties.getProperty(key);
        }
        return result;
    }

    public int getInteger(String key, int defaultValue) {
        int result = defaultValue;
        String intString = this.getString(key, null);
        if (intString != null) {
            result = Integer.parseInt(intString);
        }
        return result;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean result = defaultValue;
        String booleanString = this.getString(key, null);
        if (booleanString != null) {
            Boolean bool = new Boolean(booleanString);
            result = bool;
        }
        return result;
    }

    private void loadConfigurationProperties() {
        File configurationFile = null;
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        String configrationDirString = cfg.resolveEffectivePath("../configuration");
        File configurationDir = new File(configrationDirString);
        if (configurationDir.isDirectory()) {
            configurationFile = new File(configurationDir, "queryupgrade.properties");
        }
        this.cfgProperties = new Properties();
        if (configurationFile != null && configurationFile.isFile()) {
            try {
                FileInputStream inputStream = new FileInputStream(configurationFile);
                this.cfgProperties.load(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

