/*
 * Decompiled with CFR 0.152.
 */
package com.qfw.V4toV5;

import com.qfw.V4toV5.V4toV5QuerySet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class V4toV5QRD {
    private static final String _command = "command";
    private static final String _commandID = "commandID";
    private static final String _requestID = "requestID";
    private static final String _connection = "connection";
    private static final String _productLocale = "productLocale";
    private static final String _runLocale = "runLocale";
    private static final String _execute = "execute";
    private static final String _validate = "validate";
    private static final String _refQuery = "refQuery";
    private static final String _refDataItem = "refDataItem";
    private static final String _name = "name";
    private static final String _value = "value";
    private static final String _dataItemRef = "dataItemRef";
    private static final String _dataSourceType = "dataSourceType";
    private static final String _QueryFrameworkService = "QueryFrameworkService";
    private static final String _parameters = "parameters";
    private static final String _querySet = "querySet";
    private static final String _xml_lang = "xml:lang";
    private static final String _Model = "Model";
    private static final String _Database = "Database";
    private static final String _modelPath = "modelPath";
    private static final String _designMode = "designMode";
    private static final String _noDataMode = "noDataMode";
    private static final String _requestHints = "requestHints";
    private static final String _enabled = "enabled";
    private static final String _BIQuery = "BIQuery";
    private static final String _summary = "summary";
    private static final String _cube = "cube";
    private static final String _tabularModel = "tabularModel";
    private static final String _tabularSQL = "tabularSQL";
    private static final String _tabularSet = "tabularSet";
    private static final String _query = "query";
    private static final String _selection = "selection";
    private static final String _dataItem = "dataItem";
    private static final String _queryResultDefinitions = "queryResultDefinitions";
    private static final String _queryResultDefinition = "queryResultDefinition";
    private static final String _edges = "edges";
    private static final String _edge = "edge";
    private static final String _level = "level";
    private static final String _cellMembers = "cellMembers";
    private static final String _dataCells = "dataCells";
    private static final String _item = "item";
    private static final String _edgeGroups = "edgeGroups";
    private static final String _edgeGroup = "edgeGroup";
    private static final String _valueSets = "valueSets";
    private static final String _valueSet = "valueSet";
    private static final String _factList = "factList";
    private static final String _groupBody = "groupBody";
    private static final String _groupBodyName = "_groupBody";
    private static final String _alias = "alias";
    private static final String _refLevel = "refLevel";
    private static final String _isHeader = "isHeader";
    private static final String _true = "true";
    private static final String _aggregate = "aggregate";
    private static final String _none = "none";
    private static final String _groupHeader = "groupHeader";
    private static final String _refItem = "refItem";
    private static final String _groupFooter = "groupFooter";
    private static final String _dimension = "dimension";
    private static final String _groupHeaderName = "_groupHeader";
    private static final String _groupFooterName = "_groupFooter";
    private static final String _key = "key";
    private Document m_doc;
    private Element m_rootElem;
    private Element m_connectionElem;
    private Document m_retDoc;
    private Element m_retRootElem;
    private Element m_retHeaderElem;
    private Element m_retFooterElem;
    private int m_valueSetId = 0;

    public static void main(String[] args) {
        if (2 != args.length) {
            System.out.println("Need input and output file names");
            System.exit(1);
        }
        try {
            String theInFileName = args[0];
            FileInputStream theFilestr = new FileInputStream(theInFileName);
            String theOutfileName = args[1];
            FileOutputStream outs = new FileOutputStream(theOutfileName);
            V4toV5QRD theQRD = new V4toV5QRD();
            theQRD.genQRD(theFilestr, outs);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void genQRD(FileInputStream theFilestr, FileOutputStream outs) {
        Element theV5Ele;
        Element v4Ele;
        DocumentBuilderFactory factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theFilestr);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.m_rootElem = this.m_doc.getDocumentElement();
        if (!this.m_rootElem.getTagName().equals(_command)) {
            System.out.println("root must be <command>");
            return;
        }
        try {
            factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.m_retDoc = builder.newDocument();
            this.m_retRootElem = this.m_retDoc.createElement(_command);
            this.m_retDoc.appendChild(this.m_retRootElem);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        V4toV5QuerySet theConverter = new V4toV5QuerySet();
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(this.m_rootElem, _commandID, v4Elems);
        if (1 == v4Elems.size() && (v4Ele = (Element)v4Elems.firstElement()).hasAttribute(_value)) {
            theV5Ele = this.m_retDoc.createElement(_commandID);
            theV5Ele.setAttribute(_value, v4Ele.getAttribute(_value));
            this.m_retRootElem.appendChild(theV5Ele);
        }
        v4Elems.clear();
        theConverter.getChildElementsByTagName(this.m_rootElem, _requestID, v4Elems);
        if (1 == v4Elems.size() && (v4Ele = (Element)v4Elems.firstElement()).hasAttribute(_value)) {
            theV5Ele = this.m_retDoc.createElement(_requestID);
            theV5Ele.setAttribute(_value, v4Ele.getAttribute(_value));
            this.m_retRootElem.appendChild(theV5Ele);
        }
        v4Elems.clear();
        theConverter.getChildElementsByTagName(this.m_rootElem, _connection, v4Elems);
        if (1 != v4Elems.size()) {
            System.out.println("<connection> is required");
            return;
        }
        this.m_connectionElem = (Element)v4Elems.firstElement();
        this.genConnection(theConverter);
        v4Elems.clear();
        theConverter.getChildElementsByTagName(this.m_rootElem, _execute, v4Elems);
        if (1 == v4Elems.size()) {
            v4Ele = (Element)v4Elems.firstElement();
            theV5Ele = this.m_retDoc.createElement(_execute);
            this.genQuerySet(theConverter, v4Ele, theV5Ele);
            this.copyParms(theConverter, v4Ele, theV5Ele);
            this.m_retRootElem.appendChild(theV5Ele);
        }
        v4Elems.clear();
        theConverter.getChildElementsByTagName(this.m_rootElem, _validate, v4Elems);
        if (1 == v4Elems.size()) {
            v4Ele = (Element)v4Elems.firstElement();
            theV5Ele = this.m_retDoc.createElement(_validate);
            this.genQuerySet(theConverter, v4Ele, theV5Ele);
            this.copyParms(theConverter, v4Ele, theV5Ele);
            this.m_retRootElem.appendChild(theV5Ele);
        }
        try {
            OutputFormat format = new OutputFormat(this.m_retDoc);
            XMLSerializer output = new XMLSerializer((OutputStream)outs, format);
            output.serialize(this.m_retDoc);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    protected void genConnection(V4toV5QuerySet theConverter) {
        Element theV5Ele;
        Element v4Ele;
        Element theV5ConnEle = this.m_retDoc.createElement(_connection);
        Element theV5PTypeEle = this.m_retDoc.createElement(_dataSourceType);
        theV5PTypeEle.setAttribute(_value, _QueryFrameworkService);
        theV5ConnEle.appendChild(theV5PTypeEle);
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(this.m_connectionElem, _productLocale, v4Elems);
        if (1 == v4Elems.size() && (v4Ele = (Element)v4Elems.firstElement()).hasAttribute(_value)) {
            theV5Ele = this.m_retDoc.createElement(_productLocale);
            theV5Ele.setAttribute(_value, v4Ele.getAttribute(_value));
            theV5ConnEle.appendChild(theV5Ele);
        }
        v4Elems.clear();
        theConverter.getChildElementsByTagName(this.m_connectionElem, _runLocale, v4Elems);
        if (1 == v4Elems.size()) {
            v4Ele = (Element)v4Elems.firstElement();
            if (v4Ele.hasAttribute(_value)) {
                theV5Ele = this.m_retDoc.createElement(_runLocale);
                theV5Ele.setAttribute(_value, v4Ele.getAttribute(_value));
                theV5ConnEle.appendChild(theV5Ele);
            } else {
                StringBuffer theRunLocale = new StringBuffer();
                if (theConverter.getTheText(v4Ele, theRunLocale) && theRunLocale.length() > 0) {
                    Element theV5Ele2 = this.m_retDoc.createElement(_runLocale);
                    theV5Ele2.setAttribute(_value, theRunLocale.toString());
                    theV5ConnEle.appendChild(theV5Ele2);
                }
            }
        }
        Vector v4ConnElems = new Vector();
        theConverter.getChildElementsByTagName(this.m_connectionElem, _connection, v4ConnElems);
        for (int i = 0; i < v4ConnElems.size(); ++i) {
            Element v4ConnEle = (Element)v4ConnElems.get(i);
            Vector v4Elems_1 = new Vector();
            theConverter.getChildElementsByTagName(v4ConnEle, _dataSourceType, v4Elems_1);
            if (1 == v4Elems_1.size()) {
                String dsType;
                StringBuffer theText = new StringBuffer();
                theConverter.getTheText((Element)v4Elems_1.firstElement(), theText);
                if (0 != theText.length() && (dsType = theText.toString()).equalsIgnoreCase(_Model)) continue;
            }
            Node v5Conn = this.m_retDoc.importNode(v4ConnEle, true);
            theV5ConnEle.appendChild(v5Conn);
        }
        this.m_retRootElem.appendChild(theV5ConnEle);
    }

    protected void copyParms(V4toV5QuerySet theConverter, Element v4Ele, Element theV5Ele) {
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(v4Ele, _parameters, v4Elems);
        if (1 == v4Elems.size()) {
            Element v4ParmsEle = (Element)v4Elems.firstElement();
            Node v5Parms = this.m_retDoc.importNode(v4ParmsEle, true);
            theV5Ele.appendChild(v5Parms);
        }
    }

    protected void genQuerySet(V4toV5QuerySet theConverter, Element v4Ele, Element theV5Ele) {
        String theLang;
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(v4Ele, _querySet, v4Elems);
        if (1 != v4Elems.size()) {
            return;
        }
        Element v4QuerySetEle = (Element)v4Elems.firstElement();
        Element theV5QuerySetEle = this.m_retDoc.createElement(_querySet);
        if (v4QuerySetEle.hasAttribute(_xml_lang) && (theLang = v4QuerySetEle.getAttribute(_xml_lang)).length() > 0) {
            theV5QuerySetEle.setAttribute(_xml_lang, theLang);
        }
        StringBuffer dsName = new StringBuffer();
        this.setModelPath(theConverter, theV5QuerySetEle, dsName);
        StringBuffer error = new StringBuffer();
        if (theConverter.genV5Queries(v4QuerySetEle, dsName, error)) {
            Element v5Queries = theConverter.getV5Queries();
            Node myV5 = this.m_retDoc.importNode(v5Queries, true);
            theV5QuerySetEle.appendChild(myV5);
            Vector v5MapsVec = new Vector();
            theConverter.getV5Maps(v5MapsVec);
            this.genQRD(theConverter, v4QuerySetEle, theV5QuerySetEle, v5Queries, v5MapsVec);
        }
        this.genRequestHints(theConverter, v4QuerySetEle, theV5QuerySetEle);
        theV5Ele.appendChild(theV5QuerySetEle);
    }

    protected void setModelPath(V4toV5QuerySet theConverter, Element theV5QuerySetEle, StringBuffer dsName) {
        boolean bModelPath = false;
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(this.m_connectionElem, _connection, v4Elems);
        for (int i = 0; i < v4Elems.size(); ++i) {
            String dsType;
            Element v4Ele = (Element)v4Elems.get(i);
            Vector v4Elems_1 = new Vector();
            theConverter.getChildElementsByTagName(v4Ele, _dataSourceType, v4Elems_1);
            if (1 != v4Elems_1.size()) continue;
            StringBuffer theText = new StringBuffer();
            theConverter.getTheText((Element)v4Elems_1.firstElement(), theText);
            if (0 == theText.length() || !(dsType = theText.toString()).equalsIgnoreCase(_Model) && !dsType.equalsIgnoreCase(_Database)) continue;
            v4Elems_1.clear();
            theConverter.getChildElementsByTagName(v4Ele, _name, v4Elems_1);
            if (1 != v4Elems_1.size()) continue;
            theText.delete(0, theText.length());
            theConverter.getTheText((Element)v4Elems_1.firstElement(), theText);
            if (0 == theText.length()) continue;
            String theDSName = theText.toString();
            if (dsType.equalsIgnoreCase(_Model)) {
                if (bModelPath) continue;
                Element theV5ModelPathEle = this.m_retDoc.createElement(_modelPath);
                Text theString = this.m_retDoc.createTextNode(theDSName);
                theV5ModelPathEle.appendChild(theString);
                theV5QuerySetEle.appendChild(theV5ModelPathEle);
                bModelPath = true;
                continue;
            }
            if (0 != dsName.length()) continue;
            dsName.append(theDSName);
        }
    }

    protected void genRequestHints(V4toV5QuerySet theConverter, Element v4QuerySetEle, Element theV5QuerySetEle) {
        Element theV5Ele;
        Element AItemElem;
        NodeList allDesignModes = v4QuerySetEle.getElementsByTagName(_designMode);
        NodeList allNoDataModes = v4QuerySetEle.getElementsByTagName(_noDataMode);
        if (0 == allDesignModes.getLength() && 0 == allNoDataModes.getLength()) {
            return;
        }
        Element theV5ReqHintsEle = this.m_retDoc.createElement(_requestHints);
        if (allDesignModes.getLength() > 0) {
            AItemElem = (Element)allDesignModes.item(0);
            theV5Ele = this.m_retDoc.createElement(_designMode);
            theV5Ele.setAttribute(_enabled, AItemElem.getAttribute(_enabled));
            theV5ReqHintsEle.appendChild(theV5Ele);
        }
        if (allNoDataModes.getLength() > 0) {
            AItemElem = (Element)allNoDataModes.item(0);
            theV5Ele = this.m_retDoc.createElement(_noDataMode);
            theV5Ele.setAttribute(_enabled, AItemElem.getAttribute(_enabled));
            theV5ReqHintsEle.appendChild(theV5Ele);
        }
        theV5QuerySetEle.appendChild(theV5ReqHintsEle);
    }

    protected void genQRD(V4toV5QuerySet theConverter, Element v4QuerySetEle, Element theV5QuerySetEle, Element v5Queries, Vector v5Maps) {
        Vector v4Elems = new Vector();
        theConverter.getChildElementsByTagName(v4QuerySetEle, _BIQuery, v4Elems);
        if (0 == v4Elems.size()) {
            return;
        }
        int thelastOne = v4Elems.size() - 1;
        Element theV4BIQuery = (Element)v4Elems.get(thelastOne);
        String v4QName = theV4BIQuery.getAttribute(_name);
        v4Elems.clear();
        theConverter.getChildElementsByTagName(theV4BIQuery, _summary, v4Elems);
        if (1 == v4Elems.size()) {
            Element theV4Summary = (Element)v4Elems.firstElement();
            this.genQRD4Summary(theConverter, v4QName, v5Maps, theV5QuerySetEle, theV4Summary);
            return;
        }
        theConverter.getChildElementsByTagName(theV4BIQuery, _cube, v4Elems);
        if (1 == v4Elems.size()) {
            Element theV4Cube = (Element)v4Elems.firstElement();
            this.genQRD4Cube(theConverter, v4QName, theV5QuerySetEle, theV4Cube);
            return;
        }
        Vector v5Selections = new Vector();
        theConverter.getChildElementsByTagName(theV4BIQuery, _tabularModel, v4Elems);
        if (1 == v4Elems.size()) {
            Element theV4Tab = (Element)v4Elems.firstElement();
            this.getDataItemsFromSelection(theConverter, v4QName, v5Queries, v5Selections);
            this.genQRD4Tabular(theV5QuerySetEle, v4QName, v5Selections);
            return;
        }
        theConverter.getChildElementsByTagName(theV4BIQuery, _tabularSQL, v4Elems);
        if (1 == v4Elems.size()) {
            Element theV4Tab = (Element)v4Elems.firstElement();
            this.getDataItemsFromSelection(theConverter, v4QName, v5Queries, v5Selections);
            this.genQRD4Tabular(theV5QuerySetEle, v4QName, v5Selections);
            return;
        }
        theConverter.getChildElementsByTagName(theV4BIQuery, _tabularSet, v4Elems);
        if (1 == v4Elems.size()) {
            Element theV4Tab = (Element)v4Elems.firstElement();
            this.getDataItemsFromSelection(theConverter, v4QName, v5Queries, v5Selections);
            this.genQRD4Tabular(theV5QuerySetEle, v4QName, v5Selections);
            return;
        }
    }

    protected void getDataItemsFromSelection(V4toV5QuerySet theConverter, String qName, Element v5Queries, Vector v5Selections) {
        Vector v5Elems = new Vector();
        theConverter.getChildElementsByTagNameAndAttribue(v5Queries, _query, _name, qName, v5Elems);
        if (1 != v5Elems.size()) {
            return;
        }
        Element theV5Query = (Element)v5Elems.firstElement();
        v5Elems.clear();
        theConverter.getChildElementsByTagName(theV5Query, _selection, v5Elems);
        if (1 != v5Elems.size()) {
            return;
        }
        Element theV5Seletion = (Element)v5Elems.firstElement();
        v5Elems.clear();
        theConverter.getChildElementsByTagName(theV5Seletion, _dataItem, v5Selections);
    }

    protected void genQRD4Summary(V4toV5QuerySet theConverter, String v4QName, Vector v5Maps, Element theV5QuerySetEle, Element theV4Summary) {
        Element v5QRDs = this.m_retDoc.createElement(_queryResultDefinitions);
        Element theV5QRDEle = this.m_retDoc.createElement(_queryResultDefinition);
        theV5QRDEle.setAttribute(_name, "theQRD");
        String v4RealQName = this.getRealQueryName(theConverter, v5Maps, v4QName);
        theV5QRDEle.setAttribute(_refQuery, v4RealQName);
        Element theV5EdgesEle = this.m_retDoc.createElement(_edges);
        HashSet<String> theSet = new HashSet<String>();
        theSet.add(new String("rowEdge"));
        theSet.add(new String("columnEdge"));
        theSet.add(new String("sectionEdge"));
        Vector v4EdgeVec = new Vector();
        theConverter.getChildElementsByTagNameSet(theV4Summary, theSet, v4EdgeVec);
        boolean bHasCellMembers = false;
        int i = 0;
        for (i = 0; i < v4EdgeVec.size(); ++i) {
            Element aEdge = (Element)v4EdgeVec.get(i);
            Element theV5EdgeEle = this.m_retDoc.createElement(_edge);
            if (aEdge.hasAttribute(_name)) {
                theV5EdgeEle.setAttribute(_name, aEdge.getAttribute(_name));
            } else {
                String nS = Integer.toString(i);
                theV5EdgeEle.setAttribute(_name, nS);
            }
            Vector v4Levels = new Vector();
            HashSet<String> theSet4Edge = new HashSet<String>();
            theSet4Edge.add(new String(_level));
            theSet4Edge.add(new String(_cellMembers));
            theConverter.getChildElementsByTagNameSet(aEdge, theSet4Edge, v4Levels);
            if (!bHasCellMembers) {
                for (int j = 0; j < v4Levels.size(); ++j) {
                    Element aLevel = (Element)v4Levels.get(j);
                    if (!aLevel.getTagName().equals(_cellMembers)) continue;
                    bHasCellMembers = true;
                    break;
                }
            }
            if (v4Levels.size() > 0) {
                this.genNestedGroupsEdge(theConverter, theV5EdgeEle, 0, v4Levels, v4QName, v4RealQName, v5Maps);
            }
            theV5EdgesEle.appendChild(theV5EdgeEle);
        }
        if (!bHasCellMembers) {
            v4EdgeVec.clear();
            theConverter.getChildElementsByTagName(theV4Summary, _dataCells, v4EdgeVec);
            if (1 == v4EdgeVec.size()) {
                Element theV5EdgeEle = this.m_retDoc.createElement(_edge);
                theV5EdgeEle.setAttribute(_name, _dataCells);
                Vector<String> nameVec = new Vector<String>();
                Element cell = (Element)v4EdgeVec.firstElement();
                v4EdgeVec.clear();
                theConverter.getChildElementsByTagName(cell, _item, v4EdgeVec);
                for (i = 0; i < v4EdgeVec.size(); ++i) {
                    Element a = (Element)v4EdgeVec.get(i);
                    nameVec.add(this.getRealItemName(theConverter, a, v5Maps, v4RealQName));
                }
                this.genAV5EdgesGroups(theV5EdgeEle, nameVec, false, false, false);
                theV5EdgesEle.appendChild(theV5EdgeEle);
            }
        }
        theV5QRDEle.appendChild(theV5EdgesEle);
        v5QRDs.appendChild(theV5QRDEle);
        theV5QuerySetEle.appendChild(v5QRDs);
    }

    protected void genNestedGroupsEdge(V4toV5QuerySet theConverter, Element theV5ParentEle, int pos, Vector v4Levels, String v4QName, String v4RealQName, Vector v5Maps) {
        Element theV5EdgeGrpsEle = this.m_retDoc.createElement(_edgeGroups);
        Element theV5EdgeGrpEle = this.m_retDoc.createElement(_edgeGroup);
        Element theV5EdgeVSetsEle = this.m_retDoc.createElement(_valueSets);
        Element aV4Level = (Element)v4Levels.get(pos);
        String tag = aV4Level.getTagName();
        if (tag.equals(_level)) {
            this.genLevel(theConverter, theV5EdgeVSetsEle, aV4Level, v4QName, v4RealQName, v5Maps);
        } else {
            this.genCellMembers(theConverter, theV5EdgeVSetsEle, v4QName);
        }
        theV5EdgeGrpEle.appendChild(theV5EdgeVSetsEle);
        int len = v4Levels.size();
        if (++pos < len) {
            this.genNestedGroupsEdge(theConverter, theV5EdgeGrpEle, pos, v4Levels, v4QName, v4RealQName, v5Maps);
        }
        theV5EdgeGrpsEle.appendChild(theV5EdgeGrpEle);
        theV5ParentEle.appendChild(theV5EdgeGrpsEle);
    }

    protected void genCellMembers(V4toV5QuerySet theConverter, Element theV5EdgeVSetsEle, String v4QName) {
        Vector theVec = new Vector();
        theConverter.getV4Cube(v4QName, theVec);
        if (1 != theVec.size()) {
            return;
        }
        Element theCube = (Element)theVec.firstElement();
        theVec.clear();
        theConverter.getChildElementsByTagName(theCube, _factList, theVec);
        if (1 != theVec.size()) {
            return;
        }
        Element theFact = (Element)theVec.firstElement();
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.add(new String(_item));
        tagSet.add(new String(_dataItem));
        theVec.clear();
        theConverter.getChildElementsByTagNameSet(theFact, tagSet, theVec);
        for (int i = 0; i < theVec.size(); ++i) {
            Element theV5EdgeVSetEle = this.m_retDoc.createElement(_valueSet);
            Element a = (Element)theVec.get(i);
            String theName = this.getItemName(a);
            theV5EdgeVSetEle.setAttribute(_refDataItem, theName);
            theV5EdgeVSetEle.setAttribute(_name, theName);
            theV5EdgeVSetsEle.appendChild(theV5EdgeVSetEle);
        }
    }

    protected void genLevel(V4toV5QuerySet theConverter, Element theV5EdgeVSetsEle, Element aV4Level, String v4QName, String v4RealQName, Vector v5Maps) {
        String theName;
        Element theV5EdgeVSetEle = this.m_retDoc.createElement(_valueSet);
        Vector keyVec = new Vector();
        Vector propVec = new Vector();
        this.getSummaryLevelKeyAndProp(theConverter, aV4Level, keyVec, propVec, v4QName);
        if (1 == keyVec.size()) {
            Element keyEle = (Element)keyVec.firstElement();
            theName = this.getRealItemName(theConverter, keyEle, v5Maps, v4RealQName);
            theV5EdgeVSetEle.setAttribute(_refDataItem, theName);
            theV5EdgeVSetEle.setAttribute(_name, theName);
        } else {
            String theName2 = new String(_valueSet);
            Integer n = new Integer(++this.m_valueSetId);
            theName2 = theName2.concat(n.toString());
            theV5EdgeVSetEle.setAttribute(_name, theName2);
        }
        if (propVec.size() > 0) {
            Element theV5grpBodyEle = this.m_retDoc.createElement(_groupBody);
            theName = theV5EdgeVSetEle.getAttribute(_name);
            theName = theName.concat(new String(_groupBodyName));
            theV5grpBodyEle.setAttribute(_name, theName);
            for (int i = 0; i < propVec.size(); ++i) {
                Element propEle = (Element)propVec.get(i);
                Element theV5DIEle = this.m_retDoc.createElement(_dataItemRef);
                theV5DIEle.setAttribute(_refDataItem, this.getRealItemName(theConverter, propEle, v5Maps, v4RealQName));
                theV5grpBodyEle.appendChild(theV5DIEle);
            }
            theV5EdgeVSetEle.appendChild(theV5grpBodyEle);
        }
        theV5EdgeVSetsEle.appendChild(theV5EdgeVSetEle);
    }

    protected String getRealItemName(V4toV5QuerySet theConverter, Element ele, Vector theV5Map, String v4RealQName) {
        String relName = this.getItemName(ele);
        if (1 != theV5Map.size()) {
            return relName;
        }
        Element theMap = (Element)theV5Map.firstElement();
        Vector vec = new Vector();
        theConverter.getChildElementsByTagNameAndAttribue(theMap, "aliasMap", _query, v4RealQName, vec);
        if (0 == vec.size()) {
            return relName;
        }
        for (int i = 0; i < vec.size(); ++i) {
            Element a = (Element)vec.get(i);
            if (!relName.equals(a.getAttribute(_alias))) continue;
            return a.getAttribute(_item);
        }
        return relName;
    }

    protected void getSummaryLevelKeyAndProp(V4toV5QuerySet theConverter, Element aV4Level, Vector keyVec, Vector propVec, String v4QName) {
        block4: {
            block5: {
                Vector theItems = new Vector();
                theConverter.getChildElementsByTagName(aV4Level, _item, theItems);
                if (theItems.size() <= 0) break block5;
                Element firstOne = (Element)theItems.firstElement();
                keyVec.add(firstOne);
                if (theItems.size() <= 1) break block4;
                for (int i = 1; i < theItems.size(); ++i) {
                    Element aItem = (Element)theItems.get(i);
                    propVec.add(aItem);
                }
                break block4;
            }
            if (aV4Level.hasAttribute(_refLevel)) {
                String levelName = aV4Level.getAttribute(_refLevel);
                Vector cubeVec = new Vector();
                theConverter.getV4Cube(v4QName, cubeVec);
                if (1 == cubeVec.size()) {
                    Element theV4Cube = (Element)cubeVec.firstElement();
                    NodeList allCubeLevels = theV4Cube.getElementsByTagName(_level);
                    for (int nItem = 0; nItem < allCubeLevels.getLength(); ++nItem) {
                        String theName;
                        Element theElem = (Element)allCubeLevels.item(nItem);
                        if (!theElem.hasAttribute(_name) || !levelName.equals(theName = theElem.getAttribute(_name))) continue;
                        this.getKeyAndProperties(theConverter, theElem, keyVec, propVec);
                        break;
                    }
                }
            }
        }
    }

    protected String getRealQueryName(V4toV5QuerySet theConverter, Vector v5MapsVec, String v4QName) {
        if (1 != v5MapsVec.size()) {
            return v4QName;
        }
        Element v5Maps = (Element)v5MapsVec.firstElement();
        Vector r = new Vector();
        theConverter.getChildElementsByTagNameAndAttribue(v5Maps, "queryMap", "ignored", v4QName, r);
        if (1 == r.size()) {
            Element aM = (Element)r.firstElement();
            return aM.getAttribute("equiv");
        }
        return v4QName;
    }

    protected boolean genMeasureHeader(V4toV5QuerySet theConverter, Element v4FactList) {
        String sHeader;
        Element aItem;
        Vector<Element> theV4Items = new Vector<Element>();
        Vector v4Items = new Vector();
        theConverter.getChildElementsByTagName(v4FactList, _item, v4Items);
        int i = 0;
        for (i = 0; i < v4Items.size(); ++i) {
            aItem = (Element)v4Items.get(i);
            if (!aItem.hasAttribute(_isHeader) || !(sHeader = aItem.getAttribute(_isHeader)).equalsIgnoreCase(_true) || aItem.hasAttribute(_aggregate) && aItem.getAttribute(_aggregate).equalsIgnoreCase(_none)) continue;
            theV4Items.add(aItem);
        }
        v4Items.clear();
        theConverter.getChildElementsByTagName(v4FactList, _dataItem, v4Items);
        for (i = 0; i < v4Items.size(); ++i) {
            aItem = (Element)v4Items.get(i);
            if (!aItem.hasAttribute(_isHeader) || !(sHeader = aItem.getAttribute(_isHeader)).equalsIgnoreCase(_true) || aItem.hasAttribute(_aggregate) && aItem.getAttribute(_aggregate).equalsIgnoreCase(_none)) continue;
            theV4Items.add(aItem);
        }
        if (0 == theV4Items.size()) {
            return false;
        }
        this.m_retHeaderElem = this.m_retDoc.createElement(_groupHeader);
        for (i = 0; i < theV4Items.size(); ++i) {
            aItem = (Element)theV4Items.get(i);
            String tagName = aItem.getTagName();
            Element v5Item = this.m_retDoc.createElement(_dataItemRef);
            if (tagName.equals(_item)) {
                v5Item.setAttribute(_refDataItem, aItem.getAttribute(_refItem));
            } else {
                v5Item.setAttribute(_refDataItem, aItem.getAttribute(_name));
            }
            this.m_retHeaderElem.appendChild(v5Item);
        }
        return true;
    }

    protected boolean genMeasureFooter(V4toV5QuerySet theConverter, Element v4FactList) {
        Element aItem;
        Vector<Element> theV4Items = new Vector<Element>();
        Vector v4Items = new Vector();
        theConverter.getChildElementsByTagName(v4FactList, _item, v4Items);
        int i = 0;
        for (i = 0; i < v4Items.size(); ++i) {
            aItem = (Element)v4Items.get(i);
            if (aItem.hasAttribute(_isHeader) && aItem.getAttribute(_isHeader).equalsIgnoreCase(_true) || aItem.hasAttribute(_aggregate) && aItem.getAttribute(_aggregate).equalsIgnoreCase(_none)) continue;
            theV4Items.add(aItem);
        }
        v4Items.clear();
        theConverter.getChildElementsByTagName(v4FactList, _dataItem, v4Items);
        for (i = 0; i < v4Items.size(); ++i) {
            aItem = (Element)v4Items.get(i);
            if (aItem.hasAttribute(_isHeader) && aItem.getAttribute(_isHeader).equalsIgnoreCase(_true) || aItem.hasAttribute(_aggregate) && aItem.getAttribute(_aggregate).equalsIgnoreCase(_none)) continue;
            theV4Items.add(aItem);
        }
        if (0 == theV4Items.size()) {
            return false;
        }
        this.m_retFooterElem = this.m_retDoc.createElement(_groupFooter);
        for (i = 0; i < theV4Items.size(); ++i) {
            aItem = (Element)theV4Items.get(i);
            String tagName = aItem.getTagName();
            Element v5Item = this.m_retDoc.createElement(_dataItemRef);
            if (tagName.equals(_item)) {
                v5Item.setAttribute(_refDataItem, aItem.getAttribute(_refItem));
            } else {
                v5Item.setAttribute(_refDataItem, aItem.getAttribute(_name));
            }
            this.m_retFooterElem.appendChild(v5Item);
        }
        return true;
    }

    protected void genQRD4Cube(V4toV5QuerySet theConverter, String v4QName, Element theV5QuerySetEle, Element theV4Cube) {
        Element theV5EdgeEle;
        Element v5QRDs = this.m_retDoc.createElement(_queryResultDefinitions);
        Element theV5QRDEle = this.m_retDoc.createElement(_queryResultDefinition);
        theV5QRDEle.setAttribute(_name, "theQRD");
        theV5QRDEle.setAttribute(_refQuery, v4QName);
        Element theV5EdgesEle = this.m_retDoc.createElement(_edges);
        Vector v4Dims = new Vector();
        theConverter.getChildElementsByTagName(theV4Cube, _dimension, v4Dims);
        Vector v4Fact = new Vector();
        theConverter.getChildElementsByTagName(theV4Cube, _factList, v4Fact);
        int i = 0;
        for (i = 0; i < v4Dims.size(); ++i) {
            Element aDim = (Element)v4Dims.get(i);
            theV5EdgeEle = this.m_retDoc.createElement(_edge);
            if (aDim.hasAttribute(_name)) {
                theV5EdgeEle.setAttribute(_name, aDim.getAttribute(_name));
            } else {
                String nS = Integer.toString(i);
                theV5EdgeEle.setAttribute(_name, nS);
            }
            Vector v4Levels = new Vector();
            theConverter.getChildElementsByTagName(aDim, _level, v4Levels);
            this.genNestedGroups(theConverter, theV5EdgeEle, 0, v4Levels, v4Fact, 1 == v4Dims.size());
            theV5EdgesEle.appendChild(theV5EdgeEle);
        }
        if (1 != v4Dims.size() && 1 == v4Fact.size()) {
            Element v4FactList = (Element)v4Fact.firstElement();
            theV5EdgeEle = this.m_retDoc.createElement(_edge);
            theV5EdgeEle.setAttribute(_name, _factList);
            Vector<String> nameVec = new Vector<String>();
            Vector v4Items = new Vector();
            HashSet<String> tagSet = new HashSet<String>();
            tagSet.add(new String(_item));
            tagSet.add(new String(_dataItem));
            theConverter.getChildElementsByTagNameSet(v4FactList, tagSet, v4Items);
            for (i = 0; i < v4Items.size(); ++i) {
                Element aV4Item = (Element)v4Items.get(i);
                nameVec.add(this.getItemName(aV4Item));
            }
            boolean bGenHeader = false;
            boolean bGenFooter = false;
            if (0 == v4Dims.size()) {
                bGenHeader = this.genMeasureHeader(theConverter, v4FactList);
                bGenFooter = this.genMeasureFooter(theConverter, v4FactList);
            }
            this.genAV5EdgesGroups(theV5EdgeEle, nameVec, 0 == v4Dims.size(), bGenHeader, bGenFooter);
            theV5EdgesEle.appendChild(theV5EdgeEle);
        }
        theV5QRDEle.appendChild(theV5EdgesEle);
        v5QRDs.appendChild(theV5QRDEle);
        theV5QuerySetEle.appendChild(v5QRDs);
    }

    protected void genNestedGroups(V4toV5QuerySet theConverter, Element theV5ParentEle, int pos, Vector v4Levels, Vector v4Fact, boolean bOneDim) {
        Element aFact;
        Element theV5EdgeGrpsEle = this.m_retDoc.createElement(_edgeGroups);
        Element theV5EdgeGrpEle = this.m_retDoc.createElement(_edgeGroup);
        Element theV5EdgeVSetsEle = this.m_retDoc.createElement(_valueSets);
        Element theV5EdgeVSetEle = this.m_retDoc.createElement(_valueSet);
        Element aV4Level = (Element)v4Levels.get(pos);
        Vector keyVec = new Vector();
        Vector propVec = new Vector();
        this.getKeyAndProperties(theConverter, aV4Level, keyVec, propVec);
        if (1 == keyVec.size()) {
            Element keyEle = (Element)keyVec.firstElement();
            String theName = this.getItemName(keyEle);
            theV5EdgeVSetEle.setAttribute(_refDataItem, theName);
            theV5EdgeVSetEle.setAttribute(_name, theName);
        } else {
            String theName = new String(_valueSet);
            Integer n = new Integer(++this.m_valueSetId);
            theName = theName.concat(n.toString());
            theV5EdgeVSetEle.setAttribute(_name, theName);
        }
        if (1 == v4Fact.size() && this.genMeasureHeader(theConverter, aFact = (Element)v4Fact.firstElement())) {
            String theTmpHdr = theV5EdgeVSetEle.getAttribute(_name);
            theTmpHdr = theTmpHdr.concat(new String(_groupHeaderName));
            this.m_retHeaderElem.setAttribute(_name, theTmpHdr);
            theV5EdgeVSetEle.appendChild(this.m_retHeaderElem);
        }
        if (propVec.size() > 0) {
            Element theV5grpBodyEle = this.m_retDoc.createElement(_groupBody);
            String theTmpBd = theV5EdgeVSetEle.getAttribute(_name);
            theTmpBd = theTmpBd.concat(new String(_groupBodyName));
            theV5grpBodyEle.setAttribute(_name, theTmpBd);
            for (int i = 0; i < propVec.size(); ++i) {
                Element propEle = (Element)propVec.get(i);
                Element theV5DIEle = this.m_retDoc.createElement(_dataItemRef);
                theV5DIEle.setAttribute(_refDataItem, this.getItemName(propEle));
                theV5grpBodyEle.appendChild(theV5DIEle);
            }
            theV5EdgeVSetEle.appendChild(theV5grpBodyEle);
        }
        if (1 == v4Fact.size() && this.genMeasureFooter(theConverter, aFact = (Element)v4Fact.firstElement())) {
            String theTmpFt = theV5EdgeVSetEle.getAttribute(_name);
            theTmpFt = theTmpFt.concat(new String(_groupFooterName));
            this.m_retFooterElem.setAttribute(_name, theTmpFt);
            theV5EdgeVSetEle.appendChild(this.m_retFooterElem);
        }
        theV5EdgeVSetsEle.appendChild(theV5EdgeVSetEle);
        theV5EdgeGrpEle.appendChild(theV5EdgeVSetsEle);
        int len = v4Levels.size();
        if (++pos < len) {
            this.genNestedGroups(theConverter, theV5EdgeGrpEle, pos, v4Levels, v4Fact, bOneDim);
        } else if (bOneDim && 1 == v4Fact.size()) {
            Element v4FactList = (Element)v4Fact.firstElement();
            Vector<String> nameVec = new Vector<String>();
            Vector v4Items = new Vector();
            HashSet<String> tagSet = new HashSet<String>();
            tagSet.add(new String(_item));
            tagSet.add(new String(_dataItem));
            theConverter.getChildElementsByTagNameSet(v4FactList, tagSet, v4Items);
            for (int i = 0; i < v4Items.size(); ++i) {
                Element aV4Item = (Element)v4Items.get(i);
                nameVec.add(this.getItemName(aV4Item));
            }
            this.genAV5EdgesGroups(theV5EdgeGrpEle, nameVec, true, false, false);
        }
        theV5EdgeGrpsEle.appendChild(theV5EdgeGrpEle);
        theV5ParentEle.appendChild(theV5EdgeGrpsEle);
    }

    protected void getKeyAndProperties(V4toV5QuerySet theConverter, Element aV4Level, Vector keyVec, Vector propVec) {
        Vector v4Items = new Vector();
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.add(new String(_item));
        tagSet.add(new String(_dataItem));
        theConverter.getChildElementsByTagNameSet(aV4Level, tagSet, v4Items);
        int keyPos = -1;
        int i = 0;
        for (i = 0; i < v4Items.size(); ++i) {
            Element aV4Item = (Element)v4Items.get(i);
            if (!aV4Item.hasAttribute(_key) || !aV4Item.getAttribute(_key).equalsIgnoreCase(_true)) continue;
            keyPos = i;
            keyVec.add(aV4Item);
            break;
        }
        if (-1 == keyPos) {
            keyPos = 0;
            keyVec.add((Element)v4Items.firstElement());
        }
        for (i = 0; i < v4Items.size(); ++i) {
            if (i == keyPos) continue;
            propVec.add(v4Items.get(i));
        }
    }

    protected String getItemName(Element theItemEle) {
        String theTag = theItemEle.getTagName();
        if (theTag.equals(_item)) {
            if (theItemEle.hasAttribute(_alias)) {
                return theItemEle.getAttribute(_alias);
            }
            return theItemEle.getAttribute(_refItem);
        }
        return theItemEle.getAttribute(_name);
    }

    protected void genQRD4Tabular(Element theV5QuerySetEle, String theQueryName, Vector v5ItemsInSelection) {
        Element v5QRDs = this.m_retDoc.createElement(_queryResultDefinitions);
        Element theV5QRDEle = this.m_retDoc.createElement(_queryResultDefinition);
        theV5QRDEle.setAttribute(_name, "theQRD");
        theV5QRDEle.setAttribute(_refQuery, theQueryName);
        Element theV5EdgesEle = this.m_retDoc.createElement(_edges);
        Element theV5EdgeEle = this.m_retDoc.createElement(_edge);
        theV5EdgeEle.setAttribute(_name, "theEdge");
        Vector<String> nameVec = new Vector<String>();
        for (int i = 0; i < v5ItemsInSelection.size(); ++i) {
            Element aV5Item = (Element)v5ItemsInSelection.get(i);
            nameVec.add(aV5Item.getAttribute(_name));
        }
        this.genAV5EdgesGroups(theV5EdgeEle, nameVec, true, false, false);
        theV5EdgesEle.appendChild(theV5EdgeEle);
        theV5QRDEle.appendChild(theV5EdgesEle);
        v5QRDs.appendChild(theV5QRDEle);
        theV5QuerySetEle.appendChild(v5QRDs);
    }

    protected void genAV5EdgesGroups(Element theV5EdgeEle, Vector nameVec, boolean bGroupBody, boolean bGenHeader, boolean bGenFooter) {
        Element theV5EdgeGrpsEle = this.m_retDoc.createElement(_edgeGroups);
        Element theV5EdgeGrpEle = this.m_retDoc.createElement(_edgeGroup);
        Element theV5EdgeVSetsEle = this.m_retDoc.createElement(_valueSets);
        int i = 0;
        if (bGroupBody) {
            Element theV5EdgeVSetEle = this.m_retDoc.createElement(_valueSet);
            String theName = new String(_valueSet);
            Integer n = new Integer(++this.m_valueSetId);
            theName = theName.concat(n.toString());
            theV5EdgeVSetEle.setAttribute(_name, theName);
            if (bGenHeader) {
                String theTmpHdr = new String(theName);
                theTmpHdr = theTmpHdr.concat(new String(_groupHeaderName));
                this.m_retHeaderElem.setAttribute(_name, theTmpHdr);
                theV5EdgeVSetEle.appendChild(this.m_retHeaderElem);
            }
            Element theV5EdgeGrpBodyEle = this.m_retDoc.createElement(_groupBody);
            String theTmpBd = new String(theName);
            theTmpBd = theTmpBd.concat(new String(_groupBodyName));
            theV5EdgeGrpBodyEle.setAttribute(_name, theTmpBd);
            for (i = 0; i < nameVec.size(); ++i) {
                String aName = (String)nameVec.get(i);
                Element theV5DIEle = this.m_retDoc.createElement(_dataItemRef);
                theV5DIEle.setAttribute(_refDataItem, aName);
                theV5EdgeGrpBodyEle.appendChild(theV5DIEle);
            }
            theV5EdgeVSetEle.appendChild(theV5EdgeGrpBodyEle);
            if (bGenFooter) {
                String theTmpFt = new String(theName);
                theTmpFt = theTmpFt.concat(new String(_groupFooterName));
                this.m_retFooterElem.setAttribute(_name, theTmpFt);
                theV5EdgeVSetEle.appendChild(this.m_retFooterElem);
            }
            theV5EdgeVSetsEle.appendChild(theV5EdgeVSetEle);
        } else {
            for (i = 0; i < nameVec.size(); ++i) {
                Element theV5EdgeVSetEle = this.m_retDoc.createElement(_valueSet);
                String aName = (String)nameVec.get(i);
                theV5EdgeVSetEle.setAttribute(_refDataItem, aName);
                theV5EdgeVSetEle.setAttribute(_name, aName);
                theV5EdgeVSetsEle.appendChild(theV5EdgeVSetEle);
            }
        }
        theV5EdgeGrpEle.appendChild(theV5EdgeVSetsEle);
        theV5EdgeGrpsEle.appendChild(theV5EdgeGrpEle);
        theV5EdgeEle.appendChild(theV5EdgeGrpsEle);
    }
}

