/*
 * Decompiled with CFR 0.152.
 */
package com.qfw.V4toV5;

import com.qfw.V4toV5.QueryUpgradeProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class V4toV5QuerySet {
    private QueryUpgradeProperties properties = new QueryUpgradeProperties();
    private static final String _inputSrc = "<querySet xml:lang=\"en-us\"><BIQuery name=\"Query\"><tabularModel name=\"tabularModel\"><dataItem name=\"ProductName\" aggregate=\"none\"><expression>[otherconn].[Product].[ProductName]</expression></dataItem><dataItem name=\"ProductNumber\" aggregate=\"none\"><expression>[otherconn].[Product].[ProductNumber]</expression></dataItem><dataItem name=\"IntroductionDate\" sort=\"descending\" aggregate=\"none\"><expression>[otherconn].[Product].[IntroductionDate]</expression></dataItem><dataItem name=\"Margin\" aggregate=\"total\"><expression>[otherconn].[Product].[Margin]</expression></dataItem><dataItem name=\"ProductionCost\" aggregate=\"total\"><expression>[otherconn].[Product].[ProductionCost]</expression></dataItem><filter use=\"optional\"><condition>[otherconn].[Product].[ProductNumber] in_range {5:10}</condition></filter></tabularModel><cube><factList><item refItem=\"ProductName\" aggregate=\"none\"/><item refItem=\"ProductNumber\" aggregate=\"none\"/><item refItem=\"IntroductionDate\" aggregate=\"count\"/><item refItem=\"Margin\" aggregate=\"total\"/><item refItem=\"ProductionCost\" aggregate=\"average\"/><dataItem name=\"count(IntroductionDate)\" aggregate=\"calculated\"><expression>count(distinct([tabularModel].[IntroductionDate]))</expression></dataItem></factList></cube></BIQuery></querySet>";
    private static final String _BeringNS = "http://developer.cognos.com/schemas/report/2.0/";
    private static final String _UTF8 = "UTF-8";
    private static final String _BIQUery = "BIQuery";
    private static final String _summary = "summary";
    private static final String _cube = "cube";
    private static final String _cubeRef = "cubeReference";
    private static final String _nameAttr = "name";
    private static final String _refQueryAttr = "refQuery";
    private static final String _tabularModel = "tabularModel";
    private static final String _tabularSet = "tabularSet";
    private static final String _tabularSQL = "tabularSQL";
    private static final String _tabularReference = "tabularReference";
    private static final String _dataItem = "dataItem";
    private static final String _dimension = "dimension";
    private static final String _level = "level";
    private static final String _factList = "factList";
    private static final String _fact = "fact";
    private static final String _item = "item";
    private static final String _refItem = "refItem";
    private static final String _alias = "alias";
    private static final String _filter = "filter";
    private static final String _aggregate = "aggregate";
    private static final String _expression = "expression";
    private static final String _condition = "condition";
    private static final String _emptyStr = "";
    private static final String _stIgnored = "stIgnored";
    private static final String _stCube_Info = "stCubeWInfo";
    private static final String _stCube = "stCube";
    private static final String _stTabular = "stTabular";
    private static final String _autoSummary = "autoSummary";
    private static final String _false = "false";
    private static final String _true = "true";
    private static final String _dimensionInfo = "dimensionInfo";
    private static final String _queryItem = "queryItem";
    private static final String _extension = "_tb";
    private static final String _selection = "selection";
    private static final String _rollupAggregate = "rollupAggregate";
    private static final String _key = "key";
    private static final String _sortAttr = "sort";
    private static final String _sortOrderAttr = "sortOrder";
    private static final String _v5RefDataItemAttr = "refDataItem";
    private static final String _noneVal = "none";
    private static final String _countVal = "count";
    private static final String _notApplicable = "notApplicable";
    private static final String _summarizeVal = "summarize";
    private static final String _automaticVal = "automatic";
    private static final String _calculatedVal = "calculated";
    private static final String _source = "source";
    private static final String _model = "model";
    private static final String _left = "left";
    private static final String _right = "right";
    private static final String _setOperator = "setOperator";
    private static final int leftOnly = 1;
    private static final int rightOnly = 2;
    private static final int leftAndRight = 3;
    private Document m_doc;
    private Element m_rootElem;
    private Document m_retDoc;
    private Element m_retRootElem;
    private Element m_retQueiresElem;
    private Element m_retMapElem;
    private Element m_queryElem;
    private Map m_queryMap = new HashMap();
    private StringBuffer m_theDSName = new StringBuffer();
    private Map m_BIQueryMap = new HashMap();
    private Map m_BIQuery2FactLisMap = new HashMap();
    private Map m_V5QueryNameMap = new HashMap();
    private Map m_RefQuery2DataItemsMap = new HashMap();
    private Set m_SharedBIQueryNames;
    private Vector m_theErrorMsgs = new Vector();
    private Locale m_prodLocale = new Locale("en", "");
    private static final String BUNDLE_NAME = "qfwV4toV5Jmsgs";
    private static final String msgKey_01 = "QFW_ERR_V4toV5_UNKNOWN";
    private static final String msgKey_02 = "QFW_ERR_V4toV5_UNDEFINED_ITEM";
    private Map m_v5DataItemToV4Agg = null;

    public static String doConversion(String sQueries) {
        return V4toV5QuerySet.doConversion(sQueries, "en");
    }

    public static String doConversion(String sQueries, String sProductLocale) {
        if (sQueries.equals("test")) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(_inputSrc.getBytes(_UTF8));
                V4toV5QuerySet theConverter = new V4toV5QuerySet();
                theConverter.setProductLocale(sProductLocale);
                return theConverter.doConversionFromInputStream(bais);
            }
            catch (Exception e) {
                return "<Exception>" + e.getMessage() + "</Exception>";
            }
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(sQueries.getBytes(_UTF8));
            V4toV5QuerySet theConverter = new V4toV5QuerySet();
            return theConverter.doConversionFromInputStream(bais);
        }
        catch (Exception e) {
            return "<Exception>" + e.getMessage() + "</Exception>";
        }
    }

    public Document doConversionV4toV5(Document V4Queries) {
        return this.doConversionV4toV5(V4Queries, "en");
    }

    public Document doConversionV4toV5(Document V4Queries, String sProductLocale) {
        this.setProductLocale(sProductLocale);
        try {
            this.m_doc = V4Queries;
            this.doConversionFromInputDoc();
        }
        catch (Exception e) {
            String errStr = e.getMessage();
            this.m_theErrorMsgs.addElement(errStr);
        }
        this.reportErrors();
        return this.m_retDoc;
    }

    public Document doConversionV4toV5(Document V4Queries, Set sharedBIQueryNames, String sProductLocale) {
        this.setProductLocale(sProductLocale);
        this.m_SharedBIQueryNames = sharedBIQueryNames;
        try {
            this.m_doc = V4Queries;
            this.doConversionFromInputDoc();
        }
        catch (Exception e) {
            String errStr = e.getMessage();
            this.m_theErrorMsgs.addElement(errStr);
        }
        this.reportErrors();
        return this.m_retDoc;
    }

    private boolean doConversionFromInputDoc() {
        if (this.m_retDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_retDoc = builder.newDocument();
                this.m_retRootElem = this.m_retDoc.createElement("ret");
                this.m_retDoc.appendChild(this.m_retRootElem);
            }
            catch (Exception e) {
                String errStr = "Error in creating return instance: " + e.getMessage();
                this.m_theErrorMsgs.addElement(errStr);
                return false;
            }
        }
        StringBuffer error = new StringBuffer();
        if (!this.genV5Queries(this.m_doc.getDocumentElement(), this.m_theDSName, error)) {
            this.m_theErrorMsgs.addElement(error.toString());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        V4toV5QuerySet theConverter = new V4toV5QuerySet();
        if (args.length >= 1 && args.length <= 3) {
            try {
                String theV4fileName = args[0];
                FileInputStream theFilestr = new FileInputStream(theV4fileName);
                boolean need2CollectBIQueries = false;
                if (args.length == 3) {
                    if (theV4fileName.equalsIgnoreCase(args[2])) {
                        need2CollectBIQueries = true;
                    } else {
                        String theProductLocale = args[2];
                        theConverter.setProductLocale(theProductLocale);
                    }
                }
                theConverter.convertStringToDoc(theFilestr);
                LinkedHashSet sharedBIQueries = new LinkedHashSet();
                if (need2CollectBIQueries) {
                    V4toV5QuerySet._getListOfSharedBIQueries(theConverter.m_doc, sharedBIQueries);
                }
                Document retDoc = theConverter.doConversionV4toV5(theConverter.m_doc, sharedBIQueries, "en");
                if (args.length >= 2) {
                    String theOutfileName = args[1];
                    FileOutputStream outs = new FileOutputStream(theOutfileName);
                    String outSrc = theConverter.convertReturnDocToString(retDoc);
                    outs.write(outSrc.getBytes(_UTF8));
                    outs.close();
                }
            }
            catch (Exception e) {
                System.out.println("<Exception>" + e.getMessage() + "</Exception>");
                System.exit(1);
            }
            System.exit(0);
        } else {
            String outSrc = V4toV5QuerySet.doConversion(_inputSrc);
            System.out.println(outSrc);
            System.exit(0);
        }
    }

    private static void _getListOfSharedBIQueries(Document V4Queries, LinkedHashSet sharedBIQueries) {
        Element v4Elements = V4Queries.getDocumentElement();
        NodeList allV4QSetItems = v4Elements.getElementsByTagName("querySet");
        Element rootElem = (Element)allV4QSetItems.item(0);
        for (Node n = rootElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            String tagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(tagName = aElem.getTagName()).equals(_BIQUery)) continue;
            String BIQueryName = aElem.getAttribute(_nameAttr);
            sharedBIQueries.add(BIQueryName);
        }
    }

    private void convertStringToDoc(InputStream theStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theStream);
        }
        catch (Exception e) {
            System.out.println("<Exception>" + e.getMessage() + "</Exception>");
        }
    }

    public void setProductLocale(String theProductLocale) {
        String slanguage = null;
        if (theProductLocale != null && theProductLocale.length() > 0) {
            if (theProductLocale.length() > 2) {
                int langSep = theProductLocale.indexOf("-");
                if (langSep >= 0) {
                    slanguage = theProductLocale.substring(0, langSep);
                }
            } else {
                slanguage = theProductLocale;
            }
            if (slanguage != null && slanguage.length() > 0 && !slanguage.equalsIgnoreCase("en")) {
                this.m_prodLocale = new Locale(slanguage, _emptyStr);
            }
        }
    }

    public String doConversionFromInputStream(InputStream theStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            this.m_doc = parser.parse(theStream);
        }
        catch (Exception e) {
            return "<Exception>" + e.getMessage() + "</Exception>";
        }
        StringBuffer error = new StringBuffer();
        if (!this.genV5Queries(this.m_doc.getDocumentElement(), this.m_theDSName, error)) {
            return error.toString();
        }
        return this.convertToString();
    }

    public Element getV5Queries() {
        return this.m_retQueiresElem;
    }

    public void getV5Maps(Vector vec) {
        if (this.m_retMapElem != null) {
            vec.add(this.m_retMapElem);
        }
    }

    public boolean genV5Queries(Element theV4RootEle, StringBuffer dsName, StringBuffer error) {
        String tagName;
        Element aElem;
        Node n;
        if (dsName.length() > 0) {
            this.m_theDSName.append(dsName.toString());
        }
        this.m_rootElem = theV4RootEle;
        String rootTagName = this.m_rootElem.getTagName();
        if (!rootTagName.equals("querySet")) {
            NodeList allV4QSetItems = this.m_rootElem.getElementsByTagName("querySet");
            if (allV4QSetItems.getLength() != 1) {
                if (this.m_retDoc == null) {
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        this.m_retDoc = builder.newDocument();
                        this.m_retRootElem = this.m_retDoc.createElement("ret");
                        this.m_retDoc.appendChild(this.m_retRootElem);
                    }
                    catch (Exception e) {
                        error.append(e.getMessage());
                        return false;
                    }
                }
                if (this.m_retQueiresElem == null) {
                    this.m_retQueiresElem = this.m_retDoc.createElement("queries");
                    this.m_retQueiresElem.setAttribute("xmlns", _BeringNS);
                    this.m_retRootElem.appendChild(this.m_retQueiresElem);
                }
                return true;
            }
            this.m_rootElem = (Element)allV4QSetItems.item(0);
        }
        for (n = this.m_rootElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(tagName = aElem.getTagName()).equals(_BIQUery) || this.setQueryStatus(aElem)) continue;
            error.append("bad query definition");
            return false;
        }
        this.genV5NameMap();
        for (n = this.m_rootElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(tagName = aElem.getTagName()).equals(_BIQUery) || this.createQuery(aElem)) continue;
            error.append("bad query definition");
            return false;
        }
        if (this.m_retDoc == null) {
            error.append("return document is empty");
            return false;
        }
        return true;
    }

    protected void reportErrors() {
        if (0 == this.m_theErrorMsgs.size()) {
            return;
        }
        Element errorsEle = this.m_retDoc.createElement("Exceptions");
        for (int i = 0; i < this.m_theErrorMsgs.size(); ++i) {
            Element errorEle = this.m_retDoc.createElement("Exception");
            String theErrorMsg = (String)this.m_theErrorMsgs.get(i);
            Text theErrorText = this.m_retDoc.createTextNode(theErrorMsg);
            errorEle.appendChild(theErrorText);
            errorsEle.appendChild(errorEle);
        }
        this.m_retRootElem.appendChild(errorsEle);
    }

    protected String convertReturnDocToString(Document retDoc) {
        this.m_retDoc = retDoc;
        return this.convertToString();
    }

    protected String convertToString() {
        try {
            OutputFormat format = new OutputFormat(this.m_retDoc);
            format.setPreserveSpace(true);
            ByteArrayOutputStream theOut = new ByteArrayOutputStream();
            XMLSerializer output = new XMLSerializer((OutputStream)theOut, format);
            output.serialize(this.m_retDoc);
            return theOut.toString(_UTF8);
        }
        catch (IOException e) {
            return "empty";
        }
    }

    protected boolean setQueryStatus(Element aBIQuery) {
        if (!aBIQuery.hasAttribute(_nameAttr)) {
            return false;
        }
        String v4QueryName = aBIQuery.getAttribute(_nameAttr);
        Vector v4SumElems = new Vector();
        this.getChildElementsByTagName(aBIQuery, _summary, v4SumElems);
        if (!v4SumElems.isEmpty() && v4SumElems.size() > 1) {
            return false;
        }
        Vector v4CubeElems = new Vector();
        this.getChildElementsByTagName(aBIQuery, _cube, v4CubeElems);
        if (!v4CubeElems.isEmpty() && v4CubeElems.size() > 1) {
            return false;
        }
        if (1 == v4SumElems.size()) {
            return this.checkTheSummary(aBIQuery, v4QueryName, v4SumElems, v4CubeElems);
        }
        Vector v4TabRefElems = new Vector();
        this.getChildElementsByTagName(aBIQuery, _tabularReference, v4TabRefElems);
        if (!v4TabRefElems.isEmpty() && 1 == v4TabRefElems.size()) {
            this.checkTheTabularReference(aBIQuery, v4QueryName, v4CubeElems, v4TabRefElems);
        }
        if (!v4CubeElems.isEmpty() && 1 == v4CubeElems.size()) {
            if (!v4SumElems.isEmpty() && 1 == v4SumElems.size()) {
                Element cubeElem;
                Element summaryElem = (Element)v4SumElems.firstElement();
                if (!this.isConsistent(summaryElem, cubeElem = (Element)v4CubeElems.firstElement())) {
                    if (this.m_BIQueryMap.containsKey(v4QueryName)) {
                        StringBuffer st = (StringBuffer)this.m_BIQueryMap.get(v4QueryName);
                        st.delete(0, st.length());
                        st.append(_stCube_Info);
                    } else {
                        this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stCube_Info));
                    }
                } else if (!this.m_BIQueryMap.containsKey(v4QueryName)) {
                    this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stCube));
                }
            } else {
                Element cubeElem = (Element)v4CubeElems.firstElement();
                boolean bMKeys = false;
                Vector theElems = new Vector();
                this.getChildElementsByTagName(cubeElem, _dimension, theElems);
                for (int i = 0; i < theElems.size(); ++i) {
                    HashSet aSet;
                    Element theDimEle = (Element)theElems.get(i);
                    if (!this.getCubeItems(theDimEle, aSet = new HashSet())) continue;
                    bMKeys = true;
                    break;
                }
                if (bMKeys) {
                    if (this.m_BIQueryMap.containsKey(v4QueryName)) {
                        StringBuffer st = (StringBuffer)this.m_BIQueryMap.get(v4QueryName);
                        st.delete(0, st.length());
                        st.append(_stCube_Info);
                    } else {
                        this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stCube_Info));
                    }
                } else if (!this.m_BIQueryMap.containsKey(v4QueryName)) {
                    this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stCube));
                }
            }
            return true;
        }
        Vector v4TabularElems = new Vector();
        if (!this.getV4Tabular(aBIQuery, v4TabularElems)) {
            return false;
        }
        if (!this.m_BIQueryMap.containsKey(v4QueryName)) {
            this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stTabular));
        }
        return true;
    }

    protected void checkTheTabularReference(Element aBIQuery, String v4QueryName, Vector v4CubeElems, Vector v4TabRefElems) {
        StringBuffer refQueryName;
        Element tabRefElem = (Element)v4TabRefElems.firstElement();
        if (this.getV4QueryName4V4TabRef(tabRefElem, v4CubeElems, refQueryName = new StringBuffer())) {
            this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stIgnored));
            this.addIgnoredQueryMap(v4QueryName, refQueryName.toString());
        }
    }

    protected boolean getV4QueryName4V4TabRef(Element aTabRefElem, Vector v4CubeElems, StringBuffer theRealName) {
        if (!aTabRefElem.hasAttribute(_refQueryAttr)) {
            return false;
        }
        theRealName.append(aTabRefElem.getAttribute(_refQueryAttr));
        Vector v4QueryElems = new Vector();
        this.getChildElementsByTagNameAndAttribue(this.m_rootElem, _BIQUery, _nameAttr, theRealName.toString(), v4QueryElems);
        if (!v4QueryElems.isEmpty() && 1 == v4QueryElems.size()) {
            Element theBIQueryElem = (Element)v4QueryElems.firstElement();
            Vector theV4TabRefElems = new Vector();
            this.getChildElementsByTagName(theBIQueryElem, _tabularReference, theV4TabRefElems);
            if (!theV4TabRefElems.isEmpty() && 1 == theV4TabRefElems.size()) {
                Element aNestedTaRefElem = (Element)theV4TabRefElems.firstElement();
                int thelength = theRealName.length();
                theRealName.delete(0, thelength);
                return this.getV4QueryName4V4TabRef(aNestedTaRefElem, v4CubeElems, theRealName);
            }
            Vector targetV4CubeElems = new Vector();
            this.getChildElementsByTagName(theBIQueryElem, _cube, targetV4CubeElems);
            if (!targetV4CubeElems.isEmpty() && 1 == targetV4CubeElems.size()) {
                Node cubeFromTabRef;
                if (v4CubeElems.isEmpty()) {
                    return false;
                }
                Node targetV4Cube = (Node)targetV4CubeElems.firstElement();
                if (V4toV5QuerySet.areNodesSame(targetV4Cube, cubeFromTabRef = (Node)v4CubeElems.firstElement())) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean checkTheSummary(Element aBIQuery, String v4QueryName, Vector v4SumElems, Vector v4CubeElems) {
        Element cubeElem;
        Element summaryElem = (Element)v4SumElems.firstElement();
        StringBuffer theRealCubeName = new StringBuffer();
        if (1 == v4CubeElems.size()) {
            cubeElem = (Element)v4CubeElems.firstElement();
            theRealCubeName.append(v4QueryName);
        } else {
            Vector r;
            Vector v4CubeRefElems = new Vector();
            this.getChildElementsByTagName(aBIQuery, _cubeRef, v4CubeRefElems);
            if (v4CubeRefElems.isEmpty() || 1 != v4CubeRefElems.size()) {
                return false;
            }
            Element av4CubeRefElem = (Element)v4CubeRefElems.firstElement();
            if (!this.getV4QueryName4V4CubeRef(av4CubeRefElem, theRealCubeName, r = new Vector())) {
                return false;
            }
            boolean b = this.addIgnoredQueryMap(v4QueryName, theRealCubeName.toString());
            if (!b) {
                return false;
            }
            this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stIgnored));
            cubeElem = (Element)r.firstElement();
        }
        if (!this.isConsistent(summaryElem, cubeElem)) {
            if (this.m_BIQueryMap.containsKey(theRealCubeName.toString())) {
                StringBuffer st = (StringBuffer)this.m_BIQueryMap.get(theRealCubeName.toString());
                st.delete(0, st.length());
                st.append(_stCube_Info);
            } else {
                this.m_BIQueryMap.put(theRealCubeName.toString(), new StringBuffer(_stCube_Info));
            }
        } else if (!this.m_BIQueryMap.containsKey(v4QueryName)) {
            this.m_BIQueryMap.put(v4QueryName, new StringBuffer(_stCube));
        }
        if (!this.m_BIQuery2FactLisMap.containsKey(v4QueryName)) {
            this.m_BIQuery2FactLisMap.put(v4QueryName, cubeElem);
        }
        return true;
    }

    public void getV4Cube(String queryName, Vector v4Cube) {
        if (this.m_BIQuery2FactLisMap.containsKey(queryName)) {
            Element v4C = (Element)this.m_BIQuery2FactLisMap.get(queryName);
            v4Cube.add(v4C);
        }
    }

    protected boolean isConsistent(Element sumPart, Element cubePart) {
        Element theEle;
        HashSet aSet;
        Vector cubeDims = new Vector();
        TreeSet cubeItemName = new TreeSet();
        Vector theElems = new Vector();
        this.getChildElementsByTagName(cubePart, _factList, theElems);
        if (1 == theElems.size()) {
            Element theFactEle = (Element)theElems.firstElement();
            Vector v4ItemVec = new Vector();
            this.getChildElementsByTagName(theFactEle, _item, v4ItemVec);
            for (int i = 0; i < v4ItemVec.size(); ++i) {
                Element v4Item = (Element)v4ItemVec.get(i);
                if (!v4Item.hasAttribute(_aggregate)) continue;
                String name = v4Item.getAttribute(_aggregate);
                if (name.equalsIgnoreCase(_noneVal)) {
                    return false;
                }
                if (!name.equalsIgnoreCase(_countVal)) continue;
                return false;
            }
            aSet = new HashSet();
            this.getCubeItems(theFactEle, aSet);
            cubeDims.addElement(aSet);
            cubeItemName.addAll(aSet);
        }
        theElems.clear();
        this.getChildElementsByTagName(cubePart, _dimension, theElems);
        for (int i = 0; i < theElems.size(); ++i) {
            Element theDimEle = (Element)theElems.get(i);
            if (this.getCubeItems(theDimEle, aSet = new HashSet())) {
                return false;
            }
            cubeDims.addElement(aSet);
            cubeItemName.addAll(aSet);
        }
        theElems.clear();
        this.getChildElementsByTagName(sumPart, "dataCells", theElems);
        if (1 == theElems.size() && !this.summaryConsistent(theEle = (Element)theElems.firstElement(), cubeDims)) {
            return false;
        }
        theElems.clear();
        this.getChildElementsByTagName(sumPart, "rowEdge", theElems);
        if (1 == theElems.size() && !this.summaryConsistent(theEle = (Element)theElems.firstElement(), cubeDims)) {
            return false;
        }
        theElems.clear();
        this.getChildElementsByTagName(sumPart, "columnEdge", theElems);
        if (1 == theElems.size() && !this.summaryConsistent(theEle = (Element)theElems.firstElement(), cubeDims)) {
            return false;
        }
        theElems.clear();
        this.getChildElementsByTagName(sumPart, "sectionEdge", theElems);
        if (1 == theElems.size() && !this.summaryConsistent(theEle = (Element)theElems.firstElement(), cubeDims)) {
            return false;
        }
        return this.isCubeItemSameAsSumItem(cubeItemName, sumPart);
    }

    public boolean isCubeItemSameAsSumItem(Set cubeItemName, Element summaryElem) {
        Iterator it = cubeItemName.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.endsWith(_level) && !name.endsWith(_dimension)) continue;
            it.remove();
        }
        Vector sumItem = new Vector();
        this.getItemFromSummary(summaryElem, sumItem);
        TreeSet<String> sumItemName = new TreeSet<String>();
        for (String name : sumItem) {
            if (name.endsWith(_level) || name.endsWith(_dimension)) continue;
            sumItemName.add(name);
        }
        return cubeItemName.equals(sumItemName);
    }

    public void getItemFromSummary(Element sumEle, Vector sumItem) {
        Vector tmpVector = new Vector();
        this.getChildElementsByTagName(sumEle, "rowEdge", tmpVector);
        this.getChildElementsByTagName(sumEle, "columnEdge", tmpVector);
        this.getChildElementsByTagName(sumEle, "sectionEdge", tmpVector);
        this.getChildElementsByTagName(sumEle, "dataCells", tmpVector);
        for (int i = 0; i < tmpVector.size(); ++i) {
            Element theV4Edge = (Element)tmpVector.get(i);
            this.getSummaryItems(theV4Edge, sumItem);
        }
    }

    protected boolean checkGroupingItems(Element aBIQuery, Element aCubeElem, Element theV5) {
        Vector allSummary = new Vector();
        this.getChildElementsByTagName(aBIQuery, _summary, allSummary);
        if (0 == allSummary.size()) {
            this.getAllSummaryReferToQuery(aBIQuery, allSummary);
        }
        if (0 == allSummary.size()) {
            return true;
        }
        Vector sel = new Vector();
        this.getChildElementsByTagName(theV5, _selection, sel);
        if (1 != sel.size()) {
            return true;
        }
        Element SelElem = (Element)sel.get(0);
        Vector groupingItems = new Vector();
        this.getChildElementsByTagNameAndAttribue(SelElem, _dataItem, _aggregate, _noneVal, groupingItems);
        if (0 == groupingItems.size()) {
            return true;
        }
        NodeList allCubeItems = aCubeElem.getElementsByTagName(_item);
        HashSet<String> CubeItemSet = new HashSet<String>();
        int i = 0;
        for (i = 0; i < allCubeItems.getLength(); ++i) {
            Element AItemElem = (Element)allCubeItems.item(i);
            if (!AItemElem.hasAttribute(_refItem)) continue;
            String dItemName = AItemElem.getAttribute(_refItem);
            CubeItemSet.add(dItemName);
        }
        int nS = 0;
        boolean bAllUsed = true;
        for (nS = 0; bAllUsed && nS < allSummary.size(); ++nS) {
            Element AGPItemElem;
            String aGPName;
            Element sumPart = (Element)allSummary.get(nS);
            NodeList allSummaryItems = sumPart.getElementsByTagName(_item);
            HashSet<String> SummaryItemSet = new HashSet<String>();
            for (i = 0; i < allSummaryItems.getLength(); ++i) {
                Element ele = (Element)allSummaryItems.item(i);
                String aName = ele.getAttribute(_refItem);
                if (!CubeItemSet.contains(aName)) continue;
                SummaryItemSet.add(aName);
            }
            for (i = 0; i < groupingItems.size() && !SummaryItemSet.contains(aGPName = (AGPItemElem = (Element)groupingItems.get(i)).getAttribute(_nameAttr)); ++i) {
            }
            if (i != groupingItems.size()) continue;
            return false;
        }
        return true;
    }

    protected boolean getCubeItems(Element theEle, Set aSet) {
        String tagName = theEle.getTagName();
        Vector itemVec = new Vector();
        Vector dataItemVec = new Vector();
        boolean bR = false;
        if (tagName.equals(_dimension) && theEle.hasAttribute(_nameAttr)) {
            String dimName = theEle.getAttribute(_nameAttr);
            aSet.add(dimName.concat(_dimension));
            Vector levelEles = new Vector();
            this.getChildElementsByTagName(theEle, _level, levelEles);
            for (int i = 0; i < levelEles.size(); ++i) {
                Element levelEle = (Element)levelEles.get(i);
                if (levelEle.hasAttribute(_nameAttr)) {
                    String levelName = levelEle.getAttribute(_nameAttr);
                    aSet.add(levelName.concat(_level));
                }
                itemVec.clear();
                dataItemVec.clear();
                this.getChildElementsByTagName(levelEle, _item, itemVec);
                this.getChildElementsByTagName(levelEle, _dataItem, dataItemVec);
                boolean bMKeys = this.addCubeItems(aSet, itemVec, dataItemVec);
                if (bR || !bMKeys) continue;
                bR = true;
            }
        } else {
            this.getChildElementsByTagName(theEle, _item, itemVec);
            this.getChildElementsByTagName(theEle, _dataItem, dataItemVec);
            this.addCubeItems(aSet, itemVec, dataItemVec);
        }
        return bR;
    }

    protected boolean addCubeItems(Set aSet, Vector itemVec, Vector dataItemVec) {
        String theV;
        int nKeys = 0;
        int nItems = 0;
        int i = 0;
        for (i = 0; i < itemVec.size(); ++i) {
            Element itemEle = (Element)itemVec.get(i);
            if (itemEle.hasAttribute(_key) && (theV = itemEle.getAttribute(_key)).equalsIgnoreCase(_true)) {
                ++nKeys;
            }
            if (itemEle.hasAttribute(_alias)) {
                aSet.add(itemEle.getAttribute(_alias));
                continue;
            }
            if (!itemEle.hasAttribute(_refItem)) continue;
            aSet.add(itemEle.getAttribute(_refItem));
        }
        for (i = 0; i < dataItemVec.size(); ++i) {
            Element dataItemEle = (Element)dataItemVec.get(i);
            if (dataItemEle.hasAttribute(_key) && (theV = dataItemEle.getAttribute(_key)).equalsIgnoreCase(_true)) {
                ++nKeys;
            }
            if (!dataItemEle.hasAttribute(_nameAttr)) continue;
            aSet.add(dataItemEle.getAttribute(_nameAttr));
        }
        nItems = itemVec.size() + dataItemVec.size();
        return nKeys > 1 || nItems > 1;
    }

    protected boolean summaryConsistent(Element theEle, Vector cubeDims) {
        Vector summaryItems = new Vector();
        this.getSummaryItems(theEle, summaryItems);
        for (int i = 0; i < cubeDims.size(); ++i) {
            Set theSet = (Set)cubeDims.get(i);
            if (this.checkConsist(summaryItems, theSet)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkConsist(Vector summaryItems, Set theSet) {
        String aName;
        boolean bHasOne = false;
        int i = 0;
        for (i = 0; i < summaryItems.size(); ++i) {
            aName = (String)summaryItems.get(i);
            if (!theSet.contains(aName)) continue;
            bHasOne = true;
            break;
        }
        if (bHasOne) {
            for (i = 0; i < summaryItems.size(); ++i) {
                aName = (String)summaryItems.get(i);
                if (theSet.contains(aName)) continue;
                return false;
            }
        }
        return true;
    }

    protected void getSummaryItems(Element theEle, Vector aVec) {
        String tagName = theEle.getTagName();
        Vector itemVec = new Vector();
        if (!tagName.equals("dataCells")) {
            String theName;
            Element dimEle;
            Vector dimVec = new Vector();
            this.getChildElementsByTagName(theEle, _dimension, dimVec);
            int i = 0;
            for (i = 0; i < dimVec.size(); ++i) {
                dimEle = (Element)dimVec.get(i);
                if (dimEle.hasAttribute("refDimension")) {
                    theName = dimEle.getAttribute("refDimension");
                    aVec.addElement(theName.concat(_dimension));
                }
                itemVec.clear();
                this.getChildElementsByTagName(dimEle, _item, itemVec);
                this.addSummaryItems(aVec, itemVec);
            }
            dimVec.clear();
            this.getChildElementsByTagName(theEle, _level, dimVec);
            for (i = 0; i < dimVec.size(); ++i) {
                dimEle = (Element)dimVec.get(i);
                if (dimEle.hasAttribute("refLevel")) {
                    theName = dimEle.getAttribute("refLevel");
                    aVec.addElement(theName.concat(_level));
                }
                itemVec.clear();
                this.getChildElementsByTagName(dimEle, _item, itemVec);
                this.addSummaryItems(aVec, itemVec);
            }
        } else {
            this.getChildElementsByTagName(theEle, _item, itemVec);
            this.addSummaryItems(aVec, itemVec);
        }
    }

    protected void addSummaryItems(Vector aVec, Vector itemVec) {
        int i = 0;
        for (i = 0; i < itemVec.size(); ++i) {
            Element itemEle = (Element)itemVec.get(i);
            if (!itemEle.hasAttribute(_refItem)) continue;
            aVec.addElement(itemEle.getAttribute(_refItem));
        }
    }

    public boolean getV4QueryName4V4CubeRef(Element aCubeRefElem, StringBuffer theRealName, Vector r) {
        if (!aCubeRefElem.hasAttribute(_refQueryAttr)) {
            return false;
        }
        theRealName.append(aCubeRefElem.getAttribute(_refQueryAttr));
        Vector v4QueryElems = new Vector();
        this.getChildElementsByTagNameAndAttribue(this.m_rootElem, _BIQUery, _nameAttr, theRealName.toString(), v4QueryElems);
        if (!v4QueryElems.isEmpty() && 1 == v4QueryElems.size()) {
            Element theBIQueryElem = (Element)v4QueryElems.firstElement();
            Vector theV4CubeElems = new Vector();
            this.getChildElementsByTagName(theBIQueryElem, _cube, theV4CubeElems);
            if (theV4CubeElems.isEmpty()) {
                this.getChildElementsByTagName(theBIQueryElem, _cubeRef, theV4CubeElems);
                if (!theV4CubeElems.isEmpty() && 1 == theV4CubeElems.size()) {
                    Element aNestedCubeRefElem = (Element)theV4CubeElems.firstElement();
                    int thelength = theRealName.length();
                    theRealName.delete(0, thelength);
                    return this.getV4QueryName4V4CubeRef(aNestedCubeRefElem, theRealName, r);
                }
                return false;
            }
            if (1 == theV4CubeElems.size()) {
                Element thecubeEle = (Element)theV4CubeElems.firstElement();
                r.addElement(thecubeEle);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean addIgnoredQueryMap(String ignoredQuery, String realQuery) {
        if (this.m_retDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_retDoc = builder.newDocument();
                this.m_retRootElem = this.m_retDoc.createElement("ret");
                this.m_retDoc.appendChild(this.m_retRootElem);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.m_retMapElem == null) {
            this.m_retMapElem = this.m_retDoc.createElement("theMap");
            this.m_retRootElem.appendChild(this.m_retMapElem);
        }
        Element qItem = this.m_retDoc.createElement("queryMap");
        qItem.setAttribute("ignored", ignoredQuery);
        qItem.setAttribute("equiv", realQuery);
        this.m_retMapElem.appendChild(qItem);
        return true;
    }

    protected void genV5NameMap() {
        HashSet<String> seenNames = new HashSet<String>();
        for (Map.Entry entry : this.m_BIQueryMap.entrySet()) {
            String key = (String)entry.getKey();
            StringBuffer value = (StringBuffer)entry.getValue();
            if (0 == value.toString().compareTo(_stIgnored)) continue;
            seenNames.add(key);
        }
        for (Node n = this.m_rootElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            String tagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(tagName = aElem.getTagName()).equals(_BIQUery)) continue;
            this.genV5NameMap4Tabs(aElem, seenNames);
        }
    }

    protected void genV5NameMap4Tabs(Element aElem, Set seenNames) {
        Vector v4TabularElems = new Vector();
        HashSet<String> aSet = new HashSet<String>();
        aSet.add(_tabularModel);
        aSet.add(_tabularSet);
        aSet.add(_tabularSQL);
        aSet.add(_tabularReference);
        aSet.add(_left);
        aSet.add(_right);
        this.getChildElementsByTagNameSet(aElem, aSet, v4TabularElems);
        for (int i = 0; i < v4TabularElems.size(); ++i) {
            Element v4TabularElem = (Element)v4TabularElems.get(i);
            if (this.m_V5QueryNameMap.containsKey(v4TabularElem)) continue;
            String tabTagName = v4TabularElem.getTagName();
            if (0 == tabTagName.compareTo(_tabularReference)) {
                Vector allRefs = new Vector();
                Vector theTarget = new Vector();
                this.getV4TargetTab4TabRef(v4TabularElem, allRefs, theTarget);
                if (theTarget.size() != 1) continue;
                v4TabularElem = (Element)theTarget.firstElement();
                this.assignUniqueName4Tab(v4TabularElem, seenNames);
                String theTargetName = (String)this.m_V5QueryNameMap.get(v4TabularElem);
                for (int j = 0; j < allRefs.size(); ++j) {
                    v4TabularElem = (Element)allRefs.get(j);
                    if (this.m_V5QueryNameMap.containsKey(v4TabularElem)) continue;
                    this.m_V5QueryNameMap.put(v4TabularElem, theTargetName);
                }
                continue;
            }
            this.assignUniqueName4Tab(v4TabularElem, seenNames);
        }
    }

    protected void getV4TargetTab4TabRef(Element v4TabRef, Vector allRefs, Vector theTarget) {
        if (!v4TabRef.hasAttribute(_refQueryAttr)) {
            return;
        }
        allRefs.addElement(v4TabRef);
        String theQName = v4TabRef.getAttribute(_refQueryAttr);
        Vector v4QueryElems = new Vector();
        this.getChildElementsByTagNameAndAttribue(this.m_rootElem, _BIQUery, _nameAttr, theQName, v4QueryElems);
        if (v4QueryElems.isEmpty() || 1 != v4QueryElems.size()) {
            return;
        }
        Element theBIQueryElem = (Element)v4QueryElems.firstElement();
        Vector v4TabularElems = new Vector();
        HashSet<String> aSet = new HashSet<String>();
        aSet.add(_tabularModel);
        aSet.add(_tabularSet);
        aSet.add(_tabularSQL);
        aSet.add(_tabularReference);
        this.getChildElementsByTagNameSet(theBIQueryElem, aSet, v4TabularElems);
        if (v4TabularElems.size() != 1) {
            return;
        }
        Element v4TabularElem = (Element)v4TabularElems.firstElement();
        String tabTagName = v4TabularElem.getTagName();
        if (0 == tabTagName.compareTo(_tabularReference)) {
            this.getV4TargetTab4TabRef(v4TabularElem, allRefs, theTarget);
        } else {
            theTarget.addElement(v4TabularElem);
        }
    }

    protected void assignUniqueName4Tab(Element v4TabularElem, Set seenNames) {
        String tabTagName = v4TabularElem.getTagName();
        if (0 == tabTagName.compareTo(_tabularModel)) {
            if (!this.m_V5QueryNameMap.containsKey(v4TabularElem)) {
                this.assignUniqueName(v4TabularElem, seenNames);
                this.genV5NameMap4Tabs(v4TabularElem, seenNames);
            }
        } else if (0 == tabTagName.compareTo(_tabularSet)) {
            if (!this.m_V5QueryNameMap.containsKey(v4TabularElem)) {
                this.assignUniqueName(v4TabularElem, seenNames);
                this.genV5NameMap4Tabs(v4TabularElem, seenNames);
            }
        } else if (0 == tabTagName.compareTo(_tabularSQL)) {
            if (!this.m_V5QueryNameMap.containsKey(v4TabularElem)) {
                this.assignUniqueName(v4TabularElem, seenNames);
            }
        } else {
            this.genV5NameMap4Tabs(v4TabularElem, seenNames);
        }
    }

    protected void assignUniqueName(Element v4Tab, Set seenNames) {
        String theName = v4Tab.getAttribute(_nameAttr);
        if (0 == theName.length()) {
            theName = v4Tab.getTagName();
        }
        String theTmpName = new String(theName);
        for (int i = 0; i < 500 && seenNames.contains(theTmpName); ++i) {
            theTmpName = theName.concat(Integer.toString(i));
        }
        seenNames.add(theTmpName);
        this.m_V5QueryNameMap.put(v4Tab, theTmpName);
    }

    protected String getV5UniqueName4Tab(Element tabEle, int theOption) {
        if (0 == theOption || 10 == theOption) {
            String rt = (String)this.m_V5QueryNameMap.get(tabEle);
            if (10 == theOption) {
                rt = rt.concat("_").concat(tabEle.getTagName());
            }
            return rt;
        }
        Element tmpParent = (Element)tabEle.getParentNode();
        String tagName = tmpParent.getTagName();
        if (0 == tagName.compareTo(_BIQUery)) {
            return tmpParent.getAttribute(_nameAttr);
        }
        return (String)this.m_V5QueryNameMap.get(tabEle);
    }

    protected boolean createQuery(Element aBIQuery) {
        String v4QueryName = aBIQuery.getAttribute(_nameAttr);
        StringBuffer st = (StringBuffer)this.m_BIQueryMap.get(v4QueryName);
        String s = st.toString();
        if (s.equals(_stIgnored)) {
            return true;
        }
        if (s.equals(_stCube_Info) || s.equals(_stCube)) {
            Vector v4CubeElems = new Vector();
            this.getChildElementsByTagName(aBIQuery, _cube, v4CubeElems);
            Element theCubeElem = (Element)v4CubeElems.firstElement();
            if (s.equals(_stCube)) {
                return this.createCubeQuery(aBIQuery, theCubeElem, false);
            }
            return this.createCubeQuery(aBIQuery, theCubeElem, true);
        }
        if (s.equals(_stTabular)) {
            Vector v4TabularElems = new Vector();
            this.getV4Tabular(aBIQuery, v4TabularElems);
            Element v4TabularElem = (Element)v4TabularElems.firstElement();
            return this.createTabularQuery(aBIQuery, v4QueryName, v4TabularElem, true);
        }
        return false;
    }

    protected boolean getV4Tabular(Element aBIQuery, Vector tabularElems) {
        Vector tmp = new Vector();
        this.getChildElementsByTagName(aBIQuery, _tabularModel, tmp);
        this.getChildElementsByTagName(aBIQuery, _tabularSet, tmp);
        this.getChildElementsByTagName(aBIQuery, _tabularSQL, tmp);
        this.getChildElementsByTagName(aBIQuery, _tabularReference, tmp);
        if (tmp.size() != 1) {
            return false;
        }
        Element aTabEle = (Element)tmp.firstElement();
        String tagName = aTabEle.getTagName();
        if (0 == tagName.compareTo(_tabularReference)) {
            return this.getV4Tab4TabRef(aTabEle, tabularElems);
        }
        tabularElems.addElement(aTabEle);
        return true;
    }

    protected boolean getV4Tab4TabRef(Element v4TabRef, Vector output) {
        if (!v4TabRef.hasAttribute(_refQueryAttr)) {
            return false;
        }
        String theQName = v4TabRef.getAttribute(_refQueryAttr);
        Vector v4QueryElems = new Vector();
        this.getChildElementsByTagNameAndAttribue(this.m_rootElem, _BIQUery, _nameAttr, theQName, v4QueryElems);
        if (v4QueryElems.isEmpty() || 1 != v4QueryElems.size()) {
            return false;
        }
        Element theBIQueryElem = (Element)v4QueryElems.firstElement();
        Vector tmp = new Vector();
        this.getChildElementsByTagName(theBIQueryElem, _tabularModel, tmp);
        this.getChildElementsByTagName(theBIQueryElem, _tabularSet, tmp);
        this.getChildElementsByTagName(theBIQueryElem, _tabularSQL, tmp);
        this.getChildElementsByTagName(theBIQueryElem, _tabularReference, tmp);
        if (tmp.size() != 1) {
            return false;
        }
        Element aTabEle = (Element)tmp.firstElement();
        String tagName = aTabEle.getTagName();
        if (0 == tagName.compareTo(_tabularReference)) {
            return this.getV4Tab4TabRef(aTabEle, output);
        }
        Vector tabRefVector = new Vector();
        this.getChildElementsByTagNameRecursive(aTabEle, _tabularReference, tabRefVector);
        for (int tsize = 0; tsize < tabRefVector.size(); ++tsize) {
            String tabRefQName;
            Element aTabRefEle = (Element)tabRefVector.get(tsize);
            if (!aTabRefEle.hasAttribute(_refQueryAttr) || 0 != theQName.compareTo(tabRefQName = aTabRefEle.getAttribute(_refQueryAttr))) continue;
            return false;
        }
        output.addElement(aTabEle);
        return true;
    }

    protected boolean createTabularQuery(Element aBIQuery, String theV5QueryName, Element v4TabularElem, boolean bIsTopTab) {
        int ret = this.createAV5Query(theV5QueryName);
        if (0 == ret) {
            return false;
        }
        if (2 == ret) {
            return true;
        }
        Element theV5Query = this.m_queryElem;
        Vector v4DataItemElems = new Vector();
        if (!this.createAV5Source(aBIQuery, theV5Query, v4TabularElem, v4DataItemElems, bIsTopTab)) {
            return false;
        }
        Element selectElem = this.m_retDoc.createElement(_selection);
        String tagName = v4TabularElem.getTagName();
        int nI = 0;
        if (tagName.equals(_tabularModel)) {
            String b;
            if (v4TabularElem.hasAttribute(_autoSummary) && (b = v4TabularElem.getAttribute(_autoSummary)).equalsIgnoreCase(_false)) {
                selectElem.setAttribute(_autoSummary, _false);
            }
            HashMap tabRenameMap = new HashMap();
            for (nI = 0; nI < v4DataItemElems.size(); ++nI) {
                Element AItemElem = (Element)v4DataItemElems.get(nI);
                if (!AItemElem.hasAttribute(_nameAttr)) {
                    return false;
                }
                String dItemName = AItemElem.getAttribute(_nameAttr);
                String theExpr = this.getExpression4TabModel(v4TabularElem, AItemElem, tabRenameMap, false, bIsTopTab);
                Element theV5DataItem = this.addAnItem(dItemName, AItemElem, theExpr);
                selectElem.appendChild(theV5DataItem);
            }
            theV5Query.appendChild(selectElem);
            this.addTabularModelFilters(theV5Query, v4TabularElem, tabRenameMap, bIsTopTab);
        } else {
            String theV5TabularUniqueName = this.getV5UniqueName4Tab(v4TabularElem, 10);
            this.setAutoSummary4QueryOperation(tagName, v4DataItemElems.size(), selectElem);
            for (nI = 0; nI < v4DataItemElems.size(); ++nI) {
                Element AItemElem = (Element)v4DataItemElems.get(nI);
                Element theV5DataItem = this.addAnItem_1(AItemElem.getAttribute(_nameAttr), theV5TabularUniqueName, AItemElem);
                selectElem.appendChild(theV5DataItem);
            }
            theV5Query.appendChild(selectElem);
        }
        this.addQueryHints(theV5Query, aBIQuery);
        return true;
    }

    private void setAutoSummary4QueryOperation(String tagName, int numOfV4DIs, Element selectElem) {
        if (tagName.equals(_tabularSet) || tagName.equals(_tabularSQL) && numOfV4DIs == 0) {
            selectElem.setAttribute(_autoSummary, _false);
        }
    }

    protected void addTabularModelFilters(Element theV5Query, Element v4TabularElem, Map tabRenameMap, boolean bIsTopTab) {
        Vector v4TabularModelFilters = new Vector();
        this.getChildElementsByTagName(v4TabularElem, _filter, v4TabularModelFilters);
        if (0 == v4TabularModelFilters.size()) {
            return;
        }
        Element detailFilterElem = this.m_retDoc.createElement("detailFilters");
        theV5Query.appendChild(detailFilterElem);
        String theV5QueryName = theV5Query.getAttribute(_nameAttr);
        for (int i = 0; i < v4TabularModelFilters.size(); ++i) {
            String fType;
            Element aV4Filter = (Element)v4TabularModelFilters.get(i);
            String theExpr = this.getExpression4TabModel(v4TabularElem, aV4Filter, tabRenameMap, false, bIsTopTab);
            Element theV5FilterItem = this.addADetailFilterItem(aV4Filter, theExpr);
            boolean bSummary = false;
            if (aV4Filter.hasAttribute(_summary) && (fType = aV4Filter.getAttribute(_summary)).equalsIgnoreCase(_true)) {
                bSummary = true;
            }
            if (bSummary) {
                theV5FilterItem.setAttribute("postAutoAggregation", _true);
            } else {
                theV5FilterItem.setAttribute("postAutoAggregation", _false);
            }
            detailFilterElem.appendChild(theV5FilterItem);
        }
    }

    protected Element addAnItem_1(String itemName, String theV4TabularName, Element AItemElem) {
        String theSort;
        Element theV5DataItem = this.m_retDoc.createElement(_dataItem);
        theV5DataItem.setAttribute(_nameAttr, itemName);
        if (AItemElem.hasAttribute(_sortAttr) && !(theSort = AItemElem.getAttribute(_sortAttr)).equalsIgnoreCase(_noneVal) && AItemElem.getParentNode().getNodeName().equals(_factList)) {
            theV5DataItem.setAttribute(_sortAttr, theSort);
        }
        Element theV5Expr = this.m_retDoc.createElement(_expression);
        StringBuffer expr = new StringBuffer();
        expr.append("[");
        expr.append(theV4TabularName);
        expr.append("].[");
        expr.append(itemName);
        expr.append("]");
        Text theExpString = this.m_retDoc.createTextNode(expr.toString());
        theV5Expr.appendChild(theExpString);
        theV5DataItem.appendChild(theV5Expr);
        return theV5DataItem;
    }

    protected Element addAnItem_2(String aliasName, String dItemName, Element AItemElem) {
        String theSort;
        Element theV5DataItem = this.m_retDoc.createElement(_dataItem);
        theV5DataItem.setAttribute(_nameAttr, aliasName);
        if (AItemElem.hasAttribute(_sortAttr) && !(theSort = AItemElem.getAttribute(_sortAttr)).equalsIgnoreCase(_noneVal)) {
            theV5DataItem.setAttribute(_sortAttr, theSort);
        }
        Element theV5Expr = this.m_retDoc.createElement(_expression);
        StringBuffer expr = new StringBuffer();
        expr.append("[");
        expr.append(dItemName);
        expr.append("]");
        Text theExpString = this.m_retDoc.createTextNode(expr.toString());
        theV5Expr.appendChild(theExpString);
        theV5DataItem.appendChild(theV5Expr);
        return theV5DataItem;
    }

    protected Element addASummaryFilterItem(Element v4FilterElem, String theExpr) {
        Element theV5FilterItem = this.m_retDoc.createElement("summaryFilter");
        if (v4FilterElem.hasAttribute("use")) {
            theV5FilterItem.setAttribute("use", v4FilterElem.getAttribute("use"));
        }
        if (theExpr.length() > 0) {
            Element thefilterexp = this.m_retDoc.createElement("filterExpression");
            Text theExpString = this.m_retDoc.createTextNode(theExpr.toString());
            thefilterexp.appendChild(theExpString);
            theV5FilterItem.appendChild(thefilterexp);
        }
        return theV5FilterItem;
    }

    protected Element addADetailFilterItem(Element v4FilterElem, String theExpr) {
        Element theV5FilterItem = this.m_retDoc.createElement("detailFilter");
        if (v4FilterElem.hasAttribute("use")) {
            theV5FilterItem.setAttribute("use", v4FilterElem.getAttribute("use"));
        }
        if (theExpr.length() > 0) {
            Element thefilterexp = this.m_retDoc.createElement("filterExpression");
            Text theExpString = this.m_retDoc.createTextNode(theExpr.toString());
            thefilterexp.appendChild(theExpString);
            theV5FilterItem.appendChild(thefilterexp);
        }
        return theV5FilterItem;
    }

    protected void getV4TabFilters(Element v4TabularElem, Vector v4tabFilterElems_detail, Vector v4tabFilterElems_summary) {
        Vector v4TabularModelFilters = new Vector();
        this.getChildElementsByTagName(v4TabularElem, _filter, v4TabularModelFilters);
        for (int i = 0; i < v4TabularModelFilters.size(); ++i) {
            String fType;
            Element aFilter = (Element)v4TabularModelFilters.get(i);
            boolean bSummary = false;
            if (aFilter.hasAttribute(_summary) && (fType = aFilter.getAttribute(_summary)).equalsIgnoreCase(_true)) {
                bSummary = true;
            }
            if (bSummary) {
                v4tabFilterElems_summary.addElement(aFilter);
                continue;
            }
            v4tabFilterElems_detail.addElement(aFilter);
        }
    }

    protected boolean createAV5Source(Element theBIQuery, Element theV5Query, Element v4TabularElem, Vector v4DataItemElems, boolean bIsTopTab) {
        Element srcElem = this.m_retDoc.createElement(_source);
        theV5Query.appendChild(srcElem);
        String v4TagName = v4TabularElem.getTagName();
        if (v4TagName.equals(_tabularModel)) {
            Element modelElem = this.m_retDoc.createElement(_model);
            srcElem.appendChild(modelElem);
            this.getChildElementsByTagName(v4TabularElem, _dataItem, v4DataItemElems);
            Vector theV4Tabulars = new Vector();
            Vector theV5QNames = new Vector();
            this.getV4TabularInTabularModel(v4TabularElem, theV4Tabulars, theV5QNames);
            if (!this.createSubQueries(theBIQuery, theV5Query, theV4Tabulars, theV5QNames, modelElem, false)) {
                return false;
            }
        } else if (v4TagName.equals(_tabularSQL)) {
            StringBuffer theSQLText;
            Element sqElem = this.m_retDoc.createElement("sqlQuery");
            String v5TabularUniqueName = this.getV5UniqueName4Tab(v4TabularElem, 10);
            sqElem.setAttribute(_nameAttr, v5TabularUniqueName);
            if (v4TabularElem.hasAttribute("idConnection")) {
                sqElem.setAttribute("dataSource", v4TabularElem.getAttribute("idConnection"));
            } else if (this.m_theDSName.length() > 0) {
                sqElem.setAttribute("dataSource", this.m_theDSName.toString());
            } else {
                sqElem.setAttribute("dataSource", _emptyStr);
            }
            Element sqlTextElem = this.m_retDoc.createElement("sqlText");
            Vector theV4SQLElems = new Vector();
            this.getChildElementsByTagName(v4TabularElem, "SQL", theV4SQLElems);
            if (theV4SQLElems.isEmpty() || theV4SQLElems.size() != 1) {
                return false;
            }
            Element theSQLElem = (Element)theV4SQLElems.firstElement();
            if (!this.getTheText(theSQLElem, theSQLText = new StringBuffer())) {
                return false;
            }
            Text theSQLString = this.m_retDoc.createTextNode(theSQLText.toString());
            sqlTextElem.appendChild(theSQLString);
            sqElem.appendChild(sqlTextElem);
            if (theSQLElem.hasAttribute("syntax")) {
                String sqlType = theSQLElem.getAttribute("syntax");
                if (sqlType.equalsIgnoreCase("native")) {
                    sqElem.setAttribute("type", "native");
                } else if (sqlType.equalsIgnoreCase("Cognos")) {
                    sqElem.setAttribute("type", "cogSQL");
                } else if (sqlType.equalsIgnoreCase("passThrough")) {
                    sqElem.setAttribute("type", "passThrough");
                }
            }
            this.getChildElementsByTagName(v4TabularElem, _dataItem, v4DataItemElems);
            if (v4DataItemElems.size() > 0) {
                Element projListElem = this.m_retDoc.createElement("mdProjectedItems");
                for (int nP = 0; nP < v4DataItemElems.size(); ++nP) {
                    Element qItemElem = this.m_retDoc.createElement("mdProjectedItem");
                    Element diElem = (Element)v4DataItemElems.get(nP);
                    qItemElem.setAttribute(_nameAttr, diElem.getAttribute(_nameAttr));
                    projListElem.appendChild(qItemElem);
                }
                sqElem.appendChild(projListElem);
            }
            srcElem.appendChild(sqElem);
        } else if (v4TagName.equals(_tabularSet)) {
            Element setElem = this.m_retDoc.createElement("queryOperation");
            if (v4TabularElem.hasAttribute(_setOperator)) {
                setElem.setAttribute("setOperation", v4TabularElem.getAttribute(_setOperator));
            }
            if (v4TabularElem.hasAttribute("duplicateRows")) {
                setElem.setAttribute("duplicates", v4TabularElem.getAttribute("duplicateRows"));
            }
            this.getChildElementsByTagName(v4TabularElem, _dataItem, v4DataItemElems);
            if (0 == v4DataItemElems.size()) {
                this.getV4DataItems4TabularSet(v4TabularElem, v4DataItemElems);
            }
            Vector theV4Tabulars = new Vector();
            Vector theQNames = new Vector();
            this.getV4TabularInTabularSet(v4TabularElem, theV4Tabulars, theQNames, true, 3);
            if (!this.createSubQueries(theBIQuery, theV5Query, theV4Tabulars, theQNames, setElem, true)) {
                return false;
            }
            if (v4DataItemElems.size() > 0) {
                Element projListElem = this.m_retDoc.createElement("projectionList");
                for (int nP = 0; nP < v4DataItemElems.size(); ++nP) {
                    Element qItemElem = this.m_retDoc.createElement(_queryItem);
                    Element diElem = (Element)v4DataItemElems.get(nP);
                    qItemElem.setAttribute(_nameAttr, diElem.getAttribute(_nameAttr));
                    projListElem.appendChild(qItemElem);
                }
                setElem.appendChild(projListElem);
            }
            String v5TabularUniqueName = this.getV5UniqueName4Tab(v4TabularElem, 10);
            setElem.setAttribute(_nameAttr, v5TabularUniqueName);
            srcElem.appendChild(setElem);
        }
        return true;
    }

    protected boolean createSubQueries(Element theBIQuery, Element theV5Query, Vector theV4Tabulars, Vector theQNames, Element v5Elem, boolean bAddQueryRefs) {
        if (0 == theV4Tabulars.size()) {
            return true;
        }
        Element qRefsElem = this.m_retDoc.createElement("queryRefs");
        for (int nI = 0; nI < theV4Tabulars.size(); ++nI) {
            String theSubV5TabularName;
            Element ATab = (Element)theV4Tabulars.get(nI);
            String theTagName = ATab.getTagName();
            if (theTagName.equals(_tabularReference) || this.createTabularQuery(theBIQuery, theSubV5TabularName = (String)theQNames.get(nI), ATab, false)) continue;
            return false;
        }
        if (bAddQueryRefs) {
            Element firstTab = (Element)theV4Tabulars.get(0);
            if (((Element)firstTab.getParentNode().getParentNode()).getTagName().equals(_tabularSet) && ((Element)firstTab.getParentNode().getParentNode()).getAttribute(_setOperator).equals("EXCEPT")) {
                if (theV4Tabulars.size() != 2 || theQNames.size() < 2) {
                    return false;
                }
                Element qRefElemL = this.m_retDoc.createElement("queryRef");
                qRefElemL.setAttribute(_refQueryAttr, ((Element)firstTab.getParentNode()).getTagName().equals(_left) ? (String)theQNames.get(0) : (String)theQNames.get(1));
                qRefsElem.appendChild(qRefElemL);
                Element qRefElemR = this.m_retDoc.createElement("queryRef");
                qRefElemR.setAttribute(_refQueryAttr, ((Element)firstTab.getParentNode()).getTagName().equals(_left) ? (String)theQNames.get(1) : (String)theQNames.get(0));
                qRefsElem.appendChild(qRefElemR);
            } else {
                for (int i = 0; i < theV4Tabulars.size(); ++i) {
                    Element qRefElem = this.m_retDoc.createElement("queryRef");
                    qRefElem.setAttribute(_refQueryAttr, (String)theQNames.get(i));
                    qRefsElem.appendChild(qRefElem);
                }
            }
            v5Elem.appendChild(qRefsElem);
        }
        return true;
    }

    protected void getV4TabularInTabularModel(Element v4TabularElem, Vector theV4Tabulars, Vector qNames) {
        Vector tmp = new Vector();
        this.getChildElementsByTagName(v4TabularElem, _tabularModel, tmp);
        this.getChildElementsByTagName(v4TabularElem, _tabularSet, tmp);
        this.getChildElementsByTagName(v4TabularElem, _tabularSQL, tmp);
        this.getChildElementsByTagName(v4TabularElem, _tabularReference, tmp);
        for (int nI = 0; nI < tmp.size(); ++nI) {
            Element aElem = (Element)tmp.get(nI);
            String theTagName = aElem.getTagName();
            if (0 == theTagName.compareTo(_tabularReference)) {
                Vector r = new Vector();
                if (!this.getV4Tab4TabRef(aElem, r)) continue;
                Element aK = (Element)r.firstElement();
                theV4Tabulars.addElement(aK);
                qNames.addElement(this.getV5UniqueName4Tab(aK, 0));
                continue;
            }
            theV4Tabulars.addElement(aElem);
            qNames.addElement(this.getV5UniqueName4Tab(aElem, 0));
        }
    }

    protected void getV4DataItems4TabularSet(Element v4TabularElem, Vector v4DataItemElems) {
        String v4Tag = v4TabularElem.getTagName();
        if (v4Tag.equals(_tabularModel)) {
            this.getChildElementsByTagName(v4TabularElem, _dataItem, v4DataItemElems);
        } else if (v4Tag.equals(_tabularSQL)) {
            this.getChildElementsByTagName(v4TabularElem, _dataItem, v4DataItemElems);
        } else {
            Vector theV4Tabulars = new Vector();
            Vector theQNames = new Vector();
            this.getV4TabularInTabularSet(v4TabularElem, theV4Tabulars, theQNames, true, 1);
            for (int nI = 0; nI < theV4Tabulars.size(); ++nI) {
                Element ATab = (Element)theV4Tabulars.get(nI);
                this.getV4DataItems4TabularSet(ATab, v4DataItemElems);
            }
        }
    }

    protected void getV4TabularInTabularSet(Element v4TabularElem, Vector theV4Tabulars, Vector qNames, boolean bWithTabRef, int whichSide) {
        Vector tmp = new Vector();
        HashSet<String> aSet = new HashSet<String>();
        aSet.add(_tabularModel);
        aSet.add(_tabularSet);
        aSet.add(_tabularSQL);
        aSet.add(_tabularReference);
        switch (whichSide) {
            case 1: {
                aSet.add(_left);
                break;
            }
            case 2: {
                aSet.add(_right);
                break;
            }
            case 3: {
                aSet.add(_left);
                aSet.add(_right);
            }
        }
        this.getChildElementsByTagNameSet(v4TabularElem, aSet, tmp);
        for (int i = 0; i < tmp.size(); ++i) {
            Element aElem = (Element)tmp.get(i);
            String theTagName = aElem.getTagName();
            if (theTagName.equals(_left) || theTagName.equals(_right)) {
                this.getV4TabularInTabularSet(aElem, theV4Tabulars, qNames, bWithTabRef, whichSide);
                continue;
            }
            String v5UniqueName = this.getV5UniqueName4Tab(aElem, 0);
            if (0 == theTagName.compareTo(_tabularReference)) {
                Vector r;
                if (!bWithTabRef || !this.getV4Tab4TabRef(aElem, r = new Vector())) continue;
                Element aK = (Element)r.firstElement();
                theV4Tabulars.addElement(aK);
                qNames.addElement(this.getV5UniqueName4Tab(aK, 0));
                continue;
            }
            theV4Tabulars.add(aElem);
            qNames.addElement(v5UniqueName);
        }
    }

    protected boolean createCubeQuery(Element aBIQuery, Element aCubeElem, boolean needDimInfo) {
        if (this.m_v5DataItemToV4Agg == null) {
            this.m_v5DataItemToV4Agg = new HashMap();
        } else {
            this.m_v5DataItemToV4Agg.clear();
        }
        String theQueryName = aBIQuery.getAttribute(_nameAttr);
        Vector v4TabularElems = new Vector();
        if (!this.getV4Tabular(aBIQuery, v4TabularElems)) {
            if (0 == v4TabularElems.size()) {
                if (0 == this.createAV5Query(theQueryName)) {
                    return false;
                }
                Element srcElem = this.m_retDoc.createElement(_source);
                this.m_queryElem.appendChild(srcElem);
                Element modelElem = this.m_retDoc.createElement(_model);
                srcElem.appendChild(modelElem);
                Element selectionElem = this.m_retDoc.createElement(_selection);
                this.m_queryElem.appendChild(selectionElem);
                return true;
            }
            return false;
        }
        Element v4TabularElem = (Element)v4TabularElems.firstElement();
        int ret = this.createAV5Query(theQueryName);
        if (0 == ret) {
            return false;
        }
        if (2 == ret) {
            return true;
        }
        Element theV5Query = this.m_queryElem;
        Vector v4DataItemElems = new Vector();
        StringBuffer queryOperName = new StringBuffer();
        if (!this.createAV5Source(aBIQuery, theV5Query, v4TabularElem, v4DataItemElems, true)) {
            return false;
        }
        String tabularTag = v4TabularElem.getTagName();
        HashMap tabRenameMapMain = new HashMap();
        Element theDetailFilter2Move = null;
        if (tabularTag.equals(_tabularModel)) {
            if (!this.createACubeSelection4TabModel(aBIQuery, theV5Query, aCubeElem, v4TabularElem, v4DataItemElems, tabRenameMapMain)) {
                return false;
            }
            if (this.m_RefQuery2DataItemsMap.isEmpty()) {
                this.addTabularModelFilters(theV5Query, v4TabularElem, tabRenameMapMain, true);
            } else {
                theDetailFilter2Move = this.m_retDoc.createElement("filterToBeMoved");
                this.addTabularModelFilters(theDetailFilter2Move, v4TabularElem, tabRenameMapMain, true);
            }
            this.addFilter4TabModel(theV5Query, aCubeElem, tabRenameMapMain);
        } else {
            if (!this.createACubeSelection4Tab(theV5Query, aCubeElem, v4TabularElem, v4DataItemElems)) {
                return false;
            }
            HashMap tabRenameMap = new HashMap();
            this.addFilter4TabModel(theV5Query, aCubeElem, tabRenameMap);
        }
        boolean bDimAdded = false;
        if (this.checkIfDimInfoIsRequired(aBIQuery, aCubeElem, theV5Query, theQueryName, tabularTag, needDimInfo)) {
            this.addDimensionInformation(theV5Query, aBIQuery, aCubeElem);
            bDimAdded = true;
        }
        this.addDimensionInformationWithAdditionalFacts(bDimAdded, theV5Query, aCubeElem, v4TabularElem, v4DataItemElems, tabRenameMapMain);
        if (bDimAdded) {
            for (Map.Entry entry : this.m_v5DataItemToV4Agg.entrySet()) {
                Element v5DataItem = (Element)entry.getKey();
                String v4Agg = (String)entry.getValue();
                if (v4Agg.equalsIgnoreCase(_false)) {
                    v5DataItem.setAttribute(_rollupAggregate, _noneVal);
                    continue;
                }
                if (v4Agg.equalsIgnoreCase("any") || v4Agg.equalsIgnoreCase("averageNonZero") || v4Agg.equalsIgnoreCase("countNonZero") || v4Agg.equalsIgnoreCase(_true)) {
                    v5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                    continue;
                }
                v5DataItem.setAttribute(_rollupAggregate, v4Agg);
            }
        }
        this.addQueryHints(theV5Query, aBIQuery);
        return this.m_RefQuery2DataItemsMap.size() != 1 || false != this.generateReferencedQuery(aBIQuery, theDetailFilter2Move);
    }

    protected boolean checkIfDimInfoIsRequired(Element aBIQuery, Element aCubeElem, Element theV5Query, String BIQueryName, String tabularTag, boolean needDimInfo) {
        if (needDimInfo) {
            return true;
        }
        if (this.m_SharedBIQueryNames != null && this.m_SharedBIQueryNames.contains(BIQueryName)) {
            return true;
        }
        return true == tabularTag.equals(_tabularModel) && false == this.checkGroupingItems(aBIQuery, aCubeElem, theV5Query);
    }

    protected boolean generateReferencedQuery(Element aBIQuery, Element detailFilters) {
        Node detailFiltersNode;
        Set entrySet = this.m_RefQuery2DataItemsMap.entrySet();
        Iterator iter = entrySet.iterator();
        Map.Entry entry = iter.next();
        String uniqueQName = (String)entry.getKey();
        if (0 == this.createAV5Query(uniqueQName)) {
            return false;
        }
        Element srcElem = this.m_retDoc.createElement(_source);
        this.m_queryElem.appendChild(srcElem);
        Element modelElem = this.m_retDoc.createElement(_model);
        srcElem.appendChild(modelElem);
        Element selectionElem = this.m_retDoc.createElement(_selection);
        this.m_queryElem.appendChild(selectionElem);
        Vector dataItemVec = (Vector)this.m_RefQuery2DataItemsMap.get(uniqueQName);
        for (int i = 0; i < dataItemVec.size(); ++i) {
            Element diElm = (Element)dataItemVec.get(i);
            selectionElem.appendChild(diElm);
        }
        if (detailFilters != null && (detailFiltersNode = detailFilters.getFirstChild()) != null) {
            Element dFilters = (Element)detailFiltersNode;
            this.m_queryElem.appendChild(dFilters);
        }
        this.addQueryHints(this.m_queryElem, aBIQuery);
        this.m_RefQuery2DataItemsMap.clear();
        return true;
    }

    protected String generateUniqueQueryName(String inputQname) {
        inputQname = inputQname.concat("_Ref");
        String uniqueName = new String(inputQname);
        int bCount = 0;
        while (this.m_V5QueryNameMap.containsValue(uniqueName) || this.m_BIQueryMap.containsKey(uniqueName)) {
            uniqueName = inputQname.concat(Integer.toString(bCount));
            ++bCount;
        }
        return uniqueName;
    }

    protected void addQueryHints(Element theV5Query, Element aBIQuery) {
        Vector<Element> hints = new Vector<Element>();
        for (Node n = aBIQuery.getFirstChild(); n != null; n = n.getNextSibling()) {
            String gvName;
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(theTagName = aElem.getTagName()).equals("avoidZeroDiv") && !theTagName.equals("executionOptimization") && !theTagName.equals("queryProcessing") && !theTagName.equals("autoSort") && !theTagName.equals("rollupProcessing") && !theTagName.equals("governor") || theTagName.equals("governor") && (!aElem.hasAttribute(_nameAttr) || !(gvName = aElem.getAttribute(_nameAttr)).equals("outerJoinAllowed") && !gvName.equals("crossProductAllowed") && !gvName.equals("useSQLWithClause") && !gvName.equals("maxRowsRetrieved") && !gvName.equals("maxTablesPerQuery") && !gvName.equals("maxQueryExecutionTime") && !gvName.equals("maxTextBlobCharacters") && !gvName.equals("useLocalCache") && !gvName.equals("localCache"))) continue;
            hints.addElement(aElem);
        }
        Element theV5Hints = this.m_retDoc.createElement("queryHints");
        Element theV4Hint = this.m_retDoc.createElement("useV4Interpretation");
        theV4Hint.setAttribute("value", _true);
        theV5Hints.appendChild(theV4Hint);
        for (int i = 0; i < hints.size(); ++i) {
            String v;
            Element theV5Hint;
            String v2;
            Element theV5Hint2;
            Element aElem = (Element)hints.get(i);
            String theTagName = aElem.getTagName();
            if (theTagName.equals("avoidZeroDiv")) {
                theV5Hint2 = this.m_retDoc.createElement("avoidZeroDiv");
                if (aElem.hasAttribute("enabled")) {
                    theV5Hint2.setAttribute("value", aElem.getAttribute("enabled"));
                }
                theV5Hints.appendChild(theV5Hint2);
                continue;
            }
            if (theTagName.equals("executionOptimization")) {
                theV5Hint2 = this.m_retDoc.createElement("executionOptimization");
                if (aElem.hasAttribute("strategy")) {
                    theV5Hint2.setAttribute("value", aElem.getAttribute("strategy"));
                }
                theV5Hints.appendChild(theV5Hint2);
                continue;
            }
            if (theTagName.equals("queryProcessing")) {
                theV5Hint2 = this.m_retDoc.createElement("queryProcessing");
                if (aElem.hasAttribute("strategy")) {
                    v2 = aElem.getAttribute("strategy");
                    if (v2.equalsIgnoreCase("DatabaseOnly")) {
                        theV5Hint2.setAttribute("value", "databaseOnly");
                    } else {
                        theV5Hint2.setAttribute("value", "minimizeLocal");
                    }
                } else {
                    theV5Hint2.setAttribute("value", "minimizeLocal");
                }
                theV5Hints.appendChild(theV5Hint2);
                continue;
            }
            if (theTagName.equals("autoSort")) {
                theV5Hint2 = this.m_retDoc.createElement("autoSort");
                if (aElem.hasAttribute("enable")) {
                    v2 = aElem.getAttribute("enable");
                    if (v2.equalsIgnoreCase("minimal")) {
                        theV5Hint2.setAttribute("value", "minimal");
                    } else if (v2.equalsIgnoreCase(_true)) {
                        theV5Hint2.setAttribute("value", "all");
                    } else {
                        theV5Hint2.setAttribute("value", _noneVal);
                    }
                }
                theV5Hints.appendChild(theV5Hint2);
                continue;
            }
            if (theTagName.equals("rollupProcessing")) {
                theV5Hint2 = this.m_retDoc.createElement("rollupProcessing");
                if (aElem.hasAttribute("strategy")) {
                    theV5Hint2.setAttribute("value", aElem.getAttribute("strategy"));
                }
                theV5Hints.appendChild(theV5Hint2);
                continue;
            }
            if (!theTagName.equals("governor")) continue;
            String gvName = aElem.getAttribute(_nameAttr);
            if (gvName.equals("outerJoinAllowed")) {
                theV5Hint = this.m_retDoc.createElement("outerJoinAllowed");
                if (aElem.hasAttribute("value")) {
                    v = aElem.getAttribute("value");
                    if (v.equalsIgnoreCase("0")) {
                        theV5Hint.setAttribute("value", "allow");
                    } else if (v.equalsIgnoreCase("1")) {
                        theV5Hint.setAttribute("value", "warn");
                    } else {
                        theV5Hint.setAttribute("value", "deny");
                    }
                } else {
                    theV5Hint.setAttribute("value", "deny");
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("crossProductAllowed")) {
                theV5Hint = this.m_retDoc.createElement("crossProductAllowed");
                if (aElem.hasAttribute("value")) {
                    v = aElem.getAttribute("value");
                    if (v.equalsIgnoreCase("0")) {
                        theV5Hint.setAttribute("value", "allow");
                    } else if (v.equalsIgnoreCase("1")) {
                        theV5Hint.setAttribute("value", "warn");
                    } else {
                        theV5Hint.setAttribute("value", "deny");
                    }
                } else {
                    theV5Hint.setAttribute("value", "deny");
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("useSQLWithClause")) {
                theV5Hint = this.m_retDoc.createElement("useSQLWithClause");
                if (aElem.hasAttribute("value")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("maxRowsRetrieved")) {
                theV5Hint = this.m_retDoc.createElement("maxRowsRetrieved");
                if (aElem.hasAttribute("value") && !(v = aElem.getAttribute("value")).equalsIgnoreCase("0")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("maxTablesPerQuery")) {
                theV5Hint = this.m_retDoc.createElement("maxTablesPerQuery");
                if (aElem.hasAttribute("value")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("maxQueryExecutionTime")) {
                theV5Hint = this.m_retDoc.createElement("maxQueryExecutionTime");
                if (aElem.hasAttribute("value")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("maxTextBlobCharacters")) {
                theV5Hint = this.m_retDoc.createElement("maxTextBlobCharacters");
                if (aElem.hasAttribute("value")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (gvName.equals("useLocalCache")) {
                theV5Hint = this.m_retDoc.createElement("localCache");
                if (aElem.hasAttribute("value")) {
                    theV5Hint.setAttribute("value", aElem.getAttribute("value"));
                }
                theV5Hints.appendChild(theV5Hint);
                continue;
            }
            if (!gvName.equals("localCache")) continue;
            theV5Hint = this.m_retDoc.createElement("localCache");
            if (aElem.hasAttribute("value")) {
                theV5Hint.setAttribute("value", aElem.getAttribute("value"));
            }
            theV5Hints.appendChild(theV5Hint);
        }
        theV5Query.appendChild(theV5Hints);
    }

    protected void addDimensionInformation(Element theV5Query, Element aBIQuery, Element aCubeElem) {
        Element theV5DimInfo = this.m_retDoc.createElement(_dimensionInfo);
        Vector v4DimEles = new Vector();
        this.getChildElementsByTagName(aCubeElem, _dimension, v4DimEles);
        if (v4DimEles.size() > 0) {
            Element theV5Dims = this.m_retDoc.createElement("dimensions");
            for (int i = 0; i < v4DimEles.size(); ++i) {
                Element theV5Dim = this.m_retDoc.createElement(_dimension);
                Element theV4Dim = (Element)v4DimEles.get(i);
                if (theV4Dim.hasAttribute(_nameAttr)) {
                    theV5Dim.setAttribute(_nameAttr, theV4Dim.getAttribute(_nameAttr));
                }
                Vector v4LevelEles = new Vector();
                this.getChildElementsByTagName(theV4Dim, _level, v4LevelEles);
                if (v4LevelEles.size() > 0) {
                    Element theV5Levels = this.m_retDoc.createElement("levels");
                    StringBuffer autoSortValueStr = new StringBuffer();
                    this.getAutoSortValuesFromBIQuery(aBIQuery, autoSortValueStr);
                    for (int j = 0; j < v4LevelEles.size(); ++j) {
                        Element theV5Level = this.m_retDoc.createElement(_level);
                        Element v4Level = (Element)v4LevelEles.get(j);
                        if (v4Level.hasAttribute(_nameAttr)) {
                            theV5Level.setAttribute(_nameAttr, v4Level.getAttribute(_nameAttr));
                        }
                        this.addLevelKeys(theV5Level, v4Level);
                        this.addLevelAttributes(theV5Level, v4Level);
                        boolean force2AddSort = v4DimEles.size() == 1;
                        boolean isLowestLevel = j == v4LevelEles.size() - 1;
                        this.addLevelSorts(theV5Level, v4Level, aBIQuery, isLowestLevel, autoSortValueStr.toString(), force2AddSort);
                        this.addLevelCaption(theV5Level, v4Level);
                        theV5Levels.appendChild(theV5Level);
                    }
                    theV5Dim.appendChild(theV5Levels);
                }
                theV5Dims.appendChild(theV5Dim);
            }
            theV5DimInfo.appendChild(theV5Dims);
        }
        Vector v4FactElems = new Vector();
        this.getChildElementsByTagName(aCubeElem, _factList, v4FactElems);
        if (1 == v4FactElems.size()) {
            Element v4FactEle = (Element)v4FactElems.firstElement();
            Element theV5FactList = this.m_retDoc.createElement(_factList);
            Vector v4ItemVec = new Vector();
            Vector v4DataItemVec = new Vector();
            this.getChildElementsByTagName(v4FactEle, _item, v4ItemVec);
            this.getChildElementsByTagName(v4FactEle, _dataItem, v4DataItemVec);
            int i = 0;
            for (i = 0; i < v4ItemVec.size(); ++i) {
                Element v4Item = (Element)v4ItemVec.get(i);
                Element theV5Fact = this.m_retDoc.createElement(_fact);
                if (v4Item.hasAttribute(_alias)) {
                    theV5Fact.setAttribute(_nameAttr, v4Item.getAttribute(_alias));
                    theV5Fact.setAttribute(_v5RefDataItemAttr, v4Item.getAttribute(_alias));
                } else {
                    theV5Fact.setAttribute(_nameAttr, v4Item.getAttribute(_refItem));
                    theV5Fact.setAttribute(_v5RefDataItemAttr, v4Item.getAttribute(_refItem));
                }
                theV5FactList.appendChild(theV5Fact);
            }
            for (i = 0; i < v4DataItemVec.size(); ++i) {
                String v4DataItemName;
                Element v4DataItem = (Element)v4DataItemVec.get(i);
                String v5QueryName = theV5Query.getAttribute(_nameAttr);
                if (this.isAliasUsedForDataItemCreation(v5QueryName, v4DataItemName = v4DataItem.getAttribute(_nameAttr))) continue;
                Element theV5Fact = this.m_retDoc.createElement(_fact);
                theV5Fact.setAttribute(_nameAttr, v4DataItem.getAttribute(_nameAttr));
                theV5Fact.setAttribute(_v5RefDataItemAttr, v4DataItem.getAttribute(_nameAttr));
                theV5FactList.appendChild(theV5Fact);
            }
            theV5DimInfo.appendChild(theV5FactList);
        }
        theV5Query.appendChild(theV5DimInfo);
    }

    protected boolean isAliasUsedForDataItemCreation(String v5QueryName, String v4DataItemName) {
        if (this.m_retMapElem == null) {
            return false;
        }
        Vector aliasMapVec = new Vector();
        this.getChildElementsByTagName(this.m_retMapElem, "aliasMap", aliasMapVec);
        int i = 0;
        for (i = 0; i < aliasMapVec.size(); ++i) {
            Element aliasElem = (Element)aliasMapVec.get(i);
            String itemName = aliasElem.getAttribute(_item);
            String queryName = aliasElem.getAttribute("query");
            if (!queryName.equals(v5QueryName) || !itemName.equals(v4DataItemName)) continue;
            return true;
        }
        return false;
    }

    protected void addLevelKeys(Element theV5Level, Element v4Level) {
        Vector<Element> keyItems = new Vector<Element>();
        for (Node n = v4Level.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theV;
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(theTagName = aElem.getTagName()).equals(_item) && !theTagName.equals(_dataItem) || !aElem.hasAttribute(_key) || !(theV = aElem.getAttribute(_key)).equalsIgnoreCase(_true)) continue;
            keyItems.addElement(aElem);
        }
        Element theV5keys = this.m_retDoc.createElement("keys");
        for (int i = 0; i < keyItems.size(); ++i) {
            Element aElem = (Element)keyItems.get(i);
            Element theV5key = this.m_retDoc.createElement(_key);
            String tag = aElem.getTagName();
            if (tag.equals(_item)) {
                if (aElem.hasAttribute(_alias)) {
                    theV5key.setAttribute(_nameAttr, aElem.getAttribute(_alias));
                    theV5key.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_alias));
                } else {
                    theV5key.setAttribute(_nameAttr, aElem.getAttribute(_refItem));
                    theV5key.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_refItem));
                }
            } else if (aElem.hasAttribute(_nameAttr)) {
                theV5key.setAttribute(_nameAttr, aElem.getAttribute(_nameAttr));
                theV5key.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_nameAttr));
            }
            theV5keys.appendChild(theV5key);
        }
        theV5Level.appendChild(theV5keys);
    }

    protected void addLevelAttributes(Element theV5Level, Element v4Level) {
        Vector<Element> attrItems = new Vector<Element>();
        for (Node n = v4Level.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theV;
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(theTagName = aElem.getTagName()).equals(_item) && !theTagName.equals(_dataItem) || aElem.hasAttribute(_key) && (theV = aElem.getAttribute(_key)).equalsIgnoreCase(_true)) continue;
            attrItems.addElement(aElem);
        }
        if (0 == attrItems.size()) {
            return;
        }
        Element theV5Attrs = this.m_retDoc.createElement("attributes");
        for (int i = 0; i < attrItems.size(); ++i) {
            Element aElem = (Element)attrItems.get(i);
            Element theV5Attr = this.m_retDoc.createElement("attribute");
            String tag = aElem.getTagName();
            if (tag.equals(_item)) {
                if (aElem.hasAttribute(_alias)) {
                    theV5Attr.setAttribute(_nameAttr, aElem.getAttribute(_alias));
                    theV5Attr.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_alias));
                } else {
                    theV5Attr.setAttribute(_nameAttr, aElem.getAttribute(_refItem));
                    theV5Attr.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_refItem));
                }
            } else if (aElem.hasAttribute(_nameAttr)) {
                theV5Attr.setAttribute(_nameAttr, aElem.getAttribute(_nameAttr));
                theV5Attr.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_nameAttr));
            }
            theV5Attrs.appendChild(theV5Attr);
        }
        theV5Level.appendChild(theV5Attrs);
    }

    protected void addLevelSorts(Element theV5Level, Element v4Level, Element aBIQuery, boolean isLowestLevel, String autoSortValue, boolean force2AddSort) {
        Vector<Element> sortItems = new Vector<Element>();
        HashMap<String, String> DI2SortMap = new HashMap<String, String>();
        boolean applyDefaultSortRules = this.need2ApplyBalticDefaultSortingRules(aBIQuery, autoSortValue, isLowestLevel);
        for (Node n = v4Level.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(theTagName = aElem.getTagName()).equals(_item) && !theTagName.equals(_dataItem) || !aElem.hasAttribute(_sortAttr) && !applyDefaultSortRules && !force2AddSort) continue;
            String refItemName = true == theTagName.equals(_item) ? aElem.getAttribute(_refItem) : aElem.getAttribute(_nameAttr);
            String theSortStr = this.getSortAttributeFromTab(refItemName, aElem, aBIQuery);
            if (theSortStr.equalsIgnoreCase(_noneVal)) {
                String keyValue = null;
                if (aElem.hasAttribute(_key)) {
                    keyValue = aElem.getAttribute(_key);
                }
                if (!applyDefaultSortRules || keyValue == null || !keyValue.equals(_true)) continue;
                theSortStr = "ascending";
            }
            sortItems.addElement(aElem);
            DI2SortMap.put(refItemName, theSortStr);
        }
        if (0 == sortItems.size()) {
            return;
        }
        Element theV5Sorts = this.m_retDoc.createElement("sortList");
        for (int i = 0; i < sortItems.size(); ++i) {
            String refItemName;
            Element aElem = (Element)sortItems.get(i);
            Element theV5SortItem = this.m_retDoc.createElement("sortItem");
            String tag = aElem.getTagName();
            if (tag.equals(_item)) {
                if (aElem.hasAttribute(_alias)) {
                    theV5SortItem.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_alias));
                } else {
                    theV5SortItem.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_refItem));
                }
                refItemName = aElem.getAttribute(_refItem);
            } else {
                if (aElem.hasAttribute(_nameAttr)) {
                    theV5SortItem.setAttribute(_v5RefDataItemAttr, aElem.getAttribute(_nameAttr));
                }
                refItemName = aElem.getAttribute(_nameAttr);
            }
            String theSort = (String)DI2SortMap.get(refItemName);
            if (!theSort.equalsIgnoreCase(_noneVal)) {
                theV5SortItem.setAttribute(_sortOrderAttr, theSort);
            }
            theV5Sorts.appendChild(theV5SortItem);
        }
        theV5Level.appendChild(theV5Sorts);
    }

    private void getAutoSortValuesFromBIQuery(Element aBIQuery, StringBuffer autoSortValue) {
        Element sortElem;
        String enableValue;
        Vector autoSortVec = new Vector();
        this.getChildElementsByTagName(aBIQuery, "autoSort", autoSortVec);
        String BIQueryName = aBIQuery.getAttribute(_nameAttr);
        if (autoSortVec.size() == 1 && (enableValue = (sortElem = (Element)autoSortVec.get(0)).getAttribute("enable")) != null) {
            autoSortValue.append(enableValue);
            return;
        }
        autoSortValue.append("minimal");
    }

    private boolean need2ApplyBalticDefaultSortingRules(Element aBIQuery, String autoSortStr, boolean isLowestLevel) {
        String BIQueryName = aBIQuery.getAttribute(_nameAttr);
        if (autoSortStr == null) {
            return false;
        }
        if (autoSortStr.equalsIgnoreCase(_false)) {
            return false;
        }
        if (autoSortStr.equalsIgnoreCase(_true)) {
            return true;
        }
        if (autoSortStr.equalsIgnoreCase("minimal")) {
            if (this.isSummaryQuery(aBIQuery)) {
                return false;
            }
            if (this.containsFactList(aBIQuery)) {
                return true;
            }
            if (!isLowestLevel) {
                return true;
            }
        }
        return false;
    }

    private boolean isSummaryQuery(Element aBIQuery) {
        Vector v4SumElems = new Vector();
        this.getChildElementsByTagName(aBIQuery, _summary, v4SumElems);
        return true != v4SumElems.isEmpty() && v4SumElems.size() == 1;
    }

    private boolean containsFactList(Element aBIQuery) {
        Vector v4FactListElems = new Vector();
        this.getChildElementsByTagNameRecursive(aBIQuery, _factList, v4FactListElems);
        return true != v4FactListElems.isEmpty() && v4FactListElems.size() == 1;
    }

    protected String getSortAttributeFromTab(String refItemName, Element aElement, Element aBIQuery) {
        if (aElement.hasAttribute(_sortAttr)) {
            return aElement.getAttribute(_sortAttr);
        }
        Vector v4DataItemElems = new Vector();
        this.getChildElementsByTagNameRecursive(aBIQuery, _dataItem, v4DataItemElems);
        String sortStr = _noneVal;
        for (int i = 0; i < v4DataItemElems.size(); ++i) {
            Element aDIElem = (Element)v4DataItemElems.get(i);
            if (!aDIElem.hasAttribute(_sortAttr) || refItemName.compareTo(aDIElem.getAttribute(_nameAttr)) != 0) continue;
            sortStr = aDIElem.getAttribute(_sortAttr);
            break;
        }
        return sortStr;
    }

    protected void addLevelCaption(Element theV5Level, Element v4Level) {
        if (v4Level.hasAttribute("caption")) {
            Element theV5Cap = this.m_retDoc.createElement("caption");
            Element theV5Ref = this.m_retDoc.createElement("dataItemRef");
            theV5Ref.setAttribute(_v5RefDataItemAttr, v4Level.getAttribute("caption"));
            theV5Cap.appendChild(theV5Ref);
            theV5Level.appendChild(theV5Cap);
        }
    }

    protected boolean cubeContainsFilter(Element aCubeElem, Vector v4CubeFilters) {
        this.getChildElementsByTagName(aCubeElem, _filter, v4CubeFilters);
        return v4CubeFilters.size() > 0;
    }

    protected void addFilter4TabModel(Element theV5Query, Element aCubeElem, Map tabRenameMap) {
        Element v5Summary;
        Vector v4CubeFilters = new Vector();
        if (!this.cubeContainsFilter(aCubeElem, v4CubeFilters)) {
            return;
        }
        String theV5QueryName = theV5Query.getAttribute(_nameAttr);
        Vector v5summaryFilters = new Vector();
        this.getChildElementsByTagName(theV5Query, "summaryFilters", v5summaryFilters);
        if (v5summaryFilters.size() > 0) {
            v5Summary = (Element)v5summaryFilters.firstElement();
        } else {
            v5Summary = this.m_retDoc.createElement("summaryFilters");
            theV5Query.appendChild(v5Summary);
        }
        for (int i = 0; i < v4CubeFilters.size(); ++i) {
            Element aFilter = (Element)v4CubeFilters.get(i);
            String theExpr = this.getExpression4TabModel(aFilter, aFilter, tabRenameMap, true, true);
            Element theV5FilterItem = this.addASummaryFilterItem(aFilter, theExpr);
            v5Summary.appendChild(theV5FilterItem);
            this.addALevelRefFilter(aFilter, aCubeElem, theV5FilterItem);
        }
    }

    protected void addALevelRefFilter(Element theV4Filter, Element theV4CubeElem, Element theV5SummaryFilter) {
        Vector<String> vRefItemNames = new Vector<String>();
        Vector v4FilterLevels = new Vector();
        this.getChildElementsByTagName(theV4Filter, _level, v4FilterLevels);
        if (0 == v4FilterLevels.size()) {
            Element theV4BIQuery = (Element)theV4CubeElem.getParentNode();
            Element theV4Summary = this.queryReferredAndHasSummary(theV4BIQuery);
            if (theV4Summary.getTagName().equals("_nothing_")) {
                return;
            }
            Vector vV4rowEdges = new Vector();
            this.getChildElementsByTagName(theV4Summary, "rowEdge", vV4rowEdges);
            if (1 != vV4rowEdges.size()) {
                return;
            }
            Vector vV4columnEdges = new Vector();
            this.getChildElementsByTagName(theV4Summary, "columnEdge", vV4columnEdges);
            if (1 != vV4columnEdges.size()) {
                return;
            }
            Vector vV4sectionEdges = new Vector();
            this.getChildElementsByTagName(theV4Summary, "sectionEdge", vV4sectionEdges);
            if (1 < vV4sectionEdges.size()) {
                return;
            }
            Vector vV4AllEdges = new Vector();
            vV4AllEdges.add(vV4rowEdges.get(0));
            vV4AllEdges.add(vV4columnEdges.get(0));
            if (1 == vV4sectionEdges.size()) {
                vV4AllEdges.add(vV4sectionEdges.get(0));
            }
            for (int ii = 0; ii < vV4AllEdges.size(); ++ii) {
                Element aV4edge = (Element)vV4AllEdges.get(ii);
                Vector vV4Levels = new Vector();
                this.getChildElementsByTagName(aV4edge, _level, vV4Levels);
                if (0 == vV4Levels.size()) continue;
                Vector vV4Items = new Vector();
                this.getChildElementsByTagName((Element)vV4Levels.get(vV4Levels.size() - 1), _item, vV4Items);
                if (0 == vV4Items.size()) continue;
                vRefItemNames.addElement(((Element)vV4Items.get(0)).getAttribute(_refItem));
            }
        } else {
            for (int kk = 0; kk < v4FilterLevels.size(); ++kk) {
                String levelRefName = ((Element)v4FilterLevels.get(kk)).getAttribute("refLevel");
                Vector v4Dimensions = new Vector();
                this.getChildElementsByTagName(theV4CubeElem, _dimension, v4Dimensions);
                if (0 == v4Dimensions.size()) {
                    return;
                }
                boolean bFound = false;
                Element theV4RefererncedLevel = this.m_retDoc.createElement("XXX");
                block2: for (int ii = 0; ii < v4Dimensions.size(); ++ii) {
                    Vector v4Levels = new Vector();
                    this.getChildElementsByTagName((Element)v4Dimensions.get(ii), _level, v4Levels);
                    if (0 == v4Levels.size()) continue;
                    for (int jj = 0; jj < v4Levels.size(); ++jj) {
                        String sLevelName = ((Element)v4Levels.get(jj)).getAttribute(_nameAttr);
                        if (sLevelName.compareTo(levelRefName) == 0) {
                            theV4RefererncedLevel = (Element)v4Levels.get(jj);
                            bFound = true;
                            continue block2;
                        }
                        if (bFound) continue block2;
                    }
                }
                if (!bFound) {
                    return;
                }
                Vector v4Items = new Vector();
                HashSet<String> aSet = new HashSet<String>();
                aSet.add(_item);
                aSet.add(_dataItem);
                this.getChildElementsByTagNameSet(theV4RefererncedLevel, aSet, v4Items);
                if (0 == v4Items.size()) {
                    return;
                }
                String theRefItemName = new String();
                boolean bHasKey = false;
                for (int ii = 0; ii < v4Items.size(); ++ii) {
                    Element anItem = (Element)v4Items.get(ii);
                    if (!anItem.hasAttribute(_key) || _true != anItem.getAttribute(_key)) continue;
                    bHasKey = true;
                    if (anItem.getTagName().equals(_item)) {
                        theRefItemName = anItem.getAttribute(_refItem);
                        break;
                    }
                    theRefItemName = anItem.getAttribute(_nameAttr);
                    break;
                }
                if (!bHasKey) {
                    Element fst = (Element)v4Items.get(0);
                    theRefItemName = fst.getTagName().equals(_item) ? fst.getAttribute(_refItem) : fst.getAttribute(_nameAttr);
                }
                vRefItemNames.addElement(theRefItemName);
            }
        }
        if (0 == vRefItemNames.size()) {
            return;
        }
        Element v5Filter = this.m_retDoc.createElement("summaryFilterLevels");
        theV5SummaryFilter.appendChild(v5Filter);
        for (int kk = 0; kk < vRefItemNames.size(); ++kk) {
            Element v5FilterLevel = this.m_retDoc.createElement("summaryFilterLevel");
            v5FilterLevel.setAttribute(_v5RefDataItemAttr, (String)vRefItemNames.get(kk));
            v5Filter.appendChild(v5FilterLevel);
        }
    }

    protected boolean createACubeSelection4Tab(Element theV5Query, Element aCubeElem, Element v4TabularElem, Vector v4TabularDataItemElems) {
        Element theSelection = this.m_retDoc.createElement(_selection);
        String theTagName = v4TabularElem.getTagName();
        this.setAutoSummary4QueryOperation(theTagName, v4TabularDataItemElems.size(), theSelection);
        NodeList allItems = aCubeElem.getElementsByTagName(_item);
        HashSet<String> nonAliasItems = new HashSet<String>();
        int i = 0;
        for (i = 0; i < allItems.getLength(); ++i) {
            Element AItemElem = (Element)allItems.item(i);
            String dItemName = AItemElem.getAttribute(_refItem);
            if (!AItemElem.hasAttribute(_alias)) {
                nonAliasItems.add(dItemName);
                continue;
            }
            if (!AItemElem.hasAttribute(_alias) || !dItemName.equals(AItemElem.getAttribute(_alias))) continue;
            nonAliasItems.add(dItemName);
        }
        Vector dimAndFactListElems = new Vector();
        HashSet seenItems = new HashSet();
        this.getChildElementsFromCube(aCubeElem, dimAndFactListElems);
        int nItem = 0;
        boolean noFactElems = true;
        for (nItem = 0; nItem < dimAndFactListElems.size(); ++nItem) {
            Element theElem = (Element)dimAndFactListElems.get(nItem);
            String tagName = theElem.getTagName();
            boolean isFact = tagName.equals(_factList);
            if (isFact) {
                noFactElems = false;
            }
            if (this.addCubeDataItem4Tab(theV5Query.getAttribute(_nameAttr), v4TabularElem, nonAliasItems, seenItems, theSelection, theElem, v4TabularDataItemElems, isFact)) continue;
            return false;
        }
        if (noFactElems) {
            String v5UniqueName = this.getV5UniqueName4Tab(v4TabularElem, 10);
            this.addUnusedItems(v5UniqueName, nonAliasItems, seenItems, theSelection, v4TabularDataItemElems);
        }
        theV5Query.appendChild(theSelection);
        return true;
    }

    protected boolean addCubeDataItem4Tab(String v5queryName, Element v4TabularElem, Set nonAliasItems, Set seenItems, Element theSelection, Element aEle, Vector v4TabularDataItemElems, boolean bIsFact) {
        String theAggr;
        String v5UniqueName = this.getV5UniqueName4Tab(v4TabularElem, 10);
        int i = 0;
        NodeList allItems = aEle.getElementsByTagName(_item);
        for (i = 0; i < allItems.getLength(); ++i) {
            Element theV5DataItem;
            String aliasName;
            Element AItemElem = (Element)allItems.item(i);
            if (!AItemElem.hasAttribute(_refItem)) {
                return false;
            }
            String dItemName = AItemElem.getAttribute(_refItem);
            seenItems.add(dItemName);
            boolean bIsAlias = AItemElem.hasAttribute(_alias);
            boolean bUseAliasName = false;
            if (bIsAlias) {
                if (dItemName.equals(AItemElem.getAttribute(_alias))) {
                    bIsAlias = false;
                } else if (!nonAliasItems.contains(dItemName)) {
                    bUseAliasName = true;
                    bIsAlias = false;
                }
            }
            if (bIsAlias) {
                aliasName = AItemElem.getAttribute(_alias);
                theV5DataItem = this.addAnItem_2(aliasName, dItemName, AItemElem);
                seenItems.add(aliasName);
                if (AItemElem.hasAttribute(_aggregate)) {
                    theAggr = AItemElem.getAttribute(_aggregate);
                    if (theAggr.equalsIgnoreCase(_false)) {
                        theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
                        theV5DataItem.setAttribute(_aggregate, _noneVal);
                    } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                        theV5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                        theV5DataItem.setAttribute(_aggregate, _automaticVal);
                    } else {
                        theV5DataItem.setAttribute(_rollupAggregate, theAggr);
                        theV5DataItem.setAttribute(_aggregate, theAggr);
                    }
                }
            } else {
                theV5DataItem = this.addAnItem_1(dItemName, v5UniqueName, AItemElem);
                if (bUseAliasName) {
                    aliasName = AItemElem.getAttribute(_alias);
                    if (aliasName.length() > 0) {
                        theV5DataItem.setAttribute(_nameAttr, aliasName);
                        if (!seenItems.contains(dItemName) && !this.addAliasMap(v5queryName, aliasName, dItemName)) {
                            return false;
                        }
                    }
                    seenItems.add(aliasName);
                }
                if (AItemElem.hasAttribute(_aggregate)) {
                    String theAggr2 = AItemElem.getAttribute(_aggregate);
                    if (theAggr2.equalsIgnoreCase(_false)) {
                        theV5DataItem.setAttribute(_aggregate, _noneVal);
                        theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
                    } else if (theAggr2.equalsIgnoreCase("any") || theAggr2.equalsIgnoreCase("averageNonZero") || theAggr2.equalsIgnoreCase("countNonZero") || theAggr2.equalsIgnoreCase(_true)) {
                        theV5DataItem.setAttribute(_aggregate, _automaticVal);
                        theV5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                    } else {
                        Element theBIQuery = this.getParentBIQueryFromChild(AItemElem);
                        boolean bQueryHasSummary = this.CheckQueryReferredAndHasSummary(theBIQuery, AItemElem);
                        if (bIsFact && theAggr2.equalsIgnoreCase(_noneVal) && bQueryHasSummary) {
                            theV5DataItem.setAttribute(_rollupAggregate, _calculatedVal);
                            this.m_v5DataItemToV4Agg.put(theV5DataItem, _noneVal);
                        } else {
                            theV5DataItem.setAttribute(_rollupAggregate, theAggr2);
                        }
                    }
                }
            }
            theSelection.appendChild(theV5DataItem);
        }
        HashMap tabRenameMap = new HashMap();
        NodeList alldataItems = aEle.getElementsByTagName(_dataItem);
        for (i = 0; i < alldataItems.getLength(); ++i) {
            Element AItemElem = (Element)alldataItems.item(i);
            if (!AItemElem.hasAttribute(_nameAttr)) {
                return false;
            }
            String dItemName = AItemElem.getAttribute(_nameAttr);
            String theExpr = this.getExpression4TabModel(AItemElem, AItemElem, tabRenameMap, true, true);
            Element theV5DataItem = this.addAnItem(dItemName, AItemElem, theExpr);
            theV5DataItem.setAttribute(_aggregate, _notApplicable);
            if (AItemElem.hasAttribute(_aggregate)) {
                theAggr = AItemElem.getAttribute(_aggregate);
                if (theAggr.equalsIgnoreCase(_false)) {
                    theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
                } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                    theV5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                } else {
                    theV5DataItem.setAttribute(_rollupAggregate, theAggr);
                }
            }
            seenItems.add(dItemName);
            theSelection.appendChild(theV5DataItem);
        }
        if (bIsFact) {
            this.addUnusedItems(v5UniqueName, nonAliasItems, seenItems, theSelection, v4TabularDataItemElems);
        }
        return true;
    }

    protected void addUnusedItems(String v5UniqueName, Set nonAliasItems, Set seenItems, Element theSelection, Vector v4TabularDataItemElems) {
        int nItem = 0;
        for (nItem = 0; nItem < v4TabularDataItemElems.size(); ++nItem) {
            Element theTabDIElem = (Element)v4TabularDataItemElems.get(nItem);
            String theDIName = theTabDIElem.getAttribute(_nameAttr);
            if (seenItems.contains(theDIName) || nonAliasItems.contains(theDIName)) continue;
            seenItems.add(theDIName);
            Element theV5DataItem = this.addAnItem_1(theDIName, v5UniqueName, theTabDIElem);
            theSelection.appendChild(theV5DataItem);
        }
    }

    protected Element getParentBIQueryFromChild(Element child) {
        Element tmpEle = (Element)child.getParentNode();
        String tagName = tmpEle.getTagName();
        while (tagName.compareTo(_BIQUery) != 0) {
            tmpEle = (Element)tmpEle.getParentNode();
            tagName = tmpEle.getTagName();
        }
        return tmpEle;
    }

    protected void populateRenameMap(Element startNode, Set nonAliasItems, Map tabRenameMap) {
        int i = 0;
        NodeList allItems = startNode.getElementsByTagName(_item);
        for (i = 0; i < allItems.getLength(); ++i) {
            Element AItemElem = (Element)allItems.item(i);
            if (!AItemElem.hasAttribute(_refItem)) {
                return;
            }
            String dItemName = AItemElem.getAttribute(_refItem);
            boolean bIsAlias = AItemElem.hasAttribute(_alias);
            String aliasName = true == bIsAlias ? AItemElem.getAttribute(_alias) : new String();
            if (!bIsAlias) continue;
            if (dItemName.equals(AItemElem.getAttribute(_alias))) {
                bIsAlias = false;
                continue;
            }
            if (nonAliasItems.contains(dItemName)) continue;
            bIsAlias = false;
            tabRenameMap.put(dItemName, aliasName);
        }
    }

    protected void populateRefItemMapFromDimension(Element startNode, Map tabDIName2RefItemMap) {
        String tagName = startNode.getTagName();
        if (tagName.equals(_dimension)) {
            int i = 0;
            NodeList allItems = startNode.getElementsByTagName(_item);
            for (i = 0; i < allItems.getLength(); ++i) {
                Element AItemElem = (Element)allItems.item(i);
                if (!AItemElem.hasAttribute(_refItem)) continue;
                String dItemName = AItemElem.getAttribute(_refItem);
                tabDIName2RefItemMap.put(dItemName, AItemElem);
            }
        }
    }

    protected boolean createACubeSelection4TabModel(Element aBIQuery, Element theV5Query, Element aCubeElem, Element tabularElem, Vector v4TabularDataItemElems, Map tabRenameMap) {
        Element theV5DataItem;
        String theExpr;
        Element theTabDIEle;
        String b;
        Element theTabDIElem;
        NodeList allCubeDataItems = aCubeElem.getElementsByTagName(_dataItem);
        HashMap<String, Element> cubeDataItemNameMap = new HashMap<String, Element>();
        int nItem = 0;
        for (nItem = 0; nItem < allCubeDataItems.getLength(); ++nItem) {
            Element theElem = (Element)allCubeDataItems.item(nItem);
            if (!theElem.hasAttribute(_nameAttr)) {
                return false;
            }
            cubeDataItemNameMap.put(theElem.getAttribute(_nameAttr), theElem);
        }
        HashMap<String, Element> tabDIName2ElemMap = new HashMap<String, Element>();
        for (nItem = 0; nItem < v4TabularDataItemElems.size(); ++nItem) {
            theTabDIElem = (Element)v4TabularDataItemElems.get(nItem);
            if (!theTabDIElem.hasAttribute(_nameAttr)) {
                return false;
            }
            String theDIName = theTabDIElem.getAttribute(_nameAttr);
            tabDIName2ElemMap.put(theDIName, theTabDIElem);
        }
        if (!cubeDataItemNameMap.isEmpty() && cubeDataItemNameMap.size() > 0) {
            for (nItem = 0; nItem < v4TabularDataItemElems.size(); ++nItem) {
                theTabDIElem = (Element)v4TabularDataItemElems.get(nItem);
                if (!theTabDIElem.hasAttribute(_nameAttr)) {
                    return false;
                }
                String theTabDIName = theTabDIElem.getAttribute(_nameAttr);
                if (!cubeDataItemNameMap.containsKey(theTabDIName)) continue;
                String newName = theTabDIName.concat(_extension);
                tabRenameMap.put(theTabDIName, newName);
            }
        }
        HashSet<String> seenItems = new HashSet<String>();
        Element theSelection = this.m_retDoc.createElement(_selection);
        if (tabularElem.hasAttribute(_autoSummary) && (b = tabularElem.getAttribute(_autoSummary)).equalsIgnoreCase(_false)) {
            theSelection.setAttribute(_autoSummary, _false);
        }
        NodeList allItems = aCubeElem.getElementsByTagName(_item);
        HashSet<String> nonAliasItems = new HashSet<String>();
        int i = 0;
        for (i = 0; i < allItems.getLength(); ++i) {
            Element AItemElem = (Element)allItems.item(i);
            String dItemName = AItemElem.getAttribute(_refItem);
            if (!AItemElem.hasAttribute(_alias)) {
                nonAliasItems.add(dItemName);
                continue;
            }
            if (!AItemElem.hasAttribute(_alias) || !dItemName.equals(AItemElem.getAttribute(_alias))) continue;
            nonAliasItems.add(dItemName);
        }
        Vector dimAndFactListElems = new Vector();
        this.getChildElementsFromCube(aCubeElem, dimAndFactListElems);
        HashMap tabDIName2RefItemMap = new HashMap();
        for (nItem = 0; nItem < dimAndFactListElems.size(); ++nItem) {
            Element theElem = (Element)dimAndFactListElems.get(nItem);
            this.populateRenameMap(theElem, nonAliasItems, tabRenameMap);
            this.populateRefItemMapFromDimension(theElem, tabDIName2RefItemMap);
        }
        Vector visitedDimItems = new Vector();
        Vector v4CubeFilters = new Vector();
        boolean need2GenerateRefQuery = this.cubeContainsFilter(aCubeElem, v4CubeFilters);
        if (!this.properties.getBoolean("com.qfw.V4toV5.generaterefquery", false)) {
            need2GenerateRefQuery = false;
        }
        Vector<Element> dataItemVec = new Vector<Element>();
        String uniqueQName = theV5Query.getAttribute(_nameAttr);
        if (need2GenerateRefQuery) {
            uniqueQName = this.generateUniqueQueryName(uniqueQName);
        }
        for (nItem = 0; nItem < dimAndFactListElems.size(); ++nItem) {
            Element theElem = (Element)dimAndFactListElems.get(nItem);
            String theTagName = theElem.getTagName();
            boolean isFact = theTagName.equals(_factList);
            if (this.addCubeDataItem4TabModel(nonAliasItems, aBIQuery, theV5Query.getAttribute(_nameAttr), uniqueQName, tabularElem, seenItems, tabDIName2ElemMap, tabRenameMap, theSelection, theElem, tabDIName2RefItemMap, visitedDimItems, isFact, need2GenerateRefQuery, dataItemVec)) continue;
            return false;
        }
        Set theRenames = tabRenameMap.keySet();
        for (String oldName : theRenames) {
            String newName = (String)tabRenameMap.get(oldName);
            if (seenItems.contains(newName)) continue;
            seenItems.add(newName);
            theTabDIEle = (Element)tabDIName2ElemMap.get(oldName);
            theExpr = this.getExpression4TabModel(tabularElem, theTabDIEle, tabRenameMap, false, true);
            theV5DataItem = this.addAnItem(newName, theTabDIEle, theExpr);
            if (need2GenerateRefQuery) {
                dataItemVec.add(theV5DataItem);
                theV5DataItem = this.addAnItem_1(newName, uniqueQName, theTabDIEle);
            }
            theSelection.appendChild(theV5DataItem);
        }
        for (nItem = 0; nItem < v4TabularDataItemElems.size(); ++nItem) {
            Element theTabDIElem2 = (Element)v4TabularDataItemElems.get(nItem);
            String theDIName = theTabDIElem2.getAttribute(_nameAttr);
            if (theRenames.contains(theDIName) || seenItems.contains(theDIName)) continue;
            seenItems.add(theDIName);
            theTabDIEle = (Element)tabDIName2ElemMap.get(theDIName);
            theExpr = this.getExpression4TabModel(tabularElem, theTabDIEle, tabRenameMap, false, true);
            theV5DataItem = this.addAnItem(theDIName, theTabDIEle, theExpr);
            if (need2GenerateRefQuery) {
                dataItemVec.add(theV5DataItem);
                theV5DataItem = this.addAnItem_1(theDIName, uniqueQName, theTabDIEle);
            }
            theSelection.appendChild(theV5DataItem);
        }
        if (dataItemVec.size() > 0) {
            this.m_RefQuery2DataItemsMap.put(uniqueQName, dataItemVec);
        }
        theV5Query.appendChild(theSelection);
        return true;
    }

    protected boolean addCubeDataItem4TabModel(Set nonAliasItems, Element aBIQuery, String queryName, String uniqueQname, Element tabularElem, Set seenItems, Map tabDIName2ElemMap, Map tabRenameMap, Element theSelection, Element aEle, Map tabDIName2RefItemMap, Vector visitedDimItems, boolean bIsFact, boolean need2GenerateRefQuery, Vector dataItemVec) {
        int i = 0;
        NodeList allItems = aEle.getElementsByTagName(_item);
        for (i = 0; i < allItems.getLength(); ++i) {
            Element theV5DataItem;
            Element AItemElem_Org = (Element)allItems.item(i);
            if (!AItemElem_Org.hasAttribute(_refItem)) {
                return false;
            }
            String dItemName = AItemElem_Org.getAttribute(_refItem);
            boolean bIsAlias = AItemElem_Org.hasAttribute(_alias);
            String aliasName = true == bIsAlias ? AItemElem_Org.getAttribute(_alias) : new String();
            boolean bUseAliasName = false;
            if (bIsAlias) {
                if (dItemName.equals(AItemElem_Org.getAttribute(_alias))) {
                    bIsAlias = false;
                } else if (!nonAliasItems.contains(dItemName)) {
                    bIsAlias = false;
                    bUseAliasName = true;
                }
            }
            boolean isFact = bIsFact;
            Element AItemElem = AItemElem_Org;
            if (isFact && !bIsAlias && !visitedDimItems.contains(dItemName) && tabDIName2RefItemMap.containsKey(dItemName)) {
                AItemElem = (Element)tabDIName2RefItemMap.get(dItemName);
                visitedDimItems.add(dItemName);
                isFact = false;
            }
            if (!isFact) {
                visitedDimItems.add(dItemName);
            }
            if (seenItems.contains(false == bIsAlias && false == bUseAliasName ? dItemName : aliasName)) continue;
            seenItems.add(false == bIsAlias ? dItemName : aliasName);
            if (bIsAlias) {
                theV5DataItem = this.addAnItem_2(aliasName, dItemName, AItemElem);
                boolean bIsLevelKey = false;
                if (!isFact && AItemElem.hasAttribute(_key)) {
                    String theKey = AItemElem.getAttribute(_key);
                    bIsLevelKey = theKey.equalsIgnoreCase(_true);
                }
                if (bIsLevelKey) {
                    theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
                } else if (AItemElem.hasAttribute(_aggregate)) {
                    String theAggr = AItemElem.getAttribute(_aggregate);
                    if (theAggr.equalsIgnoreCase(_false)) {
                        theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
                    } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                        theV5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                    } else {
                        theV5DataItem.setAttribute(_rollupAggregate, theAggr);
                    }
                }
                String sRefDI = AItemElem.getAttribute(_refItem);
                Element eRefDI = (Element)tabDIName2ElemMap.get(sRefDI);
                if (eRefDI.hasAttribute(_aggregate)) {
                    String theAggr = eRefDI.getAttribute(_aggregate);
                    if (theAggr.equalsIgnoreCase(_false)) {
                        theV5DataItem.setAttribute(_aggregate, _noneVal);
                    } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                        theV5DataItem.setAttribute(_aggregate, _automaticVal);
                    } else {
                        theV5DataItem.setAttribute(_aggregate, theAggr);
                    }
                }
            } else {
                String theSort;
                if (!tabDIName2ElemMap.containsKey(dItemName)) {
                    String theErrorMsg = this.getMsgString(msgKey_02, queryName, dItemName);
                    this.m_theErrorMsgs.addElement(theErrorMsg);
                    continue;
                }
                Element theTabDIEle = (Element)tabDIName2ElemMap.get(dItemName);
                String theExpr = this.getExpression4TabModel(tabularElem, theTabDIEle, tabRenameMap, false, true);
                theV5DataItem = this.addAnItem(dItemName, theTabDIEle, theExpr);
                if (need2GenerateRefQuery) {
                    dataItemVec.add(theV5DataItem);
                    theV5DataItem = this.addAnItem_1(dItemName, uniqueQname, AItemElem);
                }
                if (bUseAliasName && aliasName.length() > 0) {
                    theV5DataItem.setAttribute(_nameAttr, aliasName);
                    seenItems.add(aliasName);
                    if (!this.addAliasMap(queryName, aliasName, dItemName)) {
                        return false;
                    }
                }
                if (AItemElem.hasAttribute(_sortAttr) && AItemElem.getParentNode().getNodeName().equals(_factList) && !(theSort = AItemElem.getAttribute(_sortAttr)).equalsIgnoreCase(_noneVal)) {
                    theV5DataItem.setAttribute(_sortAttr, theSort);
                }
                if (!isFact && bIsFact) {
                    this.setRollupAggregate(aBIQuery, AItemElem, theV5DataItem, bIsFact);
                } else {
                    this.setRollupAggregate(aBIQuery, AItemElem_Org, theV5DataItem, isFact);
                }
            }
            theSelection.appendChild(theV5DataItem);
        }
        NodeList alldataItems = aEle.getElementsByTagName(_dataItem);
        for (i = 0; i < alldataItems.getLength(); ++i) {
            Element AItemElem = (Element)alldataItems.item(i);
            if (!AItemElem.hasAttribute(_nameAttr)) {
                return false;
            }
            String dItemName = AItemElem.getAttribute(_nameAttr);
            String theExpr = this.getExpression4TabModel(tabularElem, AItemElem, tabRenameMap, true, true);
            Element theV5DataItem = this.addAnItem(dItemName, AItemElem, theExpr);
            theV5DataItem.setAttribute(_aggregate, _notApplicable);
            this.setRollupAggregate(aBIQuery, AItemElem, theV5DataItem, bIsFact);
            theSelection.appendChild(theV5DataItem);
        }
        return true;
    }

    protected boolean CheckQueryReferredAndHasSummary(Element aBIQuery, Element AItemElem) {
        Vector allSummary = new Vector();
        this.getAllSummaryReferToQuery(aBIQuery, allSummary);
        if (0 == allSummary.size()) {
            return false;
        }
        String theDITag = AItemElem.getTagName();
        String dItemName = theDITag.equals(_item) ? AItemElem.getAttribute(_refItem) : AItemElem.getAttribute(_nameAttr);
        for (int i = 0; i < allSummary.size(); ++i) {
            Element ASummary = (Element)allSummary.get(i);
            Vector v4SumDataCellsElems = new Vector();
            this.getChildElementsByTagName(ASummary, "dataCells", v4SumDataCellsElems);
            if (1 != v4SumDataCellsElems.size()) continue;
            Element ADataCells = (Element)v4SumDataCellsElems.get(0);
            Vector v4DataCellsItems = new Vector();
            this.getChildElementsByTagName(ADataCells, _item, v4DataCellsItems);
            for (int j = 0; j < v4DataCellsItems.size(); ++j) {
                Element AItem = (Element)v4DataCellsItems.get(j);
                if (!AItem.hasAttribute(_refItem) || !dItemName.equals(AItem.getAttribute(_refItem))) continue;
                return true;
            }
        }
        return false;
    }

    protected void setRollupAggregate(Element aBIQuery, Element AItemElem, Element theV5DataItem, boolean bIsFact) {
        boolean bQueryHasSummary;
        if (AItemElem.hasAttribute(_aggregate)) {
            String theAggr = AItemElem.getAttribute(_aggregate);
            boolean bIsLevelKey = false;
            if (!bIsFact && AItemElem.hasAttribute(_key)) {
                String theKey = AItemElem.getAttribute(_key);
                bIsLevelKey = theKey.equalsIgnoreCase(_true);
            }
            if (theAggr.equalsIgnoreCase(_false) || bIsLevelKey) {
                theV5DataItem.setAttribute(_rollupAggregate, _noneVal);
            } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                if (!bIsFact) {
                    theV5DataItem.setAttribute(_rollupAggregate, _automaticVal);
                } else {
                    theV5DataItem.setAttribute(_rollupAggregate, _summarizeVal);
                    this.m_v5DataItemToV4Agg.put(theV5DataItem, theAggr);
                }
            } else {
                boolean bQueryHasSummary2 = this.CheckQueryReferredAndHasSummary(aBIQuery, AItemElem);
                if (bIsFact && (theAggr.equalsIgnoreCase(_noneVal) || theAggr.equalsIgnoreCase(_automaticVal)) && bQueryHasSummary2) {
                    theV5DataItem.setAttribute(_rollupAggregate, _calculatedVal);
                    this.m_v5DataItemToV4Agg.put(theV5DataItem, theAggr);
                } else {
                    theV5DataItem.setAttribute(_rollupAggregate, theAggr);
                }
            }
        } else if (bIsFact && (bQueryHasSummary = this.CheckQueryReferredAndHasSummary(aBIQuery, AItemElem))) {
            theV5DataItem.setAttribute(_rollupAggregate, _calculatedVal);
            this.m_v5DataItemToV4Agg.put(theV5DataItem, _automaticVal);
        }
    }

    protected Element queryReferredAndHasSummary(Element passedQuery) {
        Element nothing = this.m_retDoc.createElement("_nothing_");
        String passedV4QueryName = new String();
        if (!passedQuery.hasAttribute(_nameAttr)) {
            return nothing;
        }
        passedV4QueryName = passedQuery.getAttribute(_nameAttr);
        Vector allBIQuery = new Vector();
        this.getChildElementsByTagName(this.m_rootElem, _BIQUery, allBIQuery);
        for (int i = 0; i < allBIQuery.size(); ++i) {
            Element thisBIQuery = (Element)allBIQuery.get(i);
            String thisQueryName = new String();
            if (thisBIQuery.hasAttribute(_nameAttr)) {
                thisQueryName = thisBIQuery.getAttribute(_nameAttr);
            }
            if (passedV4QueryName.compareTo(thisQueryName) == 0) continue;
            Vector cubeRefElems = new Vector();
            this.getChildElementsByTagName(thisBIQuery, _cubeRef, cubeRefElems);
            for (int j = 0; j < cubeRefElems.size(); ++j) {
                String cubRefQueryName;
                Element aCubeRefElem = (Element)cubeRefElems.get(j);
                if (!aCubeRefElem.hasAttribute(_refQueryAttr) || (cubRefQueryName = aCubeRefElem.getAttribute(_refQueryAttr)).compareTo(passedV4QueryName) != 0) continue;
                Vector v4SumElems = new Vector();
                this.getChildElementsByTagName(thisBIQuery, _summary, v4SumElems);
                if (v4SumElems.size() <= 0) continue;
                return (Element)v4SumElems.get(0);
            }
        }
        return nothing;
    }

    protected void getAllSummaryReferToQuery(Element passedQuery, Vector allSummary) {
        if (!passedQuery.hasAttribute(_nameAttr)) {
            return;
        }
        String passedV4QueryName = passedQuery.getAttribute(_nameAttr);
        Vector allBIQuery = new Vector();
        this.getChildElementsByTagName(this.m_rootElem, _BIQUery, allBIQuery);
        for (int i = 0; i < allBIQuery.size(); ++i) {
            String cubRefQueryName;
            Element aCubeRefElem;
            String thisQueryName;
            Element thisBIQuery = (Element)allBIQuery.get(i);
            if (!thisBIQuery.hasAttribute(_nameAttr) || passedV4QueryName.equals(thisQueryName = thisBIQuery.getAttribute(_nameAttr))) continue;
            Vector v4SumElems = new Vector();
            this.getChildElementsByTagName(thisBIQuery, _summary, v4SumElems);
            if (v4SumElems.size() != 1) continue;
            Vector cubeRefElems = new Vector();
            this.getChildElementsByTagName(thisBIQuery, _cubeRef, cubeRefElems);
            if (cubeRefElems.size() != 1 || !(aCubeRefElem = (Element)cubeRefElems.get(0)).hasAttribute(_refQueryAttr) || !(cubRefQueryName = aCubeRefElem.getAttribute(_refQueryAttr)).equals(passedV4QueryName)) continue;
            allSummary.addElement(v4SumElems.get(0));
        }
    }

    protected Element addAnItem(String itemName, Element AItemElem, String theExpr) {
        String theSort;
        Element theV5DataItem = this.m_retDoc.createElement(_dataItem);
        theV5DataItem.setAttribute(_nameAttr, itemName);
        if (AItemElem.hasAttribute(_aggregate)) {
            String theAggr = AItemElem.getAttribute(_aggregate);
            if (theAggr.equalsIgnoreCase(_false)) {
                theV5DataItem.setAttribute(_aggregate, _noneVal);
            } else if (theAggr.equalsIgnoreCase("any") || theAggr.equalsIgnoreCase("averageNonZero") || theAggr.equalsIgnoreCase("countNonZero") || theAggr.equalsIgnoreCase(_true)) {
                theV5DataItem.setAttribute(_aggregate, _automaticVal);
            } else {
                theV5DataItem.setAttribute(_aggregate, theAggr);
            }
        }
        if (AItemElem.hasAttribute(_sortAttr) && !(theSort = AItemElem.getAttribute(_sortAttr)).equalsIgnoreCase(_noneVal)) {
            theV5DataItem.setAttribute(_sortAttr, theSort);
        }
        Element theV5Expr = this.m_retDoc.createElement(_expression);
        if (theExpr.length() > 0) {
            Text theExpString = this.m_retDoc.createTextNode(theExpr);
            theV5Expr.appendChild(theExpString);
        }
        theV5DataItem.appendChild(theV5Expr);
        return theV5DataItem;
    }

    protected String getExpression4TabModel(Element tabularElem, Element theDIEle, Map tabRenameMap, boolean cubeExpr, boolean bIsTopTab) {
        StringBuffer theText;
        String theDITag = theDIEle.getTagName();
        NodeList exprItems = theDIEle.getElementsByTagName(theDITag.equals(_dataItem) ? _expression : _condition);
        if (1 != exprItems.getLength()) {
            return new String();
        }
        Element exprElem = (Element)exprItems.item(0);
        if (!this.getTheText(exprElem, theText = new StringBuffer())) {
            return new String();
        }
        Vector token = new Vector();
        Vector objPos = new Vector();
        if (!this.parseExpression(theText.toString(), token, objPos) || objPos.isEmpty()) {
            return theText.toString();
        }
        String tabModelName = tabularElem.getAttribute(_nameAttr);
        StringBuffer theRetExpr = new StringBuffer();
        int i = 0;
        for (i = 0; i < objPos.size(); ++i) {
            String firstPart;
            Integer theInt = (Integer)objPos.get(i);
            int objIdx = theInt;
            StringBuffer theObj = (StringBuffer)token.get(objIdx);
            int theLength = theObj.length();
            Vector nameParts = new Vector();
            if (!this.getNameParts(theObj, nameParts)) continue;
            int nSz = nameParts.size();
            if (!cubeExpr) {
                if (1 != nSz && 2 != nSz) continue;
                firstPart = (String)nameParts.get(0);
                if (1 == nSz) {
                    if (tabRenameMap.containsKey(firstPart)) {
                        theObj.delete(0, theLength);
                        theObj.append("[");
                        String newName = (String)tabRenameMap.get(firstPart);
                        theObj.append(newName);
                        theObj.append("]");
                        continue;
                    }
                    boolean bInCurrent = this.isDataItemDefinedinTab(tabularElem, firstPart);
                    if (bInCurrent) continue;
                    this.genTwoPartNameWithChildTab(tabularElem, firstPart, theObj);
                    continue;
                }
                if (tabularElem.hasAttribute(_nameAttr) && tabModelName.equals(firstPart)) {
                    String secondPart = (String)nameParts.get(1);
                    boolean definedInV4Tab = this.isDataItemDefinedinTab(tabularElem, secondPart);
                    StringBuffer queryName = new StringBuffer();
                    if (!definedInV4Tab && this.isDefinedInV4TabularRef(firstPart, secondPart, tabularElem, queryName)) {
                        theObj.delete(0, theLength);
                        theObj.append("[");
                        theObj.append(queryName.toString());
                        theObj.append("].[");
                        theObj.append(secondPart);
                        theObj.append("]");
                        continue;
                    }
                    theObj.delete(0, theLength);
                    if (!definedInV4Tab && !tabRenameMap.containsKey(secondPart)) {
                        theObj.append("[");
                        theObj.append(firstPart);
                        theObj.append("].[");
                        theObj.append(secondPart);
                        theObj.append("]");
                        continue;
                    }
                    if (!tabRenameMap.containsKey(secondPart)) {
                        theObj.append("[");
                        theObj.append(secondPart);
                        theObj.append("]");
                        continue;
                    }
                    theObj.append("[");
                    String newName = (String)tabRenameMap.get(secondPart);
                    theObj.append(newName);
                    theObj.append("]");
                    continue;
                }
                StringBuffer queryName = new StringBuffer();
                String secondPart = (String)nameParts.get(1);
                if (this.isDefinedInV4Tab(firstPart, tabularElem, queryName)) {
                    theObj.delete(0, theLength);
                    theObj.append("[");
                    theObj.append(queryName.toString());
                    theObj.append("].[");
                    theObj.append(secondPart);
                    theObj.append("]");
                    continue;
                }
                if (!this.isDefinedInV4TabularRef(firstPart, secondPart, tabularElem, queryName)) continue;
                theObj.delete(0, theLength);
                theObj.append("[");
                theObj.append(queryName.toString());
                theObj.append("].[");
                theObj.append(secondPart);
                theObj.append("]");
                continue;
            }
            if (2 != nSz && 1 != nSz) continue;
            if (1 == nSz) {
                boolean bIsDIdefinedInCube;
                String firstPart1 = (String)nameParts.get(0);
                boolean bInCurrent = this.isDataItemDefinedinTab(tabularElem, firstPart1);
                boolean bl = bIsDIdefinedInCube = !bInCurrent || bInCurrent && tabRenameMap.containsKey(firstPart1);
                if (bIsDIdefinedInCube || !tabRenameMap.containsKey(firstPart1)) continue;
                String mappedName = (String)tabRenameMap.get(firstPart1);
                theObj.delete(0, theLength);
                theObj.append("[");
                theObj.append(mappedName);
                theObj.append("]");
                continue;
            }
            firstPart = (String)nameParts.get(0);
            String secondPart = (String)nameParts.get(1);
            if (!tabRenameMap.containsKey(secondPart)) {
                if (tabularElem.hasAttribute(_nameAttr) && tabModelName.equals(firstPart)) {
                    theObj.delete(0, theLength);
                    theObj.append("[");
                    theObj.append(secondPart);
                    theObj.append("]");
                    continue;
                }
                StringBuffer queryName = new StringBuffer();
                if (!this.isDefinedInV4Tab(firstPart, tabularElem, queryName)) continue;
                theObj.delete(0, theLength);
                theObj.append("[");
                theObj.append(queryName.toString());
                theObj.append("].[");
                theObj.append(secondPart);
                theObj.append("]");
                continue;
            }
            theObj.delete(0, theLength);
            theObj.append("[");
            String newName = (String)tabRenameMap.get(secondPart);
            theObj.append(newName);
            theObj.append("]");
        }
        for (i = 0; i < token.size(); ++i) {
            StringBuffer theObj = (StringBuffer)token.get(i);
            theRetExpr.append(theObj.toString());
        }
        return theRetExpr.toString();
    }

    protected boolean isDataItemDefinedinTab(Element tabularElem, String theDIName) {
        Vector v4DataItemElems = new Vector();
        this.getChildElementsByTagName(tabularElem, _dataItem, v4DataItemElems);
        int nI = 0;
        for (nI = 0; nI < v4DataItemElems.size(); ++nI) {
            Element AItemElem = (Element)v4DataItemElems.get(nI);
            if (!AItemElem.hasAttribute(_nameAttr) || 0 != theDIName.compareTo(AItemElem.getAttribute(_nameAttr))) continue;
            return true;
        }
        return false;
    }

    protected boolean isDefinedInV4Tab(String name, Element tabularElem, StringBuffer queryName) {
        Vector subTabModels = new Vector();
        this.getChildElementsByTagName(tabularElem, _tabularModel, subTabModels);
        this.getChildElementsByTagName(tabularElem, _tabularSQL, subTabModels);
        this.getChildElementsByTagName(tabularElem, _tabularSet, subTabModels);
        for (int ii = 0; ii < subTabModels.size(); ++ii) {
            Element aTab = (Element)subTabModels.get(ii);
            if (!aTab.hasAttribute(_nameAttr) || name.compareTo(aTab.getAttribute(_nameAttr)) != 0) continue;
            int queryNameLength = queryName.length();
            if (queryNameLength != 0) {
                queryName.delete(0, queryNameLength);
            }
            String v5UniqueName = this.getV5UniqueName4Tab(aTab, 0);
            queryName.append(v5UniqueName);
            return true;
        }
        return false;
    }

    protected boolean isDefinedInV4TabularRef(String firstPart, String secondPart, Element tabularElem, StringBuffer queryName) {
        Element tabularRef;
        Vector subTabModels = new Vector();
        Vector<Element> tabWithSameName = new Vector<Element>();
        this.getChildElementsByTagName(tabularElem, _tabularReference, subTabModels);
        int j = 0;
        for (j = 0; j < subTabModels.size(); ++j) {
            Vector tabElements;
            tabularRef = (Element)subTabModels.get(j);
            if (!this.getV4Tab4TabRef(tabularRef, tabElements = new Vector())) continue;
            for (int ii = 0; ii < tabElements.size(); ++ii) {
                Element aTab = (Element)tabElements.get(ii);
                if (!aTab.hasAttribute(_nameAttr) || firstPart.compareTo(aTab.getAttribute(_nameAttr)) != 0) continue;
                tabWithSameName.addElement(aTab);
            }
        }
        if (tabWithSameName.size() > 0) {
            Element defineTab = null;
            if (tabWithSameName.size() == 1) {
                defineTab = (Element)tabWithSameName.get(0);
            } else {
                for (int i = 0; i < tabWithSameName.size(); ++i) {
                    Element aTab = (Element)tabWithSameName.get(i);
                    if (!this.isDataItemDefinedinTab(aTab, secondPart)) continue;
                    defineTab = aTab;
                    break;
                }
            }
            if (defineTab != null) {
                int queryNameLength = queryName.length();
                if (queryNameLength != 0) {
                    queryName.delete(0, queryNameLength);
                }
                String v5UniqueName = this.getV5UniqueName4Tab(defineTab, 0);
                queryName.append(v5UniqueName);
                return true;
            }
        }
        for (j = 0; j < subTabModels.size(); ++j) {
            Vector theQNames;
            Vector tabElements;
            tabularRef = (Element)subTabModels.get(j);
            if (!this.getV4TabInTabularSetByV4TabRef(tabularRef, tabElements = new Vector(), theQNames = new Vector())) continue;
            for (int ii = 0; ii < tabElements.size(); ++ii) {
                Element aTab = (Element)tabElements.get(ii);
                if (!aTab.hasAttribute(_nameAttr) || firstPart.compareTo(aTab.getAttribute(_nameAttr)) != 0) continue;
                int queryNameLength = queryName.length();
                if (queryNameLength != 0) {
                    queryName.delete(0, queryNameLength);
                }
                String v5UniqueName = this.getV5UniqueName4Tab(aTab, 0);
                queryName.append(v5UniqueName);
                return true;
            }
        }
        return false;
    }

    protected boolean getV4TabInTabularSetByV4TabRef(Element v4TabRef, Vector tabElements, Vector theQNames) {
        if (!v4TabRef.hasAttribute(_refQueryAttr)) {
            return false;
        }
        String refQueryName = v4TabRef.getAttribute(_refQueryAttr);
        Vector v4QueryElems = new Vector();
        this.getChildElementsByTagNameAndAttribue(this.m_rootElem, _BIQUery, _nameAttr, refQueryName, v4QueryElems);
        if (1 != v4QueryElems.size()) {
            return false;
        }
        Element theBIQueryElem = (Element)v4QueryElems.firstElement();
        Vector theTabSetElems = new Vector();
        this.getChildElementsByTagName(theBIQueryElem, _tabularSet, theTabSetElems);
        if (0 == theTabSetElems.size()) {
            Vector theTabModelElems = new Vector();
            this.getChildElementsByTagName(theBIQueryElem, _tabularModel, theTabModelElems);
            Element theTabModElems = (Element)theTabModelElems.firstElement();
            this.getChildElementsByTagName(theTabModElems, _tabularSet, theTabSetElems);
        }
        if (1 != theTabSetElems.size()) {
            return false;
        }
        Element tabSet = (Element)theTabSetElems.firstElement();
        this.getV4TabularInTabularSet(tabSet, tabElements, theQNames, false, 3);
        tabElements.addElement(tabSet);
        theQNames.addElement(this.getV5UniqueName4Tab(tabSet, 0));
        return tabElements.size() > 0;
    }

    protected String createSubQueryName(Element ATab, Vector theQNames, StringBuffer theBIQueryName, int ii) {
        String qName = (String)theQNames.get(ii);
        StringBuffer theSubQName = new StringBuffer();
        if (0 == qName.length()) {
            theSubQName.append(theBIQueryName);
            theSubQName.append("_");
            if (ATab.hasAttribute(_nameAttr)) {
                theSubQName.append(ATab.getAttribute(_nameAttr));
            } else {
                theSubQName.append(ii);
            }
        } else {
            StringBuffer st;
            if (this.m_BIQueryMap.containsKey(qName) && (st = (StringBuffer)this.m_BIQueryMap.get(qName)).toString().equals(_stTabular)) {
                theSubQName.append(qName);
            }
            if (0 == theSubQName.length()) {
                theSubQName.append(qName);
                if (ATab.hasAttribute(_nameAttr)) {
                    theSubQName.append(ATab.getAttribute(_nameAttr));
                } else {
                    theSubQName.append(ii);
                }
            }
        }
        return theSubQName.toString();
    }

    protected void genTwoPartNameWithChildTab(Element tabularElem, String theName, StringBuffer theObj) {
        Vector theV4Tabulars = new Vector();
        Vector theQNames = new Vector();
        this.getV4TabularInTabularModel(tabularElem, theV4Tabulars, theQNames);
        int nI = 0;
        Vector v4DataItemElems = new Vector();
        for (nI = 0; nI < theV4Tabulars.size(); ++nI) {
            Element ATab = (Element)theV4Tabulars.get(nI);
            String theTagName = ATab.getTagName();
            v4DataItemElems.clear();
            this.getChildElementsByTagName(ATab, _dataItem, v4DataItemElems);
            if (theTagName.equals(_tabularSet) && 0 == v4DataItemElems.size()) {
                this.getV4DataItems4TabularSet(ATab, v4DataItemElems);
            }
            if (0 == v4DataItemElems.size()) continue;
            boolean bFound = false;
            for (int nJ = 0; nJ < v4DataItemElems.size(); ++nJ) {
                Element AItemElem = (Element)v4DataItemElems.get(nJ);
                if (!AItemElem.hasAttribute(_nameAttr) || 0 != theName.compareTo(AItemElem.getAttribute(_nameAttr))) continue;
                bFound = true;
                break;
            }
            if (!bFound) continue;
            StringBuffer newName = new StringBuffer();
            newName.append("[");
            String v5UniqueName = this.getV5UniqueName4Tab(ATab, 0);
            newName.append(v5UniqueName);
            newName.append("].");
            newName.append(theObj);
            int theLength = theObj.length();
            theObj.delete(0, theLength);
            theObj.append(newName);
            break;
        }
    }

    protected boolean addAliasMap(String queryName, String theAlias, String theItem) {
        if (this.m_retDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_retDoc = builder.newDocument();
                this.m_retRootElem = this.m_retDoc.createElement("ret");
                this.m_retDoc.appendChild(this.m_retRootElem);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.m_retMapElem == null) {
            this.m_retMapElem = this.m_retDoc.createElement("theMap");
            this.m_retRootElem.appendChild(this.m_retMapElem);
        }
        Element qItem = this.m_retDoc.createElement("aliasMap");
        qItem.setAttribute("query", queryName);
        qItem.setAttribute(_alias, theAlias);
        qItem.setAttribute(_item, theItem);
        this.m_retMapElem.appendChild(qItem);
        return true;
    }

    protected int createAV5Query(String queryName) {
        if (this.m_queryMap.containsKey(queryName)) {
            this.m_queryElem = (Element)this.m_queryMap.get(queryName);
            return 2;
        }
        if (this.m_retDoc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.m_retDoc = builder.newDocument();
                this.m_retRootElem = this.m_retDoc.createElement("ret");
                this.m_retDoc.appendChild(this.m_retRootElem);
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (this.m_retQueiresElem == null) {
            this.m_retQueiresElem = this.m_retDoc.createElement("queries");
            this.m_retQueiresElem.setAttribute("xmlns", _BeringNS);
            this.m_retRootElem.appendChild(this.m_retQueiresElem);
        }
        this.m_queryElem = this.m_retDoc.createElement("query");
        this.m_queryElem.setAttribute(_nameAttr, queryName);
        this.m_retQueiresElem.appendChild(this.m_queryElem);
        this.m_queryMap.put(queryName, this.m_queryElem);
        return 1;
    }

    public boolean getTheText(Element theElem, StringBuffer theText) {
        Vector<Node> r = new Vector<Node>();
        for (Node n = theElem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            r.addElement(n);
        }
        if (r.isEmpty()) {
            return false;
        }
        for (int i = 0; i < r.size(); ++i) {
            Text txt = (Text)r.get(i);
            theText.append(txt.getNodeValue());
        }
        return true;
    }

    protected int indexOfStringBuffer(StringBuffer str, char c, int frm) {
        for (int n = frm; n < str.length(); ++n) {
            if (c != str.charAt(n)) continue;
            return n;
        }
        return -1;
    }

    protected int getCloseBracket(StringBuffer str, int frm) {
        int theL = str.length();
        int nEnd = this.indexOfStringBuffer(str, ']', frm);
        if (-1 == nEnd) {
            return -1;
        }
        if (nEnd < theL - 2) {
            if ('.' == str.charAt(nEnd + 1) || ']' == str.charAt(nEnd + 1)) {
                return this.getCloseBracket(str, nEnd + 2);
            }
            return nEnd;
        }
        return nEnd;
    }

    protected boolean parseExpression(String v4expr, Vector token, Vector objPos) {
        StringBuffer theExpr = new StringBuffer(v4expr);
        while (theExpr.length() > 0) {
            boolean bFound = false;
            int theLength = theExpr.length();
            for (int n = 0; n < theLength; ++n) {
                if ('[' == theExpr.charAt(n)) {
                    int nEnd = this.getCloseBracket(theExpr, n + 1);
                    if (-1 == nEnd) {
                        return false;
                    }
                    if (n > 0) {
                        String beforeStr = theExpr.substring(0, n);
                        token.add(new StringBuffer(beforeStr));
                    }
                    String objStr = theExpr.substring(n, nEnd + 1);
                    token.add(new StringBuffer(objStr));
                    objPos.add(new Integer(token.size() - 1));
                    if (nEnd == theLength - 1) {
                        return true;
                    }
                    String rest = theExpr.substring(nEnd + 1);
                    theExpr.delete(0, theLength);
                    theExpr.append(rest);
                    bFound = true;
                    break;
                }
                if (!('\'' == theExpr.charAt(n) ? -1 == (n = this.indexOfStringBuffer(theExpr, '\'', n + 1)) : ('\"' == theExpr.charAt(n) ? -1 == (n = this.indexOfStringBuffer(theExpr, '\"', n + 1)) : '#' == theExpr.charAt(n) && -1 == (n = this.indexOfStringBuffer(theExpr, '#', n + 1))))) continue;
                return false;
            }
            if (bFound) continue;
            String finalStr = theExpr.toString();
            token.add(new StringBuffer(finalStr));
            break;
        }
        return true;
    }

    protected int getCloseBracket_1(StringBuffer str, int frm) {
        int theL = str.length();
        int nEnd = this.indexOfStringBuffer(str, ']', frm);
        if (-1 == nEnd) {
            return -1;
        }
        if (nEnd < theL - 2) {
            if (']' == str.charAt(nEnd + 1)) {
                return this.getCloseBracket_1(str, nEnd + 2);
            }
            return nEnd;
        }
        return nEnd;
    }

    protected boolean getNameParts(StringBuffer theObj, Vector nameParts) {
        StringBuffer theStr = new StringBuffer(theObj.toString());
        while (theStr.length() > 0) {
            int theLength = theStr.length();
            int nEnd = this.getCloseBracket_1(theStr, 1);
            if (-1 == nEnd) {
                return false;
            }
            String theNamepart = theStr.substring(1, nEnd);
            nameParts.add(theNamepart);
            if (nEnd == theLength - 1) {
                return true;
            }
            String rest = theStr.substring(nEnd + 2);
            theStr.delete(0, theLength);
            theStr.append(rest);
        }
        return true;
    }

    public static boolean areNodesSame(Node a, Node b) {
        NamedNodeMap bAttributes;
        NamedNodeMap aAttributes;
        String bNodeValue;
        String aNodeValue;
        String bNodeName;
        if (a == b) {
            return true;
        }
        if (a.getNodeType() != b.getNodeType()) {
            return false;
        }
        String aNodeName = a.getNodeName();
        if (aNodeName != (bNodeName = b.getNodeName())) {
            if (aNodeName == null) {
                return false;
            }
            if (bNodeName == null) {
                return false;
            }
            if (!aNodeName.equals(bNodeName)) {
                return false;
            }
        }
        if ((aNodeValue = a.getNodeValue()) != (bNodeValue = b.getNodeValue())) {
            if (aNodeValue == null) {
                return false;
            }
            if (bNodeValue == null) {
                return false;
            }
            if (!aNodeValue.equals(bNodeValue)) {
                return false;
            }
        }
        if ((aAttributes = a.getAttributes()) != (bAttributes = b.getAttributes())) {
            if (aAttributes == null) {
                return false;
            }
            if (bAttributes == null) {
                return false;
            }
            if (!V4toV5QuerySet.areAttributesSame(aAttributes, bAttributes)) {
                return false;
            }
        }
        NodeList aChildren = a.getChildNodes();
        NodeList bChildren = b.getChildNodes();
        int nbChildren = aChildren.getLength();
        if (bChildren.getLength() != nbChildren) {
            return false;
        }
        for (int childNb = 0; childNb < nbChildren; ++childNb) {
            Node aChild = aChildren.item(childNb);
            Node bChild = bChildren.item(childNb);
            if (aChild.getNodeType() != bChild.getNodeType()) {
                return false;
            }
            if (aChild instanceof Attr || V4toV5QuerySet.areNodesSame(aChild, bChild)) continue;
            return false;
        }
        return true;
    }

    private static boolean areAttributesSame(NamedNodeMap a, NamedNodeMap b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String bValue;
            Node aAttribute = a.item(i);
            String aName = aAttribute.getNodeName();
            Node bAttribute = b.getNamedItem(aName);
            if (bAttribute == null) {
                return false;
            }
            String aValue = aAttribute.getNodeValue();
            if (aValue.equals(bValue = bAttribute.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    public void getChildElementsByTagName(Element aParent, String tagName, Vector r) {
        for (Node n = aParent.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !tagName.equals(theTagName = aElem.getTagName())) continue;
            r.addElement(aElem);
        }
    }

    public void getChildElementsByTagNameRecursive(Element aParent, String tagName, Vector r) {
        for (Node n = aParent.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null) continue;
            String theTagName = aElem.getTagName();
            if (tagName.equals(theTagName)) {
                r.addElement(aElem);
            }
            this.getChildElementsByTagNameRecursive(aElem, tagName, r);
        }
    }

    public void getChildElementsFromCube(Element aParent, Vector r) {
        for (Node n = aParent.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !(theTagName = aElem.getTagName()).equals(_dimension) && !theTagName.equals(_factList)) continue;
            r.addElement(aElem);
        }
    }

    public void getChildElementsByTagNameSet(Element aParent, Set tagNameSet, Vector r) {
        for (Node n = aParent.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !tagNameSet.contains(theTagName = aElem.getTagName())) continue;
            r.addElement(aElem);
        }
    }

    protected void getChildElementsByTagNameAndAttribue(Element aParent, String tagName, String attr, String attrV, Vector r) {
        for (Node n = aParent.getFirstChild(); n != null; n = n.getNextSibling()) {
            String theTagName;
            Element aElem;
            if (n.getNodeType() != 1 || (aElem = (Element)n) == null || !tagName.equals(theTagName = aElem.getTagName()) || !aElem.hasAttribute(attr) || !attrV.equals(aElem.getAttribute(attr))) continue;
            r.addElement(aElem);
        }
    }

    protected boolean isSubQuery(String theQueryName) {
        boolean bIsSubQuery = false;
        NodeList theV4BIQueries = this.m_rootElem.getElementsByTagName(_BIQUery);
        for (int i = 0; i < theV4BIQueries.getLength() && !bIsSubQuery; ++i) {
            String biQueryName;
            Element biQuery = (Element)theV4BIQueries.item(i);
            if (!biQuery.hasAttribute(_nameAttr) || (biQueryName = biQuery.getAttribute(_nameAttr)).compareTo(theQueryName) == 0) continue;
            Vector tabRefChildren = new Vector();
            this.getChildElementsByTagNameRecursive(biQuery, _tabularReference, tabRefChildren);
            for (int j = 0; j < tabRefChildren.size() && !bIsSubQuery; ++j) {
                Element tabRefElement = (Element)tabRefChildren.get(j);
                if (!tabRefElement.hasAttribute(_refQueryAttr)) continue;
                String refQueryName = tabRefElement.getAttribute(_refQueryAttr);
                bIsSubQuery = refQueryName.compareTo(theQueryName) == 0;
            }
        }
        return bIsSubQuery;
    }

    protected void addDimensionInformationWithAdditionalFacts(boolean bDimAdded, Element theV5Query, Element aCubeElem, Element v4TabularElem, Vector v4DataItemElems, Map tabRenameMapMain) {
        if (aCubeElem == null || !aCubeElem.hasChildNodes() || v4TabularElem == null || !v4TabularElem.hasChildNodes()) {
            return;
        }
        Vector<String> v4TabItemNames = new Vector<String>();
        for (int i = 0; i < v4DataItemElems.size(); ++i) {
            Element theV4DataItemElement = (Element)v4DataItemElems.get(i);
            if (!theV4DataItemElement.hasAttribute(_nameAttr)) continue;
            v4TabItemNames.addElement(theV4DataItemElement.getAttribute(_nameAttr));
        }
        Vector v4CubeItemElements = new Vector();
        this.getChildElementsByTagNameRecursive(aCubeElem, _item, v4CubeItemElements);
        Vector<String> v4CubeItemRefNames = new Vector<String>();
        for (int i = 0; i < v4CubeItemElements.size(); ++i) {
            Element theV4CubeItemRefElement = (Element)v4CubeItemElements.get(i);
            if (!theV4CubeItemRefElement.hasAttribute(_refItem)) continue;
            v4CubeItemRefNames.addElement(theV4CubeItemRefElement.getAttribute(_refItem));
        }
        Vector<String> v5Facts = new Vector<String>();
        for (int i = 0; i < v4TabItemNames.size(); ++i) {
            String tabItemName = (String)v4TabItemNames.get(i);
            if (v4CubeItemRefNames.contains(tabItemName)) continue;
            v5Facts.addElement(tabItemName);
        }
        if (v5Facts.size() > 0) {
            if (!bDimAdded) {
                this.addDimensionInformation(theV5Query, v4TabularElem, aCubeElem);
            }
            if (this.addUnusedDataItemsToFactList(aCubeElem)) {
                this.addFacts(theV5Query, v5Facts, tabRenameMapMain);
            }
        }
    }

    protected boolean addUnusedDataItemsToFactList(Element aCubeElem) {
        if (aCubeElem.getElementsByTagName(_dimension).getLength() != 1) {
            return true;
        }
        if (aCubeElem.getElementsByTagName(_factList).getLength() != 0) {
            return true;
        }
        return aCubeElem.getElementsByTagName("attributes").getLength() != 0;
    }

    protected void addFacts(Element theV5Query, Vector v5Facts, Map tabRenameMapMain) {
        if (v5Facts.size() > 0) {
            Node theV5DimInfo = null;
            NodeList theV5DimInfoList = theV5Query.getElementsByTagName(_dimensionInfo);
            if (theV5DimInfoList.getLength() > 0) {
                theV5DimInfo = (Element)theV5DimInfoList.item(0);
            }
            if (theV5DimInfo == null || theV5DimInfo.getNodeType() != 1) {
                theV5DimInfo = this.m_retDoc.createElement(_dimensionInfo);
                theV5Query.appendChild(theV5DimInfo);
            }
            Node theV5FactList = null;
            NodeList theV5FactListList = theV5DimInfo.getElementsByTagName(_factList);
            if (theV5FactListList.getLength() > 0) {
                theV5FactList = (Element)theV5FactListList.item(0);
            }
            if (theV5FactList == null || theV5FactList.getNodeType() != 1) {
                theV5FactList = this.m_retDoc.createElement(_factList);
                theV5DimInfo.appendChild(theV5FactList);
            }
            for (int j = 0; j < v5Facts.size(); ++j) {
                String theFactName = (String)v5Facts.get(j);
                if (tabRenameMapMain.containsKey(theFactName)) {
                    theFactName = (String)tabRenameMapMain.get(theFactName);
                }
                Vector duplicates = new Vector();
                this.getChildElementsByTagNameAndAttribue((Element)theV5FactList, _fact, _nameAttr, theFactName, duplicates);
                if (duplicates.size() > 0) continue;
                Element theV5FactElement = this.m_retDoc.createElement(_fact);
                theV5FactElement.setAttribute(_nameAttr, theFactName);
                theV5FactElement.setAttribute(_v5RefDataItemAttr, theFactName);
                theV5FactList.appendChild(theV5FactElement);
            }
        }
    }

    protected String getMsgTemplate(String msgKey) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, this.m_prodLocale);
            String template = bundle.getString(msgKey);
            return this.replaceToken(template, "'", "''");
        }
        catch (Exception e) {
            return new String();
        }
    }

    protected String getMsgString(String msgKey, String param1, String param2) {
        Object[] params = new Object[]{param1, param2};
        String result = this.getMsgString(msgKey, params);
        return result;
    }

    protected String getMsgString(String msgKey, Object[] param) {
        String theTm = this.getMsgTemplate(msgKey);
        if (0 == theTm.length()) {
            theTm = this.getMsgTemplate(msgKey_01);
            if (0 == theTm.length()) {
                return msgKey_01;
            }
            return theTm;
        }
        MessageFormat formatter = new MessageFormat(theTm);
        String output = formatter.format(param);
        return output;
    }

    protected String replaceToken(String src, String token, String replacedWith) {
        StringBuffer strBuf = new StringBuffer();
        StringTokenizer strParser = new StringTokenizer(src, token, true);
        while (strParser.hasMoreTokens()) {
            String tmptoken = strParser.nextToken();
            if (tmptoken.compareTo("'") == 0) {
                strBuf.append(replacedWith);
                continue;
            }
            strBuf.append(tmptoken);
        }
        return strBuf.toString();
    }
}

