/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSConfig;
import com.cognos.rtsconfig.RTSConversionData;
import com.cognos.rtsconfig.RTSTransliterationData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class RTSConfigCompile
extends JDialog {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private static final String savingData = "                    " + msgs.getString("SAVING_DATA") + "                    ";
    private static final String noSubstitution = "<" + msgs.getString("NO_SUBSTITUTION") + ">";
    private static final String restoringDefaults = "                    " + msgs.getString("RESTORING_DEFAULTS") + "                    ";
    private static final String compileConversionData = "                    " + msgs.getString("COMPILE_CONVERSION_DATA") + "                    ";
    private static final String generatingConversionData = "                    " + msgs.getString("GENERATING_CONVERSION_DATA") + "                    ";
    private static final String generatingSubstitutionData = "                    " + msgs.getString("GENERATING_SUBSTITUTION_DATA") + "                    ";
    private static final String expectedOutput = "CRN Compatibility mode is ON";
    private static String sjisName = "ibm-943_P15A-2003";
    private int configMode;
    private Thread workerThread;
    private boolean dataChanged;
    private RTSConfig parent;
    private RTSConversionData conversionData;
    private RTSTransliterationData transliterationData;
    public static final int ERROR_AT_RUNTIME = 0;
    public static final int NO_ERROR_AT_RUNTIME = 1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel1;

    private void setFont(Container container, Font font) {
        Component[] components = container.getComponents();
        for (int idx = 0; idx < components.length; ++idx) {
            components[idx].setFont(font);
            if (!(components[idx] instanceof Container)) continue;
            this.setFont((Container)components[idx], font);
        }
    }

    public RTSConfigCompile(Frame parent, RTSConversionData conversionData, RTSTransliterationData transliterationData) {
        super(parent, true);
        this.initComponents();
        this.parent = (RTSConfig)parent;
        this.conversionData = conversionData;
        this.transliterationData = transliterationData;
        this.configMode = 0;
    }

    public void setMode(int configMode) {
        this.configMode = configMode;
    }

    @Override
    public void setFont(Font font) {
        this.setFont(this, font);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performUpdate(RTSConfig utility, boolean dataChanged, boolean restoreOnly) {
        try {
            this.dataChanged = dataChanged;
            this.workerThread = new Thread(new RTSConfigCompileWorker(this, utility, restoreOnly));
            this.workerThread.start();
            this.show();
            this.workerThread.join();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.isVisible()) {
                this.setVisible(false);
            }
            this.dispose();
        }
        return this.dataChanged;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.setTitle("");
        this.setTitle(msgs.getString("ACTION_TITLE"));
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                RTSConfigCompile.this.dialogShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RTSConfigCompile.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setText(generatingSubstitutionData);
        this.jPanel1.add((Component)this.jLabel1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jButton1.setText(msgs.getString("CANCEL"));
        this.jButton1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '\u001b') {
                    RTSConfigCompile.this.workerThread.interrupt();
                }
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfigCompile.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void dialogShown(ComponentEvent evt) {
        this.jButton1.requestFocus();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.workerThread.interrupt();
    }

    private void closeDialog(WindowEvent evt) {
        this.workerThread.interrupt();
    }

    private class RTSConfigCompileWorker
    implements Runnable {
        private boolean restoreOnly;
        private RTSConfig utility;
        private RTSConfigCompile dialog;

        private void ceckCRNCompatMode() throws Exception {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = null;
                process = File.pathSeparatorChar == ':' ? runtime.exec("./conv_compat.sh") : runtime.exec("conv_compat.cmd");
                process.waitFor();
                InputStream is = process.getInputStream();
                byte[] outBuffer = new byte[256];
                is.read(outBuffer);
                String commandOutput = new String(outBuffer);
                if (commandOutput.startsWith(RTSConfigCompile.expectedOutput)) {
                    sjisName = "ibm-943_P14A-2000";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.sleep(1000L);
        }

        private void compileConversionData() throws Exception {
            if (!this.restoreOnly) {
                RTSConfigCompile.this.jLabel1.setText(compileConversionData);
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = null;
                    process = File.pathSeparatorChar == ':' ? runtime.exec("./rtscomp") : runtime.exec("rtscomp");
                    process.waitFor();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Thread.sleep(1000L);
            }
        }

        private void generateConversionData() throws Exception {
            if (!this.restoreOnly) {
                try {
                    int idx3;
                    Vector lineNumbers;
                    int idx;
                    RTSConfigCompile.this.jLabel1.setText(generatingConversionData);
                    Vector<String> rows = new Vector<String>();
                    String userdir = System.getProperty("user.dir").replace('\\', '/');
                    String filename = new String("jar:file://");
                    if (userdir.charAt(1) == ':') {
                        filename = filename + '/';
                    }
                    filename = filename + userdir;
                    filename = filename + "/rtsconfig.jar!/com/cognos/rtsconfig/" + sjisName + ".master";
                    URL url = new URL(filename);
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    String line = in.readLine();
                    while (line != null) {
                        rows.addElement(line);
                        line = in.readLine();
                    }
                    in.close();
                    block8: for (idx = 0; idx < RTSConfigCompile.this.conversionData.getRowCount(); ++idx) {
                        Vector row = RTSConfigCompile.this.conversionData.getRow(idx);
                        String val1 = (String)row.elementAt(0);
                        int pos = val1.indexOf(" ");
                        if (pos > 0) {
                            val1 = val1.substring(0, pos);
                        }
                        String val2 = (Boolean)row.elementAt(2) == true ? (String)row.elementAt(1) : ((Boolean)row.elementAt(4) == true ? (String)row.elementAt(3) : (String)row.elementAt(5));
                        lineNumbers = RTSConfigCompile.this.conversionData.getReference(idx);
                        switch (RTSConfigCompile.this.configMode) {
                            case 0: {
                                int lineNumber = (Integer)lineNumbers.elementAt(0);
                                if (val1.equalsIgnoreCase("U+FFE4")) {
                                    rows.setElementAt(new String("<U" + val1.substring(2) + "> \\x" + val2.substring(2, 4) + "\\x" + val2.substring(4) + " |1"), lineNumber);
                                    continue block8;
                                }
                                rows.setElementAt(new String("<U" + val1.substring(2) + "> \\x" + val2.substring(2, 4) + "\\x" + val2.substring(4) + " |0"), lineNumber);
                                continue block8;
                            }
                            case 1: {
                                val2 = "\\x" + val2.substring(2, 4) + "\\x" + val2.substring(4);
                                for (int idx2 = 0; idx2 < lineNumbers.size(); ++idx2) {
                                    String val3 = (String)rows.elementAt((Integer)lineNumbers.elementAt(idx2));
                                    idx3 = val3.lastIndexOf(124);
                                    val3 = val3.indexOf(val2) != -1 ? val3.substring(0, idx3) + "|0" : val3.substring(0, idx3) + "|3";
                                    rows.setElementAt(val3, (Integer)lineNumbers.elementAt(idx2));
                                }
                                continue block8;
                            }
                        }
                    }
                    if (RTSConfigCompile.this.configMode == 0) {
                        int deleteCount = 0;
                        for (idx3 = 0; idx3 < RTSConfigCompile.this.conversionData.getRowCount(); ++idx3) {
                            lineNumbers = RTSConfigCompile.this.conversionData.getReference(idx3);
                            int idx4 = 1;
                            while (idx4 < lineNumbers.size()) {
                                rows.removeElementAt((Integer)lineNumbers.elementAt(idx4) - deleteCount);
                                ++idx4;
                                ++deleteCount;
                            }
                        }
                    }
                    BufferedWriter out = new BufferedWriter(new FileWriter(sjisName + ".ucm"));
                    for (idx = 0; idx < rows.size(); ++idx) {
                        out.write((String)rows.elementAt(idx));
                        out.newLine();
                    }
                    out.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Thread.sleep(500L);
            }
        }

        private void generateTransliterationData() throws Exception {
            if (this.restoreOnly) {
                RTSConfigCompile.this.jLabel1.setText(restoringDefaults);
                this.restoreDefaults();
            } else {
                RTSConfigCompile.this.jLabel1.setText(generatingSubstitutionData);
            }
            String substitutionData = new String();
            for (int row = 0; row < RTSConfigCompile.this.transliterationData.getRowCount(); ++row) {
                Vector rowData = RTSConfigCompile.this.transliterationData.getRow(row);
                for (int col = 0; col < rowData.size(); col += 2) {
                    String val2;
                    String val1 = (String)rowData.elementAt(col);
                    int pos = val1.indexOf(" ");
                    if (pos > 0) {
                        val1 = val1.substring(0, pos);
                    }
                    if ((val2 = (String)rowData.elementAt(col + 1)).equalsIgnoreCase(noSubstitution)) continue;
                    pos = val2.indexOf(" ");
                    if (pos > 0) {
                        val2 = val2.substring(0, pos);
                    }
                    substitutionData = substitutionData + "\\u" + val1.substring(2) + " <> \\u" + val2.substring(2) + ";";
                }
            }
            if (substitutionData.length() > 0) {
                Document document;
                File file = new File("i18n_res.xml");
                if (file.canWrite()) {
                    SAXReader reader = new SAXReader();
                    document = reader.read("i18n_res.xml");
                    Element substitutionElement = (Element)document.getRootElement().selectSingleNode("//*[local-name()='resources']/*[local-name()='ja_substitution']");
                    if (substitutionElement != null) {
                        document.getRootElement().remove(substitutionElement);
                    }
                    Element eitem = document.getRootElement().addElement("ja_substitution");
                    eitem.setText(substitutionData);
                } else {
                    document = DocumentHelper.createDocument();
                    Element eitem = document.addElement("resources");
                    eitem = eitem.addElement("ja_substitution");
                    eitem.setText(substitutionData);
                }
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("i18n_res.xml"), "UTF-8"));
                OutputFormat format = new OutputFormat("\t", true);
                format.setTrimText(true);
                XMLWriter writer = new XMLWriter((Writer)out, format);
                writer.write(document);
                writer.flush();
                out.close();
            }
            Thread.sleep(500L);
        }

        private void restoreDefaults() throws Exception {
            this.utility.dataFile = "shift-jis.xml";
            String userdir = System.getProperty("user.dir").replace('\\', '/');
            String filename = new String("jar:file://");
            if (userdir.charAt(1) == ':') {
                filename = filename + '/';
            }
            filename = filename + userdir;
            filename = filename + "/rtsconfig.jar!/com/cognos/rtsconfig/shift-jis.master";
            BufferedReader bin = new BufferedReader(new InputStreamReader(new URL(filename).openStream()));
            BufferedWriter bout = new BufferedWriter(new FileWriter(this.utility.dataFile));
            String line = bin.readLine();
            while (line != null) {
                bout.write(line);
                bout.newLine();
                line = bin.readLine();
            }
            bin.close();
            bout.close();
            FileInputStream fin = new FileInputStream(sjisName + ".cnv.orig");
            FileOutputStream fout = new FileOutputStream(sjisName + ".cnv");
            byte[] buffer = new byte[4096];
            int bytesRead = fin.read(buffer);
            while (bytesRead != -1) {
                fout.write(buffer, 0, bytesRead);
                bytesRead = fin.read(buffer);
            }
            fin.close();
            fout.close();
            SAXReader reader = new SAXReader();
            Document document = reader.read(this.utility.dataFile);
            this.utility.model1.load(document);
            this.utility.model2.load(document);
        }

        private void saveAll() throws Exception {
            if (!this.restoreOnly) {
                RTSConfigCompile.this.jLabel1.setText(savingData);
                RTSConfigCompile.this.parent.save(false);
                RTSConfigCompile.this.dataChanged = false;
                Thread.sleep(500L);
            }
        }

        RTSConfigCompileWorker(RTSConfigCompile dialog, RTSConfig utility, boolean restoreOnly) {
            this.dialog = dialog;
            this.utility = utility;
            this.restoreOnly = restoreOnly;
        }

        @Override
        public void run() {
            try {
                this.ceckCRNCompatMode();
                this.saveAll();
                this.generateConversionData();
                this.compileConversionData();
                this.generateTransliterationData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            File file = new File(sjisName + ".ucm");
            file.delete();
            this.dialog.setVisible(false);
        }
    }
}

