/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSConversionData;
import com.cognos.rtsconfig.RTSTransliterationData;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RTSConfigDataSorter
extends AbstractTableModel {
    private TableModel model = null;

    private void sort(int column, boolean ascending) {
        if (this.model instanceof RTSConversionData) {
            ((RTSConversionData)this.model).sort(column, ascending);
        } else if (this.model instanceof RTSTransliterationData) {
            ((RTSTransliterationData)this.model).sort(column, ascending);
        }
        this.fireTableChanged(new TableModelEvent(this, -1));
        this.fireTableChanged(new TableModelEvent(this));
    }

    RTSConfigDataSorter(TableModel model) {
        this.model = model;
    }

    public void addColumnSelectListener(JTable table) {
        final JTable lcltable = table;
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = lcltable.getColumnModel();
                int column = lcltable.convertColumnIndexToModel(columnModel.getColumnIndexAtX(e.getX()));
                if (e.getClickCount() == 1 && column != -1) {
                    RTSConfigDataSorter.this.sort(column, !e.isShiftDown());
                    TableColumn columnHeader = columnModel.getColumn(column);
                    columnHeader.setHeaderValue((String)columnHeader.getHeaderValue() + "  *");
                }
            }
        };
        lcltable.getTableHeader().addMouseListener(mouseListener);
        TableColumn columnHeader = lcltable.getColumnModel().getColumn(0);
        columnHeader.setHeaderValue((String)columnHeader.getHeaderValue() + "  *");
    }

    public int find(String findValue) {
        int row = 0;
        if (this.model instanceof RTSConversionData) {
            row = ((RTSConversionData)this.model).find(findValue);
        } else if (this.model instanceof RTSTransliterationData) {
            row = ((RTSTransliterationData)this.model).find(findValue);
        }
        return row;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.model.getValueAt(row, column);
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.model.setValueAt(aValue, row, column);
    }
}

