/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSConversionData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class RTSConversionRadioButton
extends JRadioButton
implements ActionListener,
TableCellEditor,
TableCellRenderer {
    private Font font = null;
    private RTSConversionData data = null;
    private CellEditorListener listener = null;

    public RTSConversionRadioButton(RTSConversionData data, Font font) {
        this.data = data;
        this.font = font;
        this.addActionListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color background = null;
        JComponent component = this;
        background = isSelected ? table.getSelectionBackground() : table.getBackground();
        Vector rowInfo = this.data.getRow(row);
        String text = (String)rowInfo.elementAt(col * 2 - 1);
        if (text.length() > 0) {
            this.setText(text);
            this.setSelected((Boolean)value);
        } else {
            component = new JLabel();
        }
        ((Component)component).setFont(this.font);
        ((Component)component).setBackground(background);
        return component;
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listener = listener;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        Color background = null;
        background = isSelected ? table.getSelectionBackground() : table.getBackground();
        Vector rowInfo = this.data.getRow(row);
        String text = (String)rowInfo.elementAt(col * 2 - 1);
        this.setText(text);
        this.setSelected((Boolean)value);
        this.setFont(this.font);
        this.setBackground(background);
        return this;
    }

    @Override
    public void cancelCellEditing() {
        this.listener.editingCanceled(new ChangeEvent(this));
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !this.isSelected();
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listener = null;
    }

    @Override
    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public boolean stopCellEditing() {
        this.listener.editingStopped(new ChangeEvent(this));
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }
}

