/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RTSHelp
extends JDialog {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private String browser = new String("netscape");
    private Process process = null;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel1;

    private void setFont(Container container, Font font) {
        Component[] components = container.getComponents();
        for (int idx = 0; idx < components.length; ++idx) {
            components[idx].setFont(font);
            if (!(components[idx] instanceof Container)) continue;
            this.setFont((Container)components[idx], font);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.setPreferredSize(new Dimension(200, 100));
        this.setTitle("");
        this.setTitle(msgs.getString("HELP_LAUNCH_ERROR_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RTSHelp.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText(msgs.getString("HELP_LAUNCH_ERROR"));
        this.jPanel1.add(this.jLabel1);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jButton1.setText(msgs.getString("OK"));
        this.jButton1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '\n') {
                    RTSHelp.this.setVisible(false);
                    RTSHelp.this.dispose();
                } else if (c == '\u001b') {
                    RTSHelp.this.setVisible(false);
                    RTSHelp.this.dispose();
                }
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSHelp.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public RTSHelp(Frame parent, boolean modal, String browser) {
        super(parent, modal);
        this.initComponents();
        String platform = System.getProperty("os.arch");
        if (platform.equalsIgnoreCase("x86")) {
            this.browser = "rundll32 url.dll,FileProtocolHandler";
        } else if (browser.length() > 0) {
            this.browser = browser;
        }
    }

    public void displayHelp() {
        try {
            String cmd = this.browser + " " + "file://";
            String fileName = "../webcontent/documentation";
            fileName = fileName + "/" + Locale.getDefault().getLanguage().toLowerCase();
            fileName = fileName + "/ug_cra.html?helpid=HID_ROUND_TRIP_SAFETY";
            File file = new File(fileName);
            String absPath = file.getAbsolutePath();
            cmd = cmd + absPath;
            this.process = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(true);
    }

    @Override
    public void setFont(Font font) {
        this.setFont(this, font);
        this.pack();
    }
}

