/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class RTSLogger {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private static final String noSubstitution = "<" + msgs.getString("NO_SUBSTITUTION") + ">";
    private static String name = null;
    private static Vector entries = new Vector();
    private static RTSLogger logger = null;

    private RTSLogger() {
    }

    private static void log(String text) {
        entries.addElement(new String(new Date() + ", " + System.getProperty("user.name") + ", " + text));
    }

    public static synchronized RTSLogger getInstance() {
        if (logger == null) {
            name = new String("./rtsconfig_" + Locale.getDefault().getLanguage() + ".log");
            logger = new RTSLogger();
        }
        return logger;
    }

    public static synchronized void reset() {
        entries.clear();
    }

    public static synchronized void conversionDataChange(String unicodeValue, String nativeValue) {
        if (nativeValue != null) {
            RTSLogger.log(MessageFormat.format(msgs.getString("NOW_MAPS_TO"), unicodeValue, nativeValue));
        }
    }

    public static synchronized void substitutionDataChange(String unicodeValue, String substitutionValue) {
        if (substitutionValue != null) {
            if (substitutionValue.equalsIgnoreCase(noSubstitution)) {
                RTSLogger.log(MessageFormat.format(msgs.getString("IS_NO_LONGER_SUBSTITUTED"), unicodeValue));
            } else {
                RTSLogger.log(MessageFormat.format(msgs.getString("IS_SUBSTITUTED_WITH"), unicodeValue, substitutionValue));
            }
        }
    }

    public static synchronized void sessionEnd() {
        try {
            if (entries.size() > 0) {
                RTSLogger.log(msgs.getString("SESSION_END"));
                BufferedWriter out = new BufferedWriter(new FileWriter(name, true));
                for (int idx = 0; idx < entries.size(); ++idx) {
                    out.write((String)entries.elementAt(idx));
                    out.newLine();
                }
                out.newLine();
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void sessionStart() {
        RTSLogger.log(msgs.getString("SESSION_START"));
    }
}

