/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class RTSTransliterationData
extends AbstractTableModel {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private static final String noSubstitution = "<" + msgs.getString("NO_SUBSTITUTION") + ">";
    private static final String substitutionChar = "U+FFFD";
    private int rowCount = 0;
    private int[] map = null;
    private Vector rows = new Vector();
    private boolean dataChanged = false;
    protected boolean showGlyphs = false;

    private String getDisplayValueAt(int row, int col, boolean useMap) {
        Vector rowData;
        int pos = -1;
        String text = null;
        if (useMap && this.map != null) {
            row = this.map[row];
        }
        if (!(text = (String)(rowData = (Vector)this.rows.elementAt(row)).elementAt(col)).equalsIgnoreCase(noSubstitution)) {
            pos = text.indexOf(" ");
            if (this.showGlyphs) {
                if (pos == -1) {
                    Integer value = Integer.decode("0x" + text.substring(2));
                    text = text + "  ( " + (char)value.intValue() + " )";
                }
            } else if (pos > 0) {
                text = text.substring(0, pos);
            }
        }
        return text;
    }

    RTSTransliterationData() {
    }

    public boolean containsGlyphs() {
        return this.showGlyphs;
    }

    public boolean dataChanged() {
        return this.dataChanged;
    }

    public int find(String findValue) {
        return -1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        String name = null;
        switch (col) {
            case 0: {
                name = msgs.getString("SUBSTITUTE_FROM");
                break;
            }
            case 1: {
                name = msgs.getString("SUBSTITUTE_TO");
            }
        }
        return name;
    }

    public Vector getRow(int row) {
        if (this.map != null) {
            row = this.map[row];
        }
        return (Vector)this.rows.elementAt(row);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int pos = -1;
        String data = new String();
        if (this.map != null) {
            row = this.map[row];
        }
        Vector rowData = (Vector)this.rows.elementAt(row);
        if (col < 0) {
            col = -col;
        }
        if (col == 0) {
            for (int idx = 0; idx < rowData.size() - 1; idx += 2) {
                if (idx > 0) {
                    data = data + " , ";
                }
                String text = (String)rowData.elementAt(idx);
                pos = text.indexOf(" ");
                if (this.showGlyphs) {
                    if (pos != -1) continue;
                    Integer value = Integer.decode("0x" + text.substring(2));
                    data = data + text + "  ( " + (char)value.intValue() + " )";
                    continue;
                }
                data = pos > 0 ? data + text.substring(0, pos) : data + text;
            }
        } else {
            data = (String)rowData.elementAt(col);
            if (!data.equalsIgnoreCase(noSubstitution)) {
                pos = data.indexOf(" ");
                if (this.showGlyphs) {
                    if (pos == -1) {
                        Integer value = Integer.decode("0x" + data.substring(2));
                        data = data + "  ( " + (char)value.intValue() + " )";
                    }
                } else if (pos > 0) {
                    data = data.substring(0, pos);
                }
            }
        }
        return data;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean canEdit = false;
        if (col == 1) {
            canEdit = true;
        }
        return canEdit;
    }

    public void load(Document document) {
        try {
            this.rowCount = 0;
            this.dataChanged = false;
            this.rows.removeAllElements();
            Element entries = (Element)document.selectSingleNode("//rtsconfig/substitution");
            Iterator it = entries.elementIterator();
            while (it.hasNext()) {
                int idx;
                ++this.rowCount;
                Vector<String> row = new Vector<String>();
                Element entry = (Element)it.next();
                List list = entry.selectNodes("./codepoint");
                for (idx = 0; idx < list.size(); ++idx) {
                    Element item = (Element)list.get(idx);
                    Attribute attr = item.attribute("value");
                    row.addElement(attr.getValue());
                    attr = item.attribute("replaceWith");
                    String val = attr.getValue();
                    if (val.equalsIgnoreCase(substitutionChar)) {
                        val = noSubstitution;
                    }
                    row.addElement(val);
                }
                for (idx = list.size(); idx < 2; ++idx) {
                    row.addElement(new String());
                    row.addElement(new String());
                }
                this.rows.addElement(row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("\t<substitution>");
        out.newLine();
        for (int row = 0; row < this.rowCount; ++row) {
            out.write("\t\t<entry id=\"" + (row + 1) + "\">");
            out.newLine();
            Vector rowData = (Vector)this.rows.elementAt(row);
            for (int col = 0; col < rowData.size(); col += 2) {
                out.write("\t\t\t<codepoint");
                String val1 = (String)rowData.elementAt(col);
                int pos = val1.indexOf(" ");
                if (pos > 0) {
                    val1 = val1.substring(0, pos);
                }
                out.write(" value=\"" + val1 + "\"");
                String val2 = (String)rowData.elementAt(col + 1);
                if (val2.equalsIgnoreCase(noSubstitution)) {
                    val2 = substitutionChar;
                } else {
                    pos = val2.indexOf(" ");
                    if (pos > 0) {
                        val2 = val2.substring(0, pos);
                    }
                }
                out.write(" replaceWith=\"" + val2 + "\"/>");
                out.newLine();
            }
            out.write("\t\t</entry>");
            out.newLine();
        }
        out.write("\t</substitution>");
        out.newLine();
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object unicodeValue = null;
        if (this.map != null) {
            row = this.map[row];
        }
        Vector rowData = (Vector)this.rows.elementAt(row);
        for (int idx = 1; idx < rowData.size(); idx += 2) {
            if (((String)rowData.elementAt(idx)).equalsIgnoreCase((String)value)) continue;
            this.dataChanged = true;
            rowData.setElementAt(value, idx);
        }
        if (this.dataChanged) {
            RTSLogger.getInstance();
            RTSLogger.substitutionDataChange((String)rowData.elementAt(0), (String)value);
        }
    }

    public void showGlyphs(boolean val) {
        this.showGlyphs = val;
    }

    public void sort(int column, boolean ascending) {
        int row;
        Object[] sortValues = new SortValue[this.rowCount];
        for (row = 0; row < this.rowCount; ++row) {
            sortValues[row] = new SortValue();
            ((SortValue)sortValues[row]).row = row;
            ((SortValue)sortValues[row]).ascending = ascending;
            ((SortValue)sortValues[row]).columnValue = this.getDisplayValueAt(row, column, false);
        }
        Arrays.sort(sortValues);
        this.map = new int[this.rowCount];
        for (row = 0; row < this.rowCount; ++row) {
            this.map[row] = ((SortValue)sortValues[row]).row;
        }
    }

    private class SortValue
    implements Comparable {
        int row;
        boolean ascending;
        String columnValue;

        private SortValue() {
        }

        public int compareTo(Object obj) {
            if (this.ascending) {
                return this.columnValue.compareTo(((SortValue)obj).columnValue);
            }
            return ((SortValue)obj).columnValue.compareTo(this.columnValue);
        }
    }
}

