/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities.CAMTool;

import com.cognos.accman.jcam.utilities.CAMTool.BasicWindowMonitor;
import com.cognos.accman.jcam.utilities.CAMTool.MyActionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class CAMTool
extends Frame
implements ActionListener {
    public CAMTool() {
        super("CAMTool");
        this.setSize(1280, 356);
        this.setLocation(56, 56);
        this.addWindowListener(new BasicWindowMonitor());
        MyActionListener handler = new MyActionListener();
        String myText = "\nCAMTool - An utility tool to diagnose and debug CAM related issues.\n\n\n";
        SimpleAttributeSet centerAlignment = new SimpleAttributeSet();
        StyleConstants.setAlignment(centerAlignment, 1);
        SimpleAttributeSet leftAlignment = new SimpleAttributeSet();
        StyleConstants.setAlignment(leftAlignment, 0);
        JTextPane textPane = new JTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        doc.setParagraphAttributes(0, myText.length(), centerAlignment, true);
        try {
            StyleContext sc = new StyleContext();
            Style style = sc.addStyle("TitleStyle", null);
            Font font = new Font("Arial", 1, 20);
            StyleConstants.setFontFamily(style, font.getFamily());
            StyleConstants.setBold(style, true);
            StyleConstants.setFontSize(style, 20);
            doc.insertString(doc.getLength(), myText, style);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        try {
            String key = "CSK Keys:  ";
            this.showKeyEntry(doc, key, "List up all the names of CSK keys in your local CSK key store\n");
            key = "CA certificates:  ";
            this.showKeyEntry(doc, key, "List up all trusted CA certificates in your trust store.\n");
            key = "Encryption certificates:  ";
            this.showKeyEntry(doc, key, "Show encryption certificate or certificate chain. The encryption certificates are used for SSL and requesting newest CSK from Content Manager.\n");
            key = "Signing certificates:  ";
            this.showKeyEntry(doc, key, "Show signing certificate or certificate chain. The signing certificates are used for requesting newest CSK from Content Manager.\n");
            key = "Check Cognos Analytics connection URLs:  ";
            this.showKeyEntry(doc, key, "Check connection URLs in configuration XML.\n");
            key = "Load CAM libraries:  ";
            this.showKeyEntry(doc, key, "Load and check CAMCrypto JNI libiary.\n");
            key = "Run all above commands:  ";
            this.showKeyEntry(doc, key, "Run all diagnose tests and save the results to a text file named 'camcrypto_diagnose.txt' at the same location of the CAMTool command. This may take several minutes.\n");
            this.showKeyEntry(doc, "\n\n", null);
        }
        catch (Exception key) {
            // empty catch block
        }
        this.add((Component)textPane, "First");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.setBackground(Color.white);
        JButton button_CSKKeys = new JButton("CSK Keys");
        button_CSKKeys.setAlignmentX(0.0f);
        button_CSKKeys.setActionCommand("CSK Keys");
        button_CSKKeys.addActionListener(handler);
        panel.add(button_CSKKeys);
        JButton button_CACerts = new JButton("CA certificates");
        button_CACerts.setActionCommand("CA certificates");
        button_CACerts.addActionListener(handler);
        panel.add(button_CACerts);
        JButton button_EncCerts = new JButton("Encryption certificates");
        button_EncCerts.setActionCommand("Encryption certificates");
        button_EncCerts.addActionListener(handler);
        panel.add(button_EncCerts);
        JButton button_SignCerts = new JButton("Signing certificates");
        button_SignCerts.setActionCommand("Signing certificates");
        button_SignCerts.addActionListener(handler);
        panel.add(button_SignCerts);
        JButton button_SSLClient = new JButton("Check Cognos Analytics connection URLs");
        button_SSLClient.setActionCommand("Check Cognos Analytics connection URLs");
        button_SSLClient.addActionListener(handler);
        panel.add(button_SSLClient);
        JButton button_loadJNI = new JButton("Load CAM libraries");
        button_loadJNI.setActionCommand("Load CAM libraries");
        button_loadJNI.addActionListener(handler);
        panel.add(button_loadJNI);
        JButton button_runAll = new JButton("Run all above commands");
        button_runAll.setActionCommand("Run all above commands");
        button_runAll.addActionListener(handler);
        panel.add(button_runAll);
        this.add((Component)panel, "Before");
    }

    private void showKeyEntry(StyledDocument doc, String key, String description) throws BadLocationException {
        StyleContext sc = new StyleContext();
        Style style = sc.addStyle("KeyStyle", null);
        Font font = new Font("Arial", 1, 18);
        StyleConstants.setFontFamily(style, font.getFamily());
        StyleConstants.setBold(style, true);
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 0);
        doc.setParagraphAttributes(doc.getLength(), 0, attribs, true);
        doc.insertString(doc.getLength(), key, style);
        doc.insertString(doc.getLength(), description, attribs);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        System.out.println(ae.getActionCommand());
    }

    public static void main(String[] args) {
        CAMTool camTool = new CAMTool();
        camTool.setVisible(true);
    }
}

