/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.modelupdate;

import com.ibm.cognos.modelupdate.UpdateModelXSLT;
import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelUpdate {
    private static final String MODELFILE = "-modelfile";
    private static final String SHIFT = "-shift";
    private static final String UPPERCASE = "upper";
    private static final String LOWERCASE = "lower";
    private static final String DATASOURCENAME = "-datasourcename";
    private static final String INPUTLOCATION = "-inputlocation";
    private static final String FILENAME = "-filename";
    private static final String OUTPUTLOCATION = "-outputlocation";
    private static final String OUTPUTFILEEXTENSION = "-outputfileextension";
    private static final String QUERYOBJECT = "-queryobject";
    private static final String DBQUERY = "dbquery";
    private static final String STOREDPROCEDURE = "storedprocedure";
    private static final String FUNCTION = "function";
    private static final String CMDLINEOPTIONSFILE = "-cmdlineoptionsfile";
    private static final String XSLTFILE = "-xsltfile";
    private static String modelFile;
    private static ShiftOption shiftCase;
    private static boolean shiftToUpperCase;
    private static List<String> dataSourceNames;
    private static String inputLocation;
    private static String fileName;
    private static String outputLocation;
    private static String outputFileExtension;
    private static Map<String, String> excludeQueryObjects;
    private static String cmdLineOptionsFile;
    private static String xsltFile;
    private static String DBQUERY_XPATH;
    private static String STOREDPROCEDURE_XPATH;
    private static String FUNCTION_XPATH;

    static {
        shiftCase = ShiftOption.non;
        shiftToUpperCase = false;
        DBQUERY_XPATH = "<xsl:variable name=\"dbQuery_cognos\" select=\"fm:definition/fm:dbQuery/fm:sql[@type='cognos']\"/>";
        STOREDPROCEDURE_XPATH = "<xsl:variable name=\"storedProc\" select=\"fm:definition/fm:storedProcedure/fm:dataSourceRef\"/>";
        FUNCTION_XPATH = "<xsl:variable name=\"function\" select=\"fm:dataSourceRef\"/>";
    }

    private static void printUsage() {
        System.out.println("\n");
        System.out.println("FMMD_ModelUpdate.bat -shift=upper/lower [-datasourcename=<name>] [-inputlocation=<folder>] [-filename=<name>] [-outputlocation=<folder>] [-outputfileextension=<.out.xml>] [-queryObject=dbquery/storedprocedure/function] [-cmdlineoptionsfile=file] [-xsltfile=<file>] \n");
        System.out.println("\n");
        System.out.println("-shift=upper/lower.  Shift object names in the model file to upper-case or to lower-case.  By default, shift to upper-case is used.\n");
        System.out.println("-datasourcename=name.  Data source name to be searched.  By default, all data source names are searched.  Option can be repeated for other data source names.\n");
        System.out.println("-inputlocation=folder.  Input location to search for a model file. By default, the current working directory is used.\n");
        System.out.println("-filename=name.  Name of the model file to be searched.  By default, the name is model.xml\n");
        System.out.println("-outputlocation=folder.  Output location for the output model file.\n");
        System.out.println("-outputfileextension=.out.xml.  By default, the extension of the output model file is .out.xml.\n");
        System.out.println("-queryobject=dbquery/storedprocedure/function.  Specify a object to be searched.  By default, all objects are searched.  Option can be repeated for other objects.\n");
        System.out.println("-cmdlineoptionsfile=file. The command line options could be added to a file.\n");
        System.out.println("-xsltfile=file. A user's own stylesheet file.\n");
        System.out.println("-h. This help information.\n");
        System.out.println("\n");
        System.out.println("Notes. The option -outputfileextesion=.xml is not allowed if the output location is the same as the input location to avoid overwriting the input model file.\n");
        System.out.println("Example: FMMD_ModelUpdate.bat -shift=lower -datasourcename=DB2 -datasourcename=Oracle -queryobject=dbquery -queryobject=function");
        System.exit(1);
    }

    static void setCmdOptions(List<String> cmdOptions, String[] args) {
        int i = 0;
        while (i < args.length) {
            String[] temp = args[i].split("=");
            if (temp.length != 2) {
                System.out.printf("Invalid entry: %s\n", args[i]);
                ModelUpdate.printUsage();
            }
            if (!cmdOptions.contains(temp[0])) {
                System.out.printf("Invalid command option: %s\n", temp[0]);
                ModelUpdate.printUsage();
            }
            if (temp[0].equals(XSLTFILE)) {
                xsltFile = temp[1];
            }
            if (temp[0].equals(MODELFILE)) {
                modelFile = temp[1];
            }
            if (temp[0].equals(FILENAME)) {
                fileName = temp[1];
            }
            if (temp[0].equals(SHIFT)) {
                if (temp[1].equals(UPPERCASE)) {
                    shiftCase = ShiftOption.upper;
                } else if (temp[1].equals(LOWERCASE)) {
                    shiftCase = ShiftOption.lower;
                } else {
                    System.out.printf("Invalid command line shift option: %s\n", temp[1]);
                    ModelUpdate.printUsage();
                }
            }
            if (temp[0].equals(DATASOURCENAME)) {
                dataSourceNames.add(temp[1]);
            }
            if (temp[0].equals(INPUTLOCATION)) {
                inputLocation = temp[1];
            }
            if (temp[0].equals(OUTPUTLOCATION)) {
                outputLocation = temp[1];
            }
            if (temp[0].equals(OUTPUTFILEEXTENSION)) {
                outputFileExtension = temp[1];
            }
            if (temp[0].equals(QUERYOBJECT)) {
                if (!cmdOptions.contains(temp[1])) {
                    System.out.printf("Invalid object name: %s\n", temp[1]);
                    ModelUpdate.printUsage();
                } else {
                    excludeQueryObjects.remove(temp[1]);
                }
            }
            if (temp[0].equals(CMDLINEOPTIONSFILE)) {
                cmdLineOptionsFile = temp[1];
            }
            ++i;
        }
    }

    private static void processParams(String[] args) throws Exception {
        Path xsltPath;
        Path modelPath;
        Path inputPath;
        ArrayList<String> cmdOptions = new ArrayList<String>();
        cmdOptions.add(MODELFILE);
        cmdOptions.add(SHIFT);
        cmdOptions.add(UPPERCASE);
        cmdOptions.add(LOWERCASE);
        cmdOptions.add(DATASOURCENAME);
        cmdOptions.add(INPUTLOCATION);
        cmdOptions.add(FILENAME);
        cmdOptions.add(OUTPUTLOCATION);
        cmdOptions.add(OUTPUTFILEEXTENSION);
        cmdOptions.add(QUERYOBJECT);
        cmdOptions.add(DBQUERY);
        cmdOptions.add(STOREDPROCEDURE);
        cmdOptions.add(FUNCTION);
        cmdOptions.add(CMDLINEOPTIONSFILE);
        cmdOptions.add(XSLTFILE);
        dataSourceNames = new ArrayList<String>();
        excludeQueryObjects = new HashMap<String, String>();
        excludeQueryObjects.put(DBQUERY, DBQUERY_XPATH);
        excludeQueryObjects.put(STOREDPROCEDURE, STOREDPROCEDURE_XPATH);
        excludeQueryObjects.put(FUNCTION, FUNCTION_XPATH);
        if (args.length == 1 && args[0].equals("-h")) {
            ModelUpdate.printUsage();
        }
        ModelUpdate.setCmdOptions(cmdOptions, args);
        if (cmdLineOptionsFile != null && !cmdLineOptionsFile.isEmpty()) {
            Path configPath = Paths.get(cmdLineOptionsFile, new String[0]);
            if (!Files.exists(configPath, new LinkOption[0]) || !Files.isReadable(configPath)) {
                System.out.println(configPath);
                throw new Exception("configure file is not valid or not read-able\n");
            }
            List<String> list = ModelUpdate.readCmdLineOptionsFile(cmdLineOptionsFile);
            String[] arr = new String[list.size()];
            arr = list.toArray(arr);
            ModelUpdate.setCmdOptions(cmdOptions, arr);
        }
        if (fileName == null) {
            fileName = "model.xml";
        }
        if (xsltFile == null) {
            xsltFile = "FMMD_ModelUpdate.xsl";
        }
        if (shiftCase == ShiftOption.non) {
            throw new Exception("Please specify the shift option ( upper or lower )\n");
        }
        if (shiftCase == ShiftOption.upper) {
            shiftToUpperCase = true;
        } else if (shiftCase == ShiftOption.lower) {
            shiftToUpperCase = false;
        }
        if (inputLocation == null) {
            inputLocation = Paths.get("", new String[0]).toAbsolutePath().toString();
        }
        if (inputLocation != null && !inputLocation.isEmpty()) {
            inputPath = Paths.get(inputLocation, new String[0]);
            if (!Files.exists(inputPath, new LinkOption[0]) || !Files.isReadable(inputPath)) {
                System.out.println(inputLocation);
                throw new Exception("The input location is not valid or not read-able\n");
            }
            inputLocation = inputPath.toRealPath(new LinkOption[0]).toString();
        }
        if (outputLocation == null || outputLocation.isEmpty()) {
            if (modelFile != null && !modelFile.isEmpty()) {
                modelPath = Paths.get(modelFile, new String[0]);
                modelPath = modelPath.toRealPath(new LinkOption[0]);
                modelPath = modelPath.getParent();
                outputLocation = modelPath.toString();
            } else if (inputLocation != null && !inputLocation.isEmpty()) {
                inputPath = Paths.get(inputLocation, new String[0]);
                outputLocation = inputPath.toRealPath(new LinkOption[0]).toString();
            }
        }
        if (outputLocation != null && !outputLocation.isEmpty()) {
            Path outputPath = Paths.get(outputLocation, new String[0]);
            if (!Files.exists(outputPath, new LinkOption[0]) || !Files.isWritable(outputPath)) {
                System.out.println(outputLocation);
                throw new Exception("The output location is not valid or not write-able\n");
            }
            outputLocation = outputPath.toRealPath(new LinkOption[0]).toString();
        }
        if (outputFileExtension != null && outputFileExtension.equals(".xml")) {
            if (inputLocation != null && inputLocation.equals(outputLocation)) {
                throw new Exception("-outputfileextension=.xml is not allowed when the output location is same as the input location\n");
            }
            if (inputLocation == null) {
                modelPath = Paths.get(modelFile, new String[0]);
                modelPath = modelPath.toRealPath(new LinkOption[0]);
                if (outputLocation.equals((modelPath = modelPath.getParent()).toString())) {
                    throw new Exception("-outputfileextension=.xml is not allowed when the output location is same as the input location\n");
                }
            }
        }
        if (!(modelFile == null || modelFile.isEmpty() || Files.exists(modelPath = Paths.get(modelFile, new String[0]), new LinkOption[0]) && Files.isReadable(modelPath))) {
            System.out.println(modelPath);
            throw new Exception("The model file is not valid or not read-able: " + modelFile);
        }
        if (!(xsltFile == null || xsltFile.isEmpty() || Files.exists(xsltPath = Paths.get(xsltFile, new String[0]), new LinkOption[0]) && Files.isReadable(xsltPath))) {
            System.out.println(xsltFile);
            throw new Exception("The xslt file is not valid or not read-able: " + xsltFile);
        }
        if (excludeQueryObjects.size() == 3) {
            excludeQueryObjects.clear();
        }
    }

    static List<String> readCmdLineOptionsFile(String cmdLineOptionsFile) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader readermodel = Files.newBufferedReader(Paths.get(cmdLineOptionsFile, new String[0]), StandardCharsets.UTF_8);
            while ((line = readermodel.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                Matcher m = Pattern.compile("(\\S*\".+?\"|\\S*)\\s*").matcher(line);
                while (m.find()) {
                    String option = m.group(1);
                    if ((option = option.replaceAll("\"", "")).isEmpty()) continue;
                    list.add(option);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("The command line options file is not valid or not read-able: " + cmdLineOptionsFile);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        ModelUpdate.processParams(args);
        if (xsltFile != null && !xsltFile.isEmpty()) {
            Path xsltPath = Paths.get(xsltFile, new String[0]);
            if (!Files.exists(xsltPath, new LinkOption[0]) || !Files.isReadable(xsltPath)) {
                System.out.println(xsltFile);
                throw new Exception("xslt file is not valid or not read-able\n");
            }
            if (modelFile != null && !modelFile.isEmpty()) {
                Path modelPath = Paths.get(modelFile, new String[0]);
                if (!Files.exists(modelPath, new LinkOption[0]) || !Files.isReadable(modelPath)) {
                    System.out.println(modelPath);
                    throw new Exception("model file is not valid or not read-able\n");
                }
                UpdateModelXSLT updateModelXSLT = new UpdateModelXSLT(Paths.get(xsltFile, new String[0]), shiftToUpperCase, dataSourceNames, null, null, Paths.get(outputLocation, new String[0]), outputFileExtension, excludeQueryObjects);
                Files.walkFileTree(Paths.get(modelFile, new String[0]), updateModelXSLT);
            }
            if (inputLocation != null && !inputLocation.isEmpty()) {
                UpdateModelXSLT updateModelXSLT = new UpdateModelXSLT(Paths.get(xsltFile, new String[0]), shiftToUpperCase, dataSourceNames, inputLocation, fileName, Paths.get(outputLocation, new String[0]), outputFileExtension, excludeQueryObjects);
                Files.walkFileTree(Paths.get(inputLocation, new String[0]), updateModelXSLT);
            }
        }
    }

    static enum ShiftOption {
        non,
        upper,
        lower;

    }
}

