/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.modelupdate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class UnicodeFileCreator {
    private static int BUFF_SIZE = 32768;

    public static BufferedWriter createFile(String filename) throws Exception {
        return UnicodeFileCreator.createFile(filename, false);
    }

    public static BufferedWriter createFile(String filename, boolean silentMode) throws Exception {
        return UnicodeFileCreator.createFile(null, filename, silentMode);
    }

    public static BufferedWriter createFile(String msgFormat, String filename) throws Exception {
        return UnicodeFileCreator.createFile(msgFormat, filename, false);
    }

    public static BufferedWriter createFile(String msgFormat, String filename, boolean silentMode) throws Exception {
        BufferedWriter writer = null;
        if (!silentMode) {
            if (msgFormat == null) {
                System.out.printf("Creating %s%n", filename);
            } else {
                System.out.printf(msgFormat, filename);
            }
        }
        try {
            UnicodeFileCreator.createParentDir(filename);
            File f = new File(filename);
            if (f.exists() && !f.delete()) {
                throw new Exception("Cannot delete " + filename);
            }
            if (!f.createNewFile()) {
                throw new Exception("Cannot create " + filename);
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"), BUFF_SIZE);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Cannot open " + filename + " as utf-8.");
        }
        catch (FileNotFoundException e) {
            throw new Exception("Cannot create " + filename + ".");
        }
        catch (IOException e) {
            throw new Exception("Error writing to " + filename + ".");
        }
        return writer;
    }

    public static File createParentDir(String filename) {
        File f = new File(filename);
        File parent = f.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return parent;
    }
}

